/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.StaticMemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.benchmark.BenchmarkBase;
import org.apache.spark.sql.execution.joins.LongToUnsafeRowMap;
import org.apache.spark.sql.execution.vectorized.AggregateHashMap;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.map.BytesToBytesMap;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q1A!\u0001\u0002\u0001\u001f\t\u0011\u0012iZ4sK\u001e\fG/\u001a\"f]\u000eDW.\u0019:l\u0015\t\u0019A!A\u0005cK:\u001c\u0007.\\1sW*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011QBQ3oG\"l\u0017M]6CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\t)\u0002\u0001")
public class AggregateBenchmark
extends SparkFunSuite
implements BenchmarkBase {
    private SparkSession sparkSession;
    private volatile boolean bitmap$0;

    @Override
    public void runBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        BenchmarkBase.runBenchmark$(this, name, cardinality, f);
    }

    private SparkSession sparkSession$lzycompute() {
        AggregateBenchmark aggregateBenchmark = this;
        synchronized (aggregateBenchmark) {
            if (!this.bitmap$0) {
                this.sparkSession = BenchmarkBase.sparkSession$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkSession;
    }

    @Override
    public SparkSession sparkSession() {
        return !this.bitmap$0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    private final void f$1(int N$3) {
        this.sparkSession().range((long)N$3).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(id & 65535) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sum((Seq)Nil$.MODULE$).collect();
    }

    private final void f$2() {
        this.sparkSession().sql("select k, k, sum(id) from test group by k, k").collect();
    }

    private final void f$3(int N$4) {
        this.sparkSession().range((long)N$4).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "cast(id & 1023 as string) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
    }

    private final void f$4(int N$5) {
        this.sparkSession().range((long)N$5).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "cast(id & 65535 as decimal) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
    }

    private final void f$5(int N$6) {
        this.sparkSession().range((long)N$6).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "(id & 1023) as k1", "cast(id & 1023 as string) as k2", "cast(id & 1023 as int) as k3", "cast(id & 1023 as double) as k4", "cast(id & 1023 as float) as k5", "id > 1023 as k6"})).groupBy("k1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2", "k3", "k4", "k5", "k6"})).sum((Seq)Nil$.MODULE$).collect();
    }

    private final void f$6(int N$7) {
        this.sparkSession().range((long)N$7).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "(id & 1023) as k1", "cast(id & 1023 as double) as k2", "cast(id & 1023 as int) as k3", "case when id > 100 and id <= 200 then 1 else 0 end as v1", "case when id > 200 and id <= 300 then 1 else 0 end as v2", "case when id > 300 and id <= 400 then 1 else 0 end as v3", "case when id > 400 and id <= 500 then 1 else 0 end as v4", "case when id > 500 and id <= 600 then 1 else 0 end as v5", "case when id > 600 and id <= 700 then 1 else 0 end as v6", "case when id > 700 and id <= 800 then 1 else 0 end as v7", "case when id > 800 and id <= 900 then 1 else 0 end as v8", "case when id > 900 and id <= 1000 then 1 else 0 end as v9", "case when id > 1000 and id <= 1100 then 1 else 0 end as v10", "case when id > 1100 and id <= 1200 then 1 else 0 end as v11", "case when id > 1200 and id <= 1300 then 1 else 0 end as v12", "case when id > 1300 and id <= 1400 then 1 else 0 end as v13", "case when id > 1400 and id <= 1500 then 1 else 0 end as v14", "case when id > 1500 and id <= 1600 then 1 else 0 end as v15", "case when id > 1600 and id <= 1700 then 1 else 0 end as v16", "case when id > 1700 and id <= 1800 then 1 else 0 end as v17", "case when id > 1800 and id <= 1900 then 1 else 0 end as v18"})).groupBy("k1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2", "k3"})).sum((Seq)Nil$.MODULE$).collect();
    }

    public AggregateBenchmark() {
        BenchmarkBase.$init$(this);
        this.ignore("aggregate without grouping", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long N = 0x7D000000L;
            Benchmark benchmark = new Benchmark("agg without grouping", N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            this.runBenchmark("agg w/o group", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sparkSession().range(N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum(id)"})).collect());
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.ignore("stat functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long N = 0x6400000L;
            this.runBenchmark("stddev", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sparkSession().range(N).groupBy((Seq)Nil$.MODULE$).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"stddev"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).collect());
            this.runBenchmark("kurtosis", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sparkSession().range(N).groupBy((Seq)Nil$.MODULE$).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"kurtosis"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).collect());
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.ignore("aggregate with linear keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x5000000;
            Benchmark benchmark = new Benchmark("Aggregate w keys", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            benchmark.addCase("codegen = F", 2, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "false");
                this.f$1(N);
            });
            benchmark.addCase("codegen = T hashmap = F", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "false");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "false");
                this.f$1(N);
            });
            benchmark.addCase("codegen = T hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                this.f$1(N);
            });
            benchmark.run();
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.ignore("aggregate with randomized keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x5000000;
            Benchmark benchmark = new Benchmark("Aggregate w keys", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            this.sparkSession().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "floor(rand() * 10000) as k"})).createOrReplaceTempView("test");
            benchmark.addCase("codegen = F", 2, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", false);
                this.f$2();
            });
            benchmark.addCase("codegen = T hashmap = F", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", true);
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "false");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "false");
                this.f$2();
            });
            benchmark.addCase("codegen = T hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", true);
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                this.f$2();
            });
            benchmark.run();
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.ignore("aggregate with string key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            Benchmark benchmark = new Benchmark("Aggregate w string key", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            benchmark.addCase("codegen = F", 2, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "false");
                this.f$3(N);
            });
            benchmark.addCase("codegen = T hashmap = F", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "false");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "false");
                this.f$3(N);
            });
            benchmark.addCase("codegen = T hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                this.f$3(N);
            });
            benchmark.run();
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.ignore("aggregate with decimal key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            Benchmark benchmark = new Benchmark("Aggregate w decimal key", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            benchmark.addCase("codegen = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "false");
                this.f$4(N);
            });
            benchmark.addCase("codegen = T hashmap = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "false");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "false");
                this.f$4(N);
            });
            benchmark.addCase("codegen = T hashmap = T", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                this.f$4(N);
            });
            benchmark.run();
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.ignore("aggregate with multiple key types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            Benchmark benchmark = new Benchmark("Aggregate w multiple keys", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            benchmark.addCase("codegen = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "false");
                this.f$5(N);
            });
            benchmark.addCase("codegen = T hashmap = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "false");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "false");
                this.f$5(N);
            });
            benchmark.addCase("codegen = T hashmap = T", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enabled", "true");
                this.sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                this.f$5(N);
            });
            benchmark.run();
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.ignore("max function bytecode size of wholestagecodegen", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 655360;
            Benchmark benchmark = new Benchmark("max function bytecode size", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            benchmark.addCase("codegen = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key(), "false");
                this.f$6(N);
            });
            benchmark.addCase("codegen = T hugeMethodLimit = 10000", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key(), "true");
                this.sparkSession().conf().set(SQLConf$.MODULE$.WHOLESTAGE_HUGE_METHOD_LIMIT().key(), "10000");
                this.f$6(N);
            });
            benchmark.addCase("codegen = T hugeMethodLimit = 1500", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                this.sparkSession().conf().set(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key(), "true");
                this.sparkSession().conf().set(SQLConf$.MODULE$.WHOLESTAGE_HUGE_METHOD_LIMIT().key(), "1500");
                this.f$6(N);
            });
            benchmark.run();
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.ignore("cube", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x500000;
            this.runBenchmark("cube", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sparkSession().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 1000 as k1", "id & 256 as k2"})).cube("k1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2"})).sum((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).collect());
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        this.ignore("hash and BytesToBytesMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            Benchmark benchmark = new Benchmark("BytesToBytesMap", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            benchmark.addCase("UnsafeRowhash", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                byte[] keyBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                int s = 0;
                for (int i = 0; i < N; ++i) {
                    key.setInt(0, i % 1000);
                    int h = Murmur3_x86_32.hashUnsafeWords((Object)key.getBaseObject(), (long)key.getBaseOffset(), (int)key.getSizeInBytes(), (int)42);
                    s += h;
                }
            });
            benchmark.addCase("murmur3 hash", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                byte[] keyBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                int p = 524283;
                int s = 0;
                for (int i = 0; i < N; ++i) {
                    int h = Murmur3_x86_32.hashLong((long)i, (int)42);
                    key.setInt(0, h);
                    s += h;
                }
            });
            benchmark.addCase("fast hash", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                byte[] keyBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                int p = 524283;
                int s = 0;
                for (int i = 0; i < N; ++i) {
                    int h = i % p;
                    if (h < 0) {
                        h += p;
                    }
                    key.setInt(0, h);
                    s += h;
                }
            });
            benchmark.addCase("arrayEqual", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                byte[] keyBytes = new byte[16];
                byte[] valueBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                UnsafeRow value = new UnsafeRow(1);
                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                value.setInt(0, 555);
                int s = 0;
                for (int i = 0; i < N; ++i) {
                    key.setInt(0, i % 1000);
                    if (!key.equals((Object)value)) continue;
                    ++s;
                }
            });
            benchmark.addCase("Java HashMap (Long)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                int i;
                byte[] keyBytes = new byte[16];
                byte[] valueBytes = new byte[16];
                UnsafeRow value = new UnsafeRow(1);
                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                value.setInt(0, 555);
                HashMap<Long, UnsafeRow> map = new HashMap<Long, UnsafeRow>();
                for (i = 0; i < 65536; ++i) {
                    value.setInt(0, i);
                    map.put(BoxesRunTime.boxToLong((long)i), value);
                }
                int s = 0;
                for (i = 0; i < N; ++i) {
                    if (map.get(BoxesRunTime.boxToInteger((int)(i % 100000))) == null) continue;
                    ++s;
                }
            });
            benchmark.addCase("Java HashMap (two ints) ", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                int i;
                byte[] valueBytes = new byte[16];
                UnsafeRow value = new UnsafeRow(1);
                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                value.setInt(0, 555);
                HashMap<Long, UnsafeRow> map = new HashMap<Long, UnsafeRow>();
                for (i = 0; i < 65536; ++i) {
                    value.setInt(0, i);
                    long key = ((long)i << 32) + (long)Integer.rotateRight(i, 15);
                    map.put(BoxesRunTime.boxToLong((long)key), value);
                }
                int s = 0;
                for (i = 0; i < N; ++i) {
                    long key = ((long)(i & 0x186A0) << 32) + (long)Integer.rotateRight(i & 0x186A0, 15);
                    if (map.get(BoxesRunTime.boxToLong((long)key)) == null) continue;
                    ++s;
                }
            });
            benchmark.addCase("Java HashMap (UnsafeRow)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                int i;
                byte[] keyBytes = new byte[16];
                byte[] valueBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                UnsafeRow value = new UnsafeRow(1);
                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                value.setInt(0, 555);
                HashMap<UnsafeRow, UnsafeRow> map = new HashMap<UnsafeRow, UnsafeRow>();
                for (i = 0; i < 65536; ++i) {
                    key.setInt(0, i);
                    value.setInt(0, i);
                    map.put(key, value.copy());
                }
                int s = 0;
                for (i = 0; i < N; ++i) {
                    key.setInt(0, i % 100000);
                    if (map.get(key) == null) continue;
                    ++s;
                }
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)optimized -> {
                benchmark.addCase(new StringBuilder(25).append("LongToUnsafeRowMap (opt=").append(BoxesRunTime.unboxToBoolean((Object)optimized)).append(")").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                    int i;
                    byte[] valueBytes = new byte[16];
                    UnsafeRow value = new UnsafeRow(1);
                    value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                    value.setInt(0, 555);
                    TaskMemoryManager taskMemoryManager = new TaskMemoryManager((MemoryManager)new StaticMemoryManager(new SparkConf().set(package$.MODULE$.MEMORY_OFFHEAP_ENABLED().key(), "false"), Long.MAX_VALUE, Long.MAX_VALUE, 1), 0L);
                    LongToUnsafeRowMap map = new LongToUnsafeRowMap(taskMemoryManager, 64);
                    for (i = 0; i < 65536; ++i) {
                        value.setInt(0, i);
                        int key = i % 100000;
                        map.append((long)key, value);
                    }
                    if (optimized) {
                        map.optimize();
                    }
                    int s = 0;
                    for (i = 0; i < N$9; ++i) {
                        int key = i % 100000;
                        if (map.getValue((long)key, value) == null) continue;
                        ++s;
                    }
                });
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"off", "on"}))).foreach((Function1 & Serializable & scala.Serializable)heap -> {
                benchmark.addCase(new StringBuilder(23).append("BytesToBytesMap (").append(heap).append(" Heap)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                    int i;
                    String string = heap;
                    String string2 = "off";
                    TaskMemoryManager taskMemoryManager = new TaskMemoryManager((MemoryManager)new StaticMemoryManager(new SparkConf().set(package$.MODULE$.MEMORY_OFFHEAP_ENABLED().key(), String.valueOf(BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0))).set(package$.MODULE$.MEMORY_OFFHEAP_SIZE().key(), "102400000"), Long.MAX_VALUE, Long.MAX_VALUE, 1), 0L);
                    BytesToBytesMap map = new BytesToBytesMap(taskMemoryManager, 1024, 0x4000000L);
                    byte[] keyBytes = new byte[16];
                    byte[] valueBytes = new byte[16];
                    UnsafeRow key = new UnsafeRow(1);
                    key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                    UnsafeRow value = new UnsafeRow(1);
                    value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                    int numKeys = 65536;
                    for (i = 0; i < numKeys; ++i) {
                        key.setInt(0, i % 65536);
                        BytesToBytesMap.Location loc = map.lookup(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), Murmur3_x86_32.hashLong((long)(i % 65536), (int)42));
                        Object object = !loc.isDefined() ? BoxesRunTime.boxToBoolean((boolean)loc.append(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), value.getBaseObject(), value.getBaseOffset(), value.getSizeInBytes())) : BoxedUnit.UNIT;
                    }
                    int s = 0;
                    for (i = 0; i < N$9; ++i) {
                        key.setInt(0, i % 100000);
                        BytesToBytesMap.Location loc = map.lookup(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), Murmur3_x86_32.hashLong((long)(i % 100000), (int)42));
                        if (!loc.isDefined()) continue;
                        ++s;
                    }
                });
                return BoxedUnit.UNIT;
            });
            benchmark.addCase("Aggregate HashMap", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                int i;
                int numKeys = 65536;
                StructType schema = new StructType().add("key", (DataType)LongType$.MODULE$).add("value", (DataType)LongType$.MODULE$);
                AggregateHashMap map = new AggregateHashMap(schema);
                for (i = 0; i < numKeys; ++i) {
                    MutableColumnarRow row = map.findOrInsert((long)i);
                    row.setLong(1, row.getLong(1) + 1L);
                }
                int s = 0;
                for (i = 0; i < N; ++i) {
                    if (map.find((long)(i % 100000)) == -1) continue;
                    ++s;
                }
            });
            benchmark.run();
        }, new Position("AggregateBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
    }
}

