/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.execution.SparkSqlParser;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand;
import org.apache.spark.sql.execution.command.AnalyzePartitionCommand;
import org.apache.spark.sql.execution.command.AnalyzeTableCommand;
import org.apache.spark.sql.execution.command.DescribeColumnCommand;
import org.apache.spark.sql.execution.command.DescribeFunctionCommand;
import org.apache.spark.sql.execution.command.DescribeTableCommand;
import org.apache.spark.sql.execution.command.ShowFunctionsCommand;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.RefreshResource;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u00015\u00111c\u00159be.\u001c\u0016\u000f\u001c)beN,'oU;ji\u0016T!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f%A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001C1oC2L8/[:\u000b\u0005]!\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e!\"\u0001D!oC2L8/[:UKN$\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\u0002\u0005\nqA\\3x\u0007>tg-F\u0001#!\t\u0019c%D\u0001%\u0015\t)C!\u0001\u0005j]R,'O\\1m\u0013\t9CEA\u0004T#2\u001buN\u001c4\t\r%\u0002\u0001\u0015!\u0003#\u0003!qWm^\"p]\u001a\u0004\u0003\u0002C\u0016\u0001\u0011\u000b\u0007I\u0011\u0002\u0017\u0002\rA\f'o]3s+\u0005i\u0003C\u0001\u0010/\u0013\ty#A\u0001\bTa\u0006\u00148nU9m!\u0006\u00148/\u001a:\t\u000bE\u0002A\u0011\t\u001a\u0002\u001b9|'/\\1mSj,\u0007\u000b\\1o)\t\u00194\b\u0005\u00025s5\tQG\u0003\u00027o\u00059An\\4jG\u0006d'B\u0001\u001d\u0017\u0003\u0015\u0001H.\u00198t\u0013\tQTGA\u0006M_\u001eL7-\u00197QY\u0006t\u0007\"\u0002\u001f1\u0001\u0004\u0019\u0014\u0001\u00029mC:DQA\u0010\u0001\u0005\n}\n1\"Y:tKJ$X)];bYR\u0019\u0001IR*\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000fv\u0002\r\u0001S\u0001\u000bgFd7i\\7nC:$\u0007CA%Q\u001d\tQe\n\u0005\u0002L\u00056\tAJ\u0003\u0002N\u0019\u00051AH]8pizJ!a\u0014\"\u0002\rA\u0013X\rZ3g\u0013\t\t&K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001f\nCQ\u0001P\u001fA\u0002MBQ!\u0016\u0001\u0005\nY\u000b\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0015\u0007\u0001;\u0006\fC\u0003H)\u0002\u0007\u0001\nC\u0003Z)\u0002\u0007!,\u0001\u0005nKN\u001c\u0018mZ3t!\r\t5\fS\u0005\u00039\n\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?\u0011\u0015q\u0006\u0001\"\u0003`\u0003A\u0019'/Z1uKR\u000b'\r\\3Vg&tw\r\u0006\taM\"lWO_A\u0003\u0003\u0013\ty\"a\u000b\u00028A\u0011\u0011\rZ\u0007\u0002E*\u00111MA\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0002fE\nY1I]3bi\u0016$\u0016M\u00197f\u0011\u00159W\f1\u0001I\u0003\u0015!\u0018M\u00197f\u0011\u001dIW\f%AA\u0002)\f\u0001\u0002Z1uC\n\f7/\u001a\t\u0004\u0003.D\u0015B\u00017C\u0005\u0019y\u0005\u000f^5p]\"9a.\u0018I\u0001\u0002\u0004y\u0017!\u0003;bE2,G+\u001f9f!\t\u00018/D\u0001r\u0015\t\u0011h#A\u0004dCR\fGn\\4\n\u0005Q\f(\u0001E\"bi\u0006dwn\u001a+bE2,G+\u001f9f\u0011\u001d1X\f%AA\u0002]\fqa\u001d;pe\u0006<W\r\u0005\u0002qq&\u0011\u00110\u001d\u0002\u0015\u0007\u0006$\u0018\r\\8h'R|'/Y4f\r>\u0014X.\u0019;\t\u000fml\u0006\u0013!a\u0001y\u000611o\u00195f[\u0006\u00042!`A\u0001\u001b\u0005q(BA@\u0005\u0003\u0015!\u0018\u0010]3t\u0013\r\t\u0019A \u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002CA\u0004;B\u0005\t\u0019\u00016\u0002\u0011A\u0014xN^5eKJD\u0011\"a\u0003^!\u0003\u0005\r!!\u0004\u0002)A\f'\u000f^5uS>t7i\u001c7v[:t\u0015-\\3t!\u0015\ty!!\u0007I\u001d\u0011\t\t\"!\u0006\u000f\u0007-\u000b\u0019\"C\u0001D\u0013\r\t9BQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY\"!\b\u0003\u0007M+\u0017OC\u0002\u0002\u0018\tC\u0011\"!\t^!\u0003\u0005\r!a\t\u0002\u0015\t,8m[3u'B,7\r\u0005\u0003BW\u0006\u0015\u0002c\u00019\u0002(%\u0019\u0011\u0011F9\u0003\u0015\t+8m[3u'B,7\rC\u0005\u0002.u\u0003\n\u00111\u0001\u00020\u0005!Qn\u001c3f!\u0011\t\t$a\r\u000e\u0003\u0011I1!!\u000e\u0005\u0005!\u0019\u0016M^3N_\u0012,\u0007\"CA\u001d;B\u0005\t\u0019AA\u001e\u0003\u0015\tX/\u001a:z!\r\t5n\r\u0005\b\u0003\u007f\u0001A\u0011BA!\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015+\u0001\f\u0019%!\u0012\u0002H\u0005%\u00131JA'\u0003\u001f\n\t&!\u0016\u0002X!1q-!\u0010A\u0002!C\u0001\"[A\u001f!\u0003\u0005\rA\u001b\u0005\t]\u0006u\u0002\u0013!a\u0001_\"Aa/!\u0010\u0011\u0002\u0003\u0007q\u000f\u0003\u0005|\u0003{\u0001\n\u00111\u0001}\u0011%\t9!!\u0010\u0011\u0002\u0003\u0007!\u000e\u0003\u0006\u0002\f\u0005u\u0002\u0013!a\u0001\u0003\u001bA\u0011\"a\u0015\u0002>A\u0005\t\u0019\u00016\u0002\u000f\r|W.\\3oi\"Q\u0011QFA\u001f!\u0003\u0005\r!a\f\t\u0015\u0005e\u0012Q\bI\u0001\u0002\u0004\tY\u0004C\u0005\u0002\\\u0001\t\n\u0011\"\u0003\u0002^\u0005Q2M]3bi\u0016$\u0016M\u00197f+NLgn\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\f\u0016\u0004U\u0006\u00054FAA2!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055$)\u0001\u0006b]:|G/\u0019;j_:LA!!\u001d\u0002h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005U\u0004!%A\u0005\n\u0005]\u0014AG2sK\u0006$X\rV1cY\u0016,6/\u001b8hI\u0011,g-Y;mi\u0012\u001aTCAA=U\ry\u0017\u0011\r\u0005\n\u0003{\u0002\u0011\u0013!C\u0005\u0003\u007f\n!d\u0019:fCR,G+\u00192mKV\u001b\u0018N\\4%I\u00164\u0017-\u001e7uIQ*\"!!!+\u0007]\f\t\u0007C\u0005\u0002\u0006\u0002\t\n\u0011\"\u0003\u0002\b\u0006Q2M]3bi\u0016$\u0016M\u00197f+NLgn\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u0012\u0016\u0004y\u0006\u0005\u0004\"CAG\u0001E\u0005I\u0011BA/\u0003i\u0019'/Z1uKR\u000b'\r\\3Vg&tw\r\n3fM\u0006,H\u000e\u001e\u00137\u0011%\t\t\nAI\u0001\n\u0013\t\u0019*\u0001\u000ede\u0016\fG/\u001a+bE2,Wk]5oO\u0012\"WMZ1vYR$s'\u0006\u0002\u0002\u0016*\"\u0011QBA1\u0011%\tI\nAI\u0001\n\u0013\tY*\u0001\u000ede\u0016\fG/\u001a+bE2,Wk]5oO\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0002\u001e*\"\u00111EA1\u0011%\t\t\u000bAI\u0001\n\u0013\t\u0019+\u0001\u000ede\u0016\fG/\u001a+bE2,Wk]5oO\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0002&*\"\u0011qFA1\u0011%\tI\u000bAI\u0001\n\u0013\tY+A\u000ede\u0016\fG/\u001a+bE2,Wk]5oO\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0003[SC!a\u000f\u0002b!I\u0011\u0011\u0017\u0001\u0012\u0002\u0013%\u0011QL\u0001\u0016GJ,\u0017\r^3UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t)\fAI\u0001\n\u0013\t9(A\u000bde\u0016\fG/\u001a+bE2,G\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005e\u0006!%A\u0005\n\u0005}\u0014!F2sK\u0006$X\rV1cY\u0016$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0003{\u0003\u0011\u0013!C\u0005\u0003\u000f\u000bQc\u0019:fCR,G+\u00192mK\u0012\"WMZ1vYR$S\u0007C\u0005\u0002B\u0002\t\n\u0011\"\u0003\u0002^\u0005)2M]3bi\u0016$\u0016M\u00197fI\u0011,g-Y;mi\u00122\u0004\"CAc\u0001E\u0005I\u0011BAJ\u0003U\u0019'/Z1uKR\u000b'\r\\3%I\u00164\u0017-\u001e7uI]B\u0011\"!3\u0001#\u0003%I!!\u0018\u0002+\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%q!I\u0011Q\u001a\u0001\u0012\u0002\u0013%\u00111U\u0001\u0016GJ,\u0017\r^3UC\ndW\r\n3fM\u0006,H\u000e\u001e\u0013:\u0011%\t\t\u000eAI\u0001\n\u0013\tY+\u0001\fde\u0016\fG/\u001a+bE2,G\u0005Z3gCVdG\u000fJ\u00191\u0001")
public class SparkSqlParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private SparkSqlParser parser;
    private final SQLConf newConf;
    private final Analyzer caseSensitiveAnalyzer;
    private final Analyzer caseInsensitiveAnalyzer;
    private volatile boolean bitmap$0;

    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public Analyzer getAnalyzer(boolean caseSensitive) {
        return AnalysisTest.getAnalyzer$((AnalysisTest)this, (boolean)caseSensitive);
    }

    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$((AnalysisTest)this, (LogicalPlan)inputPlan, (LogicalPlan)expectedPlan, (boolean)caseSensitive);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$((AnalysisTest)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$((AnalysisTest)this, (LogicalPlan)inputPlan, (boolean)caseSensitive);
    }

    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$((AnalysisTest)this, (LogicalPlan)inputPlan, expectedErrors, (boolean)caseSensitive);
    }

    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$((AnalysisTest)this);
    }

    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$((AnalysisTest)this);
    }

    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$((AnalysisTest)this);
    }

    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$((AnalysisTest)this);
    }

    public SQLConf conf() {
        return PlanTestBase.conf$((PlanTestBase)this);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Analyzer caseSensitiveAnalyzer() {
        return this.caseSensitiveAnalyzer;
    }

    public Analyzer caseInsensitiveAnalyzer() {
        return this.caseInsensitiveAnalyzer;
    }

    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseSensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseSensitiveAnalyzer = x$1;
    }

    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseInsensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseInsensitiveAnalyzer = x$1;
    }

    public SQLConf newConf() {
        return this.newConf;
    }

    private SparkSqlParser parser$lzycompute() {
        SparkSqlParserSuite sparkSqlParserSuite = this;
        synchronized (sparkSqlParserSuite) {
            if (!this.bitmap$0) {
                this.parser = new SparkSqlParser(this.newConf());
                this.bitmap$0 = true;
            }
        }
        return this.parser;
    }

    private SparkSqlParser parser() {
        return !this.bitmap$0 ? this.parser$lzycompute() : this.parser;
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        LogicalPlan logicalPlan;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof CreateTable) {
            CreateTable createTable = (CreateTable)logicalPlan2;
            CatalogTable tableDesc = createTable.tableDesc();
            SaveMode mode = createTable.mode();
            Option query = createTable.query();
            long x$14 = -1L;
            TableIdentifier x$15 = tableDesc.copy$default$1();
            CatalogTableType x$16 = tableDesc.copy$default$2();
            CatalogStorageFormat x$17 = tableDesc.copy$default$3();
            StructType x$18 = tableDesc.copy$default$4();
            Option x$19 = tableDesc.copy$default$5();
            Seq x$20 = tableDesc.copy$default$6();
            Option x$21 = tableDesc.copy$default$7();
            String x$22 = tableDesc.copy$default$8();
            long x$23 = tableDesc.copy$default$10();
            String x$24 = tableDesc.copy$default$11();
            Map x$25 = tableDesc.copy$default$12();
            Option x$26 = tableDesc.copy$default$13();
            Option x$27 = tableDesc.copy$default$14();
            Option x$28 = tableDesc.copy$default$15();
            Seq x$29 = tableDesc.copy$default$16();
            boolean x$30 = tableDesc.copy$default$17();
            boolean x$31 = tableDesc.copy$default$18();
            Map x$32 = tableDesc.copy$default$19();
            CatalogTable newTableDesc = tableDesc.copy(x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$14, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
            logicalPlan = new CreateTable(newTableDesc, mode, query);
        } else {
            logicalPlan = plan;
        }
        return logicalPlan;
    }

    private void assertEqual(String sqlCommand, LogicalPlan plan) {
        LogicalPlan normalized1 = this.normalizePlan(this.parser().parsePlan(sqlCommand));
        LogicalPlan normalized2 = this.normalizePlan(plan);
        this.comparePlans(normalized1, normalized2, this.comparePlans$default$3());
    }

    private void intercept(String sqlCommand, Seq<String> messages) {
        ParseException e = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.parser().parsePlan(sqlCommand), ClassTag$.MODULE$.apply(ParseException.class), new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = message;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        });
    }

    private CreateTable createTableUsing(String table, Option<String> database, CatalogTableType tableType, CatalogStorageFormat storage, StructType schema, Option<String> provider, Seq<String> partitionColumnNames, Option<BucketSpec> bucketSpec, SaveMode mode, Option<LogicalPlan> query) {
        return new CreateTable(new CatalogTable(new TableIdentifier(table, database), tableType, storage, schema, provider, partitionColumnNames, bucketSpec, CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19()), mode, query);
    }

    private CreateTable createTable(String table, Option<String> database, CatalogTableType tableType, CatalogStorageFormat storage, StructType schema, Option<String> provider, Seq<String> partitionColumnNames, Option<String> comment, SaveMode mode, Option<LogicalPlan> query) {
        TableIdentifier x$39 = new TableIdentifier(table, database);
        CatalogTableType x$40 = tableType;
        CatalogStorageFormat x$41 = storage;
        StructType x$42 = schema;
        Option<String> x$43 = provider;
        Seq<String> x$44 = partitionColumnNames;
        Option<String> x$45 = comment;
        Option x$46 = CatalogTable$.MODULE$.apply$default$7();
        String x$47 = CatalogTable$.MODULE$.apply$default$8();
        long x$48 = CatalogTable$.MODULE$.apply$default$9();
        long x$49 = CatalogTable$.MODULE$.apply$default$10();
        String x$50 = CatalogTable$.MODULE$.apply$default$11();
        Map x$51 = CatalogTable$.MODULE$.apply$default$12();
        Option x$52 = CatalogTable$.MODULE$.apply$default$13();
        Option x$53 = CatalogTable$.MODULE$.apply$default$14();
        Seq x$54 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$55 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$56 = CatalogTable$.MODULE$.apply$default$18();
        Map x$57 = CatalogTable$.MODULE$.apply$default$19();
        return new CreateTable(new CatalogTable(x$39, x$40, x$41, x$42, x$43, x$44, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$45, x$54, x$55, x$56, x$57), mode, query);
    }

    private Option<String> createTableUsing$default$2() {
        return None$.MODULE$;
    }

    private CatalogTableType createTableUsing$default$3() {
        return CatalogTableType$.MODULE$.MANAGED();
    }

    private CatalogStorageFormat createTableUsing$default$4() {
        return CatalogStorageFormat$.MODULE$.empty();
    }

    private StructType createTableUsing$default$5() {
        return new StructType();
    }

    private Option<String> createTableUsing$default$6() {
        return new Some((Object)"parquet");
    }

    private Seq<String> createTableUsing$default$7() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Option<BucketSpec> createTableUsing$default$8() {
        return None$.MODULE$;
    }

    private SaveMode createTableUsing$default$9() {
        return SaveMode.ErrorIfExists;
    }

    private Option<LogicalPlan> createTableUsing$default$10() {
        return None$.MODULE$;
    }

    private Option<String> createTable$default$2() {
        return None$.MODULE$;
    }

    private CatalogTableType createTable$default$3() {
        return CatalogTableType$.MODULE$.MANAGED();
    }

    private CatalogStorageFormat createTable$default$4() {
        Option x$132 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("textfile").get()).inputFormat();
        Option x$133 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("textfile").get()).outputFormat();
        Some x$134 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
        Option x$135 = CatalogStorageFormat$.MODULE$.empty().copy$default$1();
        boolean x$136 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
        Map x$137 = CatalogStorageFormat$.MODULE$.empty().copy$default$6();
        return CatalogStorageFormat$.MODULE$.empty().copy(x$135, x$132, x$133, (Option)x$134, x$136, x$137);
    }

    private StructType createTable$default$5() {
        return new StructType();
    }

    private Option<String> createTable$default$6() {
        return new Some((Object)"hive");
    }

    private Seq<String> createTable$default$7() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Option<String> createTable$default$8() {
        return None$.MODULE$;
    }

    private SaveMode createTable$default$9() {
        return SaveMode.ErrorIfExists;
    }

    private Option<LogicalPlan> createTable$default$10() {
        return None$.MODULE$;
    }

    public SparkSqlParserSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        AnalysisTest.$init$((AnalysisTest)this);
        this.newConf = new SQLConf();
        this.test("refresh resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("REFRESH prefix_path", (LogicalPlan)new RefreshResource("prefix_path"));
            this.assertEqual("REFRESH /", (LogicalPlan)new RefreshResource("/"));
            this.assertEqual("REFRESH /path///a", (LogicalPlan)new RefreshResource("/path///a"));
            this.assertEqual("REFRESH pat1h/112/_1a", (LogicalPlan)new RefreshResource("pat1h/112/_1a"));
            this.assertEqual("REFRESH pat1h/112/_1a/a-1", (LogicalPlan)new RefreshResource("pat1h/112/_1a/a-1"));
            this.assertEqual("REFRESH path-with-dash", (LogicalPlan)new RefreshResource("path-with-dash"));
            this.assertEqual("REFRESH 'path with space'", (LogicalPlan)new RefreshResource("path with space"));
            this.assertEqual("REFRESH \"path with space 2\"", (LogicalPlan)new RefreshResource("path with space 2"));
            this.intercept("REFRESH a b", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\tb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\nb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\rb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\r\nb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH @ $a$", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH  ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource paths cannot be empty in REFRESH statements"}));
            this.intercept("REFRESH", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource paths cannot be empty in REFRESH statements"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("show functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("show functions", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)None$.MODULE$, true, true));
            this.assertEqual("show all functions", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)None$.MODULE$, true, true));
            this.assertEqual("show user functions", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)None$.MODULE$, true, false));
            this.assertEqual("show system functions", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)None$.MODULE$, false, true));
            this.intercept("show special functions", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHOW special FUNCTIONS"}));
            this.assertEqual("show functions foo", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)new Some((Object)"foo"), true, true));
            this.assertEqual("show functions foo.bar", (LogicalPlan)new ShowFunctionsCommand((Option)new Some((Object)"foo"), (Option)new Some((Object)"bar"), true, true));
            this.assertEqual("show functions 'foo\\\\.*'", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)new Some((Object)"foo\\.*"), true, true));
            this.intercept("show functions foo.bar.baz", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported function name"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("describe function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("describe function bar", (LogicalPlan)new DescribeFunctionCommand(new FunctionIdentifier("bar", (Option)None$.MODULE$), false));
            this.assertEqual("describe function extended bar", (LogicalPlan)new DescribeFunctionCommand(new FunctionIdentifier("bar", (Option)None$.MODULE$), true));
            this.assertEqual("describe function foo.bar", (LogicalPlan)new DescribeFunctionCommand(new FunctionIdentifier("bar", (Option)new Some((Object)"foo")), false));
            this.assertEqual("describe function extended f.bar", (LogicalPlan)new DescribeFunctionCommand(new FunctionIdentifier("bar", (Option)new Some((Object)"f")), true));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("create table - schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$58 = "my_tab";
            StructType x$59 = new StructType().add("a", (DataType)IntegerType$.MODULE$, true, "test").add("b", (DataType)StringType$.MODULE$);
            Option<String> x$60 = this.createTable$default$2();
            CatalogTableType x$61 = this.createTable$default$3();
            CatalogStorageFormat x$62 = this.createTable$default$4();
            Option<String> x$63 = this.createTable$default$6();
            Seq<String> x$64 = this.createTable$default$7();
            Option<String> x$65 = this.createTable$default$8();
            SaveMode x$66 = this.createTable$default$9();
            Option<LogicalPlan> x$67 = this.createTable$default$10();
            this.assertEqual("CREATE TABLE my_tab(a INT COMMENT 'test', b STRING)", (LogicalPlan)this.createTable(x$58, x$60, x$61, x$62, x$59, x$63, x$64, x$65, x$66, x$67));
            String x$68 = "my_tab";
            StructType x$69 = new StructType().add("a", (DataType)IntegerType$.MODULE$, true, "test").add("b", (DataType)StringType$.MODULE$).add("c", (DataType)IntegerType$.MODULE$).add("d", (DataType)StringType$.MODULE$, true, "test2");
            Seq x$70 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c", "d"}));
            Option<String> x$71 = this.createTable$default$2();
            CatalogTableType x$72 = this.createTable$default$3();
            CatalogStorageFormat x$73 = this.createTable$default$4();
            Option<String> x$74 = this.createTable$default$6();
            Option<String> x$75 = this.createTable$default$8();
            SaveMode x$76 = this.createTable$default$9();
            Option<LogicalPlan> x$77 = this.createTable$default$10();
            this.assertEqual("CREATE TABLE my_tab(a INT COMMENT 'test', b STRING) PARTITIONED BY (c INT, d STRING COMMENT 'test2')", (LogicalPlan)this.createTable(x$68, x$71, x$72, x$73, x$69, x$74, (Seq<String>)x$70, x$75, x$76, x$77));
            String x$78 = "my_tab";
            StructType x$79 = new StructType().add("id", (DataType)LongType$.MODULE$).add("nested", (DataType)new StructType().add("col1", (DataType)StringType$.MODULE$).add("col2", (DataType)IntegerType$.MODULE$));
            Option<String> x$80 = this.createTable$default$2();
            CatalogTableType x$81 = this.createTable$default$3();
            CatalogStorageFormat x$82 = this.createTable$default$4();
            Option<String> x$83 = this.createTable$default$6();
            Seq<String> x$84 = this.createTable$default$7();
            Option<String> x$85 = this.createTable$default$8();
            SaveMode x$86 = this.createTable$default$9();
            Option<LogicalPlan> x$87 = this.createTable$default$10();
            this.assertEqual("CREATE TABLE my_tab(id BIGINT, nested STRUCT<col1: STRING,col2: INT>)", (LogicalPlan)this.createTable(x$78, x$80, x$81, x$82, x$79, x$83, x$84, x$85, x$86, x$87));
            String x$88 = "my_tab";
            StructType x$89 = new StructType().add("a", (DataType)IntegerType$.MODULE$, true, "test").add("b", (DataType)StringType$.MODULE$).add("nested", (DataType)new StructType().add("col1", (DataType)StringType$.MODULE$).add("col2", (DataType)IntegerType$.MODULE$));
            Seq x$90 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nested"}));
            Option<String> x$91 = this.createTable$default$2();
            CatalogTableType x$92 = this.createTable$default$3();
            CatalogStorageFormat x$93 = this.createTable$default$4();
            Option<String> x$94 = this.createTable$default$6();
            Option<String> x$95 = this.createTable$default$8();
            SaveMode x$96 = this.createTable$default$9();
            Option<LogicalPlan> x$97 = this.createTable$default$10();
            this.assertEqual("CREATE TABLE my_tab(a INT COMMENT 'test', b STRING) PARTITIONED BY (nested STRUCT<col1: STRING,col2: INT>)", (LogicalPlan)this.createTable(x$88, x$91, x$92, x$93, x$89, x$94, (Seq<String>)x$90, x$95, x$96, x$97));
            this.intercept("CREATE TABLE my_tab(a: INT COMMENT 'test', b: STRING)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no viable alternative at input"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("create table using - schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$98 = "my_tab";
            StructType x$99 = new StructType().add("a", (DataType)IntegerType$.MODULE$, true, "test").add("b", (DataType)StringType$.MODULE$);
            Option<String> x$100 = this.createTableUsing$default$2();
            CatalogTableType x$101 = this.createTableUsing$default$3();
            CatalogStorageFormat x$102 = this.createTableUsing$default$4();
            Option<String> x$103 = this.createTableUsing$default$6();
            Seq<String> x$104 = this.createTableUsing$default$7();
            Option<BucketSpec> x$105 = this.createTableUsing$default$8();
            SaveMode x$106 = this.createTableUsing$default$9();
            Option<LogicalPlan> x$107 = this.createTableUsing$default$10();
            this.assertEqual("CREATE TABLE my_tab(a INT COMMENT 'test', b STRING) USING parquet", (LogicalPlan)this.createTableUsing(x$98, x$100, x$101, x$102, x$99, x$103, x$104, x$105, x$106, x$107));
            this.intercept("CREATE TABLE my_tab(a: INT COMMENT 'test', b: STRING) USING parquet", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no viable alternative at input"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("create view as insert into table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("CREATE VIEW testView AS INSERT INTO jt VALUES(1, 1)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: CREATE VIEW ... AS INSERT INTO"}));
            this.intercept("CREATE VIEW testView AS FROM jt INSERT INTO tbl1 SELECT * WHERE jt.id < 5 INSERT INTO tbl2 SELECT * WHERE jt.id > 4", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: CREATE VIEW ... AS FROM ... [INSERT INTO ...]+"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("SPARK-17328 Fix NPE with EXPLAIN DESCRIBE TABLE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("describe table t", (LogicalPlan)new DescribeTableCommand(TableIdentifier$.MODULE$.apply("t"), Predef$.MODULE$.Map().empty(), false));
            this.assertEqual("describe table extended t", (LogicalPlan)new DescribeTableCommand(TableIdentifier$.MODULE$.apply("t"), Predef$.MODULE$.Map().empty(), true));
            this.assertEqual("describe table formatted t", (LogicalPlan)new DescribeTableCommand(TableIdentifier$.MODULE$.apply("t"), Predef$.MODULE$.Map().empty(), true));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("describe table column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("DESCRIBE t col", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), false));
            this.assertEqual("DESCRIBE t `abc.xyz`", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc.xyz"})), false));
            this.assertEqual("DESCRIBE t abc.xyz", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "xyz"})), false));
            this.assertEqual("DESCRIBE t `a.b`.`x.y`", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a.b", "x.y"})), false));
            this.assertEqual("DESCRIBE TABLE t col", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), false));
            this.assertEqual("DESCRIBE TABLE EXTENDED t col", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), true));
            this.assertEqual("DESCRIBE TABLE FORMATTED t col", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), true));
            this.intercept("DESCRIBE TABLE t PARTITION (ds='1970-01-01') col", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DESC TABLE COLUMN for a specific partition is not supported"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("analyze table statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("analyze table t compute statistics", (LogicalPlan)new AnalyzeTableCommand(TableIdentifier$.MODULE$.apply("t"), false));
            this.assertEqual("analyze table t compute statistics noscan", (LogicalPlan)new AnalyzeTableCommand(TableIdentifier$.MODULE$.apply("t"), true));
            this.assertEqual("analyze table t partition (a) compute statistics nOscAn", (LogicalPlan)new AnalyzePartitionCommand(TableIdentifier$.MODULE$.apply("t"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)None$.MODULE$)})), true));
            TableIdentifier x$108 = TableIdentifier$.MODULE$.apply("t");
            boolean x$109 = false;
            Map x$110 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)new Some((Object)"11"))}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09', hr=11) COMPUTE STATISTICS", (LogicalPlan)new AnalyzePartitionCommand(x$108, x$110, x$109));
            TableIdentifier x$111 = TableIdentifier$.MODULE$.apply("t");
            boolean x$112 = true;
            Map x$113 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)new Some((Object)"11"))}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09', hr=11) COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$111, x$113, x$112));
            TableIdentifier x$114 = TableIdentifier$.MODULE$.apply("t");
            boolean x$115 = true;
            Map x$116 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09"))}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09') COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$114, x$116, x$115));
            TableIdentifier x$117 = TableIdentifier$.MODULE$.apply("t");
            boolean x$118 = false;
            Map x$119 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)None$.MODULE$)}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09', hr) COMPUTE STATISTICS", (LogicalPlan)new AnalyzePartitionCommand(x$117, x$119, x$118));
            TableIdentifier x$120 = TableIdentifier$.MODULE$.apply("t");
            boolean x$121 = true;
            Map x$122 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)None$.MODULE$)}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09', hr) COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$120, x$122, x$121));
            TableIdentifier x$123 = TableIdentifier$.MODULE$.apply("t");
            boolean x$124 = true;
            Map x$125 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)new Some((Object)"11"))}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds, hr=11) COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$123, x$125, x$124));
            TableIdentifier x$126 = TableIdentifier$.MODULE$.apply("t");
            boolean x$127 = false;
            Map x$128 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)None$.MODULE$)}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds, hr) COMPUTE STATISTICS", (LogicalPlan)new AnalyzePartitionCommand(x$126, x$128, x$127));
            TableIdentifier x$129 = TableIdentifier$.MODULE$.apply("t");
            boolean x$130 = true;
            Map x$131 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)None$.MODULE$)}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds, hr) COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$129, x$131, x$130));
            this.intercept("analyze table t compute statistics xxxx", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected `NOSCAN` instead of `xxxx`"}));
            this.intercept("analyze table t partition (a) compute statistics xxxx", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected `NOSCAN` instead of `xxxx`"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        this.test("analyze table column statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("ANALYZE TABLE t COMPUTE STATISTICS FOR COLUMNS", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
            this.assertEqual("ANALYZE TABLE t COMPUTE STATISTICS FOR COLUMNS key, value", (LogicalPlan)new AnalyzeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}))));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2017-06-10') COMPUTE STATISTICS FOR COLUMNS key, value", (LogicalPlan)new AnalyzeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}))));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("query organization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String baseSql = "select * from t";
            Project basePlan = new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedStar[]{new UnresolvedStar((Option)None$.MODULE$)})), (LogicalPlan)new UnresolvedRelation(TableIdentifier$.MODULE$.apply("t")));
            UnresolvedAttribute unresolvedAttribute = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute2 = UnresolvedAttribute$.MODULE$.apply("b");
            this.assertEqual(new StringBuilder(19).append(baseSql).append(" distribute by a, b").toString(), (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute), (LogicalPlan)basePlan, this.newConf().numShufflePartitions()));
            SortOrder sortOrder = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            UnresolvedAttribute unresolvedAttribute3 = UnresolvedAttribute$.MODULE$.apply("a");
            this.assertEqual(new StringBuilder(26).append(baseSql).append(" distribute by a sort by b").toString(), (LogicalPlan)new Sort((Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), false, (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute3), (LogicalPlan)basePlan, this.newConf().numShufflePartitions())));
            SortOrder sortOrder2 = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            SortOrder sortOrder3 = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            UnresolvedAttribute unresolvedAttribute4 = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute5 = UnresolvedAttribute$.MODULE$.apply("b");
            this.assertEqual(new StringBuilder(16).append(baseSql).append(" cluster by a, b").toString(), (LogicalPlan)new Sort((Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3).$colon$colon((Object)sortOrder2), false, (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute5).$colon$colon((Object)unresolvedAttribute4), (LogicalPlan)basePlan, this.newConf().numShufflePartitions())));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("pipeline concatenation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute2 = UnresolvedAttribute$.MODULE$.apply("b");
            Concat concat = new Concat((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute));
            UnresolvedAttribute unresolvedAttribute3 = UnresolvedAttribute$.MODULE$.apply("c");
            Concat concat2 = new Concat((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute3).$colon$colon((Object)concat));
            UnresolvedAlias unresolvedAlias = new UnresolvedAlias((Expression)concat2, UnresolvedAlias$.MODULE$.apply$default$2());
            this.assertEqual("SELECT a || b || c FROM t", (LogicalPlan)new Project((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAlias), (LogicalPlan)new UnresolvedRelation(TableIdentifier$.MODULE$.apply("t"))));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        this.test("SPARK-25046 Fix Alter View ... As Insert Into Table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("ALTER VIEW testView AS INSERT INTO jt VALUES(1, 1)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ALTER VIEW ... AS INSERT INTO"}));
            this.intercept("ALTER VIEW testView AS FROM jt INSERT INTO tbl1 SELECT * WHERE jt.id < 5 INSERT INTO tbl2 SELECT * WHERE jt.id > 4", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ALTER VIEW ... AS FROM ... [INSERT INTO ...]+"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
    }
}

