/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.WideSchemaBenchmark$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001-\u00111cV5eKN\u001b\u0007.Z7b\u0005\u0016t7\r[7be.T!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0011!\tia\"D\u0001\u0005\u0013\tyAAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003#Qi\u0011A\u0005\u0006\u0003'!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005U\u0011\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"DQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000fq\u0001!\u0019!C\u0005;\u0005Y1oY1mK\u001a\u000b7\r^8s+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#aA%oi\"1Q\u0005\u0001Q\u0001\ny\tAb]2bY\u00164\u0015m\u0019;pe\u0002Bqa\n\u0001C\u0002\u0013%\u0001&\u0001\u0007xS\u0012$\bn\u001d+p)\u0016\u001cH/F\u0001*!\rQSFH\u0007\u0002W)\u0011A\u0006I\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0018,\u0005\r\u0019V-\u001d\u0005\u0007a\u0001\u0001\u000b\u0011B\u0015\u0002\u001b]LG\r\u001e5t)>$Vm\u001d;!\u0011\u001d\u0011\u0004A1A\u0005\n!\nA\u0002Z3qi\"\u001cHk\u001c+fgRDa\u0001\u000e\u0001!\u0002\u0013I\u0013!\u00043faRD7\u000fV8UKN$\b\u0005\u0003\u00057\u0001!\u0015\r\u0011\"\u00038\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u0005A\u0004C\u0001\u000e:\u0013\tQ$A\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004=\u0001\u0001\u0007I\u0011B\u001f\u0002\u0011Ql\u0007OR5mKN,\u0012A\u0010\t\u0004\u007f\u001dSeB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019%\"\u0001\u0004=e>|GOP\u0005\u0002C%\u0011a\tI\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015J\u0001\u0003MSN$(B\u0001$!!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0002j_*\tq*\u0001\u0003kCZ\f\u0017BA)M\u0005\u00111\u0015\u000e\\3\t\u000fM\u0003\u0001\u0019!C\u0005)\u0006aA/\u001c9GS2,7o\u0018\u0013fcR\u0011Q\u000b\u0017\t\u0003?YK!a\u0016\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b3J\u000b\t\u00111\u0001?\u0003\rAH%\r\u0005\u00077\u0002\u0001\u000b\u0015\u0002 \u0002\u0013Ql\u0007OR5mKN\u0004\u0003bB/\u0001\u0001\u0004%IAX\u0001\u0004_V$X#A0\u0011\u0005-\u0003\u0017BA1M\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d\u0019\u0007\u00011A\u0005\n\u0011\fqa\\;u?\u0012*\u0017\u000f\u0006\u0002VK\"9\u0011LYA\u0001\u0002\u0004y\u0006BB4\u0001A\u0003&q,\u0001\u0003pkR\u0004\u0003\"B5\u0001\t\u0003R\u0017!\u00032fM>\u0014X-\u00117m)\u0005)\u0006\"\u00027\u0001\t\u0003R\u0017\u0001C1gi\u0016\u0014\u0018\t\u001c7\t\u000b9\u0004A\u0011\t6\u0002\u0013\u00054G/\u001a:FC\u000eD\u0007\"\u00029\u0001\t\u0013\t\u0018!D:bm\u0016\f5\u000fU1scV,G\u000f\u0006\u0002sqB\u00111/\u001e\b\u00035QL!A\u0012\u0002\n\u0005Y<(!\u0003#bi\u00064%/Y7f\u0015\t1%\u0001C\u0003z_\u0002\u0007!/\u0001\u0002eM\")1\u0010\u0001C\u0005y\u0006A\u0011\r\u001a3DCN,7\u000f\u0006\u0005V{\u0006-\u0011QBA\u0011\u0011\u0015q(\u00101\u0001\u0000\u0003%\u0011WM\\2i[\u0006\u00148\u000e\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001B\u0001\u0005kRLG.\u0003\u0003\u0002\n\u0005\r!!\u0003\"f]\u000eDW.\u0019:l\u0011\u0015I(\u00101\u0001s\u0011\u001d\tyA\u001fa\u0001\u0003#\tA\u0001Z3tGB!\u00111CA\u000e\u001d\u0011\t)\"a\u0006\u0011\u0005\u0005\u0003\u0013bAA\rA\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u0007!\u0011\u001d\t\u0019C\u001fa\u0001\u0003#\t\u0001b]3mK\u000e$xN\u001d")
public class WideSchemaBenchmark
extends SparkFunSuite
implements BeforeAndAfterEach {
    private SparkSession sparkSession;
    private final int scaleFactor;
    private final Seq<Object> widthsToTest;
    private final Seq<Object> depthsToTest;
    private List<File> tmpFiles;
    private OutputStream out;
    private volatile boolean bitmap$0;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    private int scaleFactor() {
        return this.scaleFactor;
    }

    private Seq<Object> widthsToTest() {
        return this.widthsToTest;
    }

    private Seq<Object> depthsToTest() {
        return this.depthsToTest;
    }

    private SparkSession sparkSession$lzycompute() {
        WideSchemaBenchmark wideSchemaBenchmark = this;
        synchronized (wideSchemaBenchmark) {
            if (!this.bitmap$0) {
                this.sparkSession = SparkSession$.MODULE$.builder().master("local[1]").appName("microbenchmark").getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.sparkSession;
    }

    private SparkSession sparkSession() {
        return !this.bitmap$0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    private List<File> tmpFiles() {
        return this.tmpFiles;
    }

    private void tmpFiles_$eq(List<File> x$1) {
        this.tmpFiles = x$1;
    }

    private OutputStream out() {
        return this.out;
    }

    private void out_$eq(OutputStream x$1) {
        this.out = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.out_$eq(new FileOutputStream(new File("benchmarks/WideSchemaBenchmark-results.txt")));
    }

    public void afterAll() {
        super.afterAll();
        this.out().close();
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        this.tmpFiles().foreach((Function1 & Serializable & scala.Serializable)tmpFile -> {
            Utils$.MODULE$.deleteRecursively(tmpFile);
            return BoxedUnit.UNIT;
        });
    }

    private Dataset<Row> saveAsParquet(Dataset<Row> df) {
        File tmpFile = File.createTempFile("WideSchemaBenchmark", "tmp");
        this.tmpFiles_$eq((List<File>)this.tmpFiles().$colon$colon((Object)tmpFile));
        tmpFile.delete();
        df.write().parquet(tmpFile.getAbsolutePath());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(tmpFile.isDirectory(), "tmpFile.isDirectory()", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        return this.sparkSession().read().parquet(tmpFile.getAbsolutePath());
    }

    private void addCases(Benchmark benchmark, Dataset<Row> df, String desc, String selector) {
        benchmark.addCase(new StringBuilder(14).append(desc).append(" (read in-mem)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append("sum(").append(selector).append(")").toString()})).collect());
        benchmark.addCase(new StringBuilder(14).append(desc).append(" (exec in-mem)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*", new StringBuilder(11).append("hash(").append(selector).append(") as f").toString()})).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append("sum(").append(selector).append(")").toString(), "sum(f)"})).collect());
        Dataset<Row> parquet = this.saveAsParquet(df);
        benchmark.addCase(new StringBuilder(15).append(desc).append(" (read parquet)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> parquet.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("sum(").append(selector).append(") as f").toString()})).collect());
        benchmark.addCase(new StringBuilder(16).append(desc).append(" (write parquet)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> this.saveAsParquet((Dataset<Row>)df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("sum(").append(selector).append(") as f").toString()}))));
    }

    public static final /* synthetic */ String $anonfun$new$3(int i) {
        return new StringBuilder(8).append("id as a_").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$new$7(int i) {
        return new StringBuilder(8).append("id as a_").append(i).toString();
    }

    public WideSchemaBenchmark() {
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.scaleFactor = 100000;
        this.widthsToTest = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 2500}));
        this.depthsToTest = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 250}));
        int $org_scalatest_assert_macro_left = this.scaleFactor();
        int $org_scalatest_assert_macro_right = BoxesRunTime.unboxToInt((Object)this.widthsToTest().max((Ordering)Ordering.Int$.MODULE$));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.tmpFiles = Nil$.MODULE$;
        this.out = null;
        this.ignore("parsing large select expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$6 = "parsing large select";
            long x$7 = 1L;
            Some x$8 = new Some((Object)this.out());
            int x$9 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$10 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$11 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$12 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$6, x$7, x$9, x$10, x$11, x$12, (Option)x$8);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> WideSchemaBenchmark.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                benchmark.addCase(new StringBuilder(19).append(width).append(" select expressions").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> this.sparkSession().range(1L).toDF().selectExpr((Seq)selectExpr));
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.ignore("many column field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$13 = "many column field r/w";
            long x$14 = this.scaleFactor();
            Some x$15 = new Some((Object)this.out());
            int x$16 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$17 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$18 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$19 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$13, x$14, x$16, x$17, x$18, x$19, (Option)x$15);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> WideSchemaBenchmark.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                Dataset df = this.sparkSession().range((long)numRows).toDF().selectExpr((Seq)selectExpr).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" cols x ").append(numRows).append(" rows").toString(), "a_1");
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.ignore("wide shallowly nested struct field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$20 = "wide shallowly nested struct field r/w";
            long x$21 = this.scaleFactor();
            Some x$22 = new Some((Object)this.out());
            int x$23 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$24 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$25 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$26 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$20, x$21, x$23, x$24, x$25, x$26, (Option)x$22);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                ObjectRef datum = ObjectRef.create((Object)"{");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    datum$1.elem = i == 1 ? new StringBuilder(0).append((String)datum$1.elem).append(new StringBuilder(11).append("\"value_").append(i).append("\": 1").toString()).toString() : new StringBuilder(0).append((String)datum$1.elem).append(new StringBuilder(13).append(", \"value_").append(i).append("\": 1").toString()).toString();
                });
                datum.elem = new StringBuilder(1).append((String)datum.elem).append("}").toString();
                datum.elem = new StringBuilder(35).append("{\"a\": {\"b\": {\"c\": ").append((String)datum.elem).append(", \"d\": ").append((String)datum.elem).append("}, \"e\": ").append((String)datum.elem).append("}}").toString();
                Dataset df = this.sparkSession().read().json(this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)datum$1.elem, this.sparkSession().implicits().newStringEncoder())).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "a.b.c.value_1");
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.ignore("deeply nested struct field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$27 = "deeply nested struct field r/w";
            long x$28 = this.scaleFactor();
            Some x$29 = new Some((Object)this.out());
            int x$30 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$31 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$32 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$33 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$27, x$28, x$30, x$31, x$32, x$33, (Option)x$29);
            this.depthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)depth -> {
                int numRows = this.scaleFactor() / depth;
                ObjectRef datum = ObjectRef.create((Object)"{\"value\": 1}");
                ObjectRef selector = ObjectRef.create((Object)"value");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), depth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    datum$2.elem = new StringBuilder(11).append("{\"value\": ").append((String)datum$2.elem).append("}").toString();
                    selector$2.elem = new StringBuilder(6).append((String)selector$2.elem).append(".value").toString();
                });
                Dataset df = this.sparkSession().read().json(this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)datum$2.elem, this.sparkSession().implicits().newStringEncoder())).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(depth).append(" deep x ").append(numRows).append(" rows").toString(), (String)selector.elem);
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.ignore("bushy struct field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$34 = "bushy struct field r/w";
            long x$35 = this.scaleFactor();
            Some x$36 = new Some((Object)this.out());
            int x$37 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$38 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$39 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$40 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$34, x$35, x$37, x$38, x$39, x$40, (Option)x$36);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 1000}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                int numNodes = 1;
                ObjectRef datum = ObjectRef.create((Object)"{\"value\": 1}");
                String selector = "value";
                int depth = 1;
                while (numNodes < width) {
                    numNodes *= 2;
                    datum.elem = new StringBuilder(23).append("{\"left_").append(depth).append("\": ").append((String)datum.elem).append(", \"right_").append(depth).append("\": ").append((String)datum.elem).append("}").toString();
                    selector = new StringBuilder(6).append("left_").append(depth).append(".").append(selector).toString();
                    ++depth;
                }
                Dataset df = this.sparkSession().read().json(this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)datum$3.elem, this.sparkSession().implicits().newStringEncoder())).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(16).append(numNodes).append(" x ").append(depth).append(" deep x ").append(numRows).append(" rows").toString(), selector);
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.ignore("wide array field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$41 = "wide array field r/w";
            long x$42 = this.scaleFactor();
            Some x$43 = new Some((Object)this.out());
            int x$44 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$45 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$46 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$47 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$41, x$42, x$44, x$45, x$46, x$47, (Option)x$43);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                ObjectRef datum = ObjectRef.create((Object)"{\"value\": [");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    datum$4.elem = i == 1 ? new StringBuilder(1).append((String)datum$4.elem).append("1").toString() : new StringBuilder(3).append((String)datum$4.elem).append(", 1").toString();
                });
                datum.elem = new StringBuilder(2).append((String)datum.elem).append("]}").toString();
                Dataset df = this.sparkSession().read().json(this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)datum$4.elem, this.sparkSession().implicits().newStringEncoder())).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "value[0]");
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.ignore("wide map field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$48 = "wide map field r/w";
            long x$49 = this.scaleFactor();
            Some x$50 = new Some((Object)this.out());
            int x$51 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$53 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$54 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$48, x$49, x$51, x$52, x$53, x$54, (Option)x$50);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                Tuple1 datum = new Tuple1((Object)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(6).append("value_").append(BoxesRunTime.unboxToInt((Object)i)).toString()), (Object)BoxesRunTime.boxToInteger((int)1)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(WideSchemaBenchmark.class.getClassLoader());
                public final class Org_apache_spark_sql_WideSchemaBenchmark$$typecreator16$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_WideSchemaBenchmark$$typecreator16$1(WideSchemaBenchmark $outer) {
                    }
                }
                Dataset df = this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$5 -> datum, this.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_WideSchemaBenchmark$$typecreator16$1(null)))).toDF().cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "_1[\"value_1\"]");
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
    }
}

