/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DatasetBenchmark;
import org.apache.spark.sql.DatasetBenchmark$;
import org.apache.spark.sql.DatasetBenchmark$ComplexAggregator$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.expressions.scalalang.typed$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class DatasetBenchmark$ {
    public static DatasetBenchmark$ MODULE$;

    static {
        new DatasetBenchmark$();
    }

    public Benchmark backToBackMapLong(SparkSession spark, long numRows, int numChains) {
        RDD rdd = spark.sparkContext().range(0L, numRows, spark.sparkContext().range$default$3(), spark.sparkContext().range$default$4());
        Dataset ds = spark.range(0L, numRows);
        Dataset df = ds.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}));
        JFunction1.mcJJ.sp & Serializable & scala.Serializable func = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)l -> l + 1L;
        Benchmark benchmark = new Benchmark("back-to-back map long", numRows, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("RDD", benchmark.addCase$default$2(), (Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DatasetBenchmark$.$anonfun$backToBackMapLong$2(numChains, rdd, (Function1)func, arg_0)));
        benchmark.addCase("DataFrame", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            Dataset res = df;
            for (int i = 0; i < numChains; ++i) {
                res = res.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}))).$((Seq)Nil$.MODULE$).$plus((Object)BoxesRunTime.boxToInteger((int)1)).as("l")}));
            }
            res.queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                DatasetBenchmark$.$anonfun$backToBackMapLong$5(x$2);
                return BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("Dataset", benchmark.addCase$default$2(), (Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DatasetBenchmark$.$anonfun$backToBackMapLong$6(spark, numChains, ds, (Function1)func, arg_0)));
        return benchmark;
    }

    public Benchmark backToBackMap(SparkSession spark, long numRows, int numChains) {
        Dataset df = spark.range(1L, numRows).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).as("l"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$).as("s")}));
        Benchmark benchmark = new Benchmark("back-to-back map", numRows, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        Function1 & Serializable & scala.Serializable func = (Function1 & Serializable & scala.Serializable)d -> new DatasetBenchmark.Data(d.l() + 1L, d.s());
        RDD rdd = spark.sparkContext().range(1L, numRows, spark.sparkContext().range$default$3(), spark.sparkContext().range$default$4()).map((Function1 & Serializable & scala.Serializable)l -> DatasetBenchmark$.$anonfun$backToBackMap$2(BoxesRunTime.unboxToLong((Object)l)), ClassTag$.MODULE$.apply(DatasetBenchmark.Data.class));
        benchmark.addCase("RDD", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            RDD res = rdd;
            for (int i = 0; i < numChains; ++i) {
                res = res.map(func, ClassTag$.MODULE$.apply(DatasetBenchmark.Data.class));
            }
            res.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                DatasetBenchmark$.$anonfun$backToBackMap$4(x$4);
                return BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("DataFrame", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            Dataset res = df;
            for (int i = 0; i < numChains; ++i) {
                res = res.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}))).$((Seq)Nil$.MODULE$).$plus((Object)BoxesRunTime.boxToInteger((int)1)).as("l"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).$((Seq)Nil$.MODULE$)}));
            }
            res.queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                DatasetBenchmark$.$anonfun$backToBackMap$6(x$5);
                return BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("Dataset", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_spark_sql_DatasetBenchmark$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_DatasetBenchmark$$typecreator4$1() {
                }
            }
            Dataset res = df.as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$typecreator4$1())));
            for (int i = 0; i < numChains; ++i) {
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                public final class Org_apache_spark_sql_DatasetBenchmark$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_DatasetBenchmark$$typecreator5$1() {
                    }
                }
                res = res.map(func, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$typecreator5$1())));
            }
            res.queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                DatasetBenchmark$.$anonfun$backToBackMap$8(x$6);
                return BoxedUnit.UNIT;
            });
        });
        return benchmark;
    }

    public Benchmark backToBackFilterLong(SparkSession spark, long numRows, int numChains) {
        RDD rdd = spark.sparkContext().range(1L, numRows, spark.sparkContext().range$default$3(), spark.sparkContext().range$default$4());
        Dataset ds = spark.range(1L, numRows);
        Dataset df = ds.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}));
        JFunction1.mcZJ.sp & Serializable & scala.Serializable func = (JFunction1.mcZJ.sp & Serializable & scala.Serializable)l -> l % 2L == 0L;
        Benchmark benchmark = new Benchmark("back-to-back filter Long", numRows, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("RDD", benchmark.addCase$default$2(), (Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DatasetBenchmark$.$anonfun$backToBackFilterLong$2(numChains, rdd, (Function1)func, arg_0)));
        benchmark.addCase("DataFrame", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            Dataset res = df;
            for (int i = 0; i < numChains; ++i) {
                res = res.filter(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToLong((long)2L)).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)0L)));
            }
            res.queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                DatasetBenchmark$.$anonfun$backToBackFilterLong$5(x$8);
                return BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("Dataset", benchmark.addCase$default$2(), (Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DatasetBenchmark$.$anonfun$backToBackFilterLong$6(spark, numChains, ds, (Function1)func, arg_0)));
        return benchmark;
    }

    public Benchmark backToBackFilter(SparkSession spark, long numRows, int numChains) {
        Dataset df = spark.range(1L, numRows).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).as("l"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$).as("s")}));
        Benchmark benchmark = new Benchmark("back-to-back filter", numRows, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        Function2 & Serializable & scala.Serializable func = (Function2 & Serializable & scala.Serializable)(d, i) -> BoxesRunTime.boxToBoolean((boolean)DatasetBenchmark$.$anonfun$backToBackFilter$1(d, BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq funcs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numChains).map((Function1 & Serializable & scala.Serializable)i -> DatasetBenchmark$.$anonfun$backToBackFilter$2(func, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        RDD rdd = spark.sparkContext().range(1L, numRows, spark.sparkContext().range$default$3(), spark.sparkContext().range$default$4()).map((Function1 & Serializable & scala.Serializable)l -> DatasetBenchmark$.$anonfun$backToBackFilter$4(BoxesRunTime.unboxToLong((Object)l)), ClassTag$.MODULE$.apply(DatasetBenchmark.Data.class));
        benchmark.addCase("RDD", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            RDD res = rdd;
            for (int i = 0; i < numChains; ++i) {
                res = res.filter((Function1)funcs.apply(i));
            }
            res.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                DatasetBenchmark$.$anonfun$backToBackFilter$6(x$10);
                return BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("DataFrame", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            Dataset res = df;
            for (int i = 0; i < numChains; ++i) {
                res = res.filter(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToLong((long)(100L + (long)i))).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)0L)));
            }
            res.queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                DatasetBenchmark$.$anonfun$backToBackFilter$8(x$11);
                return BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("Dataset", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_spark_sql_DatasetBenchmark$$typecreator12$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_DatasetBenchmark$$typecreator12$1() {
                }
            }
            Dataset res = df.as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$typecreator12$1())));
            for (int i = 0; i < numChains; ++i) {
                res = res.filter((Function1)funcs.apply(i));
            }
            res.queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                DatasetBenchmark$.$anonfun$backToBackFilter$10(x$12);
                return BoxedUnit.UNIT;
            });
        });
        return benchmark;
    }

    public Benchmark aggregate(SparkSession spark, long numRows) {
        Dataset df = spark.range(1L, numRows).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).as("l"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$).as("s")}));
        Benchmark benchmark = new Benchmark("aggregate", numRows, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        RDD rdd = spark.sparkContext().range(1L, numRows, spark.sparkContext().range$default$3(), spark.sparkContext().range$default$4()).map((Function1 & Serializable & scala.Serializable)l -> DatasetBenchmark$.$anonfun$aggregate$1(BoxesRunTime.unboxToLong((Object)l)), ClassTag$.MODULE$.apply(DatasetBenchmark.Data.class));
        benchmark.addCase("RDD sum", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> rdd.aggregate((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> BoxesRunTime.boxToLong((long)DatasetBenchmark$.$anonfun$aggregate$3(BoxesRunTime.unboxToLong((Object)x$13), x$14)), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$15, x$16) -> x$15 + x$16, ClassTag$.MODULE$.Long()));
        benchmark.addCase("DataFrame sum", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum((Column)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}))).$((Seq)Nil$.MODULE$))})).queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            DatasetBenchmark$.$anonfun$aggregate$6(x$17);
            return BoxedUnit.UNIT;
        }));
        benchmark.addCase("Dataset sum using Aggregator", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_spark_sql_DatasetBenchmark$$typecreator17$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_DatasetBenchmark$$typecreator17$1() {
                }
            }
            df.as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$typecreator17$1()))).select(typed$.MODULE$.sumLong((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToLong((long)d.l()))).queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
                DatasetBenchmark$.$anonfun$aggregate$9(x$18);
                return BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("Dataset complex Aggregator", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_spark_sql_DatasetBenchmark$$typecreator18$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_DatasetBenchmark$$typecreator18$1() {
                }
            }
            df.as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$typecreator18$1()))).select(DatasetBenchmark$ComplexAggregator$.MODULE$.toColumn()).queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
                DatasetBenchmark$.$anonfun$aggregate$11(x$19);
                return BoxedUnit.UNIT;
            });
        });
        return benchmark;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().master("local[*]").appName("Dataset benchmark").getOrCreate();
        int numRows = 100000000;
        int numChains = 10;
        Benchmark benchmark0 = this.backToBackMapLong(spark, numRows, numChains);
        Benchmark benchmark1 = this.backToBackMap(spark, numRows, numChains);
        Benchmark benchmark2 = this.backToBackFilterLong(spark, numRows, numChains);
        Benchmark benchmark3 = this.backToBackFilter(spark, numRows, numChains);
        Benchmark benchmark4 = this.aggregate(spark, numRows);
        benchmark0.run();
        benchmark1.run();
        benchmark2.run();
        benchmark3.run();
        benchmark4.run();
    }

    public static final /* synthetic */ void $anonfun$backToBackMapLong$2(int numChains$1, RDD rdd$1, Function1 func$1, int iter) {
        RDD res = rdd$1;
        for (int i = 0; i < numChains$1; ++i) {
            res = res.map(func$1, ClassTag$.MODULE$.Long());
        }
        res.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> {});
    }

    public static final /* synthetic */ void $anonfun$backToBackMapLong$5(InternalRow x$2) {
    }

    public static final /* synthetic */ void $anonfun$backToBackMapLong$7(InternalRow x$3) {
    }

    public static final /* synthetic */ void $anonfun$backToBackMapLong$6(SparkSession spark$1, int numChains$1, Dataset ds$1, Function1 func$1, int iter) {
        Dataset res = ds$1.as(spark$1.implicits().newLongEncoder());
        for (int i = 0; i < numChains$1; ++i) {
            res = res.map(func$1, spark$1.implicits().newLongEncoder());
        }
        res.queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            DatasetBenchmark$.$anonfun$backToBackMapLong$7(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ DatasetBenchmark.Data $anonfun$backToBackMap$2(long l) {
        return new DatasetBenchmark.Data(l, ((Object)BoxesRunTime.boxToLong((long)l)).toString());
    }

    public static final /* synthetic */ void $anonfun$backToBackMap$4(DatasetBenchmark.Data x$4) {
    }

    public static final /* synthetic */ void $anonfun$backToBackMap$6(InternalRow x$5) {
    }

    public static final /* synthetic */ void $anonfun$backToBackMap$8(InternalRow x$6) {
    }

    public static final /* synthetic */ void $anonfun$backToBackFilterLong$2(int numChains$3, RDD rdd$3, Function1 func$3, int iter) {
        RDD res = rdd$3;
        for (int i = 0; i < numChains$3; ++i) {
            res = res.filter(func$3);
        }
        res.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$7 -> {});
    }

    public static final /* synthetic */ void $anonfun$backToBackFilterLong$5(InternalRow x$8) {
    }

    public static final /* synthetic */ void $anonfun$backToBackFilterLong$7(InternalRow x$9) {
    }

    public static final /* synthetic */ void $anonfun$backToBackFilterLong$6(SparkSession spark$3, int numChains$3, Dataset ds$2, Function1 func$3, int iter) {
        Dataset res = ds$2.as(spark$3.implicits().newLongEncoder());
        for (int i = 0; i < numChains$3; ++i) {
            res = res.filter(func$3);
        }
        res.queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            DatasetBenchmark$.$anonfun$backToBackFilterLong$7(x$9);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$backToBackFilter$1(DatasetBenchmark.Data d, int i) {
        return d.l() % (100L + (long)i) == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$backToBackFilter$3(Function2 func$4, int i$1, DatasetBenchmark.Data d) {
        return BoxesRunTime.unboxToBoolean((Object)func$4.apply((Object)d, (Object)BoxesRunTime.boxToInteger((int)i$1)));
    }

    public static final /* synthetic */ Function1 $anonfun$backToBackFilter$2(Function2 func$4, int i) {
        return (Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DatasetBenchmark$.$anonfun$backToBackFilter$3(func$4, i, d));
    }

    public static final /* synthetic */ DatasetBenchmark.Data $anonfun$backToBackFilter$4(long l) {
        return new DatasetBenchmark.Data(l, ((Object)BoxesRunTime.boxToLong((long)l)).toString());
    }

    public static final /* synthetic */ void $anonfun$backToBackFilter$6(DatasetBenchmark.Data x$10) {
    }

    public static final /* synthetic */ void $anonfun$backToBackFilter$8(InternalRow x$11) {
    }

    public static final /* synthetic */ void $anonfun$backToBackFilter$10(InternalRow x$12) {
    }

    public static final /* synthetic */ DatasetBenchmark.Data $anonfun$aggregate$1(long l) {
        return new DatasetBenchmark.Data(l, ((Object)BoxesRunTime.boxToLong((long)l)).toString());
    }

    public static final /* synthetic */ long $anonfun$aggregate$3(long x$13, DatasetBenchmark.Data x$14) {
        return x$13 + x$14.l();
    }

    public static final /* synthetic */ void $anonfun$aggregate$6(InternalRow x$17) {
    }

    public static final /* synthetic */ void $anonfun$aggregate$9(InternalRow x$18) {
    }

    public static final /* synthetic */ void $anonfun$aggregate$11(InternalRow x$19) {
    }

    private DatasetBenchmark$() {
        MODULE$ = this;
    }
}

