/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class OracleDialect$
extends JdbcDialect
implements Product {
    public static final OracleDialect$ MODULE$;
    private final int BINARY_FLOAT;
    private final int BINARY_DOUBLE;
    private final int TIMESTAMPTZ;

    static {
        new OracleDialect$();
    }

    public int BINARY_FLOAT() {
        return this.BINARY_FLOAT;
    }

    public int BINARY_DOUBLE() {
        return this.BINARY_DOUBLE;
    }

    public int TIMESTAMPTZ() {
        return this.TIMESTAMPTZ;
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:oracle");
    }

    private boolean supportTimeZoneTypes() {
        TimeZone timeZone;
        TimeZone timeZone2 = timeZone = DateTimeUtils$.MODULE$.getTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone());
        TimeZone timeZone3 = TimeZone.getDefault();
        return !(timeZone2 != null ? !timeZone2.equals(timeZone3) : timeZone3 != null);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Object object;
        int n = sqlType;
        if (2 == n) {
            None$ none$;
            long scale = md == null ? 0L : md.build().getLong("scale");
            int n2 = size;
            switch (n2) {
                default: {
                    if (scale == -127L) {
                        none$ = Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
                case 0: {
                    none$ = Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                }
            }
            object = none$;
        } else {
            object = this.TIMESTAMPTZ() == n && this.supportTimeZoneTypes() ? new Some((Object)TimestampType$.MODULE$) : (this.BINARY_FLOAT() == n ? new Some((Object)FloatType$.MODULE$) : (this.BINARY_DOUBLE() == n ? new Some((Object)DoubleType$.MODULE$) : None$.MODULE$));
        }
        return object;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        Object object = BooleanType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NUMBER(1)", 16)) : (IntegerType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NUMBER(10)", 4)) : (LongType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NUMBER(19)", -5)) : (FloatType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NUMBER(19, 4)", 6)) : (DoubleType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NUMBER(19, 4)", 8)) : (ByteType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NUMBER(3)", 5)) : (ShortType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NUMBER(5)", 5)) : (StringType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("VARCHAR2(255)", 12)) : None$.MODULE$)))))));
        return object;
    }

    @Override
    public Object compileValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.escapeSql(string)}));
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder().append((Object)"{ts '").append((Object)timestamp).append((Object)"'}").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder().append((Object)"{d '").append((Object)date).append((Object)"'}").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object value) {
                    return OracleDialect$.MODULE$.compileValue(value);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        } else {
            object = value;
        }
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        String string = option instanceof Some && true == (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).x())) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", " CASCADE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
        return string;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public String productPrefix() {
        return "OracleDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OracleDialect$;
    }

    public int hashCode() {
        return 959235752;
    }

    public String toString() {
        return "OracleDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OracleDialect$() {
        MODULE$ = this;
        Product.class.$init$((Product)this);
        this.BINARY_FLOAT = 100;
        this.BINARY_DOUBLE = 101;
        this.TIMESTAMPTZ = -101;
    }
}

