/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class StateStoreTestsHelper$ {
    public static final StateStoreTestsHelper$ MODULE$;
    private final UnsafeProjection strProj;
    private final UnsafeProjection intProj;

    static {
        new StateStoreTestsHelper$();
    }

    public UnsafeProjection strProj() {
        return this.strProj;
    }

    public UnsafeProjection intProj() {
        return this.intProj;
    }

    public UnsafeRow stringToRow(String s) {
        return this.strProj().apply((InternalRow)new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)s)}), ClassTag$.MODULE$.Any()))).copy();
    }

    public UnsafeRow intToRow(int i) {
        return this.intProj().apply((InternalRow)new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}), ClassTag$.MODULE$.Any()))).copy();
    }

    public String rowToString(UnsafeRow row) {
        return row.getUTF8String(0).toString();
    }

    public int rowToInt(UnsafeRow row) {
        return row.getInt(0);
    }

    public Tuple2<String, Object> rowsToStringInt(UnsafeRowPair row) {
        return new Tuple2((Object)this.rowToString(row.key()), (Object)BoxesRunTime.boxToInteger((int)this.rowToInt(row.value())));
    }

    public Set<Tuple2<String, Object>> rowsToSet(Iterator<UnsafeRowPair> iterator2) {
        return iterator2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(UnsafeRowPair row) {
                return StateStoreTestsHelper$.MODULE$.rowsToStringInt(row);
            }
        }).toSet();
    }

    public void remove(StateStore store, Function1<String, Object> condition) {
        store.getRange((Option)None$.MODULE$, (Option)None$.MODULE$).foreach((Function1)new Serializable(store, condition){
            public static final long serialVersionUID = 0L;
            private final StateStore store$2;
            private final Function1 condition$1;

            public final void apply(UnsafeRowPair rowPair) {
                if (BoxesRunTime.unboxToBoolean((Object)this.condition$1.apply((Object)StateStoreTestsHelper$.MODULE$.rowToString(rowPair.key())))) {
                    this.store$2.remove(rowPair.key());
                }
            }
            {
                this.store$2 = store$2;
                this.condition$1 = condition$1;
            }
        });
    }

    public void put(StateStore store, String key, int value) {
        store.put(this.stringToRow(key), this.intToRow(value));
    }

    public Option<Object> get(StateStore store, String key) {
        return Option$.MODULE$.apply((Object)store.get(this.stringToRow(key))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(UnsafeRow row) {
                return StateStoreTestsHelper$.MODULE$.rowToInt(row);
            }
        });
    }

    public String newDir() {
        return Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toString();
    }

    private StateStoreTestsHelper$() {
        MODULE$ = this;
        this.strProj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{StringType$.MODULE$}));
        this.intProj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{IntegerType$.MODULE$}));
    }
}

