/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.stat;

import java.util.Locale;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.StddevSamp;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.execution.stat.StatFunctions;
import org.apache.spark.sql.execution.stat.StatFunctions$;
import org.apache.spark.sql.execution.stat.StatFunctions$$anonfun$15$;
import org.apache.spark.sql.execution.stat.StatFunctions$$anonfun$15$$anonfun$apply$7$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileByteRef;

public final class StatFunctions$
implements Logging {
    public static final StatFunctions$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StatFunctions$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Seq<Seq<Object>> multipleApproxQuantiles(Dataset<Row> df, Seq<String> cols, Seq<Object> probabilities, double relativeError) {
        Predef$.MODULE$.require(relativeError >= 0.0, (Function0)new Serializable(relativeError){
            public static final long serialVersionUID = 0L;
            private final double relativeError$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Relative Error must be non-negative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.relativeError$1)}));
            }
            {
                this.relativeError$1 = relativeError$1;
            }
        });
        Seq columns2 = (Seq)cols.map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$1;

            public final Column apply(String colName) {
                StructField field = this.df$1.schema().apply(colName);
                Predef$.MODULE$.require(field.dataType() instanceof NumericType, (Function0)new Serializable(this, field, colName){
                    public static final long serialVersionUID = 0L;
                    private final StructField field$1;
                    private final String colName$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Quantile calculation for column ", " with data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.colName$1, this.field$1.dataType()}))).append((Object)" is not supported.").toString();
                    }
                    {
                        this.field$1 = field$1;
                        this.colName$1 = colName$1;
                    }
                });
                return Column$.MODULE$.apply((Expression)new Cast(Column$.MODULE$.apply(colName).expr(), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3()));
            }
            {
                this.df$1 = df$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        QuantileSummaries[] emptySummaries = (QuantileSummaries[])Array$.MODULE$.fill(cols.size(), (Function0)new Serializable(relativeError){
            public static final long serialVersionUID = 0L;
            private final double relativeError$1;

            public final QuantileSummaries apply() {
                return new QuantileSummaries(QuantileSummaries$.MODULE$.defaultCompressThreshold(), this.relativeError$1, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4());
            }
            {
                this.relativeError$1 = relativeError$1;
            }
        }, ClassTag$.MODULE$.apply(QuantileSummaries.class));
        RDD<Row> qual$1 = df.select((Seq<Column>)columns2).rdd();
        QuantileSummaries[] x$6 = emptySummaries;
        Serializable x$7 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final QuantileSummaries[] apply(QuantileSummaries[] summaries, Row row) {
                return StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$apply$1(summaries, row);
            }
        };
        Serializable x$8 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final QuantileSummaries[] apply(QuantileSummaries[] sum1, QuantileSummaries[] sum2) {
                return StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$merge$1(sum1, sum2);
            }
        };
        int x$9 = qual$1.treeAggregate$default$4((Object)x$6);
        QuantileSummaries[] summaries = (QuantileSummaries[])qual$1.treeAggregate((Object)x$6, (Function2)x$7, (Function2)x$8, x$9, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(QuantileSummaries.class)));
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])summaries).map((Function1)new Serializable(probabilities){
            public static final long serialVersionUID = 0L;
            private final Seq probabilities$1;

            public final Seq<Object> apply(QuantileSummaries summary2) {
                return (Seq)this.probabilities$1.flatMap((Function1)new Serializable(this, summary2){
                    public static final long serialVersionUID = 0L;
                    private final QuantileSummaries summary$1;

                    public final Iterable<Object> apply(double quantile) {
                        return Option$.MODULE$.option2Iterable(this.summary$1.query(quantile));
                    }
                    {
                        this.summary$1 = summary$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.probabilities$1 = probabilities$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public double pearsonCorrelation(Dataset<Row> df, Seq<String> cols) {
        StatFunctions.CovarianceCounter counts = this.collectStatisticalData(df, cols, "correlation");
        return counts.Ck() / scala.math.package$.MODULE$.sqrt(counts.MkX() * counts.MkY());
    }

    private StatFunctions.CovarianceCounter collectStatisticalData(Dataset<Row> df, Seq<String> cols, String functionName) {
        Predef$.MODULE$.require(cols.length() == 2, (Function0)new Serializable(functionName){
            public static final long serialVersionUID = 0L;
            private final String functionName$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently ", " calculation is supported "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.functionName$1}))).append((Object)"between two columns.").toString();
            }
            {
                this.functionName$1 = functionName$1;
            }
        });
        ((IterableLike)cols.map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$2;

            public final Tuple2<String, Option<StructField>> apply(String name) {
                return new Tuple2((Object)name, (Object)Predef$.MODULE$.refArrayOps((Object[])this.df$2.schema().fields()).find((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$2;

                    public final boolean apply(StructField x$1) {
                        String string = x$1.name();
                        String string2 = this.name$2;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.name$2 = name$2;
                    }
                }));
            }
            {
                this.df$2 = df$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(functionName){
            public static final long serialVersionUID = 0L;
            public final String functionName$1;

            public final void apply(Tuple2<String, Option<StructField>> x0$2) {
                Tuple2<String, Option<StructField>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Option data = (Option)tuple2._2();
                    Predef$.MODULE$.require(data.nonEmpty(), (Function0)new Serializable(this, name){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find column with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                        }
                        {
                            this.name$1 = name$1;
                        }
                    });
                    Predef$.MODULE$.require(((StructField)data.get()).dataType() instanceof NumericType, (Function0)new Serializable(this, data){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.collectStatisticalData.3 $outer;
                        private final Option data$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently ", " calculation "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.functionName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for columns with dataType ", " not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((StructField)this.data$1.get()).dataType()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.data$1 = data$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.functionName$1 = functionName$1;
            }
        });
        Seq columns2 = (Seq)cols.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String n) {
                return Column$.MODULE$.apply((Expression)new Cast(Column$.MODULE$.apply(n).expr(), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        RDD<InternalRow> qual$2 = df.select((Seq<Column>)columns2).queryExecution().toRdd();
        StatFunctions.CovarianceCounter x$10 = new StatFunctions.CovarianceCounter();
        Serializable x$11 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StatFunctions.CovarianceCounter apply(StatFunctions.CovarianceCounter counter, InternalRow row) {
                return counter.add(row.getDouble(0), row.getDouble(1));
            }
        };
        Serializable x$12 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StatFunctions.CovarianceCounter apply(StatFunctions.CovarianceCounter baseCounter, StatFunctions.CovarianceCounter other) {
                return baseCounter.merge(other);
            }
        };
        int x$13 = qual$2.treeAggregate$default$4((Object)x$10);
        return (StatFunctions.CovarianceCounter)qual$2.treeAggregate((Object)x$10, (Function2)x$11, (Function2)x$12, x$13, ClassTag$.MODULE$.apply(StatFunctions.CovarianceCounter.class));
    }

    public double calculateCov(Dataset<Row> df, Seq<String> cols) {
        StatFunctions.CovarianceCounter counts = this.collectStatisticalData(df, cols, "covariance");
        return counts.cov();
    }

    public Dataset<Row> crossTabulate(Dataset<Row> df, String col1, String col2) {
        Map distinctCol2;
        int columnSize;
        String tableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col1, col2}));
        Row[] counts = (Row[])df.groupBy(col1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{col2})).agg(functions$.MODULE$.count("*"), (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).take((int)1000000.0);
        if (counts.length == (int)1000000.0) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The maximum limit of 1e6 pairs have been collected, which may not be all of the pairs. Please try reducing the amount of distinct items in your columns.";
                }
            });
        }
        Predef$.MODULE$.require((double)(columnSize = (distinctCol2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])counts).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row e) {
                return StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$cleanElement$1(e.get(1));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).distinct()).sorted((Ordering)Ordering.String$.MODULE$)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms())).size()) < 10000.0, (Function0)new Serializable(col2, columnSize){
            public static final long serialVersionUID = 0L;
            private final String col2$1;
            private final int columnSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of distinct values for ", ", can't "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col2$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exceed 1e4. Currently ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.columnSize$1)}))).toString();
            }
            {
                this.col2$1 = col2$1;
                this.columnSize$1 = columnSize$1;
            }
        });
        Seq table = ((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])counts).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row x$2) {
                return x$2.get(0);
            }
        }).map((Function1)new Serializable(distinctCol2, columnSize){
            public static final long serialVersionUID = 0L;
            public final Map distinctCol2$1;
            private final int columnSize$1;

            public final GenericInternalRow apply(Tuple2<Object, Row[]> x0$3) {
                Tuple2<Object, Row[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    Object col1Item = tuple2._1();
                    Row[] rows = (Row[])tuple2._2();
                    GenericInternalRow countsRow = new GenericInternalRow(this.columnSize$1 + 1);
                    Predef$.MODULE$.refArrayOps((Object[])rows).foreach((Function1)new Serializable(this, countsRow){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.10 $outer;
                        private final GenericInternalRow countsRow$1;

                        public final void apply(Row row) {
                            int columnIndex = BoxesRunTime.unboxToInt((Object)this.$outer.distinctCol2$1.get((Object)StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$cleanElement$1(row.get(1))).get());
                            this.countsRow$1.setLong(columnIndex + 1, row.getLong(2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.countsRow$1 = countsRow$1;
                        }
                    });
                    countsRow.update(0, (Object)UTF8String.fromString((String)StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$cleanElement$1(col1Item)));
                    GenericInternalRow genericInternalRow = countsRow;
                    return genericInternalRow;
                }
                throw new MatchError(tuple2);
            }
            {
                this.distinctCol2$1 = distinctCol2$1;
                this.columnSize$1 = columnSize$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Seq headerNames = (Seq)((TraversableLike)distinctCol2.toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x$3) {
                return x$3._2$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(Tuple2<Object, Object> r2) {
                return new StructField(StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$cleanColumnName$1(r2._1().toString()), (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        StructField structField = new StructField(tableName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema2 = StructType$.MODULE$.apply((Seq)headerNames.$plus$colon((Object)structField, Seq$.MODULE$.canBuildFrom()));
        return Dataset$.MODULE$.ofRows(df.sparkSession(), (LogicalPlan)new LocalRelation(schema2.toAttributes(), table, LocalRelation$.MODULE$.apply$default$3())).na().fill(0.0);
    }

    public Dataset<Row> summary(Dataset<?> ds, Seq<String> statistics) {
        ObjectRef aggResult$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Seq defaultStatistics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count", "mean", "stddev", "min", "25%", "50%", "75%", "max"}));
        Seq selectedStatistics = statistics.nonEmpty() ? statistics : defaultStatistics;
        Seq percentiles = (Seq)((TraversableLike)selectedStatistics.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String a) {
                return a.endsWith("%");
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(String p) {
                try {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(p)).stripSuffix("%"))).toDouble() / 100.0;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse ", " as a percentile"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p})), numberFormatException);
                }
            }
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(percentiles.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double p) {
                return this.apply$mcZD$sp(p);
            }

            public boolean apply$mcZD$sp(double p) {
                return p >= 0.0 && p <= 1.0;
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Percentiles must be in the range [0, 1]";
            }
        });
        IntRef percentileIndex = IntRef.create((int)0);
        Seq statisticFns = (Seq)selectedStatistics.map((Function1)new Serializable(percentiles, percentileIndex){
            public static final long serialVersionUID = 0L;
            public final Seq percentiles$1;
            private final IntRef percentileIndex$1;

            public final Function1<Expression, Expression> apply(String stats) {
                block9: {
                    Object object;
                    block3: {
                        Object object2;
                        block5: {
                            String string;
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            block2: {
                                                if (!stats.endsWith("%")) break block2;
                                                int index = this.percentileIndex$1.elem++;
                                                object = new Serializable(this, index){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun.15 $outer;
                                                    private final int index$1;

                                                    public final GetArrayItem apply(Expression child) {
                                                        JavaUniverse $u = package$.MODULE$.universe();
                                                        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatFunctions$.MODULE$.getClass().getClassLoader());
                                                        public final class Org_apache_spark_sql_execution_stat_StatFunctions$$anonfun$15$$anonfun$apply$7$$typecreator1$1
                                                        extends TypeCreator {
                                                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                                                Universe $u = $m$untyped.universe();
                                                                Mirror<U> $m = $m$untyped;
                                                                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor()})));
                                                            }

                                                            public Org_apache_spark_sql_execution_stat_StatFunctions$$anonfun$15$$anonfun$apply$7$$typecreator1$1(anonfun$15$$anonfun$apply$7 $outer) {
                                                            }
                                                        }
                                                        return new GetArrayItem((Expression)new ApproximatePercentile(child, (Expression)Literal$.MODULE$.create((Object)this.$outer.percentiles$1, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_stat_StatFunctions$$anonfun$15$$anonfun$apply$7$$typecreator1$1(this)))).toAggregateExpression(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.index$1)));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        this.index$1 = index$1;
                                                    }
                                                };
                                                break block3;
                                            }
                                            string = stats.toLowerCase(Locale.ROOT);
                                            if (!"count".equals(string)) break block4;
                                            object2 = new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final AggregateExpression apply(Expression child) {
                                                    return Count$.MODULE$.apply(child).toAggregateExpression();
                                                }
                                            };
                                            break block5;
                                        }
                                        if (!"mean".equals(string)) break block6;
                                        object2 = new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final AggregateExpression apply(Expression child) {
                                                return new Average(child).toAggregateExpression();
                                            }
                                        };
                                        break block5;
                                    }
                                    if (!"stddev".equals(string)) break block7;
                                    object2 = new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final AggregateExpression apply(Expression child) {
                                            return new StddevSamp(child).toAggregateExpression();
                                        }
                                    };
                                    break block5;
                                }
                                if (!"min".equals(string)) break block8;
                                object2 = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final AggregateExpression apply(Expression child) {
                                        return new Min(child).toAggregateExpression();
                                    }
                                };
                                break block5;
                            }
                            if (!"max".equals(string)) break block9;
                            object2 = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final AggregateExpression apply(Expression child) {
                                    return new Max(child).toAggregateExpression();
                                }
                            };
                        }
                        object = object2;
                    }
                    return object;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a recognised statistic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})));
            }
            {
                this.percentiles$1 = percentiles$1;
                this.percentileIndex$1 = percentileIndex$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq selectedCols = (Seq)ds.logicalPlan().output().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute a) {
                return a.dataType() instanceof NumericType || a.dataType() instanceof StringType;
            }
        });
        Seq aggExprs = (Seq)statisticFns.flatMap((Function1)new Serializable(selectedCols){
            public static final long serialVersionUID = 0L;
            private final Seq selectedCols$1;

            public final Seq<Column> apply(Function1<Expression, Expression> func) {
                return (Seq)this.selectedCols$1.map((Function1)new Serializable(this, func){
                    public static final long serialVersionUID = 0L;
                    private final Function1 func$1;

                    public final Column apply(Attribute c) {
                        return Column$.MODULE$.apply((Expression)new Cast((Expression)this.func$1.apply((Object)c), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3())).as(c.name());
                    }
                    {
                        this.func$1 = func$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.selectedCols$1 = selectedCols$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        InternalRow[] result = (InternalRow[])Array$.MODULE$.fill(selectedStatistics.length(), (Function0)new Serializable(selectedCols){
            public static final long serialVersionUID = 0L;
            private final Seq selectedCols$1;

            public final GenericInternalRow apply() {
                return new GenericInternalRow(this.selectedCols$1.length() + 1);
            }
            {
                this.selectedCols$1 = selectedCols$1;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class));
        IntRef rowIndex = IntRef.create((int)0);
        while (rowIndex.elem < result.length) {
            String statsName = (String)selectedStatistics.apply(rowIndex.elem);
            result[rowIndex.elem].update(0, (Object)UTF8String.fromString((String)statsName));
            selectedCols.indices().foreach$mVc$sp((Function1)new Serializable(ds, selectedCols, aggExprs, aggResult$lzy, result, rowIndex, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final Dataset ds$1;
                private final Seq selectedCols$1;
                private final Seq aggExprs$1;
                private final ObjectRef aggResult$lzy$1;
                private final InternalRow[] result$1;
                private final IntRef rowIndex$1;
                private final VolatileByteRef bitmap$0$1;

                public final void apply(int colIndex) {
                    this.apply$mcVI$sp(colIndex);
                }

                public void apply$mcVI$sp(int colIndex) {
                    UTF8String statsValue = StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$aggResult$1(this.ds$1, this.aggExprs$1, this.aggResult$lzy$1, this.bitmap$0$1).getUTF8String(this.rowIndex$1.elem * this.selectedCols$1.length() + colIndex);
                    this.result$1[this.rowIndex$1.elem].update(colIndex + 1, (Object)statsValue);
                }
                {
                    this.ds$1 = ds$1;
                    this.selectedCols$1 = selectedCols$1;
                    this.aggExprs$1 = aggExprs$1;
                    this.aggResult$lzy$1 = aggResult$lzy$1;
                    this.result$1 = result$1;
                    this.rowIndex$1 = rowIndex$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            ++rowIndex.elem;
        }
        String x$14 = "summary";
        StringType$ x$15 = StringType$.MODULE$;
        boolean x$16 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$17 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$18 = AttributeReference$.MODULE$.apply$default$5(x$14, (DataType)x$15, x$16, x$17);
        Option x$19 = AttributeReference$.MODULE$.apply$default$6(x$14, (DataType)x$15, x$16, x$17);
        AttributeReference attributeReference = new AttributeReference(x$14, (DataType)x$15, x$16, x$17, x$18, x$19);
        Seq output2 = (Seq)((SeqLike)selectedCols.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(Attribute c) {
                String x$20 = c.name();
                StringType$ x$21 = StringType$.MODULE$;
                boolean x$22 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$23 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$24 = AttributeReference$.MODULE$.apply$default$5(x$20, (DataType)x$21, x$22, x$23);
                Option x$25 = AttributeReference$.MODULE$.apply$default$6(x$20, (DataType)x$21, x$22, x$23);
                return new AttributeReference(x$20, (DataType)x$21, x$22, x$23, x$24, x$25);
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)attributeReference, Seq$.MODULE$.canBuildFrom());
        return Dataset$.MODULE$.ofRows(ds.sparkSession(), (LogicalPlan)new LocalRelation(output2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])result), LocalRelation$.MODULE$.apply$default$3()));
    }

    public final QuantileSummaries[] org$apache$spark$sql$execution$stat$StatFunctions$$apply$1(QuantileSummaries[] summaries, Row row) {
        for (int i = 0; i < summaries.length; ++i) {
            double v;
            if (row.isNullAt(i) || Predef$.MODULE$.double2Double(v = row.getDouble(i)).isNaN()) continue;
            summaries[i] = summaries[i].insert(v);
        }
        return summaries;
    }

    public final QuantileSummaries[] org$apache$spark$sql$execution$stat$StatFunctions$$merge$1(QuantileSummaries[] sum1, QuantileSummaries[] sum2) {
        return (QuantileSummaries[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sum1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sum2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final QuantileSummaries apply(Tuple2<QuantileSummaries, QuantileSummaries> x0$1) {
                Tuple2<QuantileSummaries, QuantileSummaries> tuple2 = x0$1;
                if (tuple2 != null) {
                    QuantileSummaries s1 = (QuantileSummaries)tuple2._1();
                    QuantileSummaries s2 = (QuantileSummaries)tuple2._2();
                    QuantileSummaries quantileSummaries = s1.compress().merge(s2.compress());
                    return quantileSummaries;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(QuantileSummaries.class)));
    }

    public final String org$apache$spark$sql$execution$stat$StatFunctions$$cleanElement$1(Object element) {
        return element == null ? "null" : element.toString();
    }

    public final String org$apache$spark$sql$execution$stat$StatFunctions$$cleanColumnName$1(String name) {
        return name.replace("`", "");
    }

    private final InternalRow aggResult$lzycompute$1(Dataset ds$1, Seq aggExprs$1, ObjectRef aggResult$lzy$1, VolatileByteRef bitmap$0$1) {
        StatFunctions$ statFunctions$ = this;
        synchronized (statFunctions$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                aggResult$lzy$1.elem = (InternalRow)Predef$.MODULE$.refArrayOps((Object[])ds$1.select((Seq<Column>)aggExprs$1).queryExecution().toRdd().collect()).head();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (InternalRow)aggResult$lzy$1.elem;
        }
    }

    public final InternalRow org$apache$spark$sql$execution$stat$StatFunctions$$aggResult$1(Dataset ds$1, Seq aggExprs$1, ObjectRef aggResult$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.aggResult$lzycompute$1(ds$1, aggExprs$1, aggResult$lzy$1, bitmap$0$1) : (InternalRow)aggResult$lzy$1.elem;
    }

    private StatFunctions$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

