/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.internal.SessionState;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CommandUtils$
implements Logging {
    public static final CommandUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CommandUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public void updateTableStats(SparkSession sparkSession, CatalogTable table) {
        if (table.stats().nonEmpty()) {
            SessionCatalog catalog2 = sparkSession.sessionState().catalog();
            if (sparkSession.sessionState().conf().autoSizeUpdateEnabled()) {
                CatalogTable newTable = catalog2.getTableMetadata(table.identifier());
                BigInt newSize = this.calculateTotalSize(sparkSession.sessionState(), newTable);
                CatalogStatistics newStats = new CatalogStatistics(newSize, CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
                catalog2.alterTableStats(table.identifier(), (Option)new Some((Object)newStats));
            } else {
                catalog2.alterTableStats(table.identifier(), (Option)None$.MODULE$);
            }
        }
    }

    public BigInt calculateTotalSize(SessionState sessionState2, CatalogTable catalogTable) {
        BigInt bigInt;
        if (catalogTable.partitionColumnNames().isEmpty()) {
            bigInt = BigInt$.MODULE$.long2bigInt(this.calculateLocationSize(sessionState2, catalogTable.identifier(), (Option<URI>)catalogTable.storage().locationUri()));
        } else {
            Seq partitions = sessionState2.catalog().listPartitions(catalogTable.identifier(), sessionState2.catalog().listPartitions$default$2());
            bigInt = BigInt$.MODULE$.long2bigInt(BoxesRunTime.unboxToLong((Object)((TraversableOnce)partitions.map((Function1)new Serializable(sessionState2, catalogTable){
                public static final long serialVersionUID = 0L;
                private final SessionState sessionState$1;
                private final CatalogTable catalogTable$1;

                public final long apply(CatalogTablePartition p) {
                    return CommandUtils$.MODULE$.calculateLocationSize(this.sessionState$1, this.catalogTable$1.identifier(), (Option<URI>)p.storage().locationUri());
                }
                {
                    this.sessionState$1 = sessionState$1;
                    this.catalogTable$1 = catalogTable$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        }
        return bigInt;
    }

    public long calculateLocationSize(SessionState sessionState2, TableIdentifier identifier, Option<URI> locationUri) {
        String stagingDir = sessionState2.conf().getConfString("hive.exec.stagingdir", ".hive-staging");
        long startTime = System.nanoTime();
        this.logInfo((Function0<String>)new Serializable(locationUri){
            public static final long serialVersionUID = 0L;
            private final Option locationUri$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting to calculate the total file size under path ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.locationUri$1}));
            }
            {
                this.locationUri$1 = locationUri$1;
            }
        });
        long size = BoxesRunTime.unboxToLong((Object)locationUri.map((Function1)new Serializable(sessionState2, identifier, stagingDir){
            public static final long serialVersionUID = 0L;
            private final SessionState sessionState$2;
            public final TableIdentifier identifier$1;
            private final String stagingDir$1;

            public final long apply(URI p) {
                long l;
                Path path = new Path(p);
                try {
                    FileSystem fs = path.getFileSystem(this.sessionState$2.newHadoopConf());
                    l = CommandUtils$.MODULE$.org$apache$spark$sql$execution$command$CommandUtils$$getPathSize$1(fs, path, this.stagingDir$1);
                }
                catch (Throwable throwable) {
                    long l2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    CommandUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this, e){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.3 $outer;
                        private final Throwable e$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get the size of table ", " in the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.identifier$1.table()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"database ", " because of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.identifier$1.database(), this.e$1.toString()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.e$1 = e$1;
                        }
                    }, e);
                    l = l2 = 0L;
                }
                return l;
            }
            {
                this.sessionState$2 = sessionState$2;
                this.identifier$1 = identifier$1;
                this.stagingDir$1 = stagingDir$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        long durationInMs = (System.nanoTime() - startTime) / 1000000L;
        this.logInfo((Function0<String>)new Serializable(locationUri, durationInMs){
            public static final long serialVersionUID = 0L;
            private final Option locationUri$1;
            private final long durationInMs$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It took ", " ms to calculate the total file size under path ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.durationInMs$1), this.locationUri$1}));
            }
            {
                this.locationUri$1 = locationUri$1;
                this.durationInMs$1 = durationInMs$1;
            }
        });
        return size;
    }

    public Option<CatalogStatistics> compareAndGetNewStats(Option<CatalogStatistics> oldStats, BigInt newTotalSize, Option<BigInt> newRowCount) {
        BigInt oldTotalSize = (BigInt)oldStats.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigInt apply(CatalogStatistics x$1) {
                return x$1.sizeInBytes();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigInt apply() {
                return package$.MODULE$.BigInt().apply(-1);
            }
        });
        BigInt oldRowCount = (BigInt)oldStats.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<BigInt> apply(CatalogStatistics x$2) {
                return x$2.rowCount();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigInt apply() {
                return package$.MODULE$.BigInt().apply(-1);
            }
        });
        None$ newStats = None$.MODULE$;
        if (newTotalSize.$greater$eq(BigInt$.MODULE$.int2bigInt(0))) {
            BigInt bigInt = newTotalSize;
            BigInt bigInt2 = oldTotalSize;
            if (bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2)) {
                newStats = new Some((Object)new CatalogStatistics(newTotalSize, CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3()));
            }
        }
        if (newRowCount.isDefined() && ((BigInt)newRowCount.get()).$greater$eq(BigInt$.MODULE$.int2bigInt(0)) && !BoxesRunTime.equals((Object)newRowCount.get(), (Object)oldRowCount)) {
            newStats = newStats.isDefined() ? newStats.map((Function1)new Serializable(newRowCount){
                public static final long serialVersionUID = 0L;
                private final Option newRowCount$1;

                public final CatalogStatistics apply(CatalogStatistics x$3) {
                    Option x$4 = this.newRowCount$1;
                    BigInt x$5 = x$3.copy$default$1();
                    Map x$6 = x$3.copy$default$3();
                    return x$3.copy(x$5, x$4, x$6);
                }
                {
                    this.newRowCount$1 = newRowCount$1;
                }
            }) : new Some((Object)new CatalogStatistics(oldTotalSize, newRowCount, CatalogStatistics$.MODULE$.apply$default$3()));
        }
        return newStats;
    }

    public final long org$apache$spark$sql$execution$command$CommandUtils$$getPathSize$1(FileSystem fs, Path path, String stagingDir$1) {
        FileStatus fileStatus = fs.getFileStatus(path);
        long size = fileStatus.isDirectory() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).map((Function1)new Serializable(stagingDir$1, fs){
            public static final long serialVersionUID = 0L;
            private final String stagingDir$1;
            private final FileSystem fs$1;

            public final long apply(FileStatus status) {
                return status.getPath().getName().startsWith(this.stagingDir$1) ? 0L : CommandUtils$.MODULE$.org$apache$spark$sql$execution$command$CommandUtils$$getPathSize$1(this.fs$1, status.getPath(), this.stagingDir$1);
            }
            {
                this.stagingDir$1 = stagingDir$1;
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : fileStatus.getLen();
        return size;
    }

    private CommandUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

