/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlanInfo$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.util.CallSite;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class SQLExecution$ {
    public static final SQLExecution$ MODULE$;
    private final String EXECUTION_ID_KEY;
    private final AtomicLong _nextExecutionId;
    private final ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution;
    private final boolean testing;

    static {
        new SQLExecution$();
    }

    public String EXECUTION_ID_KEY() {
        return this.EXECUTION_ID_KEY;
    }

    private AtomicLong _nextExecutionId() {
        return this._nextExecutionId;
    }

    private long nextExecutionId() {
        return this._nextExecutionId().getAndIncrement();
    }

    private ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution() {
        return this.executionIdToQueryExecution;
    }

    public QueryExecution getQueryExecution(long executionId) {
        return this.executionIdToQueryExecution().get(BoxesRunTime.boxToLong((long)executionId));
    }

    private boolean testing() {
        return this.testing;
    }

    public void checkSQLExecutionId(SparkSession sparkSession) {
        SparkContext sc = sparkSession.sparkContext();
        if (this.testing() && sc.getLocalProperty(this.EXECUTION_ID_KEY()) == null) {
            throw new IllegalStateException("Execution ID should be set");
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public <T> T withNewExecutionId(SparkSession sparkSession, QueryExecution queryExecution, Function0<T> body) {
        SparkContext sc = sparkSession.sparkContext();
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        long executionId = this.nextExecutionId();
        sc.setLocalProperty(this.EXECUTION_ID_KEY(), ((Object)BoxesRunTime.boxToLong((long)executionId)).toString());
        this.executionIdToQueryExecution().put(BoxesRunTime.boxToLong((long)executionId), queryExecution);
        CallSite callSite = sparkSession.sparkContext().getCallSite();
        sparkSession.sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionStart(executionId, callSite.shortForm(), callSite.longForm(), queryExecution.toString(), SparkPlanInfo$.MODULE$.fromSparkPlan(queryExecution.executedPlan()), System.currentTimeMillis()));
        Object object = body.apply();
        sparkSession.sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionEnd(executionId, System.currentTimeMillis()));
        this.executionIdToQueryExecution().remove(BoxesRunTime.boxToLong((long)executionId));
        sc.setLocalProperty(this.EXECUTION_ID_KEY(), oldExecutionId);
        return (T)object;
        {
            catch (Throwable throwable) {
                void var6_6;
                try {
                    sparkSession.sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionEnd((long)var6_6, System.currentTimeMillis()));
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    void var5_5;
                    void var4_4;
                    this.executionIdToQueryExecution().remove(BoxesRunTime.boxToLong((long)var6_6));
                    var4_4.setLocalProperty(this.EXECUTION_ID_KEY(), (String)var5_5);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withExecutionId(SparkContext sc, String executionId, Function0<T> body) {
        Object object;
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        try {
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), executionId);
            object = body.apply();
        }
        catch (Throwable throwable) {
            void var4_4;
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), (String)var4_4);
            throw throwable;
        }
        sc.setLocalProperty(this.EXECUTION_ID_KEY(), oldExecutionId);
        return (T)object;
    }

    private SQLExecution$() {
        MODULE$ = this;
        this.EXECUTION_ID_KEY = "spark.sql.execution.id";
        this._nextExecutionId = new AtomicLong(0L);
        this.executionIdToQueryExecution = new ConcurrentHashMap();
        this.testing = package$.MODULE$.props().contains("spark.testing");
    }
}

