/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.test;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkExecutorInfo;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.compatible.Assertion;
import org.scalatest.time.Span$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class SQLTestUtilsBase$class {
    public static SparkContext sparkContext(SQLTestUtilsBase $this) {
        return $this.spark().sparkContext();
    }

    public static Function1 sql(SQLTestUtilsBase $this) {
        SparkSession sparkSession = $this.spark();
        return new Serializable($this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession eta$0$1$1;

            public final Dataset<Row> apply(String sqlText) {
                return this.eta$0$1$1.sql(sqlText);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
    }

    public static void withSQLConf(SQLTestUtilsBase $this, Seq pairs, Function0 f) {
        SparkSession$.MODULE$.setActiveSession($this.spark());
        $this.org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(pairs, f);
    }

    /*
     * WARNING - void declaration
     */
    public static void withTempPath(SQLTestUtilsBase $this, Function1 f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        catch (Throwable throwable) {
            void var2_2;
            Utils$.MODULE$.deleteRecursively((File)var2_2);
            throw throwable;
        }
        Utils$.MODULE$.deleteRecursively(path);
    }

    public static void withResourceTempPath(SQLTestUtilsBase $this, String resourcePath, Function1 f) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        $this.withTempDir((Function1<File, BoxedUnit>)new Serializable($this, inputStream, f){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;
            private final Function1 f$1;

            public final void apply(File dir) {
                File tmpFile = new File(dir, "tmp");
                Files.copy(this.inputStream$1, tmpFile.toPath(), new CopyOption[0]);
                this.f$1.apply((Object)tmpFile);
            }
            {
                this.inputStream$1 = inputStream$1;
                this.f$1 = f$1;
            }
        });
    }

    public static void waitForTasksToFinish(SQLTestUtilsBase $this) {
        $this.eventually($this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds())), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLTestUtilsBase $outer;

            public final Assertion apply() {
                int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.spark().sparkContext().statusTracker().getExecutorInfos()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(SparkExecutorInfo x$1) {
                        return x$1.numRunningTasks();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.patienceConfig(), new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
    }

    /*
     * WARNING - void declaration
     */
    public static void withTempDir(SQLTestUtilsBase $this, Function1 f) {
        File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
        try {
            f.apply((Object)dir);
            $this.waitForTasksToFinish();
        }
        catch (Throwable throwable) {
            void var2_2;
            $this.waitForTasksToFinish();
            Utils$.MODULE$.deleteRecursively((File)var2_2);
            throw throwable;
        }
        Utils$.MODULE$.deleteRecursively(dir);
    }

    /*
     * WARNING - void declaration
     */
    public static void withTempPaths(SQLTestUtilsBase $this, int numPaths, Function1 f) {
        File[] files = (File[])Array$.MODULE$.fill(numPaths, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final File apply() {
                return Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
            }
        }, ClassTag$.MODULE$.apply(File.class));
        try {
            f.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])files));
            $this.waitForTasksToFinish();
        }
        catch (Throwable throwable) {
            void var3_3;
            $this.waitForTasksToFinish();
            Predef$.MODULE$.refArrayOps((Object[])var3_3).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final void apply(File file) {
                    Utils$.MODULE$.deleteRecursively(file);
                }
            });
            throw throwable;
        }
        Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void withUserDefinedFunction(SQLTestUtilsBase $this, Seq functions2, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                functions2.foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SQLTestUtilsBase $outer;

                    public final Assertion apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String functionName = (String)tuple2._1();
                            boolean isTemporary = tuple2._2$mcZ$sp();
                            String withTemporary = isTemporary ? "TEMPORARY" : "";
                            this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP ", " FUNCTION IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{withTemporary, functionName})));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.spark().sessionState().catalog().functionExists(FunctionIdentifier$.MODULE$.apply(functionName)), "SQLTestUtilsBase.this.spark.sessionState.catalog.functionExists(org.apache.spark.sql.catalyst.FunctionIdentifier.apply(functionName))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                            Assertion assertion = ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Function ", " should have been dropped. But, it still exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{functionName})), Prettifier$.MODULE$.default(), new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
                            return assertion;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                throw throwable2;
            }
        }
        functions2.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void withTempView(SQLTestUtilsBase $this, Seq viewNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            try {
                Catalog catalog = $this.spark().catalog();
                viewNames.foreach((Function1)new Serializable($this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final Catalog eta$0$2$1;

                    public final boolean apply(String viewName) {
                        return this.eta$0$2$1.dropTempView(viewName);
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                    }
                });
            }
            catch (NoSuchTableException noSuchTableException) {}
            throw throwable;
        }
        try {
            Catalog catalog = $this.spark().catalog();
            viewNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        }
        catch (NoSuchTableException noSuchTableException) {}
    }

    public static void withGlobalTempView(SQLTestUtilsBase $this, Seq viewNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            try {
                Catalog catalog = $this.spark().catalog();
                viewNames.foreach((Function1)new Serializable($this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final Catalog eta$0$3$1;

                    public final boolean apply(String viewName) {
                        return this.eta$0$3$1.dropGlobalTempView(viewName);
                    }
                    {
                        this.eta$0$3$1 = eta$0$3$1;
                    }
                });
            }
            catch (NoSuchTableException noSuchTableException) {}
            throw throwable;
        }
        try {
            Catalog catalog = $this.spark().catalog();
            viewNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        }
        catch (NoSuchTableException noSuchTableException) {}
    }

    public static void withTable(SQLTestUtilsBase $this, Seq tableNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            tableNames.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtilsBase $outer;

                public final Dataset<Row> apply(String name) {
                    return this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw throwable;
        }
        tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void withView(SQLTestUtilsBase $this, Seq viewNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            viewNames.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtilsBase $outer;

                public final Dataset<Row> apply(String name) {
                    return this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP VIEW IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw throwable;
        }
        viewNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    public static void withTempDatabase(SQLTestUtilsBase $this, Function1 f) {
        String dbName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID().toString().replace('-', '_')}));
        try {
            $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE DATABASE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})));
        }
        catch (Throwable throwable) {
            throw ((Assertions)$this).fail("Failed to create temporary database", throwable, new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        }
        try {
            f.apply((Object)dbName);
        }
        catch (Throwable throwable) {
            void var2_2;
            String string = $this.spark().catalog().currentDatabase();
            void var5_6 = var2_2;
            Object object = !(string != null ? !string.equals(var5_6) : var5_6 != null) ? $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SessionCatalog$.MODULE$.DEFAULT_DATABASE()}))) : BoxedUnit.UNIT;
            $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE ", " CASCADE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})));
            throw throwable;
        }
        String string = $this.spark().catalog().currentDatabase();
        String string2 = dbName;
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SessionCatalog$.MODULE$.DEFAULT_DATABASE()}))) : BoxedUnit.UNIT;
        $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE ", " CASCADE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})));
    }

    public static void withDatabase(SQLTestUtilsBase $this, Seq dbNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            dbNames.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtilsBase $outer;

                public final Dataset<Row> apply(String name) {
                    return this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE IF EXISTS ", " CASCADE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SessionCatalog$.MODULE$.DEFAULT_DATABASE()})));
            throw throwable;
        }
        dbNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SessionCatalog$.MODULE$.DEFAULT_DATABASE()})));
    }

    /*
     * WARNING - void declaration
     */
    public static void withLocale(SQLTestUtilsBase $this, String language, Function0 f) {
        Locale originalLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale(language));
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            void var3_3;
            Locale.setDefault((Locale)var3_3);
            throw throwable;
        }
        Locale.setDefault(originalLocale);
    }

    public static void activateDatabase(SQLTestUtilsBase $this, String db, Function0 f) {
        $this.spark().sessionState().catalog().setCurrentDatabase(db);
        try {
            f.apply$mcV$sp();
            return;
        }
        finally {
            $this.spark().sessionState().catalog().setCurrentDatabase("default");
        }
    }

    public static Dataset stripSparkFilter(SQLTestUtilsBase $this, Dataset df3) {
        StructType schema2 = df3.schema();
        SparkPlan withoutFilters = (SparkPlan)df3.queryExecution().sparkPlan().transform((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof FilterExec) {
                    FilterExec filterExec = (FilterExec)A1;
                    SparkPlan child = filterExec.child();
                    object = child;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof FilterExec;
                return bl;
            }
        });
        SparkSession qual$1 = $this.spark();
        RDD x$7 = withoutFilters.execute();
        StructType x$8 = schema2;
        boolean x$9 = qual$1.internalCreateDataFrame$default$3();
        return qual$1.internalCreateDataFrame(x$7, x$8, x$9);
    }

    public static Dataset logicalPlanToSparkQuery(SQLTestUtilsBase $this, LogicalPlan plan) {
        return Dataset$.MODULE$.ofRows($this.spark(), plan);
    }

    public static URI makeQualifiedPath(SQLTestUtilsBase $this, String path) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem($this.spark().sessionState().newHadoopConf());
        return fs.makeQualified(hadoopPath).toUri();
    }

    public static void $init$(SQLTestUtilsBase $this) {
    }
}

