/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.InternalRowCSVDataWriterFactory;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.SimpleCSVDataReaderFactory;
import org.apache.spark.sql.sources.v2.SimpleCSVDataWriterFactory;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.SupportsWriteInternalRow;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001=\u0011\u0001dU5na2,wK]5uC\ndW\rR1uCN{WO]2f\u0015\t\u0019A!\u0001\u0002we)\u0011QAB\u0001\bg>,(oY3t\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003\u0007\u000f !\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u00051!\u0015\r^1T_V\u00148-\u001a,3!\tIR$\u0003\u0002\u001f\u0005\tY!+Z1e'V\u0004\bo\u001c:u!\tI\u0002%\u0003\u0002\"\u0005\taqK]5uKN+\b\u000f]8si\")1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\u0012!\n\t\u00033\u0001Aqa\n\u0001C\u0002\u0013%\u0001&\u0001\u0004tG\",W.Y\u000b\u0002SA\u0011!&L\u0007\u0002W)\u0011AFB\u0001\u0006if\u0004Xm]\u0005\u0003]-\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0019\u0001\u0004\u0001)A\u0005S\u000591o\u00195f[\u0006\u0004c\u0001\u0002\u001a\u0001\u0001M\u0012aAU3bI\u0016\u00148cA\u0019\u0011iA\u0011Q\u0007O\u0007\u0002m)\u0011qGA\u0001\u0007e\u0016\fG-\u001a:\n\u0005e2$\u0001\u0005#bi\u0006\u001cv.\u001e:dKJ+\u0017\rZ3s\u0011!Y\u0014G!A!\u0002\u0013a\u0014\u0001\u00029bi\"\u0004\"!P\"\u000f\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005~B\u0001bR\u0019\u0003\u0002\u0003\u0006I\u0001S\u0001\u0005G>tg\r\u0005\u0002J\u001b6\t!J\u0003\u0002H\u0017*\u0011AJC\u0001\u0007Q\u0006$wn\u001c9\n\u00059S%!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003$c\u0011\u0005\u0001\u000bF\u0002R'R\u0003\"AU\u0019\u000e\u0003\u0001AQaO(A\u0002qBQaR(A\u0002!CQAV\u0019\u0005B]\u000b!B]3bIN\u001b\u0007.Z7b)\u0005I\u0003\"B-2\t\u0003R\u0016!G2sK\u0006$X\rR1uCJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:jKN$\u0012a\u0017\t\u00049~\u000bW\"A/\u000b\u0005y#\u0012\u0001B;uS2L!\u0001Y/\u0003\t1K7\u000f\u001e\t\u0004k\t$\u0017BA27\u0005E!\u0015\r^1SK\u0006$WM\u001d$bGR|'/\u001f\t\u0003K\u001al\u0011AB\u0005\u0003O\u001a\u00111AU8x\r\u0011I\u0007\u0001\u00016\u0003\r]\u0013\u0018\u000e^3s'\rA\u0007c\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\n\taa\u001e:ji\u0016\u0014\u0018B\u00019n\u0005A!\u0015\r^1T_V\u00148-Z,sSR,'\u000f\u0003\u0005sQ\n\u0005\t\u0015!\u0003=\u0003\u0015QwNY%e\u0011!Y\u0004N!A!\u0002\u0013a\u0004\u0002C$i\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b\rBG\u0011\u0001<\u0015\t]D\u0018P\u001f\t\u0003%\"DQA];A\u0002qBQaO;A\u0002qBQaR;A\u0002!CQ\u0001 5\u0005Bu\f1c\u0019:fCR,wK]5uKJ4\u0015m\u0019;pef$\u0012A \t\u0004Y~$\u0017bAA\u0001[\n\tB)\u0019;b/JLG/\u001a:GC\u000e$xN]=\t\u000f\u0005\u0015\u0001\u000e\"\u0011\u0002\b\u000511m\\7nSR$B!!\u0003\u0002\u0010A\u0019a(a\u0003\n\u0007\u00055qH\u0001\u0003V]&$\b\u0002CA\t\u0003\u0007\u0001\r!a\u0005\u0002\u00115,7o]1hKN\u0004RAPA\u000b\u00033I1!a\u0006@\u0005\u0015\t%O]1z!\ra\u00171D\u0005\u0004\u0003;i'aE,sSR,'oQ8n[&$X*Z:tC\u001e,\u0007bBA\u0011Q\u0012\u0005\u00131E\u0001\u0006C\n|'\u000f\u001e\u000b\u0005\u0003\u0013\t)\u0003\u0003\u0005\u0002\u0012\u0005}\u0001\u0019AA\n\r\u0019\tI\u0003\u0001\u0001\u0002,\t\t\u0012J\u001c;fe:\fGNU8x/JLG/\u001a:\u0014\u000b\u0005\u001dr/!\f\u0011\u00071\fy#C\u0002\u000225\u0014\u0001dU;qa>\u0014Ho],sSR,\u0017J\u001c;fe:\fGNU8x\u0011%\u0011\u0018q\u0005B\u0001B\u0003%A\bC\u0005<\u0003O\u0011\t\u0011)A\u0005y!Iq)a\n\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\bG\u0005\u001dB\u0011AA\u001e)!\ti$a\u0010\u0002B\u0005\r\u0003c\u0001*\u0002(!1!/!\u000fA\u0002qBaaOA\u001d\u0001\u0004a\u0004BB$\u0002:\u0001\u0007\u0001\n\u0003\u0004}\u0003O!\t% \u0005\t\u0003\u0013\n9\u0003\"\u0011\u0002L\u0005q2M]3bi\u0016Le\u000e^3s]\u0006d'k\\<Xe&$XM\u001d$bGR|'/\u001f\u000b\u0003\u0003\u001b\u0002B\u0001\\@\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0005\u00033\n\u0019FA\u0006J]R,'O\\1m%><\bbBA/\u0001\u0011\u0005\u0013qL\u0001\rGJ,\u0017\r^3SK\u0006$WM\u001d\u000b\u0004i\u0005\u0005\u0004\u0002CA2\u00037\u0002\r!!\u001a\u0002\u000f=\u0004H/[8ogB\u0019\u0011$a\u001a\n\u0007\u0005%$AA\tECR\f7k\\;sG\u0016|\u0005\u000f^5p]NDq!!\u001c\u0001\t\u0003\ny'\u0001\u0007de\u0016\fG/Z,sSR,'\u000f\u0006\u0006\u0002r\u0005]\u0014\u0011PA>\u0003\u000b\u0003B\u0001XA:W&\u0019\u0011QO/\u0003\u0011=\u0003H/[8oC2DaA]A6\u0001\u0004a\u0004BB\u0014\u0002l\u0001\u0007\u0011\u0006\u0003\u0005\u0002~\u0005-\u0004\u0019AA@\u0003\u0011iw\u000eZ3\u0011\u0007\u0015\f\t)C\u0002\u0002\u0004\u001a\u0011\u0001bU1wK6{G-\u001a\u0005\t\u0003G\nY\u00071\u0001\u0002f!9\u0011Q\u000e\u0001\u0005\n\u0005%E#C6\u0002\f\u00065\u00151TAO\u0011\u0019\u0011\u0018q\u0011a\u0001y!91(a\"A\u0002\u0005=\u0005\u0003BAI\u0003/k!!a%\u000b\u0007\u0005U5*\u0001\u0002gg&!\u0011\u0011TAJ\u0005\u0011\u0001\u0016\r\u001e5\t\r\u001d\u000b9\t1\u0001I\u0011!\ty*a\"A\u0002\u0005\u0005\u0016\u0001C5oi\u0016\u0014h.\u00197\u0011\u0007y\n\u0019+C\u0002\u0002&~\u0012qAQ8pY\u0016\fg\u000e")
public class SimpleWritableDataSource
implements ReadSupport,
WriteSupport {
    private final StructType org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema = new StructType().add("i", "long").add("j", "long");

    public StructType org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema() {
        return this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema;
    }

    public DataSourceReader createReader(DataSourceOptions options) {
        Path path = new Path((String)options.get("path").get());
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        return new Reader(this, path.toUri().toString(), conf);
    }

    public Optional<DataSourceWriter> createWriter(String jobId, StructType schema2, SaveMode mode, DataSourceOptions options) {
        Predef$.MODULE$.assert(DataType$.MODULE$.equalsStructurally((DataType)schema2.asNullable(), (DataType)this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema().asNullable(), DataType$.MODULE$.equalsStructurally$default$3()));
        Predef$.MODULE$.assert(!((SparkContext)SparkContext$.MODULE$.getActive().get()).conf().getBoolean("spark.speculation", false));
        Path path = new Path((String)options.get("path").get());
        boolean internal = options.get("internal").isPresent();
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        FileSystem fs = path.getFileSystem(conf);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.ErrorIfExists;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && fs.exists(path)) {
            throw new RuntimeException("data already exists.");
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && fs.exists(path)) {
            return Optional.empty();
        }
        SaveMode saveMode5 = mode;
        SaveMode saveMode6 = SaveMode.Overwrite;
        Object object = !(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(path, true)) : BoxedUnit.UNIT;
        return Optional.of(this.createWriter(jobId, path, conf, internal));
    }

    private DataSourceWriter createWriter(String jobId, Path path, Configuration conf, boolean internal) {
        String pathStr = path.toUri().toString();
        return internal ? new InternalRowWriter(this, jobId, pathStr, conf) : new Writer(this, jobId, pathStr, conf);
    }

    public class Reader
    implements DataSourceReader {
        private final String path;
        public final Configuration org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public StructType readSchema() {
            return this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer().org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema();
        }

        public List<DataReaderFactory<Row>> createDataReaderFactories() {
            Path dataPath = new Path(this.path);
            FileSystem fs = dataPath.getFileSystem(this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf);
            return fs.exists(dataPath) ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(dataPath)).filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileStatus status) {
                    String name = status.getPath().getName();
                    return name.startsWith("_") || name.startsWith(".");
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Reader $outer;

                public final DataReaderFactory<Row> apply(FileStatus f) {
                    SerializableConfiguration serializableConf = new SerializableConfiguration(this.$outer.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf);
                    return new SimpleCSVDataReaderFactory(f.getPath().toUri().toString(), serializableConf);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataReaderFactory.class)))).toList()).asJava() : Collections.emptyList();
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer() {
            return this.$outer;
        }

        public Reader(SimpleWritableDataSource $outer, String path, Configuration conf) {
            this.path = path;
            this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class Writer
    implements DataSourceWriter {
        private final String jobId;
        private final String path;
        private final Configuration conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public DataWriterFactory<Row> createWriterFactory() {
            return new SimpleCSVDataWriterFactory(this.path, this.jobId, new SerializableConfiguration(this.conf));
        }

        /*
         * WARNING - void declaration
         */
        public void commit(WriterCommitMessage[] messages) {
            Path finalPath = new Path(this.path);
            Path jobPath = new Path(new Path(finalPath, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            try {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(jobPath)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(FileStatus x$1) {
                        return x$1.getPath();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).foreach((Function1)new Serializable(this, finalPath, fs){
                    public static final long serialVersionUID = 0L;
                    private final Path finalPath$1;
                    private final FileSystem fs$1;

                    public final void apply(Path file) {
                        Path dest = new Path(this.finalPath$1, file.getName());
                        if (this.fs$1.rename(file, dest)) {
                            return;
                        }
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to rename(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, dest})));
                    }
                    {
                        this.finalPath$1 = finalPath$1;
                        this.fs$1 = fs$1;
                    }
                });
            }
            catch (Throwable throwable) {
                void var3_3;
                void var4_4;
                var4_4.delete((Path)var3_3, true);
                throw throwable;
            }
            fs.delete(jobPath, true);
        }

        public void abort(WriterCommitMessage[] messages) {
            Path jobPath = new Path(new Path(this.path, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            fs.delete(jobPath, true);
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Writer$$$outer() {
            return this.$outer;
        }

        public Writer(SimpleWritableDataSource $outer, String jobId, String path, Configuration conf) {
            this.jobId = jobId;
            this.path = path;
            this.conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class InternalRowWriter
    extends Writer
    implements SupportsWriteInternalRow {
        private final String jobId;
        private final String path;
        private final Configuration conf;

        @Override
        public DataWriterFactory<Row> createWriterFactory() {
            throw new IllegalArgumentException("not expected!");
        }

        public DataWriterFactory<InternalRow> createInternalRowWriterFactory() {
            return new InternalRowCSVDataWriterFactory(this.path, this.jobId, new SerializableConfiguration(this.conf));
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$InternalRowWriter$$$outer() {
            return this.$outer;
        }

        public InternalRowWriter(SimpleWritableDataSource $outer, String jobId, String path, Configuration conf) {
            this.jobId = jobId;
            this.path = path;
            this.conf = conf;
            super($outer, jobId, path, conf);
        }
    }
}

