/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.File;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStats;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStatsTrackerSuite$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001=\u0011qDQ1tS\u000e<&/\u001b;f)\u0006\u001c8n\u0015;biN$&/Y2lKJ\u001cV/\u001b;f\u0015\t\u0019A!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%IaG\u0001\bi\u0016l\u0007\u000fR5s+\u0005a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\tIwNC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"\u0001\u0002$jY\u0016Da!\n\u0001!\u0002\u0013a\u0012\u0001\u0003;f[B$\u0015N\u001d\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005YA/Z7q\t&\u0014\b+\u0019;i+\u0005I\u0003C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\t17O\u0003\u0002/\u0015\u00051\u0001.\u00193p_BL!\u0001M\u0016\u0003\tA\u000bG\u000f\u001b\u0005\u0007e\u0001\u0001\u000b\u0011B\u0015\u0002\u0019Q,W\u000e\u001d#jeB\u000bG\u000f\u001b\u0011\t\u000fQ\u0002!\u0019!C\u0005k\u0005!1m\u001c8g+\u00051\u0004CA\u001c:\u001b\u0005A$B\u0001\u001b.\u0013\tQ\u0004HA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0007y\u0001\u0001\u000b\u0011\u0002\u001c\u0002\u000b\r|gN\u001a\u0011\t\u000fy\u0002!\u0019!C\u0005\u007f\u00059An\\2bY\u001a\u001cX#\u0001!\u0011\u0005)\n\u0015B\u0001\",\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002!\u0002\u00111|7-\u00197gg\u0002BqA\u0012\u0001C\u0002\u0013%q)A\u0003eCR\f\u0017'F\u0001I!\rIEJT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n)\u0011I\u001d:bsB\u0011\u0011jT\u0005\u0003!*\u0013AAQ=uK\"1!\u000b\u0001Q\u0001\n!\u000ba\u0001Z1uCF\u0002\u0003b\u0002+\u0001\u0005\u0004%IaR\u0001\u0006I\u0006$\u0018M\r\u0005\u0007-\u0002\u0001\u000b\u0011\u0002%\u0002\r\u0011\fG/\u0019\u001a!\u0011\u001dA\u0006A1A\u0005\ne\u000bA\u0001\\3ocU\t!\f\u0005\u0002J7&\u0011AL\u0013\u0002\u0004\u0013:$\bB\u00020\u0001A\u0003%!,A\u0003mK:\f\u0004\u0005C\u0004a\u0001\t\u0007I\u0011B-\u0002\t1,gN\r\u0005\u0007E\u0002\u0001\u000b\u0011\u0002.\u0002\u000b1,gN\r\u0011\t\u000b\u0011\u0004A\u0011K3\u0002\u0011\u00054G/\u001a:BY2$\u0012A\u001a\t\u0003\u0013\u001eL!\u0001\u001b&\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\u0002!Ia[\u0001\fCN\u001cXM\u001d;Ti\u0006$8\u000f\u0006\u0003gYF\u001c\b\"B7j\u0001\u0004q\u0017a\u0002;sC\u000e\\WM\u001d\t\u00031=L!\u0001\u001d\u0002\u00035\t\u000b7/[2Xe&$X\rV1tWN#\u0018\r^:Ue\u0006\u001c7.\u001a:\t\u000bIL\u0007\u0019\u0001.\u0002\u000b\u0019LG.Z:\t\u000bQL\u0007\u0019\u0001.\u0002\u000b\tLH/Z:\t\u000bY\u0004A\u0011B<\u0002\u0017\u0019Lg.\u00197Ti\u0006$Xo\u001d\u000b\u0003qn\u0004\"\u0001G=\n\u0005i\u0014!a\u0005\"bg&\u001cwK]5uKR\u000b7o[*uCR\u001c\b\"B7v\u0001\u0004q\u0007\"B?\u0001\t\u0013q\u0018!\u0002;pk\u000eDGC\u00014\u0000\u0011\u0019\t\t\u0001 a\u0001S\u0005!a-\u001b7f\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\tQa\u001e:ji\u0016$b!!\u0003\u0002\u0016\u0005]\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=\u0001%\u0001\u0003mC:<\u0017\u0002BA\n\u0003\u001b\u0011q!\u00138uK\u001e,'\u000fC\u0004\u0002\u0002\u0005\r\u0001\u0019A\u0015\t\u000f\u0005e\u00111\u0001a\u0001\u0011\u0006!A-\u0019;b\u0011\u001d\ti\u0002\u0001C\u0005\u0003?\taa\u001e:ji\u0016\fDc\u00014\u0002\"!9\u0011\u0011AA\u000e\u0001\u0004I\u0003bBA\u0013\u0001\u0011%\u0011qE\u0001\u0007oJLG/\u001a\u001a\u0015\u0007\u0019\fI\u0003C\u0004\u0002\u0002\u0005\r\u0002\u0019A\u0015")
public class BasicWriteTaskStatsTrackerSuite
extends SparkFunSuite {
    private final File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
    private final Path org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath = new Path(this.tempDir().toURI());
    private final Configuration org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf = new Configuration();
    private final FileSystem org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$localfs = this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath().getFileSystem(this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
    private final byte[] org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$data1 = "0123456789".getBytes(Charset.forName("US-ASCII"));
    private final byte[] data2 = "012".getBytes(Charset.forName("US-ASCII"));
    private final int org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len1 = this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$data1().length;
    private final int org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len2 = this.data2().length;

    private File tempDir() {
        return this.tempDir;
    }

    public Path org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath() {
        return this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath;
    }

    public Configuration org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf() {
        return this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf;
    }

    public FileSystem org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$localfs() {
        return this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$localfs;
    }

    public byte[] org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$data1() {
        return this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$data1;
    }

    private byte[] data2() {
        return this.data2;
    }

    public int org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len1() {
        return this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len1;
    }

    public int org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len2() {
        return this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len2;
    }

    public void afterAll() {
        Utils$.MODULE$.deleteRecursively(this.tempDir());
    }

    public void org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(BasicWriteTaskStatsTracker tracker, int files, int bytes) {
        BasicWriteTaskStats stats = this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$finalStatus(tracker);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)files));
        int $org_scalatest_assert_macro_right = stats.numFiles();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Wrong number of files", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes));
        long $org_scalatest_assert_macro_right2 = stats.numBytes();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Wrong byte count of file size", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }

    public BasicWriteTaskStats org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$finalStatus(BasicWriteTaskStatsTracker tracker) {
        return (BasicWriteTaskStats)tracker.getFinalStats();
    }

    public void org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$touch(Path file) {
        this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$localfs().create(file, true).close();
    }

    /*
     * WARNING - void declaration
     */
    private Integer write(Path file, byte[] data) {
        FSDataOutputStream stream = this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$localfs().create(file, true);
        try {
            stream.write(data);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        stream.close();
        return Predef$.MODULE$.int2Integer(data.length);
    }

    public void org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write1(Path file) {
        this.write(file, this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$data1());
    }

    public void org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write2(Path file) {
        this.write(file, this.data2());
    }

    public BasicWriteTaskStatsTrackerSuite() {
        this.test("No files in run", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(tracker, 0, 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("Missing File", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path missing = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "missing");
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile(missing.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(tracker, 0, 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("Empty filename is forwarded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final IllegalArgumentException apply() {
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile("");
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this, tracker){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final BasicWriteTaskStatsTracker tracker$1;

                    public final BasicWriteTaskStats apply() {
                        return this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$finalStatus(this.tracker$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tracker$1 = tracker$1;
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            }

            public /* synthetic */ BasicWriteTaskStatsTrackerSuite org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("Null filename is only picked up in final status", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final IllegalArgumentException apply() {
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile(null);
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this, tracker){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final BasicWriteTaskStatsTracker tracker$2;

                    public final BasicWriteTaskStats apply() {
                        return this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$finalStatus(this.tracker$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tracker$2 = tracker$2;
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            }

            public /* synthetic */ BasicWriteTaskStatsTrackerSuite org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("0 byte file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path file = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "file0");
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile(file.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$touch(file);
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(tracker, 1, 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("File with data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path file = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "file-with-data");
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile(file.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write1(file);
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(tracker, 1, this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("Open file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                Assertion assertion;
                Path file = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "file-open");
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile(file.toString());
                FSDataOutputStream stream = this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$localfs().create(file, true);
                try {
                    this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(tracker, 1, 0);
                    stream.write(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$data1());
                    stream.flush();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)1));
                    int $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$finalStatus(tracker).numFiles();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Wrong number of files", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                }
                catch (Throwable throwable) {
                    void var3_3;
                    var3_3.close();
                    throw throwable;
                }
                stream.close();
                return assertion;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("Two files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path file1 = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "f-2-1");
                Path file2 = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "f-2-2");
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile(file1.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write1(file1);
                tracker.newFile(file2.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write2(file2);
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(tracker, 2, this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len1() + this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("Three files, last one empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path file1 = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "f-3-1");
                Path file2 = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "f-3-2");
                Path file3 = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "f-3-2");
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile(file1.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write1(file1);
                tracker.newFile(file2.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write2(file2);
                tracker.newFile(file3.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$touch(file3);
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(tracker, 3, this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len1() + this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("Three files, one not found", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTrackerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path file1 = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "f-4-1");
                Path file2 = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "f-4-2");
                Path file3 = new Path(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$tempDirPath(), "f-3-2");
                BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$conf());
                tracker.newFile(file1.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write1(file1);
                tracker.newFile(file2.toString());
                tracker.newFile(file3.toString());
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$write2(file3);
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$assertStats(tracker, 2, this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len1() + this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$$len2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
    }
}

