/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.benchmark.TPCDSQueryBenchmark$;
import org.apache.spark.sql.execution.benchmark.TPCDSQueryBenchmarkArguments;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TPCDSQueryBenchmark$
implements Logging {
    public static final TPCDSQueryBenchmark$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;
    private final Seq<String> tables;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new TPCDSQueryBenchmark$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public Seq<String> tables() {
        return this.tables;
    }

    public Map<String, Object> setupTables(String dataLocation) {
        return ((TraversableOnce)this.tables().map((Function1)new Serializable(dataLocation){
            public static final long serialVersionUID = 0L;
            private final String dataLocation$1;

            public final Tuple2<String, Object> apply(String tableName) {
                TPCDSQueryBenchmark$.MODULE$.spark().read().parquet(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataLocation$1, tableName}))).createOrReplaceTempView(tableName);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)BoxesRunTime.boxToLong((long)TPCDSQueryBenchmark$.MODULE$.spark().table(tableName).count()));
            }
            {
                this.dataLocation$1 = dataLocation$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void tpcdsAll(String dataLocation, Seq<String> queries) {
        Map<String, Object> tableSizes = this.setupTables(dataLocation);
        queries.foreach((Function1)new Serializable(tableSizes){
            public static final long serialVersionUID = 0L;
            public final Map tableSizes$1;

            public final void apply(String name) {
                String x$2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tpcds/", ".sql"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
                ClassLoader x$3 = Thread.currentThread().getContextClassLoader();
                String x$4 = package$.MODULE$.resourceToString$default$2();
                String queryString = package$.MODULE$.resourceToString(x$2, x$4, x$3);
                HashSet queryRelations = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
                TPCDSQueryBenchmark$.MODULE$.spark().sql(queryString).queryExecution().analyzed().foreach((Function1)new Serializable(this, queryRelations){
                    public static final long serialVersionUID = 0L;
                    private final HashSet queryRelations$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final void apply(LogicalPlan x0$1) {
                        LogicalRelation logicalRelation;
                        Option option;
                        LogicalPlan logicalPlan = x0$1;
                        if (logicalPlan instanceof SubqueryAlias) {
                            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
                            String alias = subqueryAlias.alias();
                            if (subqueryAlias.child() instanceof LogicalRelation) {
                                this.queryRelations$1.add((Object)alias);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        if (logicalPlan instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan).catalogTable()) instanceof Some) {
                            Some some = (Some)option;
                            CatalogTable catalogTable = (CatalogTable)some.x();
                            this.queryRelations$1.add((Object)catalogTable.identifier().table());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        if (logicalPlan instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan;
                            CatalogTable tableMeta = hiveTableRelation.tableMeta();
                            this.queryRelations$1.add((Object)tableMeta.identifier().table());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        this.queryRelations$1 = queryRelations$1;
                    }
                });
                long numRows = BoxesRunTime.unboxToLong((Object)((TraversableOnce)queryRelations.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.tpcdsAll.1 $outer;

                    public final long apply(String x$1) {
                        return BoxesRunTime.unboxToLong((Object)this.$outer.tableSizes$1.getOrElse((Object)x$1, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, HashSet$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                Benchmark benchmark = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TPCDS Snappy"})).s((Seq)Nil$.MODULE$), numRows, 5, Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark.addCase(name, benchmark.addCase$default$2(), (Function1)new Serializable(this, queryString){
                    public static final long serialVersionUID = 0L;
                    private final String queryString$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        TPCDSQueryBenchmark$.MODULE$.spark().sql(this.queryString$1).collect();
                    }
                    {
                        this.queryString$1 = queryString$1;
                    }
                });
                TPCDSQueryBenchmark$.MODULE$.logInfo((Function0<String>)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\n===== TPCDS QUERY BENCHMARK OUTPUT FOR ", " =====\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
                benchmark.run();
                TPCDSQueryBenchmark$.MODULE$.logInfo((Function0<String>)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\n===== FINISHED ", " =====\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
            }
            {
                this.tableSizes$1 = tableSizes$1;
            }
        });
    }

    public void main(String[] args) {
        Seq seq;
        TPCDSQueryBenchmarkArguments benchmarkArgs = new TPCDSQueryBenchmarkArguments(args);
        Seq tpcdsQueries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14a", "q14b", "q15", "q16", "q17", "q18", "q19", "q20", "q21", "q22", "q23a", "q23b", "q24a", "q24b", "q25", "q26", "q27", "q28", "q29", "q30", "q31", "q32", "q33", "q34", "q35", "q36", "q37", "q38", "q39a", "q39b", "q40", "q41", "q42", "q43", "q44", "q45", "q46", "q47", "q48", "q49", "q50", "q51", "q52", "q53", "q54", "q55", "q56", "q57", "q58", "q59", "q60", "q61", "q62", "q63", "q64", "q65", "q66", "q67", "q68", "q69", "q70", "q71", "q72", "q73", "q74", "q75", "q76", "q77", "q78", "q79", "q80", "q81", "q82", "q83", "q84", "q85", "q86", "q87", "q88", "q89", "q90", "q91", "q92", "q93", "q94", "q95", "q96", "q97", "q98", "q99"}));
        if (benchmarkArgs.queryFilter().nonEmpty()) {
            Seq queries = (Seq)tpcdsQueries.filter((Function1)new Serializable(benchmarkArgs){
                public static final long serialVersionUID = 0L;
                private final TPCDSQueryBenchmarkArguments benchmarkArgs$1;

                public final boolean apply(String x0$2) {
                    String string = x0$2;
                    boolean bl = this.benchmarkArgs$1.queryFilter().contains((Object)string);
                    return bl;
                }
                {
                    this.benchmarkArgs$1 = benchmarkArgs$1;
                }
            });
            if (queries.isEmpty()) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty queries to run. Bad query name filter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{benchmarkArgs.queryFilter()})));
            }
            seq = queries;
        } else {
            seq = tpcdsQueries;
        }
        Seq queriesToRun = seq;
        this.tpcdsAll(benchmarkArgs.dataLocation(), (Seq<String>)queriesToRun);
    }

    private TPCDSQueryBenchmark$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.conf = new SparkConf().setMaster("local[1]").setAppName("test-sql-context").set("spark.sql.parquet.compression.codec", "snappy").set("spark.sql.shuffle.partitions", "4").set("spark.driver.memory", "3g").set("spark.executor.memory", "3g").set("spark.sql.autoBroadcastJoinThreshold", ((Object)BoxesRunTime.boxToInteger((int)0x1400000)).toString()).set("spark.sql.crossJoin.enabled", "true");
        this.spark = SparkSession$.MODULE$.builder().config(this.conf()).getOrCreate();
        this.tables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"catalog_page", "catalog_returns", "customer", "customer_address", "customer_demographics", "date_dim", "household_demographics", "inventory", "item", "promotion", "store", "store_returns", "catalog_sales", "web_sales", "store_sales", "web_returns", "web_site", "reason", "call_center", "warehouse", "ship_mode", "income_band", "time_dim", "web_page"}));
    }
}

