/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.test;

import java.io.File;
import java.util.UUID;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkExecutorInfo;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.UninterruptibleThread;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Assertions;
import org.scalatest.FunSuiteLike;
import org.scalatest.Tag;
import org.scalatest.time.Span$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.util.control.NonFatal$;

public abstract class SQLTestUtils$class {
    public static SparkContext sparkContext(SQLTestUtils $this) {
        return $this.spark().sparkContext();
    }

    public static Function1 sql(SQLTestUtils $this) {
        SparkSession sparkSession = $this.spark();
        return new Serializable($this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession eta$0$1$1;

            public final Dataset<Row> apply(String sqlText) {
                return this.eta$0$1$1.sql(sqlText);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
    }

    public static void setupTestData(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(true);
    }

    public static void beforeAll(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll();
        if ($this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests()) {
            $this.loadTestData();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void withSQLConf(SQLTestUtils $this, Seq pairs, Function0 f) {
        Tuple2 tuple22;
        Tuple2 tuple2 = pairs.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq keys = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)keys, (Object)values);
        Seq keys2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        Seq currentValues = (Seq)keys2.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLTestUtils $outer;

            public final Option<String> apply(String key) {
                return this.$outer.spark().conf().contains(key) ? new Some((Object)this.$outer.spark().conf().get(key)) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        RuntimeConfig runtimeConfig = $this.spark().conf();
        Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)keys2, (Object)values2)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)new Serializable($this, runtimeConfig){
            public static final long serialVersionUID = 0L;
            private final RuntimeConfig eta$0$2$1;

            public final void apply(String key, String value) {
                this.eta$0$2$1.set(key, value);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            void var10_10;
            void var8_8;
            ((IterableLike)var8_8.zip((GenIterable)var10_10, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;

                public final void apply(Tuple2<String, Option<String>> x0$1) {
                    Tuple2<String, Option<String>> tuple2;
                    block4: {
                        block3: {
                            block2: {
                                tuple2 = x0$1;
                                if (tuple2 == null) break block2;
                                String key = (String)tuple2._1();
                                Option option = (Option)tuple2._2();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String value = (String)some.x();
                                this.$outer.spark().conf().set(key, value);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (tuple2 == null) break block4;
                            String key = (String)tuple2._1();
                            Option option = (Option)tuple2._2();
                            if (!None$.MODULE$.equals(option)) break block4;
                            this.$outer.spark().conf().unset(key);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw throwable;
        }
        ((IterableLike)keys2.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    public static void withTempPath(SQLTestUtils $this, Function1 f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        catch (Throwable throwable) {
            void var2_2;
            Utils$.MODULE$.deleteRecursively((File)var2_2);
            throw throwable;
        }
        Utils$.MODULE$.deleteRecursively(path);
    }

    public static void waitForTasksToFinish(SQLTestUtils $this) {
        $this.eventually($this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLTestUtils $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.spark().sparkContext().statusTracker().getExecutorInfos()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(SparkExecutorInfo x$2) {
                        return x$2.numRunningTasks();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.patienceConfig());
    }

    /*
     * WARNING - void declaration
     */
    public static void withTempDir(SQLTestUtils $this, Function1 f) {
        File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
        try {
            f.apply((Object)dir);
            $this.waitForTasksToFinish();
        }
        catch (Throwable throwable) {
            void var2_2;
            $this.waitForTasksToFinish();
            Utils$.MODULE$.deleteRecursively((File)var2_2);
            throw throwable;
        }
        Utils$.MODULE$.deleteRecursively(dir);
    }

    public static void withUserDefinedFunction(SQLTestUtils $this, Seq functions2, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                functions2.foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SQLTestUtils $outer;

                    public final void apply(Tuple2<String, Object> x0$2) {
                        Tuple2<String, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            String functionName = (String)tuple2._1();
                            boolean isTemporary = tuple2._2$mcZ$sp();
                            String withTemporary = isTemporary ? "TEMPORARY" : "";
                            this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP ", " FUNCTION IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{withTemporary, functionName})));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.spark().sessionState().catalog().functionExists(FunctionIdentifier$.MODULE$.apply(functionName)), "SQLTestUtils.this.spark.sessionState.catalog.functionExists(org.apache.spark.sql.catalyst.FunctionIdentifier.apply(functionName))"));
                            ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Function ", " should have been dropped. But, it still exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{functionName})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                throw throwable2;
            }
        }
        functions2.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void withTempView(SQLTestUtils $this, Seq tableNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            try {
                Catalog catalog = $this.spark().catalog();
                tableNames.foreach((Function1)new Serializable($this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final Catalog eta$0$3$1;

                    public final boolean apply(String viewName) {
                        return this.eta$0$3$1.dropTempView(viewName);
                    }
                    {
                        this.eta$0$3$1 = eta$0$3$1;
                    }
                });
            }
            catch (NoSuchTableException noSuchTableException) {}
            throw throwable;
        }
        try {
            Catalog catalog = $this.spark().catalog();
            tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        }
        catch (NoSuchTableException noSuchTableException) {}
    }

    public static void withTable(SQLTestUtils $this, Seq tableNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            tableNames.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;

                public final Dataset<Row> apply(String name) {
                    return this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw throwable;
        }
        tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void withView(SQLTestUtils $this, Seq viewNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            viewNames.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;

                public final Dataset<Row> apply(String name) {
                    return this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP VIEW IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw throwable;
        }
        viewNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    public static void withTempDatabase(SQLTestUtils $this, Function1 f) {
        String dbName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID().toString().replace('-', '_')}));
        try {
            $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE DATABASE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})));
        }
        catch (Throwable throwable) {
            throw ((Assertions)$this).fail("Failed to create temporary database", throwable);
        }
        try {
            f.apply((Object)dbName);
        }
        catch (Throwable throwable) {
            void var2_2;
            String string = $this.spark().catalog().currentDatabase();
            void var5_6 = var2_2;
            Object object = !(string != null ? !string.equals(var5_6) : var5_6 != null) ? $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SessionCatalog$.MODULE$.DEFAULT_DATABASE()}))) : BoxedUnit.UNIT;
            $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE ", " CASCADE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})));
            throw throwable;
        }
        String string = $this.spark().catalog().currentDatabase();
        String string2 = dbName;
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SessionCatalog$.MODULE$.DEFAULT_DATABASE()}))) : BoxedUnit.UNIT;
        $this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE ", " CASCADE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})));
    }

    public static void activateDatabase(SQLTestUtils $this, String db, Function0 f) {
        $this.spark().sessionState().catalog().setCurrentDatabase(db);
        try {
            f.apply$mcV$sp();
            return;
        }
        finally {
            $this.spark().sessionState().catalog().setCurrentDatabase("default");
        }
    }

    public static Dataset stripSparkFilter(SQLTestUtils $this, Dataset df) {
        StructType schema2 = df.schema();
        SparkPlan withoutFilters = (SparkPlan)df.queryExecution().sparkPlan().transform((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof FilterExec) {
                    FilterExec filterExec = (FilterExec)A1;
                    SparkPlan child = filterExec.child();
                    object = child;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof FilterExec;
                return bl;
            }
        });
        return $this.spark().internalCreateDataFrame(withoutFilters.execute(), schema2);
    }

    public static Dataset logicalPlanToSparkQuery(SQLTestUtils $this, LogicalPlan plan) {
        return Dataset$.MODULE$.ofRows($this.spark(), plan);
    }

    public static void testQuietly(SQLTestUtils $this, String name, Function0 f) {
        ((FunSuiteLike)$this).test(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function0 f$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                package$.MODULE$.quietly(this.f$1);
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static void testWithUninterruptibleThread(SQLTestUtils $this, String name, boolean quietly, Function0 body) {
        int timeoutMillis = 10000;
        ObjectRef ex = ObjectRef.create(null);
        if (quietly) {
            $this.testQuietly(name, (Function0<BoxedUnit>)new Serializable($this, timeoutMillis, ex, name, body){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;
                private final int timeoutMillis$1;
                private final ObjectRef ex$1;
                private final String name$1;
                private final Function0 body$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    SQLTestUtils$class.runOnThread$1(this.$outer, this.timeoutMillis$1, this.ex$1, this.name$1, this.body$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeoutMillis$1 = timeoutMillis$1;
                    this.ex$1 = ex$1;
                    this.name$1 = name$1;
                    this.body$1 = body$1;
                }
            });
        } else {
            ((FunSuiteLike)$this).test(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable($this, timeoutMillis, ex, name, body){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;
                private final int timeoutMillis$1;
                private final ObjectRef ex$1;
                private final String name$1;
                private final Function0 body$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    SQLTestUtils$class.runOnThread$1(this.$outer, this.timeoutMillis$1, this.ex$1, this.name$1, this.body$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeoutMillis$1 = timeoutMillis$1;
                    this.ex$1 = ex$1;
                    this.name$1 = name$1;
                    this.body$1 = body$1;
                }
            });
        }
    }

    public static boolean testWithUninterruptibleThread$default$2(SQLTestUtils $this) {
        return false;
    }

    public static final void runOnThread$1(SQLTestUtils $this, int timeoutMillis$1, ObjectRef ex$1, String name$1, Function0 body$1) {
        UninterruptibleThread thread = new UninterruptibleThread($this, ex$1, name$1, body$1){
            private final ObjectRef ex$1;
            private final Function0 body$1;

            public void run() {
                try {
                    this.body$1.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.ex$1.elem = e;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.ex$1 = ex$1;
                this.body$1 = body$1;
                super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Testing thread for test ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$1})));
            }
        };
        thread.setDaemon(true);
        thread.start();
        thread.join((long)timeoutMillis$1);
        if (thread.isAlive()) {
            thread.interrupt();
            throw ((Assertions)$this).fail(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test '", "' running on o.a.s.util.UninterruptibleThread timed out after"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)timeoutMillis$1)}))).toString());
        }
        if ((Throwable)ex$1.elem == null) {
            return;
        }
        throw (Throwable)ex$1.elem;
    }

    public static void $init$(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(false);
    }
}

