/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.StateStoreSuite;
import org.apache.spark.sql.execution.streaming.state.StoreUpdate;
import org.apache.spark.sql.execution.streaming.state.ValueAdded;
import org.apache.spark.sql.execution.streaming.state.ValueRemoved;
import org.apache.spark.sql.execution.streaming.state.ValueUpdated;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class StateStoreSuite$
implements Serializable {
    public static final StateStoreSuite$ MODULE$;
    private final UnsafeProjection strProj;
    private final UnsafeProjection intProj;

    static {
        new StateStoreSuite$();
    }

    public UnsafeProjection strProj() {
        return this.strProj;
    }

    public UnsafeProjection intProj() {
        return this.intProj;
    }

    public UnsafeRow stringToRow(String s) {
        return this.strProj().apply((InternalRow)new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)s)}), ClassTag$.MODULE$.Any()))).copy();
    }

    public UnsafeRow intToRow(int i) {
        return this.intProj().apply((InternalRow)new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}), ClassTag$.MODULE$.Any()))).copy();
    }

    public String rowToString(UnsafeRow row) {
        return row.getUTF8String(0).toString();
    }

    public int rowToInt(UnsafeRow row) {
        return row.getInt(0);
    }

    public Tuple2<Object, Object> rowsToIntInt(Tuple2<UnsafeRow, UnsafeRow> row) {
        return new Tuple2.mcII.sp(this.rowToInt((UnsafeRow)row._1()), this.rowToInt((UnsafeRow)row._2()));
    }

    public Tuple2<String, Object> rowsToStringInt(Tuple2<UnsafeRow, UnsafeRow> row) {
        return new Tuple2((Object)this.rowToString((UnsafeRow)row._1()), (Object)BoxesRunTime.boxToInteger((int)this.rowToInt((UnsafeRow)row._2())));
    }

    public Set<Tuple2<String, Object>> rowsToSet(Iterator<Tuple2<UnsafeRow, UnsafeRow>> iterator) {
        return iterator.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<UnsafeRow, UnsafeRow> row) {
                return StateStoreSuite$.MODULE$.rowsToStringInt(row);
            }
        }).toSet();
    }

    public Set<StateStoreSuite.TestUpdate> updatesToSet(Iterator<StoreUpdate> iterator) {
        return iterator.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Product apply(StoreUpdate x0$1) {
                StoreUpdate storeUpdate;
                block5: {
                    StateStoreSuite.TestUpdate testUpdate;
                    block3: {
                        block4: {
                            block2: {
                                storeUpdate = x0$1;
                                if (!(storeUpdate instanceof ValueAdded)) break block2;
                                ValueAdded valueAdded = (ValueAdded)storeUpdate;
                                UnsafeRow key = valueAdded.key();
                                UnsafeRow value = valueAdded.value();
                                testUpdate = new StateStoreSuite.Added(StateStoreSuite$.MODULE$.rowToString(key), StateStoreSuite$.MODULE$.rowToInt(value));
                                break block3;
                            }
                            if (!(storeUpdate instanceof ValueUpdated)) break block4;
                            ValueUpdated valueUpdated = (ValueUpdated)storeUpdate;
                            UnsafeRow key = valueUpdated.key();
                            UnsafeRow value = valueUpdated.value();
                            testUpdate = new StateStoreSuite.Updated(StateStoreSuite$.MODULE$.rowToString(key), StateStoreSuite$.MODULE$.rowToInt(value));
                            break block3;
                        }
                        if (!(storeUpdate instanceof ValueRemoved)) break block5;
                        ValueRemoved valueRemoved = (ValueRemoved)storeUpdate;
                        UnsafeRow key = valueRemoved.key();
                        testUpdate = new StateStoreSuite.Removed(StateStoreSuite$.MODULE$.rowToString(key));
                    }
                    return testUpdate;
                }
                throw new MatchError((Object)storeUpdate);
            }
        }).toSet();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StateStoreSuite$() {
        MODULE$ = this;
        this.strProj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{StringType$.MODULE$}));
        this.intProj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{IntegerType$.MODULE$}));
    }
}

