/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutorSuite$$anonfun$4$;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;

@ScalaSignature(bytes="\u0006\u0001\u001d2A!\u0001\u0002\u0001\u001f\tY\u0002K]8dKN\u001c\u0018N\\4US6,W\t_3dkR|'oU;ji\u0016T!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0013Y\u0012\u0001\u0006;fgR\u0014\u0015\r^2i)\u0016\u0014X.\u001b8bi&|g\u000e\u0006\u0002\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5u\u0011\u0015\u0019\u0013\u00041\u0001%\u0003)Ig\u000e^3sm\u0006dWj\u001d\t\u0003;\u0015J!A\n\u0010\u0003\t1{gn\u001a")
public class ProcessingTimeExecutorSuite
extends SparkFunSuite {
    public void org$apache$spark$sql$execution$streaming$ProcessingTimeExecutorSuite$$testBatchTermination(long intervalMs) {
        IntRef batchCounts = IntRef.create((int)0);
        ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTime(intervalMs), ProcessingTimeExecutor$.MODULE$.apply$default$2());
        processingTimeExecutor.execute((Function0)new Serializable(this, batchCounts){
            public static final long serialVersionUID = 0L;
            private final IntRef batchCounts$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ++this.batchCounts$1.elem;
                return this.batchCounts$1.elem < 3;
            }
            {
                this.batchCounts$1 = batchCounts$1;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounts.elem));
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public ProcessingTimeExecutorSuite() {
        this.test("nextBatchTime", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessingTimeExecutorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTime(100L), ProcessingTimeExecutor$.MODULE$.apply$default$2());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(0L)));
                int $org_scalatest_assert_macro_right = 100;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(1L)));
                int $org_scalatest_assert_macro_right2 = 100;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(99L)));
                int $org_scalatest_assert_macro_right3 = 100;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(100L)));
                int $org_scalatest_assert_macro_right4 = 200;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(101L)));
                int $org_scalatest_assert_macro_right5 = 200;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(150L)));
                int $org_scalatest_assert_macro_right6 = 200;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("calling nextBatchTime with the result of a previous call should return the next interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessingTimeExecutorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int intervalMS = 100;
                ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTime((long)intervalMS), ProcessingTimeExecutor$.MODULE$.apply$default$2());
                int ITERATION = 10;
                LongRef nextBatchTime = LongRef.create((long)0L);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), ITERATION).foreach$mVc$sp((Function1)new Serializable(this, processingTimeExecutor, nextBatchTime){
                    public static final long serialVersionUID = 0L;
                    private final ProcessingTimeExecutor processingTimeExecutor$1;
                    private final LongRef nextBatchTime$1;

                    public final void apply(int it) {
                        this.apply$mcVI$sp(it);
                    }

                    public void apply$mcVI$sp(int it) {
                        this.nextBatchTime$1.elem = this.processingTimeExecutor$1.nextBatchTime(this.nextBatchTime$1.elem);
                    }
                    {
                        this.processingTimeExecutor$1 = processingTimeExecutor$1;
                        this.nextBatchTime$1 = nextBatchTime$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)nextBatchTime.elem));
                int $org_scalatest_assert_macro_right = intervalMS * ITERATION;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("batch termination", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessingTimeExecutorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$streaming$ProcessingTimeExecutorSuite$$testBatchTermination(0L);
                this.$outer.org$apache$spark$sql$execution$streaming$ProcessingTimeExecutorSuite$$testBatchTermination(10L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("notifyBatchFallingBehind", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessingTimeExecutorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ManualClock clock = new ManualClock();
                VolatileBooleanRef batchFallingBehindCalled = VolatileBooleanRef.create((boolean)false);
                CountDownLatch latch = new CountDownLatch(1);
                Thread t = new Thread(this, clock, batchFallingBehindCalled, latch){
                    public final ManualClock clock$1;
                    public final VolatileBooleanRef batchFallingBehindCalled$1;
                    public final CountDownLatch latch$1;

                    public void run() {
                        ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(this){
                            private final /* synthetic */ $anonfun$4$$anon$2 $outer;

                            public void notifyBatchFallingBehind(long realElapsedTimeMs) {
                                this.$outer.batchFallingBehindCalled$1.elem = true;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(new ProcessingTime(100L), (Clock)$outer.clock$1);
                            }
                        };
                        processingTimeExecutor.execute((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anon$2 $outer;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                this.$outer.latch$1.countDown();
                                this.$outer.clock$1.waitTillTime(200L);
                                return false;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.clock$1 = clock$1;
                        this.batchFallingBehindCalled$1 = batchFallingBehindCalled$1;
                        this.latch$1 = latch$1;
                    }
                };
                t.start();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(latch.await(10L, TimeUnit.SECONDS), "latch.await(10L, SECONDS)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the batch has not yet started in 10 seconds");
                clock.advance(200L);
                t.join();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)batchFallingBehindCalled.elem));
                boolean $org_scalatest_assert_macro_right = true;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

