/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.TestMemoryManager;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.python.DiskRowQueue;
import org.apache.spark.sql.execution.python.HybridRowQueue;
import org.apache.spark.sql.execution.python.InMemoryRowQueue;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e1A!\u0001\u0002\u0001\u001f\ti!k\\<Rk\u0016,XmU;ji\u0016T!a\u0001\u0003\u0002\rALH\u000f[8o\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011\u0001C\u0005\u0003'!\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0001")
public class RowQueueSuite
extends SparkFunSuite {
    public RowQueueSuite() {
        this.test("in-memory queue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowQueueSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MemoryBlock page = MemoryBlock.fromLongArray((long[])new long[1024]);
                InMemoryRowQueue queue = new InMemoryRowQueue(this, page){

                    public void close() {
                    }
                };
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(new byte[16], 16);
                long n = page.size() / (long)(4 + row.getSizeInBytes());
                int i = 0;
                while ((long)i < n) {
                    row.setLong(0, (long)i);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"fail to add");
                    ++i;
                }
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should not add more");
                i = 0;
                while ((long)i < n) {
                    UnsafeRow row2;
                    UnsafeRow $org_scalatest_assert_macro_left = row2 = queue.remove();
                    Object $org_scalatest_assert_macro_right = null;
                    UnsafeRow unsafeRow = $org_scalatest_assert_macro_left;
                    Object var13_12 = null;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, unsafeRow != null ? !unsafeRow.equals(var13_12) : var13_12 != null);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"fail to poll");
                    long $org_scalatest_assert_macro_left2 = row2.getLong(0);
                    int $org_scalatest_assert_macro_right2 = i;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"does not match");
                    ++i;
                }
                UnsafeRow $org_scalatest_assert_macro_left = queue.remove();
                Object $org_scalatest_assert_macro_right = null;
                UnsafeRow unsafeRow = $org_scalatest_assert_macro_left;
                Object var21_18 = null;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(unsafeRow != null ? !unsafeRow.equals(var21_18) : var21_18 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"should be empty");
                queue.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("disk queue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowQueueSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                UnsafeRow first;
                int i;
                File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
                dir.mkdirs();
                DiskRowQueue queue = new DiskRowQueue(new File(dir, "buffer"), 1);
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(new byte[16], 16);
                int n = 1000;
                for (i = 0; i < n; ++i) {
                    row.setLong(0, (long)i);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"fail to add");
                }
                UnsafeRow $org_scalatest_assert_macro_left = first = queue.remove();
                Object $org_scalatest_assert_macro_right = null;
                UnsafeRow unsafeRow = $org_scalatest_assert_macro_left;
                Object var11_10 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, unsafeRow != null ? !unsafeRow.equals(var11_10) : var11_10 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"first should not be null");
                long $org_scalatest_assert_macro_left2 = first.getLong(0);
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"first should be 0");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not add more");
                for (i = 1; i < n; ++i) {
                    UnsafeRow row2;
                    UnsafeRow $org_scalatest_assert_macro_left3 = row2 = queue.remove();
                    Object $org_scalatest_assert_macro_right3 = null;
                    UnsafeRow unsafeRow2 = $org_scalatest_assert_macro_left3;
                    Object var21_20 = null;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, unsafeRow2 != null ? !unsafeRow2.equals(var21_20) : var21_20 != null);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"fail to poll");
                    long $org_scalatest_assert_macro_left4 = row2.getLong(0);
                    int $org_scalatest_assert_macro_right4 = i;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"does not match");
                }
                UnsafeRow $org_scalatest_assert_macro_left5 = queue.remove();
                Object $org_scalatest_assert_macro_right5 = null;
                UnsafeRow unsafeRow3 = $org_scalatest_assert_macro_left5;
                Object var29_26 = null;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", null, !(unsafeRow3 != null ? !unsafeRow3.equals(var29_26) : var29_26 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"should be empty");
                queue.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("hybrid queue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowQueueSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int i;
                TestMemoryManager mem = new TestMemoryManager(new SparkConf());
                mem.limit(4096L);
                TaskMemoryManager taskM = new TaskMemoryManager((MemoryManager)mem, 0L);
                HybridRowQueue queue = new HybridRowQueue(taskM, Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile(), 1);
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(new byte[16], 16);
                int n = 768;
                for (i = 0; i < n; ++i) {
                    row.setLong(0, (long)i);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"fail to add");
                }
                int $org_scalatest_assert_macro_left = queue.numQueues();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should have more than one queue");
                queue.spill(0x100000L, null);
                for (i = 0; i < n; ++i) {
                    UnsafeRow row2;
                    UnsafeRow $org_scalatest_assert_macro_left2 = row2 = queue.remove();
                    Object $org_scalatest_assert_macro_right2 = null;
                    UnsafeRow unsafeRow = $org_scalatest_assert_macro_left2;
                    Object var15_15 = null;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", null, unsafeRow != null ? !unsafeRow.equals(var15_15) : var15_15 != null);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"fail to poll");
                    long $org_scalatest_assert_macro_left3 = row2.getLong(0);
                    int $org_scalatest_assert_macro_right3 = i;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"does not match");
                }
                for (i = 0; i < n; ++i) {
                    row.setLong(0, (long)i);
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"fail to add");
                }
                int $org_scalatest_assert_macro_left4 = queue.numQueues();
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"should have more than one queue");
                queue.spill(0x100000L, null);
                int $org_scalatest_assert_macro_left5 = queue.numQueues();
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right5);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"should have more than one queue");
                for (i = 0; i < n; ++i) {
                    UnsafeRow row3;
                    UnsafeRow $org_scalatest_assert_macro_left6 = row3 = queue.remove();
                    Object $org_scalatest_assert_macro_right6 = null;
                    UnsafeRow unsafeRow = $org_scalatest_assert_macro_left6;
                    Object var31_30 = null;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!=", null, unsafeRow != null ? !unsafeRow.equals(var31_30) : var31_30 != null);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"fail to poll");
                    long $org_scalatest_assert_macro_left7 = row3.getLong(0);
                    int $org_scalatest_assert_macro_right7 = i;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == (long)$org_scalatest_assert_macro_right7);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"does not match");
                }
                queue.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

