/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadBenchmark$;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.sql.execution.vectorized.ColumnarBatch;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.util.Try$;

public final class ParquetReadBenchmark$ {
    public static final ParquetReadBenchmark$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;

    static {
        new ParquetReadBenchmark$();
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    /*
     * WARNING - void declaration
     */
    public void withTempPath(Function1<File, BoxedUnit> f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        catch (Throwable throwable) {
            void var2_2;
            Utils$.MODULE$.deleteRecursively((File)var2_2);
            throw throwable;
        }
        Utils$.MODULE$.deleteRecursively(path);
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            tableNames.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String viewName) {
                    return ParquetReadBenchmark$.MODULE$.spark().catalog().dropTempView(viewName);
                }
            });
            throw throwable;
        }
        tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        Tuple2 tuple22;
        Tuple2 tuple2 = pairs.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq keys = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)keys, (Object)values);
        Seq keys2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        Seq currentValues = (Seq)keys2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String key) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final String key$1;

                    public final String apply() {
                        return ParquetReadBenchmark$.MODULE$.spark().conf().get(this.key$1);
                    }
                    {
                        this.key$1 = key$1;
                    }
                }).toOption();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)keys2, (Object)values2)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String key, String value) {
                ParquetReadBenchmark$.MODULE$.spark().conf().set(key, value);
            }
        });
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            void var10_10;
            void var8_8;
            ((IterableLike)var8_8.zip((GenIterable)var10_10, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, Option<String>> x0$1) {
                    Tuple2<String, Option<String>> tuple2;
                    block4: {
                        block3: {
                            block2: {
                                tuple2 = x0$1;
                                if (tuple2 == null) break block2;
                                String key = (String)tuple2._1();
                                Option option = (Option)tuple2._2();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String value = (String)some.x();
                                ParquetReadBenchmark$.MODULE$.spark().conf().set(key, value);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (tuple2 == null) break block4;
                            String key = (String)tuple2._1();
                            Option option = (Option)tuple2._2();
                            if (!None$.MODULE$.equals(option)) break block4;
                            ParquetReadBenchmark$.MODULE$.spark().conf().unset(key);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            throw throwable;
        }
        ((IterableLike)keys2.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public void intScanBenchmark(int values) {
        Benchmark sqlBenchmark = new Benchmark("SQL Single Int Column Scan", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        Benchmark parquetReaderBenchmark = new Benchmark("Parquet Reader Single Int Column Scan", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, sqlBenchmark, parquetReaderBenchmark){
            public static final long serialVersionUID = 0L;
            public final int values$1;
            public final Benchmark sqlBenchmark$1;
            public final Benchmark parquetReaderBenchmark$1;

            public final void apply(File dir) {
                ParquetReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "tempTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.intScanBenchmark.1 $outer;
                    private final File dir$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ParquetReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$1).createOrReplaceTempView("t1");
                        ParquetReadBenchmark$.MODULE$.spark().sql("select cast(id as INT) as id from t1").write().parquet(this.dir$1.getCanonicalPath());
                        ParquetReadBenchmark$.MODULE$.spark().read().parquet(this.dir$1.getCanonicalPath()).createOrReplaceTempView("tempTable");
                        this.$outer.sqlBenchmark$1.addCase("SQL Parquet Vectorized", this.$outer.sqlBenchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.spark().sql("select sum(id) from tempTable").collect();
                            }
                        });
                        this.$outer.sqlBenchmark$1.addCase("SQL Parquet MR", this.$outer.sqlBenchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        ParquetReadBenchmark$.MODULE$.spark().sql("select sum(id) from tempTable").collect();
                                    }
                                });
                            }
                        });
                        Object[] files = SpecificParquetRecordReaderBase.listDirectory((File)this.dir$1).toArray();
                        this.$outer.parquetReaderBenchmark$1.addCase("ParquetReader Vectorized", this.$outer.parquetReaderBenchmark$1.addCase$default$2(), (Function1)new Serializable(this, files){
                            public static final long serialVersionUID = 0L;
                            private final Object[] files$1;

                            public final void apply(int num) {
                                this.apply$mcVI$sp(num);
                            }

                            public void apply$mcVI$sp(int num) {
                                LongRef sum = LongRef.create((long)0L);
                                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.files$1).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Object x$2) {
                                        return (String)x$2;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, sum){
                                    public static final long serialVersionUID = 0L;
                                    private final LongRef sum$1;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void apply(String p) {
                                        VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader();
                                        try {
                                            String string = "id";
                                            reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string)).asJava());
                                            ColumnarBatch batch = reader.resultBatch();
                                            ColumnVector col = batch.column(0);
                                            while (reader.nextBatch()) {
                                                int numRows = batch.numRows();
                                                for (int i = 0; i < numRows; ++i) {
                                                    if (col.isNullAt(i)) continue;
                                                    this.sum$1.elem += (long)col.getInt(i);
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            void var2_2;
                                            var2_2.close();
                                            throw throwable;
                                        }
                                        reader.close();
                                    }
                                    {
                                        this.sum$1 = sum$1;
                                    }
                                });
                            }
                            {
                                this.files$1 = files$1;
                            }
                        });
                        this.$outer.parquetReaderBenchmark$1.addCase("ParquetReader Vectorized -> Row", this.$outer.parquetReaderBenchmark$1.addCase$default$2(), (Function1)new Serializable(this, files){
                            public static final long serialVersionUID = 0L;
                            private final Object[] files$1;

                            public final void apply(int num) {
                                this.apply$mcVI$sp(num);
                            }

                            public void apply$mcVI$sp(int num) {
                                LongRef sum = LongRef.create((long)0L);
                                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.files$1).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Object x$4) {
                                        return (String)x$4;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, sum){
                                    public static final long serialVersionUID = 0L;
                                    private final LongRef sum$2;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void apply(String p) {
                                        VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader();
                                        try {
                                            String string = "id";
                                            reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string)).asJava());
                                            ColumnarBatch batch = reader.resultBatch();
                                            while (reader.nextBatch()) {
                                                Iterator it = batch.rowIterator();
                                                while (it.hasNext()) {
                                                    ColumnarBatch.Row record = (ColumnarBatch.Row)it.next();
                                                    if (record.isNullAt(0)) continue;
                                                    this.sum$2.elem += (long)record.getInt(0);
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            void var2_2;
                                            var2_2.close();
                                            throw throwable;
                                        }
                                        reader.close();
                                    }
                                    {
                                        this.sum$2 = sum$2;
                                    }
                                });
                            }
                            {
                                this.files$1 = files$1;
                            }
                        });
                        this.$outer.sqlBenchmark$1.run();
                        this.$outer.parquetReaderBenchmark$1.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$1 = dir$1;
                    }
                });
            }
            {
                this.values$1 = values$1;
                this.sqlBenchmark$1 = sqlBenchmark$1;
                this.parquetReaderBenchmark$1 = parquetReaderBenchmark$1;
            }
        });
    }

    public void intStringScanBenchmark(int values) {
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values){
            public static final long serialVersionUID = 0L;
            public final int values$2;

            public final void apply(File dir) {
                ParquetReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "tempTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.intStringScanBenchmark.1 $outer;
                    private final File dir$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ParquetReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$2).createOrReplaceTempView("t1");
                        ParquetReadBenchmark$.MODULE$.spark().sql("select cast(id as INT) as c1, cast(id as STRING) as c2 from t1").write().parquet(this.dir$2.getCanonicalPath());
                        ParquetReadBenchmark$.MODULE$.spark().read().parquet(this.dir$2.getCanonicalPath()).createOrReplaceTempView("tempTable");
                        Benchmark benchmark = new Benchmark("Int and String Scan", (long)this.$outer.values$2, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                        benchmark.addCase("SQL Parquet Vectorized", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from tempTable").collect();
                            }
                        });
                        benchmark.addCase("SQL Parquet MR", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        ParquetReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from tempTable").collect();
                                    }
                                });
                            }
                        });
                        Object[] files = SpecificParquetRecordReaderBase.listDirectory((File)this.dir$2).toArray();
                        benchmark.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$2 = dir$2;
                    }
                });
            }
            {
                this.values$2 = values$2;
            }
        });
    }

    public void stringDictionaryScanBenchmark(int values) {
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values){
            public static final long serialVersionUID = 0L;
            public final int values$3;

            public final void apply(File dir) {
                ParquetReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "tempTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stringDictionaryScanBenchmark.1 $outer;
                    private final File dir$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ParquetReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$3).createOrReplaceTempView("t1");
                        ParquetReadBenchmark$.MODULE$.spark().sql("select cast((id % 200) + 10000 as STRING) as c1 from t1").write().parquet(this.dir$3.getCanonicalPath());
                        ParquetReadBenchmark$.MODULE$.spark().read().parquet(this.dir$3.getCanonicalPath()).createOrReplaceTempView("tempTable");
                        Benchmark benchmark = new Benchmark("String Dictionary", (long)this.$outer.values$3, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                        benchmark.addCase("SQL Parquet Vectorized", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from tempTable").collect();
                            }
                        });
                        benchmark.addCase("SQL Parquet MR", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        ParquetReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from tempTable").collect();
                                    }
                                });
                            }
                        });
                        benchmark.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$3 = dir$3;
                    }
                });
            }
            {
                this.values$3 = values$3;
            }
        });
    }

    public void partitionTableScanBenchmark(int values) {
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values){
            public static final long serialVersionUID = 0L;
            public final int values$4;

            public final void apply(File dir) {
                ParquetReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "tempTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionTableScanBenchmark.1 $outer;
                    private final File dir$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ParquetReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$4).createOrReplaceTempView("t1");
                        ParquetReadBenchmark$.MODULE$.spark().sql("select id % 2 as p, cast(id as INT) as id from t1").write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).parquet(this.dir$4.getCanonicalPath());
                        ParquetReadBenchmark$.MODULE$.spark().read().parquet(this.dir$4.getCanonicalPath()).createOrReplaceTempView("tempTable");
                        Benchmark benchmark = new Benchmark("Partitioned Table", (long)this.$outer.values$4, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                        benchmark.addCase("Read data column", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.spark().sql("select sum(id) from tempTable").collect();
                            }
                        });
                        benchmark.addCase("Read partition column", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.spark().sql("select sum(p) from tempTable").collect();
                            }
                        });
                        benchmark.addCase("Read both columns", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from tempTable").collect();
                            }
                        });
                        benchmark.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$4 = dir$4;
                    }
                });
            }
            {
                this.values$4 = values$4;
            }
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, fractionOfNulls){
            public static final long serialVersionUID = 0L;
            public final int values$5;
            public final double fractionOfNulls$1;

            public final void apply(File dir) {
                ParquetReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "tempTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stringWithNullsScanBenchmark.1 $outer;
                    private final File dir$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ParquetReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$5).createOrReplaceTempView("t1");
                        ParquetReadBenchmark$.MODULE$.spark().sql(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select IF(rand(1) < ", ", NULL, cast(id as STRING)) as c1, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.fractionOfNulls$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IF(rand(2) < ", ", NULL, cast(id as STRING)) as c2 from t1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.fractionOfNulls$1)}))).toString()).write().parquet(this.dir$5.getCanonicalPath());
                        ParquetReadBenchmark$.MODULE$.spark().read().parquet(this.dir$5.getCanonicalPath()).createOrReplaceTempView("tempTable");
                        Benchmark benchmark = new Benchmark("String with Nulls Scan", (long)this.$outer.values$5, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                        benchmark.addCase("SQL Parquet Vectorized", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                ParquetReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from tempTable where c1 is not NULL and c2 is not NULL").collect();
                            }
                        });
                        Object[] files = SpecificParquetRecordReaderBase.listDirectory((File)this.dir$5).toArray();
                        benchmark.addCase("PR Vectorized", benchmark.addCase$default$2(), (Function1)new Serializable(this, files){
                            public static final long serialVersionUID = 0L;
                            private final Object[] files$2;

                            public final void apply(int num) {
                                this.apply$mcVI$sp(num);
                            }

                            public void apply$mcVI$sp(int num) {
                                IntRef sum = IntRef.create((int)0);
                                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.files$2).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Object x$6) {
                                        return (String)x$6;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, sum){
                                    public static final long serialVersionUID = 0L;
                                    private final IntRef sum$3;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void apply(String p) {
                                        VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader();
                                        try {
                                            String string = "c1";
                                            String string2 = "c2";
                                            reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string)).asJava());
                                            ColumnarBatch batch = reader.resultBatch();
                                            while (reader.nextBatch()) {
                                                Iterator rowIterator = batch.rowIterator();
                                                while (rowIterator.hasNext()) {
                                                    ColumnarBatch.Row row = (ColumnarBatch.Row)rowIterator.next();
                                                    UTF8String value = row.getUTF8String(0);
                                                    if (row.isNullAt(0) || row.isNullAt(1)) continue;
                                                    this.sum$3.elem += value.numBytes();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            void var2_2;
                                            var2_2.close();
                                            throw throwable;
                                        }
                                        reader.close();
                                    }
                                    {
                                        this.sum$3 = sum$3;
                                    }
                                });
                            }
                            {
                                this.files$2 = files$2;
                            }
                        });
                        benchmark.addCase("PR Vectorized (Null Filtering)", benchmark.addCase$default$2(), (Function1)new Serializable(this, files){
                            public static final long serialVersionUID = 0L;
                            private final Object[] files$2;

                            public final void apply(int num) {
                                this.apply$mcVI$sp(num);
                            }

                            public void apply$mcVI$sp(int num) {
                                LongRef sum = LongRef.create((long)0L);
                                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.files$2).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Object x$9) {
                                        return (String)x$9;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, sum){
                                    public static final long serialVersionUID = 0L;
                                    private final LongRef sum$4;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void apply(String p) {
                                        VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader();
                                        try {
                                            String string = "c1";
                                            String string2 = "c2";
                                            reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string)).asJava());
                                            ColumnarBatch batch = reader.resultBatch();
                                            batch.filterNullsInColumn(0);
                                            batch.filterNullsInColumn(1);
                                            while (reader.nextBatch()) {
                                                Iterator rowIterator = batch.rowIterator();
                                                while (rowIterator.hasNext()) {
                                                    this.sum$4.elem += (long)((ColumnarBatch.Row)rowIterator.next()).getUTF8String(0).numBytes();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            void var2_2;
                                            var2_2.close();
                                            throw throwable;
                                        }
                                        reader.close();
                                    }
                                    {
                                        this.sum$4 = sum$4;
                                    }
                                });
                            }
                            {
                                this.files$2 = files$2;
                            }
                        });
                        benchmark.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$5 = dir$5;
                    }
                });
            }
            {
                this.values$5 = values$5;
                this.fractionOfNulls$1 = fractionOfNulls$1;
            }
        });
    }

    public void main(String[] args) {
        this.intScanBenchmark(0xF00000);
        this.intStringScanBenchmark(0xA00000);
        this.stringDictionaryScanBenchmark(0xA00000);
        this.partitionTableScanBenchmark(0xF00000);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95})).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(double fractionOfNulls) {
                this.apply$mcVD$sp(fractionOfNulls);
            }

            public void apply$mcVD$sp(double fractionOfNulls) {
                ParquetReadBenchmark$.MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls);
            }
        });
    }

    private ParquetReadBenchmark$() {
        MODULE$ = this;
        this.conf = new SparkConf();
        this.conf().set("spark.sql.parquet.compression.codec", "snappy");
        this.spark = SparkSession$.MODULE$.builder().master("local[1]").appName("test-sql-context").config(this.conf()).getOrCreate();
        this.spark().conf().set(SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key(), "true");
        this.spark().conf().set(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key(), "true");
    }
}

