/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.CSVTypeCast$;
import org.apache.spark.sql.execution.datasources.csv.CSVTypeCastSuite$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%2A!\u0001\u0002\u0001#\t\u00012i\u0015,UsB,7)Y:u'VLG/\u001a\u0006\u0003\u0007\u0011\t1aY:w\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f\u0001\t\u0013i\u0012AC1tg\u0016\u0014HOT;mYR\u0011a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0005+:LG\u000fC\u0003&7\u0001\u0007a%A\u0001w!\tyr%\u0003\u0002)A\t\u0019\u0011I\\=")
public class CSVTypeCastSuite
extends SparkFunSuite {
    public void org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(Object v) {
        Object $org_scalatest_assert_macro_left = v;
        Object $org_scalatest_assert_macro_right = null;
        Object object = $org_scalatest_assert_macro_left;
        Object var5_4 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var5_4) : var5_4 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public CSVTypeCastSuite() {
        this.test("Can parse decimal type values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq stringValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10.05", "1,000.01", "158,058,049.001"}));
                Seq decimalValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.05, 1000.01, 1.58058049001E8}));
                DecimalType decimalType = new DecimalType();
                ((IterableLike)stringValues.zip((GenIterable)decimalValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, decimalType){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final DecimalType decimalType$1;

                    public final void apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String strVal = (String)tuple2._1();
                            double decimalVal = tuple2._2$mcD$sp();
                            BigDecimal decimalValue = new BigDecimal(((Object)BoxesRunTime.boxToDouble((double)decimalVal)).toString());
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$anonfun$$$outer().convertToEqualizer(CSVTypeCast$.MODULE$.castTo(strVal, "_1", (DataType)this.decimalType$1, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5()));
                            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(decimalValue, this.decimalType$1.precision(), this.decimalType$1.scale());
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.decimalType$1 = decimalType$1;
                    }
                });
            }

            public /* synthetic */ CSVTypeCastSuite org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Can parse escaped characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVTypeCast$.MODULE$.toChar("\\t")));
                char $org_scalatest_assert_macro_right = '\t';
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVTypeCast$.MODULE$.toChar("\\r")));
                char $org_scalatest_assert_macro_right2 = '\r';
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVTypeCast$.MODULE$.toChar("\\b")));
                char $org_scalatest_assert_macro_right3 = '\b';
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVTypeCast$.MODULE$.toChar("\\f")));
                char $org_scalatest_assert_macro_right4 = '\f';
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVTypeCast$.MODULE$.toChar("\\\"")));
                char $org_scalatest_assert_macro_right5 = '\"';
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVTypeCast$.MODULE$.toChar("\\'")));
                char $org_scalatest_assert_macro_right6 = '\'';
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVTypeCast$.MODULE$.toChar("\u0000")));
                char $org_scalatest_assert_macro_right7 = '\u0000';
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not accept delimiter larger than one character", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IllegalArgumentException exception = (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final char apply() {
                        return this.apply$mcC$sp();
                    }

                    public char apply$mcC$sp() {
                        return CSVTypeCast$.MODULE$.toChar("ab");
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                String $org_scalatest_assert_macro_left = exception.getMessage();
                String $org_scalatest_assert_macro_right = "cannot be more than one character";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Throws exception for unsupported escaped characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IllegalArgumentException exception = (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final char apply() {
                        return this.apply$mcC$sp();
                    }

                    public char apply$mcC$sp() {
                        return CSVTypeCast$.MODULE$.toChar("\\1");
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                String $org_scalatest_assert_macro_left = exception.getMessage();
                String $org_scalatest_assert_macro_right = "Unsupported special character for delimiter";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Nullable types are handled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String message;
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)ByteType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)ShortType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)IntegerType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)LongType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)FloatType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)DoubleType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)BooleanType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)DecimalType$.MODULE$.DoubleDecimal(), true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)TimestampType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)DateType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)StringType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo(null, "_1", (DataType)IntegerType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "-")));
                String $org_scalatest_assert_macro_left = message = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply() {
                        return CSVTypeCast$.MODULE$.castTo(null, "_1", (DataType)IntegerType$.MODULE$, false, CSVOptions$.MODULE$.apply("nullValue", "-"));
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class))).getMessage();
                String $org_scalatest_assert_macro_right = "null value found but field _1 is not nullable.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = message = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply() {
                        return CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)StringType$.MODULE$, false, CSVOptions$.MODULE$.apply("nullValue", "-"));
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class))).getMessage();
                String $org_scalatest_assert_macro_right2 = "null value found but field _1 is not nullable.";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("String type should also respect `nullValue`", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo("", "_1", (DataType)StringType$.MODULE$, true, CSVOptions$.MODULE$.apply()));
                Object $org_scalatest_assert_macro_left = CSVTypeCast$.MODULE$.castTo("", "_1", (DataType)StringType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "null"));
                UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)"");
                Object object = $org_scalatest_assert_macro_left;
                UTF8String uTF8String = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(uTF8String) : uTF8String != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Object $org_scalatest_assert_macro_left2 = CSVTypeCast$.MODULE$.castTo("", "_1", (DataType)StringType$.MODULE$, false, CSVOptions$.MODULE$.apply("nullValue", "null"));
                UTF8String $org_scalatest_assert_macro_right2 = UTF8String.fromString((String)"");
                Object object2 = $org_scalatest_assert_macro_left2;
                UTF8String uTF8String2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(object2 != null ? !object2.equals(uTF8String2) : uTF8String2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVTypeCastSuite$$assertNull(CSVTypeCast$.MODULE$.castTo(null, "_1", (DataType)StringType$.MODULE$, true, CSVOptions$.MODULE$.apply("nullValue", "null")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Throws exception for empty string with non null type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RuntimeException exception = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply() {
                        return CSVTypeCast$.MODULE$.castTo("", "_1", (DataType)IntegerType$.MODULE$, false, CSVOptions$.MODULE$.apply());
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                String $org_scalatest_assert_macro_left = exception.getMessage();
                String $org_scalatest_assert_macro_right = "null value found but field _1 is not nullable.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Types are cast correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object castedDate;
                Object castedTimestamp;
                Object $org_scalatest_assert_macro_left = CSVTypeCast$.MODULE$.castTo("10", "_1", (DataType)ByteType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                int $org_scalatest_assert_macro_right = 10;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Object $org_scalatest_assert_macro_left2 = CSVTypeCast$.MODULE$.castTo("10", "_1", (DataType)ShortType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                int $org_scalatest_assert_macro_right2 = 10;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Object $org_scalatest_assert_macro_left3 = CSVTypeCast$.MODULE$.castTo("10", "_1", (DataType)IntegerType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                int $org_scalatest_assert_macro_right3 = 10;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Object $org_scalatest_assert_macro_left4 = CSVTypeCast$.MODULE$.castTo("10", "_1", (DataType)LongType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                int $org_scalatest_assert_macro_right4 = 10;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Object $org_scalatest_assert_macro_left5 = CSVTypeCast$.MODULE$.castTo("1.00", "_1", (DataType)FloatType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                double $org_scalatest_assert_macro_right5 = 1.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Object $org_scalatest_assert_macro_left6 = CSVTypeCast$.MODULE$.castTo("1.00", "_1", (DataType)DoubleType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                double $org_scalatest_assert_macro_right6 = 1.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left6, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Object $org_scalatest_assert_macro_left7 = CSVTypeCast$.MODULE$.castTo("true", "_1", (DataType)BooleanType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                boolean $org_scalatest_assert_macro_right7 = true;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left7, "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left7, (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                CSVOptions timestampsOptions = CSVOptions$.MODULE$.apply("timestampFormat", "dd/MM/yyyy hh:mm");
                String customTimestamp = "31/01/2015 00:00";
                long expectedTime = timestampsOptions.timestampFormat().parse(customTimestamp).getTime();
                Object $org_scalatest_assert_macro_left8 = castedTimestamp = CSVTypeCast$.MODULE$.castTo(customTimestamp, "_1", (DataType)TimestampType$.MODULE$, true, timestampsOptions);
                long $org_scalatest_assert_macro_right8 = expectedTime * 1000L;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left8, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left8, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                String customDate = "31/01/2015";
                CSVOptions dateOptions = CSVOptions$.MODULE$.apply("dateFormat", "dd/MM/yyyy");
                long expectedDate = dateOptions.dateFormat().parse(customDate).getTime();
                Object $org_scalatest_assert_macro_left9 = castedDate = CSVTypeCast$.MODULE$.castTo(customTimestamp, "_1", (DataType)DateType$.MODULE$, true, dateOptions);
                int $org_scalatest_assert_macro_right9 = DateTimeUtils$.MODULE$.millisToDays(expectedDate);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left9, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left9, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                String timestamp = "2015-01-01 00:00:00";
                Object $org_scalatest_assert_macro_left10 = CSVTypeCast$.MODULE$.castTo(timestamp, "_1", (DataType)TimestampType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                long $org_scalatest_assert_macro_right10 = DateTimeUtils$.MODULE$.stringToTime(timestamp).getTime() * 1000L;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left10, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left10, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Object $org_scalatest_assert_macro_left11 = CSVTypeCast$.MODULE$.castTo("2015-01-01", "_1", (DataType)DateType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                int $org_scalatest_assert_macro_right11 = DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.stringToTime("2015-01-01").getTime());
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left11, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left11, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Float and Double Types are cast without respect to platform default Locale", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcV$sp() {
                Locale originalLocale = Locale.getDefault();
                try {
                    Locale.setDefault(new Locale("fr", "FR"));
                    Object $org_scalatest_assert_macro_left = CSVTypeCast$.MODULE$.castTo("1,00", "_1", (DataType)FloatType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                    double $org_scalatest_assert_macro_right = 100.0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    Object $org_scalatest_assert_macro_left2 = CSVTypeCast$.MODULE$.castTo("1,00", "_1", (DataType)DoubleType$.MODULE$, CSVTypeCast$.MODULE$.castTo$default$4(), CSVTypeCast$.MODULE$.castTo$default$5());
                    double $org_scalatest_assert_macro_right2 = 100.0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                }
                catch (Throwable throwable) {
                    void var1_1;
                    Locale.setDefault((Locale)var1_1);
                    throw throwable;
                }
                Locale.setDefault(originalLocale);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Float NaN values are parsed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                float floatVal;
                float $org_scalatest_assert_macro_left = floatVal = BoxesRunTime.unboxToFloat((Object)CSVTypeCast$.MODULE$.castTo("nn", "_1", (DataType)FloatType$.MODULE$, true, CSVOptions$.MODULE$.apply("nanValue", "nn")));
                float $org_scalatest_assert_macro_right = floatVal;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Double NaN values are parsed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double doubleVal = BoxesRunTime.unboxToDouble((Object)CSVTypeCast$.MODULE$.castTo("-", "_1", (DataType)DoubleType$.MODULE$, true, CSVOptions$.MODULE$.apply("nanValue", "-")));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(doubleVal).isNaN(), "scala.this.Predef.double2Double(doubleVal).isNaN()");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Float infinite values can be parsed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                float floatVal2;
                float floatVal1;
                float $org_scalatest_assert_macro_left = floatVal1 = BoxesRunTime.unboxToFloat((Object)CSVTypeCast$.MODULE$.castTo("max", "_1", (DataType)FloatType$.MODULE$, true, CSVOptions$.MODULE$.apply("negativeInf", "max")));
                float $org_scalatest_assert_macro_right = Float.NEGATIVE_INFINITY;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                float $org_scalatest_assert_macro_left2 = floatVal2 = BoxesRunTime.unboxToFloat((Object)CSVTypeCast$.MODULE$.castTo("max", "_1", (DataType)FloatType$.MODULE$, true, CSVOptions$.MODULE$.apply("positiveInf", "max")));
                float $org_scalatest_assert_macro_right2 = Float.POSITIVE_INFINITY;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Double infinite values can be parsed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVTypeCastSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double doubleVal2;
                double doubleVal1;
                double $org_scalatest_assert_macro_left = doubleVal1 = BoxesRunTime.unboxToDouble((Object)CSVTypeCast$.MODULE$.castTo("max", "_1", (DataType)DoubleType$.MODULE$, true, CSVOptions$.MODULE$.apply("negativeInf", "max")));
                double $org_scalatest_assert_macro_right = Double.NEGATIVE_INFINITY;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left2 = doubleVal2 = BoxesRunTime.unboxToDouble((Object)CSVTypeCast$.MODULE$.castTo("max", "_1", (DataType)DoubleType$.MODULE$, true, CSVOptions$.MODULE$.apply("positiveInf", "max")));
                double $org_scalatest_assert_macro_right2 = Double.POSITIVE_INFINITY;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

