/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.NoopColumnStats;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.types.AtomicType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001#\t1\"+\u001e8MK:<G\u000f[#oG>$\u0017N\\4Tk&$XM\u0003\u0002\u0004\t\u0005Y1m\\7qe\u0016\u001c8/[8o\u0015\t)a!\u0001\u0005d_2,XN\\1s\u0015\t9\u0001\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AC\u0005\u0003+)\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003U!Xm\u001d;Sk:dUM\\4uQ\u0016s7m\u001c3j]\u001e,\"A\b\u001a\u0015\u0007})3\u0006\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\b\"\u0002\u0014\u001c\u0001\u00049\u0013aC2pYVlgn\u0015;biN\u0004\"\u0001K\u0015\u000e\u0003\u0011I!A\u000b\u0003\u0003\u0017\r{G.^7o'R\fGo\u001d\u0005\u0006Ym\u0001\r!L\u0001\u000bG>dW/\u001c8UsB,\u0007c\u0001\u0015/a%\u0011q\u0006\u0002\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016\u0004\"!\r\u001a\r\u0001\u0011)1g\u0007b\u0001i\t\tA+\u0005\u00026qA\u0011\u0001EN\u0005\u0003o\u0005\u0012qAT8uQ&tw\r\u0005\u0002:y5\t!H\u0003\u0002<\u0011\u0005)A/\u001f9fg&\u0011QH\u000f\u0002\u000b\u0003R|W.[2UsB,\u0007")
public class RunLengthEncodingSuite
extends SparkFunSuite {
    public <T extends AtomicType> void testRunLengthEncoding(ColumnStats columnStats, NativeColumnType<T> columnType) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(0, (Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": simple case"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": run length == 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": single long run"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1000))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
    }

    public final void org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(int uniqueValueCount, Seq inputRuns, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)RunLengthEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq values = (Seq)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)values, (Object)rows);
            Seq values2 = (Seq)tuple23._1();
            Seq rows2 = (Seq)tuple23._2();
            Seq inputSeq = (Seq)inputRuns.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Object> apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int run2 = tuple2._2$mcI$sp();
                        Seq seq = (Seq)Seq$.MODULE$.fill(run2, (Function0)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.index$1;
                            }
                            {
                                this.index$1 = index$1;
                            }
                        });
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            inputSeq.foreach((Function1)new Serializable(this, builder, rows2){
                public static final long serialVersionUID = 0L;
                private final TestCompressibleColumnBuilder builder$1;
                private final Seq rows$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.builder$1.appendFrom((InternalRow)this.rows$1.apply(i), 0);
                }
                {
                    this.builder$1 = builder$1;
                    this.rows$1 = rows$1;
                }
            });
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            int compressedSize = 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)inputRuns.map((Function1)new Serializable(this, columnType$1, rows2){
                public static final long serialVersionUID = 0L;
                private final NativeColumnType columnType$1;
                private final Seq rows$1;

                public final int apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int n = this.columnType$1.actualSize((InternalRow)this.rows$1.apply(index), 0) + 4;
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.columnType$1 = columnType$1;
                    this.rows$1 = rows$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()));
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)RunLengthEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
            inputRuns.foreach((Function1)new Serializable(this, columnType$1, values2, buffer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RunLengthEncodingSuite $outer;
                private final NativeColumnType columnType$1;
                private final Seq values$1;
                private final ByteBuffer buffer$1;

                public final void apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int run2 = tuple2._2$mcI$sp();
                        this.$outer.assertResult(this.values$1.apply(index), "Wrong column element value", this.columnType$1.extract(this.buffer$1));
                        this.$outer.assertResult(BoxesRunTime.boxToInteger((int)run2), "Wrong run length", BoxesRunTime.boxToInteger((int)this.buffer$1.getInt()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.values$1 = values$1;
                    this.buffer$1 = buffer$1;
                }
            });
            buffer.rewind().position(headerSize + 4);
            RunLengthEncoding.Decoder decoder = RunLengthEncoding$.MODULE$.decoder(buffer, columnType$1);
            GenericInternalRow mutableRow = new GenericInternalRow(1);
            if (inputSeq.nonEmpty()) {
                inputSeq.foreach((Function1)new Serializable(this, columnType$1, values2, decoder, mutableRow){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RunLengthEncodingSuite $outer;
                    private final NativeColumnType columnType$1;
                    private final Seq values$1;
                    private final RunLengthEncoding.Decoder decoder$1;
                    private final GenericInternalRow mutableRow$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.decoder$1.hasNext(), "decoder.hasNext");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Object object = this.values$1.apply(i);
                        this.decoder$1.next((InternalRow)this.mutableRow$1, 0);
                        this.$outer.assertResult(object, "Wrong decoded value", this.columnType$1.getField((InternalRow)this.mutableRow$1, 0));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.columnType$1 = columnType$1;
                        this.values$1 = values$1;
                        this.decoder$1 = decoder$1;
                        this.mutableRow$1 = mutableRow$1;
                    }
                });
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext"));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            return;
        }
        throw new MatchError(tuple2);
    }

    public RunLengthEncodingSuite() {
        this.testRunLengthEncoding((ColumnStats)new NoopColumnStats(), (NativeColumnType)BOOLEAN$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new ByteColumnStats(), (NativeColumnType)BYTE$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new ShortColumnStats(), (NativeColumnType)SHORT$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$);
    }
}

