/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.Decoder;
import org.apache.spark.sql.execution.columnar.compression.IntDelta$;
import org.apache.spark.sql.execution.columnar.compression.IntegralDeltaSuite$;
import org.apache.spark.sql.execution.columnar.compression.LongDelta$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.types.IntegralType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001#\t\u0011\u0012J\u001c;fOJ\fG\u000eR3mi\u0006\u001cV/\u001b;f\u0015\t\u0019A!A\u0006d_6\u0004(/Z:tS>t'BA\u0003\u0007\u0003!\u0019w\u000e\\;n]\u0006\u0014(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f\u0001\t\u0003i\u0012!\u0005;fgRLe\u000e^3he\u0006dG)\u001a7uCV\u0011aD\r\u000b\u0005?\u0015Zc\b\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\b\"\u0002\u0014\u001c\u0001\u00049\u0013aC2pYVlgn\u0015;biN\u0004\"\u0001K\u0015\u000e\u0003\u0011I!A\u000b\u0003\u0003\u0017\r{G.^7o'R\fGo\u001d\u0005\u0006Ym\u0001\r!L\u0001\u000bG>dW/\u001c8UsB,\u0007c\u0001\u0015/a%\u0011q\u0006\u0002\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016\u0004\"!\r\u001a\r\u0001\u0011)1g\u0007b\u0001i\t\t\u0011*\u0005\u00026qA\u0011\u0001EN\u0005\u0003o\u0005\u0012qAT8uQ&tw\r\u0005\u0002:y5\t!H\u0003\u0002<\u0011\u0005)A/\u001f9fg&\u0011QH\u000f\u0002\r\u0013:$Xm\u001a:bYRK\b/\u001a\u0005\u0006\u007fm\u0001\r\u0001Q\u0001\u0007g\u000eDW-\\3\u0011\u0005i\t\u0015B\u0001\"\u0003\u0005E\u0019u.\u001c9sKN\u001c\u0018n\u001c8TG\",W.\u001a")
public class IntegralDeltaSuite
extends SparkFunSuite {
    public <I extends IntegralType> void testIntegralDelta(ColumnStats columnStats, NativeColumnType<I> columnType, CompressionScheme scheme) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, scheme){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegralDeltaSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final CompressionScheme scheme$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$IntegralDeltaSuite$$skeleton$1((Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1, this.scheme$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.scheme$1 = scheme$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": simple case"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, scheme){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegralDeltaSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final CompressionScheme scheme$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NativeColumnType nativeColumnType;
                block4: {
                    Seq seq;
                    block3: {
                        block2: {
                            nativeColumnType = this.columnType$1;
                            if (!INT$.MODULE$.equals(nativeColumnType)) break block2;
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 2, 130}));
                            break block3;
                        }
                        if (!LONG$.MODULE$.equals(nativeColumnType)) break block4;
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 1L, 2L, 130L}));
                    }
                    Seq input = seq;
                    this.$outer.org$apache$spark$sql$execution$columnar$compression$IntegralDeltaSuite$$skeleton$1((Seq)input.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Object x$2) {
                            return x$2;
                        }
                    }, Seq$.MODULE$.canBuildFrom()), this.columnStats$1, this.columnType$1, this.scheme$1);
                    return;
                }
                throw new MatchError((Object)nativeColumnType);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.scheme$1 = scheme$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": long random series"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, scheme){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegralDeltaSuite $outer;
            private final ColumnStats columnStats$1;
            public final NativeColumnType columnType$1;
            private final CompressionScheme scheme$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object[] input = (Object[])Array$.MODULE$.fill(10000, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testIntegralDelta$3 $outer;

                    public final Object apply() {
                        return ColumnarTestUtils$.MODULE$.makeRandomValue(this.$outer.columnType$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Any());
                this.$outer.org$apache$spark$sql$execution$columnar$compression$IntegralDeltaSuite$$skeleton$1((Seq)Predef$.MODULE$.genericArrayOps((Object)input).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object x$3) {
                        return x$3;
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), this.columnStats$1, this.columnType$1, this.scheme$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.scheme$1 = scheme$1;
            }
        });
    }

    public final void org$apache$spark$sql$execution$columnar$compression$IntegralDeltaSuite$$skeleton$1(Seq input, ColumnStats columnStats$1, NativeColumnType columnType$1, CompressionScheme scheme$1) {
        int n;
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, scheme$1);
        Seq deltas = input.isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(input.tail(), input.init())), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Object x0$1, Object x1$1) {
                Tuple2 tuple2;
                block4: {
                    long l;
                    block3: {
                        block2: {
                            tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 == null) break block2;
                            Object x = tuple2._1();
                            Object y = tuple2._2();
                            if (!(x instanceof Integer)) break block2;
                            int n = BoxesRunTime.unboxToInt((Object)x);
                            if (!(y instanceof Integer)) break block2;
                            int n2 = BoxesRunTime.unboxToInt((Object)y);
                            l = n - n2;
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Object x = tuple2._1();
                        Object y = tuple2._2();
                        if (!(x instanceof Long)) break block4;
                        long l2 = BoxesRunTime.unboxToLong((Object)x);
                        if (!(y instanceof Long)) break block4;
                        long l3 = BoxesRunTime.unboxToLong((Object)y);
                        l = l2 - l3;
                    }
                    return l;
                }
                throw new MatchError((Object)tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        input.foreach((Function1)new Serializable(this, columnType$1, builder){
            public static final long serialVersionUID = 0L;
            private final NativeColumnType columnType$1;
            private final TestCompressibleColumnBuilder builder$1;

            public final void apply(Object value) {
                GenericInternalRow row = new GenericInternalRow(1);
                this.columnType$1.setField((InternalRow)row, 0, value);
                this.builder$1.appendFrom((InternalRow)row, 0);
            }
            {
                this.columnType$1 = columnType$1;
                this.builder$1 = builder$1;
            }
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        if (deltas.isEmpty()) {
            n = 0;
        } else {
            int oneBoolean = columnType$1.defaultSize();
            n = 1 + oneBoolean + BoxesRunTime.unboxToInt((Object)((TraversableOnce)deltas.map((Function1)new Serializable(this, oneBoolean){
                public static final long serialVersionUID = 0L;
                private final int oneBoolean$1;

                public final int apply(long d) {
                    return this.apply$mcIJ$sp(d);
                }

                public int apply$mcIJ$sp(long d) {
                    return package$.MODULE$.abs(d) <= (long)127 ? 1 : 1 + this.oneBoolean$1;
                }
                {
                    this.oneBoolean$1 = oneBoolean$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        int compressedSize = 4 + n;
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)scheme$1.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
        if (input.nonEmpty()) {
            this.assertResult(BoxesRunTime.boxToByte((byte)-128), "The first byte should be an escaping mark", BoxesRunTime.boxToByte((byte)buffer.get()));
            this.assertResult(input.head(), "The first value is wrong", columnType$1.extract(buffer));
            Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(input.tail(), (Object)deltas)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)new Serializable(this, columnType$1, buffer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegralDeltaSuite $outer;
                private final NativeColumnType columnType$1;
                private final ByteBuffer buffer$1;

                public final void apply(Object value, long delta) {
                    if (package$.MODULE$.abs(delta) <= (long)127) {
                        this.$outer.assertResult(BoxesRunTime.boxToLong((long)delta), "Wrong delta", BoxesRunTime.boxToByte((byte)this.buffer$1.get()));
                    } else {
                        this.$outer.assertResult(BoxesRunTime.boxToByte((byte)-128), "Expecting escaping mark here", BoxesRunTime.boxToByte((byte)this.buffer$1.get()));
                        this.$outer.assertResult(value, "Wrong value", this.columnType$1.extract(this.buffer$1));
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.buffer$1 = buffer$1;
                }
            });
        }
        buffer.rewind().position(headerSize + 4);
        Decoder decoder = scheme$1.decoder(buffer, columnType$1);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (input.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext");
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            input.foreach((Function1)new Serializable(this, columnType$1, decoder, mutableRow){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegralDeltaSuite $outer;
                private final NativeColumnType columnType$1;
                private final Decoder decoder$1;
                private final GenericInternalRow mutableRow$1;

                public final void apply(Object x$1) {
                    this.decoder$1.next((InternalRow)this.mutableRow$1, 0);
                    this.$outer.assertResult(x$1, "Wrong decoded value", this.columnType$1.getField((InternalRow)this.mutableRow$1, 0));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.decoder$1 = decoder$1;
                    this.mutableRow$1 = mutableRow$1;
                }
            });
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext"));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public IntegralDeltaSuite() {
        this.testIntegralDelta((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, (CompressionScheme)IntDelta$.MODULE$);
        this.testIntegralDelta((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, (CompressionScheme)LongDelta$.MODULE$);
    }
}

