/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.StaticMemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.benchmark.AggregateBenchmark$;
import org.apache.spark.sql.execution.benchmark.AggregateBenchmark$$anonfun$9$;
import org.apache.spark.sql.execution.benchmark.BenchmarkBase;
import org.apache.spark.sql.execution.benchmark.BenchmarkBase$class;
import org.apache.spark.sql.execution.joins.LongToUnsafeRowMap;
import org.apache.spark.sql.execution.vectorized.AggregateHashMap;
import org.apache.spark.sql.execution.vectorized.ColumnarBatch;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.map.BytesToBytesMap;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q1A!\u0001\u0002\u0001\u001f\t\u0011\u0012iZ4sK\u001e\fG/\u001a\"f]\u000eDW.\u0019:l\u0015\t\u0019A!A\u0005cK:\u001c\u0007.\\1sW*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011QBQ3oG\"l\u0017M]6CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\t)\u0002\u0001")
public class AggregateBenchmark
extends SparkFunSuite
implements BenchmarkBase {
    private final SparkSession sparkSession;
    private volatile boolean bitmap$0;

    private SparkSession sparkSession$lzycompute() {
        AggregateBenchmark aggregateBenchmark = this;
        synchronized (aggregateBenchmark) {
            if (!this.bitmap$0) {
                this.sparkSession = BenchmarkBase$class.sparkSession(this);
                this.bitmap$0 = true;
            }
            return this.sparkSession;
        }
    }

    @Override
    public SparkSession sparkSession() {
        return this.bitmap$0 ? this.sparkSession : this.sparkSession$lzycompute();
    }

    @Override
    public void runBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        BenchmarkBase$class.runBenchmark(this, name, cardinality, f);
    }

    public AggregateBenchmark() {
        BenchmarkBase$class.$init$(this);
        this.ignore("aggregate without grouping", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregateBenchmark $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long N = 0x7D000000L;
                Benchmark benchmark = new Benchmark("agg without grouping", N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                this.$outer.runBenchmark("agg w/o group", N, (Function0<BoxedUnit>)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final long N$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().range(this.N$1).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum(id)"})).collect();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$1 = N$1;
                    }
                });
            }

            public /* synthetic */ AggregateBenchmark org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("stat functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregateBenchmark $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long N = 0x6400000L;
                this.$outer.runBenchmark("stddev", N, (Function0<BoxedUnit>)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final long N$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().range(this.N$2).groupBy((Seq)Nil$.MODULE$).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"stddev"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).collect();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$2 = N$2;
                    }
                });
                this.$outer.runBenchmark("kurtosis", N, (Function0<BoxedUnit>)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final long N$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().range(this.N$2).groupBy((Seq)Nil$.MODULE$).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"kurtosis"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).collect();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$2 = N$2;
                    }
                });
            }

            public /* synthetic */ AggregateBenchmark org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("aggregate with linear keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregateBenchmark $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int N = 0x5000000;
                Benchmark benchmark = new Benchmark("Aggregate w keys", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = F"})).s((Seq)Nil$.MODULE$), 2, (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final int N$3;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$1(this.N$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$3 = N$3;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = F"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final int N$3;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$1(this.N$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$3 = N$3;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = T"})).s((Seq)Nil$.MODULE$), 5, (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final int N$3;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$1(this.N$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$3 = N$3;
                    }
                });
                benchmark.run();
            }

            public /* synthetic */ AggregateBenchmark org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer() {
                return this.$outer;
            }

            public final void org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$1(int N$3) {
                this.$outer.sparkSession().range((long)N$3).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(id & 65535) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sum((Seq)Nil$.MODULE$).collect();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("aggregate with randomized keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregateBenchmark $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int N = 0x5000000;
                Benchmark benchmark = new Benchmark("Aggregate w keys", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                this.$outer.sparkSession().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "floor(rand() * 10000) as k"})).createOrReplaceTempView("test");
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = F"})).s((Seq)Nil$.MODULE$), 2, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", false);
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$2();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = F"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", true);
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$2();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = T"})).s((Seq)Nil$.MODULE$), 5, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", true);
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$2();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                benchmark.run();
            }

            public /* synthetic */ AggregateBenchmark org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer() {
                return this.$outer;
            }

            public final void org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$2() {
                this.$outer.sparkSession().sql("select k, k, sum(id) from test group by k, k").collect();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("aggregate with string key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregateBenchmark $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int N = 0x1400000;
                Benchmark benchmark = new Benchmark("Aggregate w string key", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = F"})).s((Seq)Nil$.MODULE$), 2, (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final int N$4;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$3(this.N$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$4 = N$4;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = F"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final int N$4;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$3(this.N$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$4 = N$4;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = T"})).s((Seq)Nil$.MODULE$), 5, (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final int N$4;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$3(this.N$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$4 = N$4;
                    }
                });
                benchmark.run();
            }

            public /* synthetic */ AggregateBenchmark org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer() {
                return this.$outer;
            }

            public final void org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$3(int N$4) {
                this.$outer.sparkSession().range((long)N$4).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "cast(id & 1023 as string) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("aggregate with decimal key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregateBenchmark $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int N = 0x1400000;
                Benchmark benchmark = new Benchmark("Aggregate w decimal key", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = F"})).s((Seq)Nil$.MODULE$), benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final int N$5;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$4(this.N$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$5 = N$5;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = F"})).s((Seq)Nil$.MODULE$), benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final int N$5;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$4(this.N$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$5 = N$5;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = T"})).s((Seq)Nil$.MODULE$), benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final int N$5;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$4(this.N$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$5 = N$5;
                    }
                });
                benchmark.run();
            }

            public /* synthetic */ AggregateBenchmark org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer() {
                return this.$outer;
            }

            public final void org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$4(int N$5) {
                this.$outer.sparkSession().range((long)N$5).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "cast(id & 65535 as decimal) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("aggregate with multiple key types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregateBenchmark $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int N = 0x1400000;
                Benchmark benchmark = new Benchmark("Aggregate w multiple keys", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = F"})).s((Seq)Nil$.MODULE$), benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final int N$6;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$5(this.N$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$6 = N$6;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = F"})).s((Seq)Nil$.MODULE$), benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final int N$6;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "false");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$5(this.N$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$6 = N$6;
                    }
                });
                benchmark.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codegen = T hashmap = T"})).s((Seq)Nil$.MODULE$), benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final int N$6;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.wholeStage", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.twolevel.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().conf().set("spark.sql.codegen.aggregate.map.vectorized.enable", "true");
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$5(this.N$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$6 = N$6;
                    }
                });
                benchmark.run();
            }

            public /* synthetic */ AggregateBenchmark org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer() {
                return this.$outer;
            }

            public final void org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$f$5(int N$6) {
                this.$outer.sparkSession().range((long)N$6).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "(id & 1023) as k1", "cast(id & 1023 as string) as k2", "cast(id & 1023 as int) as k3", "cast(id & 1023 as double) as k4", "cast(id & 1023 as float) as k5", "id > 1023 as k6"})).groupBy("k1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2", "k3", "k4", "k5", "k6"})).sum((Seq)Nil$.MODULE$).collect();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("cube", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregateBenchmark $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int N = 0x500000;
                this.$outer.runBenchmark("cube", N, (Function0<BoxedUnit>)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final int N$7;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer().sparkSession().range((long)this.N$7).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 1000 as k1", "id & 256 as k2"})).cube("k1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2"})).sum((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).collect();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.N$7 = N$7;
                    }
                });
            }

            public /* synthetic */ AggregateBenchmark org$apache$spark$sql$execution$benchmark$AggregateBenchmark$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("hash and BytesToBytesMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int N = 0x1400000;
                Benchmark benchmark = new Benchmark("BytesToBytesMap", (long)N, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark.addCase("UnsafeRowhash", benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final int N$8;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        byte[] keyBytes = new byte[16];
                        UnsafeRow key = new UnsafeRow(1);
                        key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        int s = 0;
                        for (int i = 0; i < this.N$8; ++i) {
                            key.setInt(0, i % 1000);
                            int h = Murmur3_x86_32.hashUnsafeWords((Object)key.getBaseObject(), (long)key.getBaseOffset(), (int)key.getSizeInBytes(), (int)42);
                            s += h;
                        }
                    }
                    {
                        this.N$8 = N$8;
                    }
                });
                benchmark.addCase("murmur3 hash", benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final int N$8;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        byte[] keyBytes = new byte[16];
                        UnsafeRow key = new UnsafeRow(1);
                        key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        int p = 524283;
                        int s = 0;
                        for (int i = 0; i < this.N$8; ++i) {
                            int h = Murmur3_x86_32.hashLong((long)i, (int)42);
                            key.setInt(0, h);
                            s += h;
                        }
                    }
                    {
                        this.N$8 = N$8;
                    }
                });
                benchmark.addCase("fast hash", benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final int N$8;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        byte[] keyBytes = new byte[16];
                        UnsafeRow key = new UnsafeRow(1);
                        key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        int p = 524283;
                        int s = 0;
                        for (int i = 0; i < this.N$8; ++i) {
                            int h = i % p;
                            if (h < 0) {
                                h += p;
                            }
                            key.setInt(0, h);
                            s += h;
                        }
                    }
                    {
                        this.N$8 = N$8;
                    }
                });
                benchmark.addCase("arrayEqual", benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final int N$8;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        byte[] keyBytes = new byte[16];
                        byte[] valueBytes = new byte[16];
                        UnsafeRow key = new UnsafeRow(1);
                        key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        UnsafeRow value = new UnsafeRow(1);
                        value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        value.setInt(0, 555);
                        int s = 0;
                        for (int i = 0; i < this.N$8; ++i) {
                            key.setInt(0, i % 1000);
                            if (!key.equals((Object)value)) continue;
                            ++s;
                        }
                    }
                    {
                        this.N$8 = N$8;
                    }
                });
                benchmark.addCase("Java HashMap (Long)", benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final int N$8;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        int i;
                        byte[] keyBytes = new byte[16];
                        byte[] valueBytes = new byte[16];
                        UnsafeRow value = new UnsafeRow(1);
                        value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        value.setInt(0, 555);
                        HashMap<Long, UnsafeRow> map = new HashMap<Long, UnsafeRow>();
                        for (i = 0; i < 65536; ++i) {
                            value.setInt(0, i);
                            map.put(BoxesRunTime.boxToLong((long)i), value);
                        }
                        int s = 0;
                        for (i = 0; i < this.N$8; ++i) {
                            if (map.get(BoxesRunTime.boxToInteger((int)(i % 100000))) == null) continue;
                            ++s;
                        }
                    }
                    {
                        this.N$8 = N$8;
                    }
                });
                benchmark.addCase("Java HashMap (two ints) ", benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final int N$8;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        int i;
                        byte[] valueBytes = new byte[16];
                        UnsafeRow value = new UnsafeRow(1);
                        value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        value.setInt(0, 555);
                        HashMap<Long, UnsafeRow> map = new HashMap<Long, UnsafeRow>();
                        for (i = 0; i < 65536; ++i) {
                            value.setInt(0, i);
                            long key = ((long)i << 32) + (long)Integer.rotateRight(i, 15);
                            map.put(BoxesRunTime.boxToLong((long)key), value);
                        }
                        int s = 0;
                        for (i = 0; i < this.N$8; ++i) {
                            long key = ((long)(i & 0x186A0) << 32) + (long)Integer.rotateRight(i & 0x186A0, 15);
                            if (map.get(BoxesRunTime.boxToLong((long)key)) == null) continue;
                            ++s;
                        }
                    }
                    {
                        this.N$8 = N$8;
                    }
                });
                benchmark.addCase("Java HashMap (UnsafeRow)", benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final int N$8;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        int i;
                        byte[] keyBytes = new byte[16];
                        byte[] valueBytes = new byte[16];
                        UnsafeRow key = new UnsafeRow(1);
                        key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        UnsafeRow value = new UnsafeRow(1);
                        value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                        value.setInt(0, 555);
                        HashMap<UnsafeRow, UnsafeRow> map = new HashMap<UnsafeRow, UnsafeRow>();
                        for (i = 0; i < 65536; ++i) {
                            key.setInt(0, i);
                            value.setInt(0, i);
                            map.put(key, value.copy());
                        }
                        int s = 0;
                        for (i = 0; i < this.N$8; ++i) {
                            key.setInt(0, i % 100000);
                            if (map.get(key) == null) continue;
                            ++s;
                        }
                    }
                    {
                        this.N$8 = N$8;
                    }
                });
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1)new Serializable(this, N, benchmark){
                    public static final long serialVersionUID = 0L;
                    public final int N$8;
                    private final Benchmark benchmark$1;

                    public final void apply(boolean optimized) {
                        this.benchmark$1.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LongToUnsafeRowMap (opt=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)optimized)})), this.benchmark$1.addCase$default$2(), (Function1)new Serializable(this, optimized){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$28 $outer;
                            private final boolean optimized$1;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                int i;
                                byte[] valueBytes = new byte[16];
                                UnsafeRow value = new UnsafeRow(1);
                                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                                value.setInt(0, 555);
                                TaskMemoryManager taskMemoryManager = new TaskMemoryManager((MemoryManager)new StaticMemoryManager(new SparkConf().set("spark.memory.offHeap.enabled", "false"), Long.MAX_VALUE, Long.MAX_VALUE, 1), 0L);
                                LongToUnsafeRowMap map = new LongToUnsafeRowMap(taskMemoryManager, 64);
                                for (i = 0; i < 65536; ++i) {
                                    value.setInt(0, i);
                                    int key = i % 100000;
                                    map.append((long)key, value);
                                }
                                if (this.optimized$1) {
                                    map.optimize();
                                }
                                int s = 0;
                                for (i = 0; i < this.$outer.N$8; ++i) {
                                    int key = i % 100000;
                                    if (map.getValue((long)key, value) == null) continue;
                                    ++s;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.optimized$1 = optimized$1;
                            }
                        });
                    }
                    {
                        this.N$8 = N$8;
                        this.benchmark$1 = benchmark$1;
                    }
                });
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"off", "on"}))).foreach((Function1)new Serializable(this, N, benchmark){
                    public static final long serialVersionUID = 0L;
                    public final int N$8;
                    private final Benchmark benchmark$1;

                    public final void apply(String heap) {
                        this.benchmark$1.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BytesToBytesMap (", " Heap)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{heap})), this.benchmark$1.addCase$default$2(), (Function1)new Serializable(this, heap){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$29 $outer;
                            private final String heap$1;

                            public final void apply(int iter) {
                                this.apply$mcVI$sp(iter);
                            }

                            public void apply$mcVI$sp(int iter) {
                                int i;
                                Object[] objectArray = new Object[1];
                                String string = this.heap$1;
                                String string2 = "off";
                                objectArray[0] = BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
                                TaskMemoryManager taskMemoryManager = new TaskMemoryManager((MemoryManager)new StaticMemoryManager(new SparkConf().set("spark.memory.offHeap.enabled", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray))).set("spark.memory.offHeap.size", "102400000"), Long.MAX_VALUE, Long.MAX_VALUE, 1), 0L);
                                BytesToBytesMap map = new BytesToBytesMap(taskMemoryManager, 1024, 0x4000000L);
                                byte[] keyBytes = new byte[16];
                                byte[] valueBytes = new byte[16];
                                UnsafeRow key = new UnsafeRow(1);
                                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                                UnsafeRow value = new UnsafeRow(1);
                                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                                int numKeys = 65536;
                                for (i = 0; i < numKeys; ++i) {
                                    key.setInt(0, i % 65536);
                                    BytesToBytesMap.Location loc = map.lookup(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), Murmur3_x86_32.hashLong((long)(i % 65536), (int)42));
                                    Object object = loc.isDefined() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)loc.append(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), value.getBaseObject(), value.getBaseOffset(), value.getSizeInBytes()));
                                }
                                int s = 0;
                                for (i = 0; i < this.$outer.N$8; ++i) {
                                    key.setInt(0, i % 100000);
                                    BytesToBytesMap.Location loc = map.lookup(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), Murmur3_x86_32.hashLong((long)(i % 100000), (int)42));
                                    if (!loc.isDefined()) continue;
                                    ++s;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.heap$1 = heap$1;
                            }
                        });
                    }
                    {
                        this.N$8 = N$8;
                        this.benchmark$1 = benchmark$1;
                    }
                });
                benchmark.addCase("Aggregate HashMap", benchmark.addCase$default$2(), (Function1)new Serializable(this, N){
                    public static final long serialVersionUID = 0L;
                    private final int N$8;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        int i;
                        int numKeys = 65536;
                        StructType schema2 = new StructType().add("key", (DataType)LongType$.MODULE$).add("value", (DataType)LongType$.MODULE$);
                        AggregateHashMap map = new AggregateHashMap(schema2);
                        for (i = 0; i < numKeys; ++i) {
                            ColumnarBatch.Row row = map.findOrInsert((long)i);
                            row.setLong(1, row.getLong(1) + 1L);
                        }
                        int s = 0;
                        for (i = 0; i < this.N$8; ++i) {
                            if (map.find((long)(i % 100000)) == -1) continue;
                            ++s;
                        }
                    }
                    {
                        this.N$8 = N$8;
                    }
                });
                benchmark.run();
            }
        });
    }
}

