/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.UnsafeRowSuite$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001U1A!\u0001\u0002\u0001\u0017\tqQK\\:bM\u0016\u0014vn^*vSR,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0005\u0013\tyAAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\t\u0001")
public class UnsafeRowSuite
extends SparkFunSuite {
    public UnsafeRowSuite() {
        this.test("UnsafeRow Java serialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] data = new byte[1024];
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(data, 16);
                row.setLong(0, 19285L);
                SerializerInstance ser = new JavaSerializer(new SparkConf()).newInstance();
                UnsafeRow row1 = (UnsafeRow)ser.deserialize(ser.serialize((Object)row, ClassTag$.MODULE$.apply(UnsafeRow.class)), ClassTag$.MODULE$.apply(UnsafeRow.class));
                long $org_scalatest_assert_macro_left = row1.getLong(0);
                int $org_scalatest_assert_macro_right = 19285;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                byte[] $org_scalatest_assert_macro_left2 = (byte[])row1.getBaseObject();
                int $org_scalatest_assert_macro_right2 = 16;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("UnsafeRow Kryo serialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] data = new byte[1024];
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(data, 16);
                row.setLong(0, 19285L);
                SerializerInstance ser = new KryoSerializer(new SparkConf()).newInstance();
                UnsafeRow row1 = (UnsafeRow)ser.deserialize(ser.serialize((Object)row, ClassTag$.MODULE$.apply(UnsafeRow.class)), ClassTag$.MODULE$.apply(UnsafeRow.class));
                long $org_scalatest_assert_macro_left = row1.getLong(0);
                int $org_scalatest_assert_macro_right = 19285;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                byte[] $org_scalatest_assert_macro_left2 = (byte[])row1.getBaseObject();
                int $org_scalatest_assert_macro_right2 = 16;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("bitset width calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)0)));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)1)));
                int $org_scalatest_assert_macro_right2 = 8;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)32)));
                int $org_scalatest_assert_macro_right3 = 8;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)64)));
                int $org_scalatest_assert_macro_right4 = 8;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)65)));
                int $org_scalatest_assert_macro_right5 = 16;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)128)));
                int $org_scalatest_assert_macro_right6 = 16;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("writeToStream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcV$sp() {
                Tuple2 tuple29;
                Tuple2 tuple26;
                Tuple2 tuple2;
                Tuple2 tuple22;
                InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"hello"), UTF8String.fromString((String)"world"), BoxesRunTime.boxToInteger((int)123)}));
                UnsafeRow arrayBackedUnsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$})).apply(row);
                Object $org_scalatest_assert_macro_left = arrayBackedUnsafeRow.getBaseObject();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left, "isInstanceOf", "scala.Array", $org_scalatest_assert_macro_left instanceof byte[]);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                arrayBackedUnsafeRow.writeToStream((OutputStream)baos, null);
                Tuple2 tuple23 = new Tuple2((Object)baos.toByteArray(), (Object)arrayBackedUnsafeRow.getString(0));
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                byte[] bytesFromArrayBackedRow = (byte[])tuple23._1();
                String field0StringFromArrayBackedRow = (String)tuple23._2();
                Tuple2 tuple232 = tuple22 = new Tuple2((Object)bytesFromArrayBackedRow, (Object)field0StringFromArrayBackedRow);
                byte[] bytesFromArrayBackedRow2 = (byte[])tuple232._1();
                String field0StringFromArrayBackedRow2 = (String)tuple232._2();
                MemoryBlock offheapRowPage = MemoryAllocator.UNSAFE.allocate((long)arrayBackedUnsafeRow.getSizeInBytes());
                try {
                    Platform.copyMemory((Object)arrayBackedUnsafeRow.getBaseObject(), (long)arrayBackedUnsafeRow.getBaseOffset(), (Object)offheapRowPage.getBaseObject(), (long)offheapRowPage.getBaseOffset(), (long)arrayBackedUnsafeRow.getSizeInBytes());
                    UnsafeRow offheapUnsafeRow = new UnsafeRow(3);
                    offheapUnsafeRow.pointTo(offheapRowPage.getBaseObject(), offheapRowPage.getBaseOffset(), arrayBackedUnsafeRow.getSizeInBytes());
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(offheapUnsafeRow.getBaseObject());
                    Null$ $org_scalatest_assert_macro_right = null;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    byte[] writeBuffer = new byte[1024];
                    offheapUnsafeRow.writeToStream((OutputStream)baos2, writeBuffer);
                    tuple2 = new Tuple2((Object)baos2.toByteArray(), (Object)offheapUnsafeRow.getString(0));
                }
                catch (Throwable throwable) {
                    void var15_13;
                    MemoryAllocator.UNSAFE.free((MemoryBlock)var15_13);
                    throw throwable;
                }
                MemoryAllocator.UNSAFE.free(offheapRowPage);
                Tuple2 tuple25 = tuple2;
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                byte[] bytesFromOffheapRow = (byte[])tuple25._1();
                String field0StringFromOffheapRow = (String)tuple25._2();
                Tuple2 tuple27 = tuple26 = new Tuple2((Object)bytesFromOffheapRow, (Object)field0StringFromOffheapRow);
                byte[] bytesFromOffheapRow2 = (byte[])tuple27._1();
                String field0StringFromOffheapRow2 = (String)tuple27._2();
                ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
                int numBytes = arrayBackedUnsafeRow.getSizeInBytes();
                byte[] bytesWithOffset = new byte[numBytes + 100];
                System.arraycopy((byte[])arrayBackedUnsafeRow.getBaseObject(), 0, bytesWithOffset, 100, numBytes);
                UnsafeRow arrayBackedRow = new UnsafeRow(arrayBackedUnsafeRow.numFields());
                arrayBackedRow.pointTo((Object)bytesWithOffset, (long)(Platform.BYTE_ARRAY_OFFSET + 100), numBytes);
                arrayBackedRow.writeToStream((OutputStream)baos3, null);
                Tuple2 tuple28 = new Tuple2((Object)baos3.toByteArray(), (Object)arrayBackedRow.getString(0));
                if (tuple28 == null) throw new MatchError((Object)tuple28);
                byte[] bytesFromArrayBackedRowWithOffset = (byte[])tuple28._1();
                String field0StringFromArrayBackedRowWithOffset = (String)tuple28._2();
                Tuple2 tuple210 = tuple29 = new Tuple2((Object)bytesFromArrayBackedRowWithOffset, (Object)field0StringFromArrayBackedRowWithOffset);
                byte[] bytesFromArrayBackedRowWithOffset2 = (byte[])tuple210._1();
                String field0StringFromArrayBackedRowWithOffset2 = (String)tuple210._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(bytesFromArrayBackedRow2);
                byte[] $org_scalatest_assert_macro_right2 = bytesFromOffheapRow2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(field0StringFromArrayBackedRow2);
                String $org_scalatest_assert_macro_right3 = field0StringFromOffheapRow2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(bytesFromArrayBackedRow2);
                byte[] $org_scalatest_assert_macro_right4 = bytesFromArrayBackedRowWithOffset2;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(field0StringFromArrayBackedRow2);
                String $org_scalatest_assert_macro_right5 = field0StringFromArrayBackedRowWithOffset2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("calling getDouble() and getFloat() on null columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null}));
                UnsafeRow unsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{FloatType$.MODULE$, DoubleType$.MODULE$})).apply(row);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToFloat((float)unsafeRow.getFloat(0)));
                float $org_scalatest_assert_macro_right = row.getFloat(0);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)unsafeRow.getDouble(1)));
                double $org_scalatest_assert_macro_right2 = row.getDouble(1);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("calling get(ordinal, datatype) on null columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}));
                UnsafeRow unsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{NullType$.MODULE$})).apply(row);
                DataTypeTestUtils$.MODULE$.atomicTypes().foreach((Function1)new Serializable(this, unsafeRow){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final UnsafeRow unsafeRow$1;

                    public final void apply(DataType dataType) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$UnsafeRowSuite$$anonfun$$$outer().convertToEqualizer(this.unsafeRow$1.get(0, dataType));
                        Null$ $org_scalatest_assert_macro_right = null;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$sql$UnsafeRowSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.unsafeRow$1 = unsafeRow$1;
                    }
                });
            }

            public /* synthetic */ UnsafeRowSuite org$apache$spark$sql$UnsafeRowSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("createFromByteArray and copyFrom", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"abc")}));
                UnsafeProjection converter = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{IntegerType$.MODULE$, StringType$.MODULE$}));
                UnsafeRow unsafeRow = converter.apply(row);
                UnsafeRow emptyRow = UnsafeRow.createFromByteArray((int)64, (int)2);
                Object buffer = emptyRow.getBaseObject();
                emptyRow.copyFrom(unsafeRow);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getSizeInBytes()));
                int $org_scalatest_assert_macro_right = unsafeRow.getSizeInBytes();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getInt(0)));
                int $org_scalatest_assert_macro_right2 = unsafeRow.getInt(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(emptyRow.getUTF8String(1));
                UTF8String $org_scalatest_assert_macro_right3 = unsafeRow.getUTF8String(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(emptyRow.getBaseObject());
                Object $org_scalatest_assert_macro_right4 = buffer;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                unsafeRow.setInt(0, 2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getInt(0)));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                UTF8String longString = UTF8String.fromString((String)((String)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int x$4) {
                        return "abc";
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$5, String x$6) {
                        return new StringBuilder().append((Object)x$5).append((Object)x$6).toString();
                    }
                })));
                InternalRow row2 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), longString}));
                UnsafeRow unsafeRow2 = converter.apply(row2);
                emptyRow.copyFrom(unsafeRow2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getSizeInBytes()));
                int $org_scalatest_assert_macro_right6 = unsafeRow2.getSizeInBytes();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getInt(0)));
                int $org_scalatest_assert_macro_right7 = 3;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(emptyRow.getUTF8String(1));
                UTF8String $org_scalatest_assert_macro_right8 = longString;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Object $org_scalatest_assert_macro_left9 = emptyRow.getBaseObject();
                Object $org_scalatest_assert_macro_right9 = buffer;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left9, "!=", $org_scalatest_assert_macro_right9, !BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left9, (Object)$org_scalatest_assert_macro_right9));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                emptyRow.copyFrom(unsafeRow);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getSizeInBytes()));
                int $org_scalatest_assert_macro_right10 = unsafeRow.getSizeInBytes();
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getInt(0)));
                int $org_scalatest_assert_macro_right11 = unsafeRow.getInt(0);
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(emptyRow.getUTF8String(1));
                UTF8String $org_scalatest_assert_macro_right12 = unsafeRow.getUTF8String(1);
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("calling hashCode on unsafe array returned by getArray(ordinal)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData(new long[]{1L})}));
                UnsafeRow unsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$)})).apply(row);
                unsafeRow.getArray(0).hashCode();
            }
        });
    }
}

