/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DatasetBenchmark;
import org.apache.spark.sql.DatasetBenchmark$;
import org.apache.spark.sql.DatasetBenchmark$$anonfun$aggregate$3$;
import org.apache.spark.sql.DatasetBenchmark$$anonfun$aggregate$4$;
import org.apache.spark.sql.DatasetBenchmark$$anonfun$backToBackFilter$3$;
import org.apache.spark.sql.DatasetBenchmark$$anonfun$backToBackMap$3$;
import org.apache.spark.sql.DatasetBenchmark$ComplexAggregator$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.expressions.scalalang.typed$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class DatasetBenchmark$ {
    public static final DatasetBenchmark$ MODULE$;

    static {
        new DatasetBenchmark$();
    }

    public Benchmark backToBackMap(SparkSession spark, long numRows, int numChains) {
        Dataset df = spark.range(1L, numRows).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).as("l"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$).as("s")}));
        Benchmark benchmark = new Benchmark("back-to-back map", numRows, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        Serializable func = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DatasetBenchmark.Data apply(DatasetBenchmark.Data d) {
                return new DatasetBenchmark.Data(d.l() + 1L, d.s());
            }
        };
        RDD rdd = spark.sparkContext().range(1L, numRows, spark.sparkContext().range$default$3(), spark.sparkContext().range$default$4()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DatasetBenchmark.Data apply(long l) {
                return new DatasetBenchmark.Data(l, ((Object)BoxesRunTime.boxToLong((long)l)).toString());
            }
        }, ClassTag$.MODULE$.apply(DatasetBenchmark.Data.class));
        benchmark.addCase("RDD", benchmark.addCase$default$2(), (Function1)new Serializable(numChains, (Function1)func, rdd){
            public static final long serialVersionUID = 0L;
            private final int numChains$1;
            private final Function1 func$1;
            private final RDD rdd$1;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                RDD res = this.rdd$1;
                for (int i = 0; i < this.numChains$1; ++i) {
                    res = res.map(this.func$1, ClassTag$.MODULE$.apply(DatasetBenchmark.Data.class));
                }
                res.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(DatasetBenchmark.Data x$1) {
                    }
                });
            }
            {
                this.numChains$1 = numChains$1;
                this.func$1 = func$1;
                this.rdd$1 = rdd$1;
            }
        });
        benchmark.addCase("DataFrame", benchmark.addCase$default$2(), (Function1)new Serializable(spark, numChains, df){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final int numChains$1;
            private final Dataset df$1;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                Dataset res = this.df$1;
                for (int i = 0; i < this.numChains$1; ++i) {
                    res = res.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark$1.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}))).$((Seq)Nil$.MODULE$).$plus((Object)BoxesRunTime.boxToInteger((int)1)).as("l"), this.spark$1.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).$((Seq)Nil$.MODULE$)}));
                }
                res.queryExecution().toRdd().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InternalRow x$2) {
                    }
                });
            }
            {
                this.spark$1 = spark$1;
                this.numChains$1 = numChains$1;
                this.df$1 = df$1;
            }
        });
        benchmark.addCase("Dataset", benchmark.addCase$default$2(), (Function1)new Serializable(spark, numChains, df, (Function1)func){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final int numChains$1;
            private final Dataset df$1;
            private final Function1 func$1;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DatasetBenchmark$.MODULE$.getClass().getClassLoader());
                public final class Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackMap$3$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackMap$3$$typecreator1$1(anonfun.backToBackMap.3 $outer) {
                    }
                }
                Dataset res = this.df$1.as(this.spark$1.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackMap$3$$typecreator1$1(this))));
                for (int i = 0; i < this.numChains$1; ++i) {
                    JavaUniverse $u2 = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DatasetBenchmark$.MODULE$.getClass().getClassLoader());
                    public final class Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackMap$3$$typecreator2$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackMap$3$$typecreator2$1(anonfun.backToBackMap.3 $outer) {
                        }
                    }
                    res = res.map(this.func$1, this.spark$1.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackMap$3$$typecreator2$1(this))));
                }
                res.queryExecution().toRdd().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InternalRow x$3) {
                    }
                });
            }
            {
                this.spark$1 = spark$1;
                this.numChains$1 = numChains$1;
                this.df$1 = df$1;
                this.func$1 = func$1;
            }
        });
        return benchmark;
    }

    public Benchmark backToBackFilter(SparkSession spark, long numRows, int numChains) {
        Dataset df = spark.range(1L, numRows).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).as("l"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$).as("s")}));
        Benchmark benchmark = new Benchmark("back-to-back filter", numRows, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        Serializable func = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DatasetBenchmark.Data d, int i) {
                return d.l() % (100L + (long)i) == 0L;
            }
        };
        IndexedSeq funcs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numChains).map((Function1)new Serializable((Function2)func){
            public static final long serialVersionUID = 0L;
            public final Function2 func$2;

            public final Function1<DatasetBenchmark.Data, Object> apply(int i) {
                return new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;
                    private final int i$1;

                    public final boolean apply(DatasetBenchmark.Data d) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.func$2.apply((Object)d, (Object)BoxesRunTime.boxToInteger((int)this.i$1)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                };
            }
            {
                this.func$2 = func$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        RDD rdd = spark.sparkContext().range(1L, numRows, spark.sparkContext().range$default$3(), spark.sparkContext().range$default$4()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DatasetBenchmark.Data apply(long l) {
                return new DatasetBenchmark.Data(l, ((Object)BoxesRunTime.boxToLong((long)l)).toString());
            }
        }, ClassTag$.MODULE$.apply(DatasetBenchmark.Data.class));
        benchmark.addCase("RDD", benchmark.addCase$default$2(), (Function1)new Serializable(numChains, funcs, rdd){
            public static final long serialVersionUID = 0L;
            private final int numChains$2;
            private final IndexedSeq funcs$1;
            private final RDD rdd$2;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                RDD res = this.rdd$2;
                for (int i = 0; i < this.numChains$2; ++i) {
                    res = res.filter((Function1)this.funcs$1.apply(i));
                }
                res.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(DatasetBenchmark.Data x$4) {
                    }
                });
            }
            {
                this.numChains$2 = numChains$2;
                this.funcs$1 = funcs$1;
                this.rdd$2 = rdd$2;
            }
        });
        benchmark.addCase("DataFrame", benchmark.addCase$default$2(), (Function1)new Serializable(spark, numChains, df){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$2;
            private final int numChains$2;
            private final Dataset df$2;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                Dataset res = this.df$2;
                for (int i = 0; i < this.numChains$2; ++i) {
                    res = res.filter(this.spark$2.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToLong((long)(100L + (long)i))).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)0L)));
                }
                res.queryExecution().toRdd().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InternalRow x$5) {
                    }
                });
            }
            {
                this.spark$2 = spark$2;
                this.numChains$2 = numChains$2;
                this.df$2 = df$2;
            }
        });
        benchmark.addCase("Dataset", benchmark.addCase$default$2(), (Function1)new Serializable(spark, numChains, df, funcs){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$2;
            private final int numChains$2;
            private final Dataset df$2;
            private final IndexedSeq funcs$1;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DatasetBenchmark$.MODULE$.getClass().getClassLoader());
                public final class Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackFilter$3$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackFilter$3$$typecreator3$1(anonfun.backToBackFilter.3 $outer) {
                    }
                }
                Dataset res = this.df$2.as(this.spark$2.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$anonfun$backToBackFilter$3$$typecreator3$1(this))));
                for (int i = 0; i < this.numChains$2; ++i) {
                    res = res.filter((Function1)this.funcs$1.apply(i));
                }
                res.queryExecution().toRdd().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InternalRow x$6) {
                    }
                });
            }
            {
                this.spark$2 = spark$2;
                this.numChains$2 = numChains$2;
                this.df$2 = df$2;
                this.funcs$1 = funcs$1;
            }
        });
        return benchmark;
    }

    public Benchmark aggregate(SparkSession spark, long numRows) {
        Dataset df = spark.range(1L, numRows).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).as("l"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$).as("s")}));
        Benchmark benchmark = new Benchmark("aggregate", numRows, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        RDD rdd = spark.sparkContext().range(1L, numRows, spark.sparkContext().range$default$3(), spark.sparkContext().range$default$4()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DatasetBenchmark.Data apply(long l) {
                return new DatasetBenchmark.Data(l, ((Object)BoxesRunTime.boxToLong((long)l)).toString());
            }
        }, ClassTag$.MODULE$.apply(DatasetBenchmark.Data.class));
        benchmark.addCase("RDD sum", benchmark.addCase$default$2(), (Function1)new Serializable(rdd){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$3;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                this.rdd$3.aggregate((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x$7, DatasetBenchmark.Data x$8) {
                        return x$7 + x$8.l();
                    }
                }, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x$9, long x$10) {
                        return this.apply$mcJJJ$sp(x$9, x$10);
                    }

                    public long apply$mcJJJ$sp(long x$9, long x$10) {
                        return x$9 + x$10;
                    }
                }, ClassTag$.MODULE$.Long());
            }
            {
                this.rdd$3 = rdd$3;
            }
        });
        benchmark.addCase("DataFrame sum", benchmark.addCase$default$2(), (Function1)new Serializable(spark, df){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$3;
            private final Dataset df$3;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                this.df$3.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum((Column)this.spark$3.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}))).$((Seq)Nil$.MODULE$))})).queryExecution().toRdd().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InternalRow x$11) {
                    }
                });
            }
            {
                this.spark$3 = spark$3;
                this.df$3 = df$3;
            }
        });
        benchmark.addCase("Dataset sum using Aggregator", benchmark.addCase$default$2(), (Function1)new Serializable(spark, df){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$3;
            private final Dataset df$3;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DatasetBenchmark$.MODULE$.getClass().getClassLoader());
                public final class Org_apache_spark_sql_DatasetBenchmark$$anonfun$aggregate$3$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_DatasetBenchmark$$anonfun$aggregate$3$$typecreator5$1(anonfun.aggregate.3 $outer) {
                    }
                }
                this.df$3.as(this.spark$3.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$anonfun$aggregate$3$$typecreator5$1(this)))).select(typed$.MODULE$.sumLong((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(DatasetBenchmark.Data d) {
                        return d.l();
                    }
                })).queryExecution().toRdd().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InternalRow x$12) {
                    }
                });
            }
            {
                this.spark$3 = spark$3;
                this.df$3 = df$3;
            }
        });
        benchmark.addCase("Dataset complex Aggregator", benchmark.addCase$default$2(), (Function1)new Serializable(spark, df){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$3;
            private final Dataset df$3;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DatasetBenchmark$.MODULE$.getClass().getClassLoader());
                public final class Org_apache_spark_sql_DatasetBenchmark$$anonfun$aggregate$4$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.DatasetBenchmark.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_DatasetBenchmark$$anonfun$aggregate$4$$typecreator6$1(anonfun.aggregate.4 $outer) {
                    }
                }
                this.df$3.as(this.spark$3.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_DatasetBenchmark$$anonfun$aggregate$4$$typecreator6$1(this)))).select(DatasetBenchmark$ComplexAggregator$.MODULE$.toColumn()).queryExecution().toRdd().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InternalRow x$13) {
                    }
                });
            }
            {
                this.spark$3 = spark$3;
                this.df$3 = df$3;
            }
        });
        return benchmark;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().master("local[*]").appName("Dataset benchmark").getOrCreate();
        int numRows = 100000000;
        int numChains = 10;
        Benchmark benchmark = this.backToBackMap(spark, numRows, numChains);
        Benchmark benchmark2 = this.backToBackFilter(spark, numRows, numChains);
        Benchmark benchmark3 = this.aggregate(spark, numRows);
        benchmark.run();
        benchmark2.run();
        benchmark3.run();
    }

    private DatasetBenchmark$() {
        MODULE$ = this;
    }
}

