/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.jdbc.AggregatedDialect;
import org.apache.spark.sql.jdbc.JDBCSuite$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.jdbc.NoopDialect$;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$class;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils$class;
import org.apache.spark.sql.test.SQLTestUtils$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSQLContext$class;
import org.apache.spark.sql.test.TestSQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.util.Utils$;
import org.h2.jdbc.JdbcSQLException;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u001b\tI!\n\u0012\"D'VLG/\u001a\u0006\u0003\u0007\u0011\tAA\u001b3cG*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\n\u0019!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+)\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005]!\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d\t\u00033qi\u0011A\u0007\u0006\u00037\u0011\tA\u0001^3ti&\u0011QD\u0007\u0002\u0011'\"\f'/\u001a3T#2\u001buN\u001c;fqRDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000f\u0011\u0002!\u0019!C\u0001K\u0005\u0019QO\u001d7\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgn\u001a\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\u0014\u0002\tU\u0014H\u000e\t\u0005\bc\u0001\u0011\r\u0011\"\u0001&\u0003I)(\u000f\\,ji\",6/\u001a:B]\u0012\u0004\u0016m]:\t\rM\u0002\u0001\u0015!\u0003'\u0003M)(\u000f\\,ji\",6/\u001a:B]\u0012\u0004\u0016m]:!\u0011\u001d)\u0004\u00011A\u0005\u0002Y\nAaY8o]V\tq\u0007\u0005\u00029u5\t\u0011H\u0003\u0002\u0006U%\u00111(\u000f\u0002\u000b\u0007>tg.Z2uS>t\u0007bB\u001f\u0001\u0001\u0004%\tAP\u0001\tG>tgn\u0018\u0013fcR\u0011q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0005+:LG\u000fC\u0004Gy\u0005\u0005\t\u0019A\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004I\u0001\u0001\u0006KaN\u0001\u0006G>tg\u000e\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0003%!Xm\u001d;CsR,7/F\u0001M!\r\u0001UjT\u0005\u0003\u001d\u0006\u0013Q!\u0011:sCf\u0004\"\u0001\u0011)\n\u0005E\u000b%\u0001\u0002\"zi\u0016Daa\u0015\u0001!\u0002\u0013a\u0015A\u0003;fgR\u0014\u0015\u0010^3tA!9Q\u000b\u0001b\u0001\n\u00031\u0016!\u0004;fgRD%\u0007R5bY\u0016\u001cG/F\u0001X!\t\u0011\u0003,\u0003\u0002Z\u0005\tY!\n\u001a2d\t&\fG.Z2u\u0011\u0019Y\u0006\u0001)A\u0005/\u0006qA/Z:u\u0011J\"\u0015.\u00197fGR\u0004\u0003")
public class JDBCSuite
extends SparkFunSuite
implements BeforeAndAfter,
SharedSQLContext {
    private final String url;
    private final String urlWithUserAndPass;
    private Connection conn;
    private final byte[] testBytes;
    private final JdbcDialect testH2Dialect;
    private TestSQLContext org$apache$spark$sql$test$SharedSQLContext$$_ctx;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private final Function1<String, DataFrame> sql;
    private final DataFrame testData;
    private final DataFrame testData2;
    private final DataFrame testData3;
    private final DataFrame negativeData;
    private final DataFrame largeAndSmallInts;
    private final DataFrame decimalData;
    private final DataFrame binaryData;
    private final DataFrame upperCaseData;
    private final DataFrame lowerCaseData;
    private final RDD<SQLTestData.ArrayData> arrayData;
    private final RDD<SQLTestData.MapData> mapData;
    private final RDD<SQLTestData.StringData> repeatedData;
    private final RDD<SQLTestData.StringData> nullableRepeatedData;
    private final DataFrame nullInts;
    private final DataFrame allNulls;
    private final DataFrame nullStrings;
    private final DataFrame tableName;
    private final RDD<String> unparsedStrings;
    private final RDD<SQLTestData.IntField> withEmptyParts;
    private final DataFrame person;
    private final DataFrame salary;
    private final DataFrame complexData;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile int bitmap$0;
    private volatile SQLTestUtils$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;

    @Override
    public TestSQLContext org$apache$spark$sql$test$SharedSQLContext$$_ctx() {
        return this.org$apache$spark$sql$test$SharedSQLContext$$_ctx;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$_ctx_$eq(TestSQLContext x$1) {
        this.org$apache$spark$sql$test$SharedSQLContext$$_ctx = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SQLTestUtils$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public TestSQLContext ctx() {
        return SharedSQLContext$class.ctx(this);
    }

    @Override
    public TestSQLContext sqlContext() {
        return SharedSQLContext$class.sqlContext(this);
    }

    @Override
    public SQLContext _sqlContext() {
        return SharedSQLContext$class._sqlContext(this);
    }

    @Override
    public void beforeAll() {
        SharedSQLContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext$class.afterAll(this);
    }

    @Override
    public SharedSQLContext.StringToColumn StringToColumn(StringContext sc) {
        return SharedSQLContext$class.StringToColumn(this, sc);
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1 sql$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtils$class.sql(this);
                this.bitmap$0 |= 1;
            }
            return this.sql;
        }
    }

    @Override
    public Function1<String, DataFrame> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestUtils$testImplicits$ testImplicits$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if (this.testImplicits$module != null) return this.testImplicits$module;
            this.testImplicits$module = new SQLTestUtils$testImplicits$(this);
            return this.testImplicits$module;
        }
    }

    @Override
    public SQLTestUtils$testImplicits$ testImplicits() {
        return this.testImplicits$module == null ? this.testImplicits$lzycompute() : this.testImplicits$module;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils$class.setupTestData(this);
    }

    @Override
    public Configuration configuration() {
        return SQLTestUtils$class.configuration(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withSQLConf(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtils$class.withTempPath(this, f);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils$class.withTempDir(this, f);
    }

    @Override
    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withTempTable(this, tableNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withTable(this, tableNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtils$class.withTempDatabase(this, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtils$class.activateDatabase(this, db, f);
    }

    @Override
    public DataFrame logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtils$class.logicalPlanToSparkQuery(this, plan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if (this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module != null) return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module = new SQLTestData$internalImplicits$(this);
            return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
        }
    }

    @Override
    public final SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module == null ? this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() : this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
    }

    private DataFrame testData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.testData = SQLTestData$class.testData(this);
                this.bitmap$0 |= 2;
            }
            return this.testData;
        }
    }

    @Override
    public DataFrame testData() {
        return (this.bitmap$0 & 2) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private DataFrame testData2$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData2 = SQLTestData$class.testData2(this);
                this.bitmap$0 |= 4;
            }
            return this.testData2;
        }
    }

    @Override
    public DataFrame testData2() {
        return (this.bitmap$0 & 4) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private DataFrame testData3$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData3 = SQLTestData$class.testData3(this);
                this.bitmap$0 |= 8;
            }
            return this.testData3;
        }
    }

    @Override
    public DataFrame testData3() {
        return (this.bitmap$0 & 8) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private DataFrame negativeData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.negativeData = SQLTestData$class.negativeData(this);
                this.bitmap$0 |= 0x10;
            }
            return this.negativeData;
        }
    }

    @Override
    public DataFrame negativeData() {
        return (this.bitmap$0 & 0x10) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private DataFrame largeAndSmallInts$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.largeAndSmallInts = SQLTestData$class.largeAndSmallInts(this);
                this.bitmap$0 |= 0x20;
            }
            return this.largeAndSmallInts;
        }
    }

    @Override
    public DataFrame largeAndSmallInts() {
        return (this.bitmap$0 & 0x20) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private DataFrame decimalData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.decimalData = SQLTestData$class.decimalData(this);
                this.bitmap$0 |= 0x40;
            }
            return this.decimalData;
        }
    }

    @Override
    public DataFrame decimalData() {
        return (this.bitmap$0 & 0x40) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private DataFrame binaryData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.binaryData = SQLTestData$class.binaryData(this);
                this.bitmap$0 |= 0x80;
            }
            return this.binaryData;
        }
    }

    @Override
    public DataFrame binaryData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private DataFrame upperCaseData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.upperCaseData = SQLTestData$class.upperCaseData(this);
                this.bitmap$0 |= 0x100;
            }
            return this.upperCaseData;
        }
    }

    @Override
    public DataFrame upperCaseData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private DataFrame lowerCaseData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.lowerCaseData = SQLTestData$class.lowerCaseData(this);
                this.bitmap$0 |= 0x200;
            }
            return this.lowerCaseData;
        }
    }

    @Override
    public DataFrame lowerCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private RDD arrayData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.arrayData = SQLTestData$class.arrayData(this);
                this.bitmap$0 |= 0x400;
            }
            return this.arrayData;
        }
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD mapData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.mapData = SQLTestData$class.mapData(this);
                this.bitmap$0 |= 0x800;
            }
            return this.mapData;
        }
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD repeatedData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.repeatedData = SQLTestData$class.repeatedData(this);
                this.bitmap$0 |= 0x1000;
            }
            return this.repeatedData;
        }
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD nullableRepeatedData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.nullableRepeatedData = SQLTestData$class.nullableRepeatedData(this);
                this.bitmap$0 |= 0x2000;
            }
            return this.nullableRepeatedData;
        }
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private DataFrame nullInts$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.nullInts = SQLTestData$class.nullInts(this);
                this.bitmap$0 |= 0x4000;
            }
            return this.nullInts;
        }
    }

    @Override
    public DataFrame nullInts() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private DataFrame allNulls$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.allNulls = SQLTestData$class.allNulls(this);
                this.bitmap$0 |= 0x8000;
            }
            return this.allNulls;
        }
    }

    @Override
    public DataFrame allNulls() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private DataFrame nullStrings$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullStrings = SQLTestData$class.nullStrings(this);
                this.bitmap$0 |= 0x10000;
            }
            return this.nullStrings;
        }
    }

    @Override
    public DataFrame nullStrings() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private DataFrame tableName$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.tableName = SQLTestData$class.tableName(this);
                this.bitmap$0 |= 0x20000;
            }
            return this.tableName;
        }
    }

    @Override
    public DataFrame tableName() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD unparsedStrings$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.unparsedStrings = SQLTestData$class.unparsedStrings(this);
                this.bitmap$0 |= 0x40000;
            }
            return this.unparsedStrings;
        }
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD withEmptyParts$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.withEmptyParts = SQLTestData$class.withEmptyParts(this);
                this.bitmap$0 |= 0x80000;
            }
            return this.withEmptyParts;
        }
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private DataFrame person$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.person = SQLTestData$class.person(this);
                this.bitmap$0 |= 0x100000;
            }
            return this.person;
        }
    }

    @Override
    public DataFrame person() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.person$lzycompute() : this.person;
    }

    private DataFrame salary$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.salary = SQLTestData$class.salary(this);
                this.bitmap$0 |= 0x200000;
            }
            return this.salary;
        }
    }

    @Override
    public DataFrame salary() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private DataFrame complexData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.complexData = SQLTestData$class.complexData(this);
                this.bitmap$0 |= 0x400000;
            }
            return this.complexData;
        }
    }

    @Override
    public DataFrame complexData() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    @Override
    public void loadTestData() {
        SQLTestData$class.loadTestData(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public String url() {
        return this.url;
    }

    public String urlWithUserAndPass() {
        return this.urlWithUserAndPass;
    }

    public Connection conn() {
        return this.conn;
    }

    public void conn_$eq(Connection x$1) {
        this.conn = x$1;
    }

    public byte[] testBytes() {
        return this.testBytes;
    }

    public JdbcDialect testH2Dialect() {
        return this.testH2Dialect;
    }

    public JDBCSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        SQLTestData$class.$init$(this);
        SQLTestUtils$class.$init$(this);
        SharedSQLContext$class.$init$(this);
        this.url = "jdbc:h2:mem:testdb0";
        this.urlWithUserAndPass = "jdbc:h2:mem:testdb0;user=testUser;password=testPass";
        this.conn = null;
        this.testBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)99, (byte)134, (byte)135, (byte)200, (byte)205}), ClassTag$.MODULE$.Byte());
        this.testH2Dialect = new $anon$1(this);
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final DataFrame apply() {
                Utils$.MODULE$.classForName("org.h2.Driver");
                Properties properties = new Properties();
                properties.setProperty("user", "testUser");
                properties.setProperty("password", "testPass");
                properties.setProperty("rowId", "false");
                this.$outer.conn_$eq(DriverManager.getConnection(this.$outer.url(), properties));
                this.$outer.conn().prepareStatement("create schema test").executeUpdate();
                this.$outer.conn().prepareStatement("create table test.people (name TEXT(32) NOT NULL, theid INTEGER NOT NULL)").executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.people values ('fred', 1)").executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.people values ('mary', 2)").executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.people values ('joe ''foo'' \"bar\"', 3)").executeUpdate();
                this.$outer.conn().commit();
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE foobar\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable 'TEST.PEOPLE', user 'testUser', password 'testPass')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE fetchtwo\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable 'TEST.PEOPLE', user 'testUser', password 'testPass',\n        |         fetchSize '2')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE parts\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable 'TEST.PEOPLE', user 'testUser', password 'testPass',\n        |         partitionColumn 'THEID', lowerBound '1', upperBound '4', numPartitions '3')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                this.$outer.conn().prepareStatement("create table test.inttypes (a INT, b BOOLEAN, c TINYINT, d SMALLINT, e BIGINT)").executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.inttypes values (1, false, 3, 4, 1234567890123)").executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.inttypes values (null, null, null, null, null)").executeUpdate();
                this.$outer.conn().commit();
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE inttypes\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable 'TEST.INTTYPES', user 'testUser', password 'testPass')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                this.$outer.conn().prepareStatement("create table test.strtypes (a BINARY(20), b VARCHAR(20), c VARCHAR_IGNORECASE(20), d CHAR(20), e BLOB, f CLOB)").executeUpdate();
                PreparedStatement stmt = this.$outer.conn().prepareStatement("insert into test.strtypes values (?, ?, ?, ?, ?, ?)");
                stmt.setBytes(1, this.$outer.testBytes());
                stmt.setString(2, "Sensitive");
                stmt.setString(3, "Insensitive");
                stmt.setString(4, "Twenty-byte CHAR");
                stmt.setBytes(5, this.$outer.testBytes());
                stmt.setString(6, "I am a clob!");
                stmt.executeUpdate();
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE strtypes\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable 'TEST.STRTYPES', user 'testUser', password 'testPass')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                this.$outer.conn().prepareStatement("create table test.timetypes (a TIME, b DATE, c TIMESTAMP)").executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.timetypes values ('12:34:56', '1996-01-01', '2002-02-20 11:22:33.543543543')").executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.timetypes values ('12:34:56', null, '2002-02-20 11:22:33.543543543')").executeUpdate();
                this.$outer.conn().commit();
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE timetypes\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable 'TEST.TIMETYPES', user 'testUser', password 'testPass')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                this.$outer.conn().prepareStatement("create table test.flttypes (a DOUBLE, b REAL, c DECIMAL(38, 18))").executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.flttypes values (1.0000000000000002220446049250313080847263336181640625, 1.00000011920928955078125, 123456789012345.543215432154321)").executeUpdate();
                this.$outer.conn().commit();
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE flttypes\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable 'TEST.FLTTYPES', user 'testUser', password 'testPass')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                this.$outer.conn().prepareStatement(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |create table test.nulltypes (a INT, b BOOLEAN, c TINYINT, d BINARY(20), e VARCHAR(20),\n        |f VARCHAR_IGNORECASE(20), g CHAR(20), h BLOB, i CLOB, j TIME, k DATE, l TIMESTAMP,\n        |m DOUBLE, n REAL, o DECIMAL(38, 18))\n      "})).s((Seq)Nil$.MODULE$))).stripMargin().replaceAll("\n", " ")).executeUpdate();
                this.$outer.conn().prepareStatement("insert into test.nulltypes values (null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)").executeUpdate();
                this.$outer.conn().commit();
                return (DataFrame)this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TEMPORARY TABLE nulltypes\n         |USING org.apache.spark.sql.jdbc\n         |OPTIONS (url '", "', dbtable 'TEST.NULLTYPES', user 'testUser', password 'testPass')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.after((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.conn().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT *", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM foobar")).collect()).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT * WHERE (simple predicates)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM foobar WHERE THEID < 1")).collect()).size()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM foobar WHERE THEID != 2")).collect()).size()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM foobar WHERE THEID = 1")).collect()).size()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM foobar WHERE NAME = 'fred'")).collect()).size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM foobar WHERE NAME > 'fred'")).collect()).size()));
                int $org_scalatest_assert_macro_right5 = 2;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM foobar WHERE NAME != 'fred'")).collect()).size()));
                int $org_scalatest_assert_macro_right6 = 2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT * WHERE (quoted strings)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"select * from foobar")).where(this.$outer.testImplicits().symbolToColumn(Symbol$.MODULE$.apply("NAME")).$eq$eq$eq((Object)"joe 'foo' \"bar\"")).collect()).size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT first field", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String[] names = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT NAME FROM foobar")).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x) {
                        return x.getString(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$1, String x$2) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).$less((Object)x$2);
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])names).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(names[0].equals("fred"), "names.apply(0).equals(\"fred\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(names[1].equals("joe 'foo' \"bar\""), "names.apply(1).equals(\"joe \\'foo\\' \\\"bar\\\"\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(names[2].equals("mary"), "names.apply(2).equals(\"mary\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT first field when fetchSize is two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String[] names = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT NAME FROM fetchtwo")).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x) {
                        return x.getString(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$3, String x$4) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$3)).$less((Object)x$4);
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])names).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(names[0].equals("fred"), "names.apply(0).equals(\"fred\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(names[1].equals("joe 'foo' \"bar\""), "names.apply(1).equals(\"joe \\'foo\\' \\\"bar\\\"\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(names[2].equals("mary"), "names.apply(2).equals(\"mary\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT second field", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int[] ids = (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT THEID FROM foobar")).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Row x) {
                        return x.getInt(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$5, int x$6) {
                        return this.apply$mcZII$sp(x$5, x$6);
                    }

                    public boolean apply$mcZII$sp(int x$5, int x$6) {
                        return x$5 < x$6;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.intArrayOps(ids).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[0]));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[1]));
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[2]));
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT second field when fetchSize is two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int[] ids = (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT THEID FROM fetchtwo")).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Row x) {
                        return x.getInt(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$7, int x$8) {
                        return this.apply$mcZII$sp(x$7, x$8);
                    }

                    public boolean apply$mcZII$sp(int x$7, int x$8) {
                        return x$7 < x$8;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.intArrayOps(ids).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[0]));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[1]));
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[2]));
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT * partitioned", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayOps $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM parts")).collect());
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (long)$org_scalatest_assert_macro_left.size(), (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT WHERE (simple predicates) partitioned", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM parts WHERE THEID < 1")).collect()).size()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM parts WHERE THEID != 2")).collect()).size()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT THEID FROM parts WHERE THEID = 1")).collect()).size()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT second field partitioned", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int[] ids = (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])((DataFrame)this.$outer.sql().apply((Object)"SELECT THEID FROM parts")).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Row x) {
                        return x.getInt(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$9, int x$10) {
                        return this.apply$mcZII$sp(x$9, x$10);
                    }

                    public boolean apply$mcZII$sp(int x$9, int x$10) {
                        return x$9 < x$10;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.intArrayOps(ids).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[0]));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[1]));
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[2]));
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Register JDBC query with renamed fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE renamed\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable '(select NAME as NAME1, NAME as NAME2 from TEST.PEOPLE)',\n        |user 'testUser', password 'testPass')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                DataFrame df2 = (DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM renamed");
                ArrayOps $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])df2.schema().fields());
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (long)$org_scalatest_assert_macro_left.size(), (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = df2.schema().fields()[0].name();
                String $org_scalatest_assert_macro_right2 = "NAME1";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = df2.schema().fields()[1].name();
                String $org_scalatest_assert_macro_right3 = "NAME2";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Basic API", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.PEOPLE", new Properties()).collect().length));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Basic API with FetchSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Properties properties = new Properties();
                properties.setProperty("fetchSize", "2");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.PEOPLE", properties).collect().length));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Partitioning via JDBCPartitioningInfo API", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.PEOPLE", "THEID", 0L, 4L, 3, new Properties()).collect().length));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Partitioning via list-of-where-clauses API", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String[] parts = (String[])((Object[])new String[]{"THEID < 2", "THEID >= 2"});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.PEOPLE", parts, new Properties()).collect().length));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("H2 integral types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] rows = ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM inttypes WHERE A IS NOT NULL")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows.length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows[0].getInt(0)));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)rows[0].getBoolean(1)));
                boolean $org_scalatest_assert_macro_right3 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows[0].getInt(2)));
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows[0].getInt(3)));
                int $org_scalatest_assert_macro_right5 = 4;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rows[0].getLong(4)));
                long $org_scalatest_assert_macro_right6 = 1234567890123L;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("H2 null entries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] rows = ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM inttypes WHERE A IS NULL")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows.length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(0), "rows.apply(0).isNullAt(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(1), "rows.apply(0).isNullAt(1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(2), "rows.apply(0).isNullAt(2)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(3), "rows.apply(0).isNullAt(3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(4), "rows.apply(0).isNullAt(4)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("H2 string types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] rows = ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM strtypes")).collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.byteArrayOps((byte[])rows[0].getAs(0)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.$outer.testBytes())), "scala.this.Predef.byteArrayOps(rows.apply(0).getAs[Array[Byte]](0)).sameElements[Byte](scala.this.Predef.wrapByteArray(JDBCSuite.this.testBytes))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(1).equals("Sensitive"), "rows.apply(0).getString(1).equals(\"Sensitive\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(2).equals("Insensitive"), "rows.apply(0).getString(2).equals(\"Insensitive\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(3).equals("Twenty-byte CHAR"), "rows.apply(0).getString(3).equals(\"Twenty-byte CHAR\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.byteArrayOps((byte[])rows[0].getAs(4)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.$outer.testBytes())), "scala.this.Predef.byteArrayOps(rows.apply(0).getAs[Array[Byte]](4)).sameElements[Byte](scala.this.Predef.wrapByteArray(JDBCSuite.this.testBytes))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(5).equals("I am a clob!"), "rows.apply(0).getString(5).equals(\"I am a clob!\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("H2 time types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] rows = ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM timetypes")).collect();
                GregorianCalendar cal = new GregorianCalendar(Locale.ROOT);
                cal.setTime((java.util.Date)rows[0].getAs(0));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(11)));
                int $org_scalatest_assert_macro_right = 12;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(12)));
                int $org_scalatest_assert_macro_right2 = 34;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(13)));
                int $org_scalatest_assert_macro_right3 = 56;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                cal.setTime((java.util.Date)rows[0].getAs(1));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(1)));
                int $org_scalatest_assert_macro_right4 = 1996;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(2)));
                int $org_scalatest_assert_macro_right5 = 0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(5)));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                cal.setTime((java.util.Date)rows[0].getAs(2));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(1)));
                int $org_scalatest_assert_macro_right7 = 2002;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(2)));
                int $org_scalatest_assert_macro_right8 = 1;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(5)));
                int $org_scalatest_assert_macro_right9 = 20;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(10)));
                int $org_scalatest_assert_macro_right10 = 11;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(12)));
                int $org_scalatest_assert_macro_right11 = 22;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(13)));
                int $org_scalatest_assert_macro_right12 = 33;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Timestamp)rows[0].getAs(2)).getNanos()));
                int $org_scalatest_assert_macro_right13 = 543543000;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("test DATE types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] rows = this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).collect();
                Row[] cachedRows = this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).cache().collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(rows[0].getAs(1));
                Date $org_scalatest_assert_macro_right = Date.valueOf("1996-01-01");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(rows[1].getAs(1));
                Null$ $org_scalatest_assert_macro_right2 = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(cachedRows[0].getAs(1));
                Date $org_scalatest_assert_macro_right3 = Date.valueOf("1996-01-01");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("test DATE types in cache", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] rows = this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).collect();
                this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).cache().registerTempTable("mycached_date");
                Row[] cachedRows = ((DataFrame)this.$outer.sql().apply((Object)"select * from mycached_date")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(rows[0].getAs(1));
                Date $org_scalatest_assert_macro_right = Date.valueOf("1996-01-01");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(cachedRows[0].getAs(1));
                Date $org_scalatest_assert_macro_right2 = Date.valueOf("1996-01-01");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("test types for null value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] rows = this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.NULLTYPES", new Properties()).collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).forall((Function1)new Serializable(this, rows){
                    public static final long serialVersionUID = 0L;
                    private final Row[] rows$1;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.rows$1[0].isNullAt(i);
                    }
                    {
                        this.rows$1 = rows$1;
                    }
                }), "scala.this.Predef.intWrapper(0).to(14).forall(((i: Int) => rows.apply(0).isNullAt(i)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("H2 floating-point types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] rows = ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM flttypes")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rows[0].getDouble(0)));
                double $org_scalatest_assert_macro_right = 1.0000000000000002;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rows[0].getDouble(1)));
                double $org_scalatest_assert_macro_right2 = 1.0000001192092896;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(rows[0].getAs(2));
                BigDecimal $org_scalatest_assert_macro_right3 = new BigDecimal("123456789012345.543215432154321000");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(rows[0].schema().fields()[2].dataType());
                DecimalType $org_scalatest_assert_macro_right4 = new DecimalType(38, 18);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Row[] result = ((DataFrame)this.$outer.sql().apply((Object)"SELECT C FROM flttypes where C > C - 1")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(result[0].getAs(0));
                BigDecimal $org_scalatest_assert_macro_right5 = new BigDecimal("123456789012345.543215432154321000");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SQL query as table name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TEMPORARY TABLE hack\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '", "', dbtable '(SELECT B, B*B FROM TEST.FLTTYPES)',\n        |         user 'testUser', password 'testPass')\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.url()})))).stripMargin().replaceAll("\n", " "));
                Row[] rows = ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM hack")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rows[0].getDouble(0)));
                double $org_scalatest_assert_macro_right = 1.0000001192092896;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left2 = package$.MODULE$.abs(rows[0].getDouble(1) - 1.0000002384185933);
                double $org_scalatest_assert_macro_right2 = 1.0E-12;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Pass extra properties via OPTIONS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;

                    public final DataFrame apply() {
                        return (DataFrame)this.$outer.org$apache$spark$sql$jdbc$JDBCSuite$$anonfun$$$outer().sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |CREATE TEMPORARY TABLE abc\n          |USING org.apache.spark.sql.jdbc\n          |OPTIONS (url '", "', dbtable '(SELECT _ROWID_ FROM test.people)',\n          |         user 'testUser', password 'testPass')\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$jdbc$JDBCSuite$$anonfun$$$outer().url()})))).stripMargin().replaceAll("\n", " "));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(JdbcSQLException.class));
            }

            public /* synthetic */ JDBCSuite org$apache$spark$sql$jdbc$JDBCSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Remap types via JdbcDialects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JdbcDialects$.MODULE$.registerDialect(this.$outer.testH2Dialect());
                DataFrame df2 = this.$outer.ctx().read().jdbc(this.$outer.urlWithUserAndPass(), "TEST.PEOPLE", new Properties());
                Seq $org_scalatest_assert_macro_left = (Seq)df2.schema().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StructField x$11) {
                        DataType dataType = x$11.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        return dataType != null ? !dataType.equals(stringType$) : stringType$ != null;
                    }
                });
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Row[] rows = df2.collect();
                Object $org_scalatest_assert_macro_left2 = rows[0].get(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left2, "isInstanceOf", "scala.Predef.String", $org_scalatest_assert_macro_left2 instanceof String);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Object $org_scalatest_assert_macro_left3 = rows[0].get(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left3, "isInstanceOf", "scala.Predef.String", $org_scalatest_assert_macro_left3 instanceof String);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                JdbcDialects$.MODULE$.unregisterDialect(this.$outer.testH2Dialect());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Default jdbc dialect registration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JdbcDialect $org_scalatest_assert_macro_left = JdbcDialects$.MODULE$.get("jdbc:mysql://127.0.0.1/db");
                MySQLDialect$ $org_scalatest_assert_macro_right = MySQLDialect$.MODULE$;
                JdbcDialect jdbcDialect = $org_scalatest_assert_macro_left;
                MySQLDialect$ mySQLDialect$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jdbcDialect != null ? !jdbcDialect.equals(mySQLDialect$) : mySQLDialect$ != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                JdbcDialect $org_scalatest_assert_macro_left2 = JdbcDialects$.MODULE$.get("jdbc:postgresql://127.0.0.1/db");
                PostgresDialect$ $org_scalatest_assert_macro_right2 = PostgresDialect$.MODULE$;
                JdbcDialect jdbcDialect2 = $org_scalatest_assert_macro_left2;
                PostgresDialect$ postgresDialect$ = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(jdbcDialect2 != null ? !jdbcDialect2.equals(postgresDialect$) : postgresDialect$ != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                JdbcDialect $org_scalatest_assert_macro_left3 = JdbcDialects$.MODULE$.get("test.invalid");
                NoopDialect$ $org_scalatest_assert_macro_right3 = NoopDialect$.MODULE$;
                JdbcDialect jdbcDialect3 = $org_scalatest_assert_macro_left3;
                NoopDialect$ noopDialect$ = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(jdbcDialect3 != null ? !jdbcDialect3.equals(noopDialect$) : noopDialect$ != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("quote column names by jdbc dialect", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JdbcDialect MySQL = JdbcDialects$.MODULE$.get("jdbc:mysql://127.0.0.1/db");
                JdbcDialect Postgres = JdbcDialects$.MODULE$.get("jdbc:postgresql://127.0.0.1/db");
                Seq columns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "key"}));
                Seq MySQLColumns = (Seq)columns.map((Function1)new Serializable(this, MySQL){
                    public static final long serialVersionUID = 0L;
                    private final JdbcDialect MySQL$1;

                    public final String apply(String x$12) {
                        return this.MySQL$1.quoteIdentifier(x$12);
                    }
                    {
                        this.MySQL$1 = MySQL$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq PostgresColumns = (Seq)columns.map((Function1)new Serializable(this, Postgres){
                    public static final long serialVersionUID = 0L;
                    private final JdbcDialect Postgres$1;

                    public final String apply(String x$13) {
                        return this.Postgres$1.quoteIdentifier(x$13);
                    }
                    {
                        this.Postgres$1 = Postgres$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(MySQLColumns);
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`abc`", "`key`"}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(PostgresColumns);
                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"abc\"", "\"key\""}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Dialect unregister", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JdbcDialects$.MODULE$.registerDialect(this.$outer.testH2Dialect());
                JdbcDialects$.MODULE$.unregisterDialect(this.$outer.testH2Dialect());
                JdbcDialect $org_scalatest_assert_macro_left = JdbcDialects$.MODULE$.get(this.$outer.urlWithUserAndPass());
                NoopDialect$ $org_scalatest_assert_macro_right = NoopDialect$.MODULE$;
                JdbcDialect jdbcDialect = $org_scalatest_assert_macro_left;
                NoopDialect$ noopDialect$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jdbcDialect != null ? !jdbcDialect.equals(noopDialect$) : noopDialect$ != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Aggregated dialects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AggregatedDialect agg = new AggregatedDialect(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JdbcDialect[]{new JdbcDialect(this){

                    public boolean canHandle(String url) {
                        return url.startsWith("jdbc:h2:");
                    }

                    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
                        return sqlType % 2 == 0 ? new Some((Object)LongType$.MODULE$) : None$.MODULE$;
                    }
                }, this.$outer.testH2Dialect()})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(agg.canHandle("jdbc:h2:xxx"), "agg.canHandle(\"jdbc:h2:xxx\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(agg.canHandle("jdbc:h2"), "agg.canHandle(\"jdbc:h2\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(agg.getCatalystType(0, "", 1, null));
                Some $org_scalatest_assert_macro_right = new Some((Object)LongType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(agg.getCatalystType(1, "", 1, null));
                Some $org_scalatest_assert_macro_right2 = new Some((Object)StringType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

