/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.parquet.CatalystReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaSuite$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaTest;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001#\t\u0011\u0002+\u0019:rk\u0016$8k\u00195f[\u0006\u001cV/\u001b;f\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\tQCJ\fX/\u001a;TG\",W.\u0019+fgRDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001\"B\u000e\u0001\t\u0013a\u0012A\u0005;fgR\u001c6\r[3nC\u000ec\u0017\u000e\u001d9j]\u001e$R!H\u0012-]Y\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011A!\u00168ji\")AE\u0007a\u0001K\u0005AA/Z:u\u001d\u0006lW\r\u0005\u0002'S9\u0011adJ\u0005\u0003Q}\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0016,\u0005\u0019\u0019FO]5oO*\u0011\u0001f\b\u0005\u0006[i\u0001\r!J\u0001\u000ea\u0006\u0014\u0018/^3u'\u000eDW-\\1\t\u000b=R\u0002\u0019\u0001\u0019\u0002\u001d\r\fG/\u00197zgR\u001c6\r[3nCB\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007C\u0001\u0006if\u0004Xm]\u0005\u0003kI\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u00159$\u00041\u0001&\u00039)\u0007\u0010]3di\u0016$7k\u00195f[\u0006\u0004")
public class ParquetSchemaSuite
extends ParquetSchemaTest {
    private void testSchemaClipping(String testName, String parquetSchema, StructType catalystSchema, String expectedSchema) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Clipping - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, parquetSchema, catalystSchema, expectedSchema){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetSchemaSuite $outer;
            private final String parquetSchema$3;
            private final StructType catalystSchema$1;
            private final String expectedSchema$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MessageType expected2 = MessageTypeParser.parseMessageType((String)this.expectedSchema$1);
                MessageType actual = CatalystReadSupport$.MODULE$.clipParquetSchema(MessageTypeParser.parseMessageType((String)this.parquetSchema$3), this.catalystSchema$1);
                try {
                    expected2.checkContains((Type)actual);
                    actual.checkContains((Type)expected2);
                    return;
                }
                catch (Throwable throwable) {
                    throw this.$outer.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected clipped schema:\n             |", "\n             |Actual clipped schema:\n             |", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected2, actual})))).stripMargin(), throwable);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.parquetSchema$3 = parquetSchema$3;
                this.catalystSchema$1 = catalystSchema$1;
                this.expectedSchema$1 = expectedSchema$1;
            }
        });
    }

    public ParquetSchemaSuite() {
        this.test("DataType string parser compatibility", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetSchemaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String caseClassString = "StructType(List(StructField(c1,IntegerType,false), StructField(c2,BinaryType,true)))";
                String jsonString = "{\"type\":\"struct\",\"fields\":[{\"name\":\"c1\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"c2\",\"type\":\"binary\",\"nullable\":true,\"metadata\":{}}]}";
                Seq fromCaseClassString = ParquetTypesConverter$.MODULE$.convertFromString(caseClassString);
                Seq fromJson = ParquetTypesConverter$.MODULE$.convertFromString(jsonString);
                Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)fromCaseClassString, (Object)fromJson)), (Function1)Predef$.MODULE$.conforms(), (Function1)Predef$.MODULE$.conforms()), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(Attribute a, Attribute b) {
                        String $org_scalatest_assert_macro_left = a.name();
                        String $org_scalatest_assert_macro_right = b.name();
                        String string = $org_scalatest_assert_macro_left;
                        String string2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                        this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetSchemaSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetSchemaSuite$$anonfun$$$outer().convertToEqualizer(a.dataType());
                        DataType $org_scalatest_assert_macro_right2 = b.dataType();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetSchemaSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetSchemaSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)a.nullable()));
                        boolean $org_scalatest_assert_macro_right3 = b.nullable();
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetSchemaSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ParquetSchemaSuite org$apache$spark$sql$execution$datasources$parquet$ParquetSchemaSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge with metastore schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetSchemaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertResult(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("lowerCase", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("UPPERCase", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), ParquetRelation$.MODULE$.mergeMetastoreParquetSchema(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("lowercase", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("uppercase", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("lowerCase", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("UPPERCase", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})))));
                this.$outer.assertResult(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("UPPERCase", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), ParquetRelation$.MODULE$.mergeMetastoreParquetSchema(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("uppercase", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("lowerCase", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("UPPERCase", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})))));
                String $org_scalatest_assert_macro_left = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructType apply() {
                        return ParquetRelation$.MODULE$.mergeMetastoreParquetSchema(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("uppercase", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("lowerCase", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("UPPERCase", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}))));
                    }
                }, ManifestFactory$.MODULE$.classType(Throwable.class))).getMessage();
                String $org_scalatest_assert_macro_right = "detected conflicting schemas";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructType apply() {
                        return ParquetRelation$.MODULE$.mergeMetastoreParquetSchema(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("lower", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("lowerCase", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
                    }
                }, ManifestFactory$.MODULE$.classType(Throwable.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge missing nullable fields from Metastore schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetSchemaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertResult(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("firstField", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("secondField", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("thirdfield", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}))), ParquetRelation$.MODULE$.mergeMetastoreParquetSchema(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("firstfield", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("secondfield", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("thirdfield", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("firstField", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("secondField", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})))));
                String $org_scalatest_assert_macro_left = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructType apply() {
                        return ParquetRelation$.MODULE$.mergeMetastoreParquetSchema(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("firstfield", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("secondfield", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("thirdfield", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("firstField", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("secondField", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}))));
                    }
                }, ManifestFactory$.MODULE$.classType(Throwable.class))).getMessage();
                String $org_scalatest_assert_macro_right = "detected conflicting schemas";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.testParquetToCatalyst("Backwards-compatibility: LIST with nullable element type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      optional int32 element;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: LIST with nullable element type - 2", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      optional int32 num;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      required int32 element;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 2", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      required int32 num;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 3", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated int32 element;\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 4", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("num", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      required binary str (UTF8);\n      |      required int32 num;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 5 - parquet-avro style", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group array {\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 6 - parquet-thrift style", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group f1_tuple {\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type 7 - parquet-protobuf primitive lists", new StructType().add("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  repeated int32 f1;\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        StructType elementType = new StructType().add("c1", (DataType)StringType$.MODULE$, true).add("c2", (DataType)IntegerType$.MODULE$, false);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type 8 - parquet-protobuf non-primitive lists", new StructType().add("f1", (DataType)new ArrayType((DataType)elementType, false), false), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  repeated group f1 {\n      |    optional binary c1 (UTF8);\n      |    required int32 c2;\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        String x$43 = "Backwards-compatibility: LIST with nullable element type - 1 - standard";
        StructType x$44 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())})));
        String x$45 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      optional int32 element;\n      |    }\n      |  }\n      |}\n    ")).stripMargin();
        boolean x$46 = true;
        boolean x$47 = this.testCatalystToParquet$default$4();
        boolean x$48 = this.testCatalystToParquet$default$5();
        boolean x$49 = this.testCatalystToParquet$default$7();
        this.testCatalystToParquet(x$43, x$44, x$45, x$47, x$48, x$46, x$49);
        this.testCatalystToParquet("Backwards-compatibility: LIST with nullable element type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group bag {\n      |      optional int32 array;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testCatalystToParquet$default$4(), this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6(), this.testCatalystToParquet$default$7());
        String x$50 = "Backwards-compatibility: LIST with non-nullable element type - 1 - standard";
        StructType x$51 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())})));
        String x$52 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      required int32 element;\n      |    }\n      |  }\n      |}\n    ")).stripMargin();
        boolean x$53 = true;
        boolean x$54 = this.testCatalystToParquet$default$4();
        boolean x$55 = this.testCatalystToParquet$default$5();
        boolean x$56 = this.testCatalystToParquet$default$7();
        this.testCatalystToParquet(x$50, x$51, x$52, x$54, x$55, x$53, x$56);
        this.testCatalystToParquet("Backwards-compatibility: LIST with non-nullable element type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated int32 array;\n      |  }\n      |}\n    ")).stripMargin(), this.testCatalystToParquet$default$4(), this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6(), this.testCatalystToParquet$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 2", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP_KEY_VALUE) {\n      |    repeated group map {\n      |      required int32 num;\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 3 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group map (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 2", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP_KEY_VALUE) {\n      |    repeated group map {\n      |      required int32 num;\n      |      optional binary str (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 3 - parquet-avro style", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group map (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testParquetToCatalyst$default$4(), this.testParquetToCatalyst$default$5(), this.testParquetToCatalyst$default$6(), this.testParquetToCatalyst$default$7());
        String x$57 = "Backwards-compatibility: MAP with non-nullable value type - 1 - standard";
        StructType x$58 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())})));
        String x$59 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin();
        boolean x$60 = true;
        boolean x$61 = this.testCatalystToParquet$default$4();
        boolean x$62 = this.testCatalystToParquet$default$5();
        boolean x$63 = this.testCatalystToParquet$default$7();
        this.testCatalystToParquet(x$57, x$58, x$59, x$61, x$62, x$60, x$63);
        this.testCatalystToParquet("Backwards-compatibility: MAP with non-nullable value type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group map (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testCatalystToParquet$default$4(), this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6(), this.testCatalystToParquet$default$7());
        String x$64 = "Backwards-compatibility: MAP with nullable value type - 1 - standard";
        StructType x$65 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())})));
        String x$66 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin();
        boolean x$67 = true;
        boolean x$68 = this.testCatalystToParquet$default$4();
        boolean x$69 = this.testCatalystToParquet$default$5();
        boolean x$70 = this.testCatalystToParquet$default$7();
        this.testCatalystToParquet(x$64, x$65, x$66, x$68, x$69, x$67, x$70);
        this.testCatalystToParquet("Backwards-compatibility: MAP with nullable value type - 3 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group map (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), this.testCatalystToParquet$default$4(), this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6(), this.testCatalystToParquet$default$7());
        String x$71 = "DECIMAL(1, 0) - standard";
        StructType x$72 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(1, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        String x$73 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(1, 0));\n      |}\n    ")).stripMargin();
        boolean x$74 = true;
        boolean x$75 = this.testSchema$default$4();
        boolean x$76 = this.testSchema$default$5();
        boolean x$77 = this.testSchema$default$7();
        this.testSchema(x$71, x$72, x$73, x$75, x$76, x$74, x$77);
        String x$78 = "DECIMAL(8, 3) - standard";
        StructType x$79 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(8, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        String x$80 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(8, 3));\n      |}\n    ")).stripMargin();
        boolean x$81 = true;
        boolean x$82 = this.testSchema$default$4();
        boolean x$83 = this.testSchema$default$5();
        boolean x$84 = this.testSchema$default$7();
        this.testSchema(x$78, x$79, x$80, x$82, x$83, x$81, x$84);
        String x$85 = "DECIMAL(9, 3) - standard";
        StructType x$86 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(9, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        String x$87 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(9, 3));\n      |}\n    ")).stripMargin();
        boolean x$88 = true;
        boolean x$89 = this.testSchema$default$4();
        boolean x$90 = this.testSchema$default$5();
        boolean x$91 = this.testSchema$default$7();
        this.testSchema(x$85, x$86, x$87, x$89, x$90, x$88, x$91);
        String x$92 = "DECIMAL(18, 3) - standard";
        StructType x$93 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(18, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        String x$94 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional int64 f1 (DECIMAL(18, 3));\n      |}\n    ")).stripMargin();
        boolean x$95 = true;
        boolean x$96 = this.testSchema$default$4();
        boolean x$97 = this.testSchema$default$5();
        boolean x$98 = this.testSchema$default$7();
        this.testSchema(x$92, x$93, x$94, x$96, x$97, x$95, x$98);
        String x$99 = "DECIMAL(19, 3) - standard";
        StructType x$100 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(19, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        String x$101 = new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(9) f1 (DECIMAL(19, 3));\n      |}\n    ")).stripMargin();
        boolean x$102 = true;
        boolean x$103 = this.testSchema$default$4();
        boolean x$104 = this.testSchema$default$5();
        boolean x$105 = this.testSchema$default$7();
        this.testSchema(x$99, x$100, x$101, x$103, x$104, x$102, x$105);
        this.testSchema("DECIMAL(1, 0) - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(1, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(1) f1 (DECIMAL(1, 0));\n      |}\n    ")).stripMargin(), this.testSchema$default$4(), this.testSchema$default$5(), this.testSchema$default$6(), this.testSchema$default$7());
        this.testSchema("DECIMAL(8, 3) - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(8, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(4) f1 (DECIMAL(8, 3));\n      |}\n    ")).stripMargin(), this.testSchema$default$4(), this.testSchema$default$5(), this.testSchema$default$6(), this.testSchema$default$7());
        this.testSchema("DECIMAL(9, 3) - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(9, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(5) f1 (DECIMAL(9, 3));\n      |}\n    ")).stripMargin(), this.testSchema$default$4(), this.testSchema$default$5(), this.testSchema$default$6(), this.testSchema$default$7());
        this.testSchema("DECIMAL(18, 3) - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(18, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(8) f1 (DECIMAL(18, 3));\n      |}\n    ")).stripMargin(), this.testSchema$default$4(), this.testSchema$default$5(), this.testSchema$default$6(), this.testSchema$default$7());
        StructType f0Type = new StructType().add("f00", (DataType)IntegerType$.MODULE$, true);
        this.testSchemaClipping("simple nested struct", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional int32 f00;\n        |    optional int32 f01;\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type, false).add("f1", (DataType)IntegerType$.MODULE$, true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional int32 f00;\n        |  }\n        |  optional int32 f1;\n        |}\n      ")).stripMargin());
        ArrayType f00Type = new ArrayType((DataType)StringType$.MODULE$, false);
        ArrayType f01Type = new ArrayType((DataType)new StructType().add("f011", (DataType)DoubleType$.MODULE$, true), false);
        StructType f0Type2 = new StructType().add("f00", (DataType)f00Type, false).add("f01", (DataType)f01Type, false);
        ArrayType f1Type = new ArrayType((DataType)IntegerType$.MODULE$, true);
        this.testSchemaClipping("parquet-protobuf style array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    repeated binary f00 (UTF8);\n        |    repeated group f01 {\n        |      optional int32 f010;\n        |      optional double f011;\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type2, false).add("f1", (DataType)f1Type, true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    repeated binary f00 (UTF8);\n        |    repeated group f01 {\n        |      optional double f011;\n        |    }\n        |  }\n        |\n        |  optional group f1 (LIST) {\n        |    repeated group list {\n        |      optional int32 element;\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
        StructType f01ElementType = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type3 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType, false), true);
        this.testSchemaClipping("parquet-thrift style array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary f00_tuple (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group f01_tuple {\n        |        optional int32 f010;\n        |        optional double f011;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type3, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary f00_tuple (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group f01_tuple {\n        |        optional double f011;\n        |        optional int64 f012;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
        StructType f01ElementType2 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type4 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType2, false), true);
        this.testSchemaClipping("parquet-avro style array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary array (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group array {\n        |        optional int32 f010;\n        |        optional double f011;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type4, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary array (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group array {\n        |        optional double f011;\n        |        optional int64 f012;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
        StructType f01ElementType3 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type5 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, true), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType3, true), true);
        this.testSchemaClipping("parquet-hive style array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  optional group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group bag {\n        |        optional binary array_element;\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group bag {\n        |        optional group array_element {\n        |          optional int32 f010;\n        |          optional double f011;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type5, true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  optional group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group bag {\n        |        optional binary array_element;\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group bag {\n        |        optional group array_element {\n        |          optional double f011;\n        |          optional int64 f012;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
        StructType f00ElementType = new StructType().add("f001", (DataType)LongType$.MODULE$, true).add("f002", (DataType)DoubleType$.MODULE$, false);
        ArrayType f00Type2 = new ArrayType((DataType)f00ElementType, false);
        StructType f0Type6 = new StructType().add("f00", (DataType)f00Type2, false);
        this.testSchemaClipping("2-level list of required struct", new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message root {\n         |  required group f0 {\n         |    required group f00 (LIST) {\n         |      repeated group element {\n         |        required int32 f000;\n         |        optional int64 f001;\n         |      }\n         |    }\n         |  }\n         |}\n       "})).s((Seq)Nil$.MODULE$))).stripMargin(), new StructType().add("f0", (DataType)f0Type6, false), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message root {\n         |  required group f0 {\n         |    required group f00 (LIST) {\n         |      repeated group element {\n         |        optional int64 f001;\n         |        required double f002;\n         |      }\n         |    }\n         |  }\n         |}\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        StructType f01ElementType4 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type7 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType4, false), true);
        this.testSchemaClipping("standard array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group list {\n        |        required group element {\n        |          optional int32 f010;\n        |          optional double f011;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type7, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group list {\n        |        required group element {\n        |          optional double f011;\n        |          optional int64 f012;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
        this.testSchemaClipping("empty requested schema", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    required int32 f00;\n        |    required int64 f01;\n        |  }\n        |}\n      ")).stripMargin(), new StructType(), "message root {}");
        this.testSchemaClipping("disjoint field sets", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    required int32 f00;\n        |    required int64 f01;\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)new StructType().add("f02", (DataType)FloatType$.MODULE$, true).add("f03", (DataType)DoubleType$.MODULE$, true), true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional float f02;\n        |    optional double f03;\n        |  }\n        |}\n      ")).stripMargin());
        StructType valueType = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type8 = new MapType((DataType)IntegerType$.MODULE$, (DataType)valueType, false);
        this.testSchemaClipping("parquet-avro style map", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group map (MAP_KEY_VALUE) {\n        |      required int32 key;\n        |      required group value {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type8, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group map (MAP_KEY_VALUE) {\n        |      required int32 key;\n        |      required group value {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
        StructType valueType2 = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type9 = new MapType((DataType)IntegerType$.MODULE$, (DataType)valueType2, false);
        this.testSchemaClipping("standard map", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required int32 key;\n        |      required group value {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type9, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required int32 key;\n        |      required group value {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
        StructType keyType = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type10 = new MapType((DataType)keyType, (DataType)IntegerType$.MODULE$, false);
        this.testSchemaClipping("standard map with complex key", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required group key {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |      required int32 value;\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type10, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required group key {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |      required int32 value;\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
    }
}

