/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.BOOLEAN$;
import org.apache.spark.sql.columnar.BYTE$;
import org.apache.spark.sql.columnar.ByteColumnStats;
import org.apache.spark.sql.columnar.ColumnStats;
import org.apache.spark.sql.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.columnar.INT$;
import org.apache.spark.sql.columnar.IntColumnStats;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.LongColumnStats;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.NoopColumnStats;
import org.apache.spark.sql.columnar.SHORT$;
import org.apache.spark.sql.columnar.STRING$;
import org.apache.spark.sql.columnar.ShortColumnStats;
import org.apache.spark.sql.columnar.StringColumnStats;
import org.apache.spark.sql.columnar.compression.CompressionScheme;
import org.apache.spark.sql.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.columnar.compression.RunLengthEncoding;
import org.apache.spark.sql.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.types.AtomicType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001f\t1\"+\u001e8MK:<G\u000f[#oG>$\u0017N\\4Tk&$XM\u0003\u0002\u0004\t\u0005Y1m\\7qe\u0016\u001c8/[8o\u0015\t)a!\u0001\u0005d_2,XN\\1s\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t\u0001\"\u0003\u0002\u0014\u0011\ti1\u000b]1sW\u001a+hnU;ji\u0016DQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000bi\u0001A\u0011A\u000e\u0002+Q,7\u000f\u001e*v]2+gn\u001a;i\u000b:\u001cw\u000eZ5oOV\u0011A\u0004\r\u000b\u0004;\rJ\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDQ\u0001J\rA\u0002\u0015\n1bY8mk6t7\u000b^1ugB\u0011aeJ\u0007\u0002\t%\u0011\u0001\u0006\u0002\u0002\f\u0007>dW/\u001c8Ti\u0006$8\u000fC\u0003+3\u0001\u00071&\u0001\u0006d_2,XN\u001c+za\u0016\u00042A\n\u0017/\u0013\tiCA\u0001\tOCRLg/Z\"pYVlg\u000eV=qKB\u0011q\u0006\r\u0007\u0001\t\u0015\t\u0014D1\u00013\u0005\u0005!\u0016CA\u001a7!\tqB'\u0003\u00026?\t9aj\u001c;iS:<\u0007CA\u001c;\u001b\u0005A$BA\u001d\u0007\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0004H\u0001\u0006Bi>l\u0017n\u0019+za\u0016\u0004")
public class RunLengthEncodingSuite
extends SparkFunSuite {
    public <T extends AtomicType> void testRunLengthEncoding(ColumnStats columnStats, NativeColumnType<T> columnType) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$columnar$compression$RunLengthEncodingSuite$$skeleton$1(0, (Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": simple case"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$columnar$compression$RunLengthEncodingSuite$$skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": run length == 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$columnar$compression$RunLengthEncodingSuite$$skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": single long run"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$columnar$compression$RunLengthEncodingSuite$$skeleton$1(1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1000))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
    }

    public final void org$apache$spark$sql$columnar$compression$RunLengthEncodingSuite$$skeleton$1(int uniqueValueCount, Seq inputRuns, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)RunLengthEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericMutableRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq values = (Seq)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)values, (Object)rows);
            Seq values2 = (Seq)tuple23._1();
            Seq rows2 = (Seq)tuple23._2();
            Seq inputSeq = (Seq)inputRuns.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Object> apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int run2 = tuple2._2$mcI$sp();
                        Seq seq = (Seq)Seq$.MODULE$.fill(run2, (Function0)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.index$1;
                            }
                            {
                                this.index$1 = index$1;
                            }
                        });
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            inputSeq.foreach((Function1)new Serializable(this, builder, rows2){
                public static final long serialVersionUID = 0L;
                private final TestCompressibleColumnBuilder builder$1;
                private final Seq rows$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.builder$1.appendFrom((InternalRow)this.rows$1.apply(i), 0);
                }
                {
                    this.builder$1 = builder$1;
                    this.rows$1 = rows$1;
                }
            });
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            int compressedSize = 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)inputRuns.map((Function1)new Serializable(this, columnType$1, rows2){
                public static final long serialVersionUID = 0L;
                private final NativeColumnType columnType$1;
                private final Seq rows$1;

                public final int apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int n = this.columnType$1.actualSize((InternalRow)this.rows$1.apply(index), 0) + 4;
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.columnType$1 = columnType$1;
                    this.rows$1 = rows$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()));
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)RunLengthEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
            inputRuns.foreach((Function1)new Serializable(this, columnType$1, values2, buffer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RunLengthEncodingSuite $outer;
                private final NativeColumnType columnType$1;
                private final Seq values$1;
                private final ByteBuffer buffer$1;

                public final void apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int run2 = tuple2._2$mcI$sp();
                        this.$outer.assertResult(this.values$1.apply(index), "Wrong column element value", this.columnType$1.extract(this.buffer$1));
                        this.$outer.assertResult(BoxesRunTime.boxToInteger((int)run2), "Wrong run length", BoxesRunTime.boxToInteger((int)this.buffer$1.getInt()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.values$1 = values$1;
                    this.buffer$1 = buffer$1;
                }
            });
            buffer.rewind().position(headerSize + 4);
            RunLengthEncoding.Decoder decoder = RunLengthEncoding$.MODULE$.decoder(buffer, columnType$1);
            GenericMutableRow mutableRow = new GenericMutableRow(1);
            if (inputSeq.nonEmpty()) {
                inputSeq.foreach((Function1)new Serializable(this, columnType$1, values2, decoder, mutableRow){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RunLengthEncodingSuite $outer;
                    private final NativeColumnType columnType$1;
                    private final Seq values$1;
                    private final RunLengthEncoding.Decoder decoder$1;
                    private final GenericMutableRow mutableRow$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.decoder$1.hasNext(), "decoder.hasNext");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Object object = this.values$1.apply(i);
                        this.decoder$1.next((MutableRow)this.mutableRow$1, 0);
                        this.$outer.assertResult(object, "Wrong decoded value", this.columnType$1.getField((InternalRow)this.mutableRow$1, 0));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.columnType$1 = columnType$1;
                        this.values$1 = values$1;
                        this.decoder$1 = decoder$1;
                        this.mutableRow$1 = mutableRow$1;
                    }
                });
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext"));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            return;
        }
        throw new MatchError(tuple2);
    }

    public RunLengthEncodingSuite() {
        this.testRunLengthEncoding((ColumnStats)new NoopColumnStats(), (NativeColumnType)BOOLEAN$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new ByteColumnStats(), (NativeColumnType)BYTE$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new ShortColumnStats(), (NativeColumnType)SHORT$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$);
        this.testRunLengthEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$);
    }
}

