/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.ColumnStats;
import org.apache.spark.sql.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.columnar.INT$;
import org.apache.spark.sql.columnar.IntColumnStats;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.LongColumnStats;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.compression.CompressionScheme;
import org.apache.spark.sql.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.columnar.compression.Decoder;
import org.apache.spark.sql.columnar.compression.IntDelta$;
import org.apache.spark.sql.columnar.compression.IntegralDeltaSuite$;
import org.apache.spark.sql.columnar.compression.LongDelta$;
import org.apache.spark.sql.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.types.IntegralType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

@ScalaSignature(bytes="\u0006\u0001\u00053A!\u0001\u0002\u0001\u001f\t\u0011\u0012J\u001c;fOJ\fG\u000eR3mi\u0006\u001cV/\u001b;f\u0015\t\u0019A!A\u0006d_6\u0004(/Z:tS>t'BA\u0003\u0007\u0003!\u0019w\u000e\\;n]\u0006\u0014(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t\u0011\u0003^3ti&sG/Z4sC2$U\r\u001c;b+\ta\u0002\u0007\u0006\u0003\u001eG%b\u0004C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDQ\u0001J\rA\u0002\u0015\n1bY8mk6t7\u000b^1ugB\u0011aeJ\u0007\u0002\t%\u0011\u0001\u0006\u0002\u0002\f\u0007>dW/\u001c8Ti\u0006$8\u000fC\u0003+3\u0001\u00071&\u0001\u0006d_2,XN\u001c+za\u0016\u00042A\n\u0017/\u0013\tiCA\u0001\tOCRLg/Z\"pYVlg\u000eV=qKB\u0011q\u0006\r\u0007\u0001\t\u0015\t\u0014D1\u00013\u0005\u0005I\u0015CA\u001a7!\tqB'\u0003\u00026?\t9aj\u001c;iS:<\u0007CA\u001c;\u001b\u0005A$BA\u001d\u0007\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0004H\u0001\u0007J]R,wM]1m)f\u0004X\rC\u0003>3\u0001\u0007a(\u0001\u0004tG\",W.\u001a\t\u00031}J!\u0001\u0011\u0002\u0003#\r{W\u000e\u001d:fgNLwN\\*dQ\u0016lW\r")
public class IntegralDeltaSuite
extends SparkFunSuite {
    public <I extends IntegralType> void testIntegralDelta(ColumnStats columnStats, NativeColumnType<I> columnType, CompressionScheme scheme) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, scheme){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegralDeltaSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final CompressionScheme scheme$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$columnar$compression$IntegralDeltaSuite$$skeleton$1((Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1, this.scheme$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.scheme$1 = scheme$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": simple case"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, scheme){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegralDeltaSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final CompressionScheme scheme$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NativeColumnType nativeColumnType;
                block4: {
                    Seq seq;
                    block3: {
                        block2: {
                            nativeColumnType = this.columnType$1;
                            INT$ iNT$ = INT$.MODULE$;
                            NativeColumnType nativeColumnType2 = nativeColumnType;
                            if (iNT$ != null ? !iNT$.equals(nativeColumnType2) : nativeColumnType2 != null) break block2;
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 2, 130}));
                            break block3;
                        }
                        LONG$ lONG$ = LONG$.MODULE$;
                        NativeColumnType nativeColumnType3 = nativeColumnType;
                        if (lONG$ != null ? !lONG$.equals(nativeColumnType3) : nativeColumnType3 != null) break block4;
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 1L, 2L, 130L}));
                    }
                    Seq input = seq;
                    this.$outer.org$apache$spark$sql$columnar$compression$IntegralDeltaSuite$$skeleton$1((Seq)input.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Object x$2) {
                            return x$2;
                        }
                    }, Seq$.MODULE$.canBuildFrom()), this.columnStats$1, this.columnType$1, this.scheme$1);
                    return;
                }
                throw new MatchError((Object)nativeColumnType);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.scheme$1 = scheme$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": long random series"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, scheme){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegralDeltaSuite $outer;
            private final ColumnStats columnStats$1;
            public final NativeColumnType columnType$1;
            private final CompressionScheme scheme$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object[] input = (Object[])Array$.MODULE$.fill(10000, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testIntegralDelta$3 $outer;

                    public final Object apply() {
                        return ColumnarTestUtils$.MODULE$.makeRandomValue(this.$outer.columnType$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Any());
                this.$outer.org$apache$spark$sql$columnar$compression$IntegralDeltaSuite$$skeleton$1((Seq)Predef$.MODULE$.genericArrayOps((Object)input).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object x$3) {
                        return x$3;
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), this.columnStats$1, this.columnType$1, this.scheme$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.scheme$1 = scheme$1;
            }
        });
    }

    public final void org$apache$spark$sql$columnar$compression$IntegralDeltaSuite$$skeleton$1(Seq input, ColumnStats columnStats$1, NativeColumnType columnType$1, CompressionScheme scheme$1) {
        int n;
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, scheme$1);
        Seq deltas = input.isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(input.tail(), input.init())), (Function1)Predef$.MODULE$.conforms(), (Function1)Predef$.MODULE$.conforms()), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Object x0$1, Object x1$1) {
                Tuple2 tuple2;
                block4: {
                    long l;
                    block3: {
                        block2: {
                            tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 == null) break block2;
                            Object x = tuple2._1();
                            Object y = tuple2._2();
                            if (!(x instanceof Integer)) break block2;
                            int n = BoxesRunTime.unboxToInt((Object)x);
                            if (!(y instanceof Integer)) break block2;
                            int n2 = BoxesRunTime.unboxToInt((Object)y);
                            l = n - n2;
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Object x = tuple2._1();
                        Object y = tuple2._2();
                        if (!(x instanceof Long)) break block4;
                        long l2 = BoxesRunTime.unboxToLong((Object)x);
                        if (!(y instanceof Long)) break block4;
                        long l3 = BoxesRunTime.unboxToLong((Object)y);
                        l = l2 - l3;
                    }
                    return l;
                }
                throw new MatchError((Object)tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        input.map((Function1)new Serializable(this, columnType$1, builder){
            public static final long serialVersionUID = 0L;
            private final NativeColumnType columnType$1;
            private final TestCompressibleColumnBuilder builder$1;

            public final void apply(Object value) {
                GenericMutableRow row = new GenericMutableRow(1);
                this.columnType$1.setField((MutableRow)row, 0, value);
                this.builder$1.appendFrom((InternalRow)row, 0);
            }
            {
                this.columnType$1 = columnType$1;
                this.builder$1 = builder$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        if (deltas.isEmpty()) {
            n = 0;
        } else {
            int oneBoolean = columnType$1.defaultSize();
            n = 1 + oneBoolean + BoxesRunTime.unboxToInt((Object)((TraversableOnce)deltas.map((Function1)new Serializable(this, oneBoolean){
                public static final long serialVersionUID = 0L;
                private final int oneBoolean$1;

                public final int apply(long d) {
                    return this.apply$mcIJ$sp(d);
                }

                public int apply$mcIJ$sp(long d) {
                    return package$.MODULE$.abs(d) <= (long)127 ? 1 : 1 + this.oneBoolean$1;
                }
                {
                    this.oneBoolean$1 = oneBoolean$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        int compressedSize = 4 + n;
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)scheme$1.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
        if (input.nonEmpty()) {
            this.assertResult(BoxesRunTime.boxToByte((byte)-128), "The first byte should be an escaping mark", BoxesRunTime.boxToByte((byte)buffer.get()));
            this.assertResult(input.head(), "The first value is wrong", columnType$1.extract(buffer));
            Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(input.tail(), (Object)deltas)), (Function1)Predef$.MODULE$.conforms(), (Function1)Predef$.MODULE$.conforms()), (Function2)new Serializable(this, columnType$1, buffer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegralDeltaSuite $outer;
                private final NativeColumnType columnType$1;
                private final ByteBuffer buffer$1;

                public final void apply(Object value, long delta) {
                    if (package$.MODULE$.abs(delta) <= (long)127) {
                        this.$outer.assertResult(BoxesRunTime.boxToLong((long)delta), "Wrong delta", BoxesRunTime.boxToByte((byte)this.buffer$1.get()));
                    } else {
                        this.$outer.assertResult(BoxesRunTime.boxToByte((byte)-128), "Expecting escaping mark here", BoxesRunTime.boxToByte((byte)this.buffer$1.get()));
                        this.$outer.assertResult(value, "Wrong value", this.columnType$1.extract(this.buffer$1));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.buffer$1 = buffer$1;
                }
            });
        }
        buffer.rewind().position(headerSize + 4);
        Decoder decoder = scheme$1.decoder(buffer, columnType$1);
        GenericMutableRow mutableRow = new GenericMutableRow(1);
        if (input.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext");
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            input.foreach((Function1)new Serializable(this, columnType$1, decoder, mutableRow){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegralDeltaSuite $outer;
                private final NativeColumnType columnType$1;
                private final Decoder decoder$1;
                private final GenericMutableRow mutableRow$1;

                public final void apply(Object x$1) {
                    this.decoder$1.next((MutableRow)this.mutableRow$1, 0);
                    this.$outer.assertResult(x$1, "Wrong decoded value", this.columnType$1.getField((InternalRow)this.mutableRow$1, 0));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.decoder$1 = decoder$1;
                    this.mutableRow$1 = mutableRow$1;
                }
            });
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext"));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public IntegralDeltaSuite() {
        this.testIntegralDelta((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, (CompressionScheme)IntDelta$.MODULE$);
        this.testIntegralDelta((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, (CompressionScheme)LongDelta$.MODULE$);
    }
}

