/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.ColumnStats;
import org.apache.spark.sql.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.columnar.INT$;
import org.apache.spark.sql.columnar.IntColumnStats;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.LongColumnStats;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.STRING$;
import org.apache.spark.sql.columnar.StringColumnStats;
import org.apache.spark.sql.columnar.compression.CompressionScheme;
import org.apache.spark.sql.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.columnar.compression.DictionaryEncoding;
import org.apache.spark.sql.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.columnar.compression.DictionaryEncodingSuite$$anonfun$org$apache$spark$sql$columnar$compression$DictionaryEncodingSuite$;
import org.apache.spark.sql.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.types.AtomicType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001f\t9B)[2uS>t\u0017M]=F]\u000e|G-\u001b8h'VLG/\u001a\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\tG>dW/\u001c8be*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011\u0001C\u0005\u0003'!\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003Y!Xm\u001d;ES\u000e$\u0018n\u001c8bef,enY8eS:<WC\u0001\u000f1)\ri2%\u000b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0005+:LG\u000fC\u0003%3\u0001\u0007Q%A\u0006d_2,XN\\*uCR\u001c\bC\u0001\u0014(\u001b\u0005!\u0011B\u0001\u0015\u0005\u0005-\u0019u\u000e\\;n]N#\u0018\r^:\t\u000b)J\u0002\u0019A\u0016\u0002\u0015\r|G.^7o)f\u0004X\rE\u0002'Y9J!!\f\u0003\u0003!9\u000bG/\u001b<f\u0007>dW/\u001c8UsB,\u0007CA\u00181\u0019\u0001!Q!M\rC\u0002I\u0012\u0011\u0001V\t\u0003gY\u0002\"A\b\u001b\n\u0005Uz\"a\u0002(pi\"Lgn\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0019\tQ\u0001^=qKNL!a\u000f\u001d\u0003\u0015\u0005#x.\\5d)f\u0004X\r")
public class DictionaryEncodingSuite
extends SparkFunSuite {
    public <T extends AtomicType> void testDictionaryEncoding(ColumnStats columnStats, NativeColumnType<T> columnType) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$columnar$compression$DictionaryEncodingSuite$$skeleton$1(0, (Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": simple case"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$columnar$compression$DictionaryEncodingSuite$$skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0, 1})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": dictionary overflow"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$columnar$compression$DictionaryEncodingSuite$$skeleton$1(DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() + 1, (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), (int)DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        });
    }

    private final Map buildDictionary$1(ByteBuffer buffer, NativeColumnType columnType$1) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.getInt()).map((Function1)new Serializable(this, columnType$1, buffer){
            public static final long serialVersionUID = 0L;
            private final NativeColumnType columnType$1;
            private final ByteBuffer buffer$1;

            public final Tuple2<Object, Object> apply(int x$1) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(this.columnType$1.extract(this.buffer$1)), (Object)BoxesRunTime.boxToShort((short)((short)x$1)));
            }
            {
                this.columnType$1 = columnType$1;
                this.buffer$1 = buffer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    private final Seq stableDistinct$1(Seq seq) {
        Seq seq2;
        if (seq.isEmpty()) {
            seq2 = (Seq)Seq$.MODULE$.empty();
        } else {
            int n = BoxesRunTime.unboxToInt((Object)seq.head());
            seq2 = (Seq)((SeqLike)((TraversableLike)seq.tail()).filterNot((Function1)new Serializable(this, seq){
                public static final long serialVersionUID = 0L;
                private final Seq seq$1;

                public final boolean apply(int x$2) {
                    return this.apply$mcZI$sp(x$2);
                }

                public boolean apply$mcZI$sp(int x$2) {
                    return x$2 == BoxesRunTime.unboxToInt((Object)this.seq$1.head());
                }
                {
                    this.seq$1 = seq$1;
                }
            })).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
        }
        return seq2;
    }

    public final void org$apache$spark$sql$columnar$compression$DictionaryEncodingSuite$$skeleton$1(int uniqueValueCount, Seq inputSeq, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)DictionaryEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericMutableRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq values = (Seq)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)values, (Object)rows);
            Seq values2 = (Seq)tuple23._1();
            Seq rows2 = (Seq)tuple23._2();
            Seq dictValues = this.stableDistinct$1(inputSeq);
            inputSeq.foreach((Function1)new Serializable(this, builder, rows2){
                public static final long serialVersionUID = 0L;
                private final TestCompressibleColumnBuilder builder$1;
                private final Seq rows$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.builder$1.appendFrom((InternalRow)this.rows$1.apply(i), 0);
                }
                {
                    this.builder$1 = builder$1;
                    this.rows$1 = rows$1;
                }
            });
            if (dictValues.length() > DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                this.withClue("Dictionary overflowed, compression should fail", (Function0)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DictionaryEncodingSuite $outer;
                    public final TestCompressibleColumnBuilder builder$1;

                    public final Throwable apply() {
                        return (Throwable)this.$outer.intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$org$apache$spark$sql$columnar$compression$DictionaryEncodingSuite$$skeleton$1$5 $outer;

                            public final ByteBuffer apply() {
                                return this.$outer.builder$1.build();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Throwable.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.builder$1 = builder$1;
                    }
                });
            } else {
                ByteBuffer buffer = builder.build();
                int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
                int dictionarySize = 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)rows2.map((Function1)new Serializable(this, columnType$1){
                    public static final long serialVersionUID = 0L;
                    private final NativeColumnType columnType$1;

                    public final int apply(GenericMutableRow x$5) {
                        return this.columnType$1.actualSize((InternalRow)x$5, 0);
                    }
                    {
                        this.columnType$1 = columnType$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int compressedSize = 4 + dictionarySize + 2 * inputSeq.length();
                this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()));
                buffer.position(headerSize);
                this.assertResult(BoxesRunTime.boxToInteger((int)DictionaryEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
                Map dictionary = this.buildDictionary$1(buffer, columnType$1).toMap(Predef$.MODULE$.conforms());
                dictValues.foreach((Function1)new Serializable(this, values2, dictionary){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DictionaryEncodingSuite $outer;
                    private final Seq values$1;
                    private final Map dictionary$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.assertResult(BoxesRunTime.boxToInteger((int)i), "Wrong dictionary entry", this.dictionary$1.apply(this.values$1.apply(i)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.values$1 = values$1;
                        this.dictionary$1 = dictionary$1;
                    }
                });
                inputSeq.foreach((Function1)new Serializable(this, buffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DictionaryEncodingSuite $outer;
                    private final ByteBuffer buffer$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.assertResult(BoxesRunTime.boxToShort((short)((short)i)), "Wrong column element value", BoxesRunTime.boxToShort((short)this.buffer$2.getShort()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.buffer$2 = buffer$2;
                    }
                });
                buffer.rewind().position(headerSize + 4);
                DictionaryEncoding.Decoder decoder = DictionaryEncoding$.MODULE$.decoder(buffer, columnType$1);
                GenericMutableRow mutableRow = new GenericMutableRow(1);
                if (inputSeq.nonEmpty()) {
                    inputSeq.foreach((Function1)new Serializable(this, columnType$1, values2, decoder, mutableRow){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DictionaryEncodingSuite $outer;
                        private final NativeColumnType columnType$1;
                        private final Seq values$1;
                        private final DictionaryEncoding.Decoder decoder$1;
                        private final GenericMutableRow mutableRow$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.decoder$1.hasNext(), "decoder.hasNext");
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Object object = this.values$1.apply(i);
                            this.decoder$1.next((MutableRow)this.mutableRow$1, 0);
                            this.$outer.assertResult(object, "Wrong decoded value", this.columnType$1.getField((InternalRow)this.mutableRow$1, 0));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.columnType$1 = columnType$1;
                            this.values$1 = values$1;
                            this.decoder$1 = decoder$1;
                            this.mutableRow$1 = mutableRow$1;
                        }
                    });
                }
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext"));
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public DictionaryEncodingSuite() {
        this.testDictionaryEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$);
        this.testDictionaryEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$);
        this.testDictionaryEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$);
    }
}

