/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.columnar.BOOLEAN$;
import org.apache.spark.sql.columnar.BYTE$;
import org.apache.spark.sql.columnar.BooleanColumnStats;
import org.apache.spark.sql.columnar.ByteColumnStats;
import org.apache.spark.sql.columnar.ColumnStats;
import org.apache.spark.sql.columnar.ColumnStatsSuite$;
import org.apache.spark.sql.columnar.ColumnType;
import org.apache.spark.sql.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.columnar.DATE$;
import org.apache.spark.sql.columnar.DOUBLE$;
import org.apache.spark.sql.columnar.DateColumnStats;
import org.apache.spark.sql.columnar.DoubleColumnStats;
import org.apache.spark.sql.columnar.FIXED_DECIMAL;
import org.apache.spark.sql.columnar.FLOAT$;
import org.apache.spark.sql.columnar.FixedDecimalColumnStats;
import org.apache.spark.sql.columnar.FloatColumnStats;
import org.apache.spark.sql.columnar.INT$;
import org.apache.spark.sql.columnar.IntColumnStats;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.LongColumnStats;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.SHORT$;
import org.apache.spark.sql.columnar.STRING$;
import org.apache.spark.sql.columnar.ShortColumnStats;
import org.apache.spark.sql.columnar.StringColumnStats;
import org.apache.spark.sql.columnar.TIMESTAMP$;
import org.apache.spark.sql.columnar.TimestampColumnStats;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\t\u00012i\u001c7v[:\u001cF/\u0019;t'VLG/\u001a\u0006\u0003\u0007\u0011\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$A\u0005de\u0016\fG/\u001a*poR\u0011!D\t\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004B\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011\u0005\b\u0002\u0013\u000f\u0016tWM]5d\u0013:$XM\u001d8bYJ{w\u000fC\u0003$/\u0001\u0007A%\u0001\u0004wC2,Xm\u001d\t\u0004K!RS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002&W%\u0011AF\n\u0002\u0004\u0003:L\b\"\u0002\u0018\u0001\t\u0003y\u0013a\u0004;fgR\u001cu\u000e\\;n]N#\u0018\r^:\u0016\u0007Aru\b\u0006\u00032i!;\u0006CA\u00133\u0013\t\u0019dE\u0001\u0003V]&$\b\"B\u001b.\u0001\u00041\u0014\u0001E2pYVlgn\u0015;biN\u001cE.Y:t!\r9$(\u0010\b\u0003KaJ!!\u000f\u0014\u0002\rA\u0013X\rZ3g\u0013\tYDHA\u0003DY\u0006\u001c8O\u0003\u0002:MA\u0011ah\u0010\u0007\u0001\t\u0015\u0001UF1\u0001B\u0005\u0005)\u0016C\u0001\"F!\t)3)\u0003\u0002EM\t9aj\u001c;iS:<\u0007C\u0001\fG\u0013\t9%AA\u0006D_2,XN\\*uCR\u001c\b\"B%.\u0001\u0004Q\u0015AC2pYVlg\u000eV=qKB\u0019acS'\n\u00051\u0013!\u0001\u0005(bi&4XmQ8mk6tG+\u001f9f!\tqd\nB\u0003P[\t\u0007\u0001KA\u0001U#\t\u0011\u0015\u000b\u0005\u0002S+6\t1K\u0003\u0002U\t\u0005)A/\u001f9fg&\u0011ak\u0015\u0002\u000b\u0003R|W.[2UsB,\u0007\"\u0002-.\u0001\u0004Q\u0012!E5oSRL\u0017\r\\*uCRL7\u000f^5dg\")!\f\u0001C\u00017\u00061B/Z:u\t\u0016\u001c\u0017.\\1m\u0007>dW/\u001c8Ti\u0006$8/F\u0002]=~#\"!M/\t\u000baK\u0006\u0019\u0001\u000e\u0005\u000b=K&\u0019\u0001)\u0005\u000b\u0001K&\u0019A!")
public class ColumnStatsSuite
extends SparkFunSuite {
    public GenericInternalRow createRow(Seq<Object> values) {
        return new GenericInternalRow((Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    public <T extends AtomicType, U extends ColumnStats> void testColumnStats(Class<U> columnStatsClass, NativeColumnType<T> columnType, GenericInternalRow initialStatistics) {
        String columnStatsName = columnStatsClass.getSimpleName();
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnStatsName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStatsClass, initialStatistics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnStatsSuite $outer;
            private final Class columnStatsClass$1;
            private final GenericInternalRow initialStatistics$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ColumnStats columnStats = (ColumnStats)this.columnStatsClass$1.newInstance();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics().values()).zip((GenIterable)Predef$.MODULE$.genericWrapArray((Object)this.initialStatistics$1.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnStats$1 $outer;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object actual = tuple2._1();
                            Object expected2 = tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$columnar$ColumnStatsSuite$$anonfun$$$outer().convertToEqualizer(actual);
                            Object $org_scalatest_assert_macro_right = expected2;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$sql$columnar$ColumnStatsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnStatsSuite org$apache$spark$sql$columnar$ColumnStatsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStatsClass$1 = columnStatsClass$1;
                this.initialStatistics$1 = initialStatistics$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": non-empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnStatsName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStatsClass, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnStatsSuite $outer;
            private final Class columnStatsClass$1;
            public final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ColumnStats columnStats = (ColumnStats)this.columnStatsClass$1.newInstance();
                Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnStats$2 $outer;

                    public final InternalRow apply() {
                        return ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.$outer.columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GenericMutableRow apply() {
                        return ColumnarTestUtils$.MODULE$.makeNullRow(1);
                    }
                }), Seq$.MODULE$.canBuildFrom());
                rows.foreach((Function1)new Serializable(this, columnStats){
                    public static final long serialVersionUID = 0L;
                    private final ColumnStats columnStats$1;

                    public final void apply(InternalRow x$1) {
                        this.columnStats$1.gatherStats(x$1, 0);
                    }
                    {
                        this.columnStats$1 = columnStats$1;
                    }
                });
                Seq values = (Seq)((TraversableLike)rows.take(10)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnStats$2 $outer;

                    public final Object apply(InternalRow x$2) {
                        return x$2.get(0, (DataType)this.$outer.columnType$1.dataType());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Ordering ordering = this.columnType$1.dataType().ordering();
                GenericInternalRow stats = columnStats.collectedStatistics();
                this.$outer.assertResult(values.min(ordering), "Wrong lower bound", stats.values()[0]);
                this.$outer.assertResult(values.max(ordering), "Wrong upper bound", stats.values()[1]);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats.values()[2]);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats.values()[3]);
                this.$outer.assertResult(stats.values()[4], "Wrong size in bytes", ((TraversableOnce)rows.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnStats$2 $outer;

                    public final int apply(InternalRow row) {
                        return row.isNullAt(0) ? 4 : this.$outer.columnType$1.actualSize(row, 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStatsClass$1 = columnStatsClass$1;
                this.columnType$1 = columnType$1;
            }
        });
    }

    public <T extends AtomicType, U extends ColumnStats> void testDecimalColumnStats(GenericInternalRow initialStatistics) {
        String columnStatsName = FixedDecimalColumnStats.class.getSimpleName();
        FIXED_DECIMAL columnType = new FIXED_DECIMAL(15, 10);
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnStatsName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, initialStatistics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnStatsSuite $outer;
            private final GenericInternalRow initialStatistics$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                FixedDecimalColumnStats columnStats = new FixedDecimalColumnStats(15, 10);
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics().values()).zip((GenIterable)Predef$.MODULE$.genericWrapArray((Object)this.initialStatistics$2.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDecimalColumnStats$1 $outer;

                    public final void apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object actual = tuple2._1();
                            Object expected2 = tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$columnar$ColumnStatsSuite$$anonfun$$$outer().convertToEqualizer(actual);
                            Object $org_scalatest_assert_macro_right = expected2;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$sql$columnar$ColumnStatsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnStatsSuite org$apache$spark$sql$columnar$ColumnStatsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.initialStatistics$2 = initialStatistics$2;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": non-empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnStatsName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnStatsSuite $outer;
            public final FIXED_DECIMAL columnType$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                FixedDecimalColumnStats columnStats = new FixedDecimalColumnStats(15, 10);
                Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDecimalColumnStats$2 $outer;

                    public final InternalRow apply() {
                        return ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.$outer.columnType$2, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GenericMutableRow apply() {
                        return ColumnarTestUtils$.MODULE$.makeNullRow(1);
                    }
                }), Seq$.MODULE$.canBuildFrom());
                rows.foreach((Function1)new Serializable(this, columnStats){
                    public static final long serialVersionUID = 0L;
                    private final FixedDecimalColumnStats columnStats$2;

                    public final void apply(InternalRow x$3) {
                        this.columnStats$2.gatherStats(x$3, 0);
                    }
                    {
                        this.columnStats$2 = columnStats$2;
                    }
                });
                Seq values = (Seq)((TraversableLike)rows.take(10)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDecimalColumnStats$2 $outer;

                    public final Object apply(InternalRow x$4) {
                        return x$4.get(0, (DataType)this.$outer.columnType$2.dataType());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Decimal.DecimalIsFractional$ ordering = ((DecimalType)this.columnType$2.dataType()).ordering();
                GenericInternalRow stats = columnStats.collectedStatistics();
                this.$outer.assertResult(values.min((Ordering)ordering), "Wrong lower bound", stats.values()[0]);
                this.$outer.assertResult(values.max((Ordering)ordering), "Wrong upper bound", stats.values()[1]);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats.values()[2]);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats.values()[3]);
                this.$outer.assertResult(stats.values()[4], "Wrong size in bytes", ((TraversableOnce)rows.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDecimalColumnStats$2 $outer;

                    public final int apply(InternalRow row) {
                        return row.isNullAt(0) ? 4 : this.$outer.columnType$2.actualSize(row, 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$2 = columnType$2;
            }
        });
    }

    public ColumnStatsSuite() {
        this.testColumnStats((Class)BooleanColumnStats.class, (NativeColumnType)BOOLEAN$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)ByteColumnStats.class, (NativeColumnType)BYTE$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)ShortColumnStats.class, (NativeColumnType)SHORT$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)IntColumnStats.class, (NativeColumnType)INT$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)DateColumnStats.class, (NativeColumnType)DATE$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)LongColumnStats.class, (NativeColumnType)LONG$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)TimestampColumnStats.class, (NativeColumnType)TIMESTAMP$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)FloatColumnStats.class, (NativeColumnType)FLOAT$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), BoxesRunTime.boxToFloat((float)Float$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)DoubleColumnStats.class, (NativeColumnType)DOUBLE$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)0)})));
        Object[] objectArray = new Object[3];
        objectArray[0] = null;
        objectArray[1] = null;
        objectArray[2] = BoxesRunTime.boxToInteger((int)0);
        this.testColumnStats((Class)StringColumnStats.class, (NativeColumnType)STRING$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = null;
        objectArray2[1] = null;
        objectArray2[2] = BoxesRunTime.boxToInteger((int)0);
        this.testDecimalColumnStats(this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray2)));
    }
}

