/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.columnar.InMemoryRelation;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001-\u0011\u0011\"U;fef$Vm\u001d;\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0015\u0001H.\u00198t\u0015\t\t\"!\u0001\u0005dCR\fG._:u\u0013\t\u0019bB\u0001\u0005QY\u0006tG+Z:u\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0003\u001b\u0001\u0011\u00051$\u0001\bdQ\u0016\u001c7.\u0012=jgR,gnY3\u0015\tq\u0011s\u0005\f\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0005+:LG\u000fC\u0003$3\u0001\u0007A%\u0001\u0002eMB\u0011\u0001$J\u0005\u0003M\t\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u000b!J\u0002\u0019A\u0015\u0002\r\u0015D\u0018n\u001d;t!\ti\"&\u0003\u0002,=\t9!i\\8mK\u0006t\u0007\"B\u0017\u001a\u0001\u0004q\u0013\u0001C6fs^|'\u000fZ:\u0011\u0007uy\u0013'\u0003\u00021=\tQAH]3qK\u0006$X\r\u001a \u0011\u0005I*dBA\u000f4\u0013\t!d$\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b\u001f\u0011\u0015I\u0004\u0001\"\u0005;\u0003-\u0019\u0007.Z2l\u0003:\u001cx/\u001a:\u0015\u0007qYD\bC\u0003$q\u0001\u0007A\u0005C\u0003>q\u0001\u0007a(\u0001\bfqB,7\r^3e\u0003:\u001cx/\u001a:\u0011\u0007}:%J\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111IC\u0001\u0007yI|w\u000e\u001e \n\u0003}I!A\u0012\u0010\u0002\u000fA\f7m[1hK&\u0011\u0001*\u0013\u0002\u0004'\u0016\f(B\u0001$\u001f!\tA2*\u0003\u0002M\u0005\t\u0019!k\\<\t\u000be\u0002A\u0011\u0003(\u0015\u0007qy\u0005\u000bC\u0003$\u001b\u0002\u0007A\u0005C\u0003>\u001b\u0002\u0007!\nC\u0003:\u0001\u0011E!\u000bF\u0002\u001d'RCQaI)A\u0002\u0011BQ!P)A\u0002\u0011BQA\u0016\u0001\u0005\u0002]\u000bA\"Y:tKJ$8)Y2iK\u0012$2\u0001\b-[\u0011\u0015IV\u000b1\u0001%\u0003\u0015\tX/\u001a:z\u0011\u001dYV\u000b%AA\u0002q\u000bqB\\;n\u0007\u0006\u001c\u0007.\u001a3UC\ndWm\u001d\t\u0003;uK!A\u0018\u0010\u0003\u0007%sG\u000fC\u0004a\u0001E\u0005I\u0011A1\u0002-\u0005\u001c8/\u001a:u\u0007\u0006\u001c\u0007.\u001a3%I\u00164\u0017-\u001e7uII*\u0012A\u0019\u0016\u00039\u000e\\\u0013\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005%t\u0012AC1o]>$\u0018\r^5p]&\u00111N\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,w!B7\u0003\u0011\u0003q\u0017!C)vKJLH+Z:u!\tArNB\u0003\u0002\u0005!\u0005\u0001oE\u0002pcR\u0004\"!\b:\n\u0005Mt\"AB!osJ+g\r\u0005\u0002\u001ek&\u0011aO\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006+=$\t\u0001\u001f\u000b\u0002]\")\u0011h\u001cC\u0001uR\u00191P`@\u0011\u0007ua\u0018'\u0003\u0002~=\t1q\n\u001d;j_:DQaI=A\u0002\u0011BQ!P=A\u0002yBa!O8\u0005\u0002\u0005\rA#B\u0019\u0002\u0006\u0005\u001d\u0001BB\u0012\u0002\u0002\u0001\u0007A\u0005C\u0004>\u0003\u0003\u0001\r!!\u0003\u0011\u000b\u0005-\u0011Q\u0003&\u000e\u0005\u00055!\u0002BA\b\u0003#\tA!\u001e;jY*\u0011\u00111C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u00055!\u0001\u0002'jgRD\u0011\"a\u0007p\u0003\u0003%I!!\b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0005\u0003K\t\t\"\u0001\u0003mC:<\u0017\u0002BA\u0015\u0003G\u0011aa\u00142kK\u000e$\b")
public class QueryTest
extends PlanTest {
    public void checkExistence(DataFrame df2, boolean exists, Seq<String> keywords) {
        String outputs = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df2.collect()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$1) {
                return x$1.mkString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString();
        keywords.foreach((Function1)new Serializable(this, df2, exists, outputs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryTest $outer;
            private final DataFrame df$1;
            private final boolean exists$1;
            private final String outputs$1;

            public final void apply(String key) {
                if (this.exists$1) {
                    String $org_scalatest_assert_macro_left = this.outputs$1;
                    String $org_scalatest_assert_macro_right = key;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed for ", " (", " doesn't exist in result)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.df$1, key})));
                } else {
                    String $org_scalatest_assert_macro_left = this.outputs$1;
                    String $org_scalatest_assert_macro_right = key;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed for ", " (", " existed in the result)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.df$1, key})));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.df$1 = df$1;
                this.exists$1 = exists$1;
                this.outputs$1 = outputs$1;
            }
        });
    }

    public void checkAnswer(DataFrame df2, Seq<Row> expectedAnswer) {
        Option<String> option = QueryTest$.MODULE$.checkAnswer(df2, expectedAnswer);
        if (option instanceof Some) {
            Some some = (Some)option;
            String errorMessage = (String)some.x();
            throw this.fail(errorMessage);
        }
        None$ none$ = None$.MODULE$;
        Option<String> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError(option);
    }

    public void checkAnswer(DataFrame df2, Row expectedAnswer) {
        this.checkAnswer(df2, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{expectedAnswer}))));
    }

    public void checkAnswer(DataFrame df2, DataFrame expectedAnswer) {
        this.checkAnswer(df2, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()));
    }

    public void assertCached(DataFrame query, int numCachedTables) {
        Seq cachedData;
        LogicalPlan planWithCaching = query.queryExecution().withCachedData();
        Seq $org_scalatest_assert_macro_left = cachedData = planWithCaching.collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InMemoryRelation) {
                    InMemoryRelation inMemoryRelation = (InMemoryRelation)A1;
                    object = inMemoryRelation;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof InMemoryRelation;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right = numCachedTables;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (long)$org_scalatest_assert_macro_left.size(), (long)$org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected query to contain ", ", but it actually had ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numCachedTables), BoxesRunTime.boxToInteger((int)cachedData.size())}))).append((Object)planWithCaching).toString());
    }

    public int assertCached$default$2() {
        return 1;
    }

    public QueryTest() {
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        Locale.setDefault(Locale.US);
    }
}

