/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.kafka010.AssignStrategy;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.KafkaTestUtils;
import org.apache.spark.sql.kafka010.KafkaTestUtils$;
import org.apache.spark.sql.kafka010.SubscribePatternStrategy;
import org.apache.spark.sql.kafka010.SubscribeStrategy;
import org.apache.spark.util.ResetSystemProperties;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Array$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0007\u000f\u0001eAQ\u0001\n\u0001\u0005\u0002\u0015B\u0011\u0002\u000b\u0001A\u0002\u0003\u0007I\u0011B\u0015\t\u00135\u0002\u0001\u0019!a\u0001\n\u0013q\u0003\"C\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003+\u0011\u0015A\u0004\u0001\"\u0003:\u0011\u00159\u0005\u0001\"\u0005I\u0011\u001di\u0006!%A\u0005\u0012yCQ!\u001b\u0001\u0005\n)DQ!\u001f\u0001\u0005\niDq!a\u0002\u0001\t\u0013\tI\u0001C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005-\u0002\u0001\"\u0011\u0002*\t)2i\u001c8tk6,'o\u0015;sCR,w-_*vSR,'BA\b\u0011\u0003!Y\u0017MZ6baE\u0002$BA\t\u0013\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001b=A\u00111\u0004H\u0007\u0002%%\u0011QD\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0012\u0001B;uS2L!a\t\u0011\u0003+I+7/\u001a;TsN$X-\u001c)s_B,'\u000f^5fg\u00061A(\u001b8jiz\"\u0012A\n\t\u0003O\u0001i\u0011AD\u0001\ni\u0016\u001cH/\u0016;jYN,\u0012A\u000b\t\u0003O-J!\u0001\f\b\u0003\u001d-\u000bgm[1UKN$X\u000b^5mg\u0006iA/Z:u+RLGn]0%KF$\"aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bm\r\t\t\u00111\u0001+\u0003\rAH%M\u0001\u000bi\u0016\u001cH/\u0016;jYN\u0004\u0013\u0001\u00033p%\u0016$XO\u001d8\u0015\u0005i\u0012\u0005CA\u001eA\u001b\u0005a$BA\u001f?\u0003!\u0019H/\u001e2cS:<'BA \u0017\u0003\u001diwnY6ji>L!!\u0011\u001f\u0003\u000fM#XO\u00192fe\")1)\u0002a\u0001\t\u0006)a/\u00197vKB\u0011\u0001'R\u0005\u0003\rF\u00121!\u00118z\u0003!qWm\u001e+pa&\u001cGCA%R!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!.\u0013aa\u0015;sS:<\u0007b\u0002*\u0007!\u0003\u0005\raU\u0001\u0007aJ,g-\u001b=\u0011\u0005Q[fBA+Z!\t1\u0016'D\u0001X\u0015\tA\u0006$\u0001\u0004=e>|GOP\u0005\u00035F\na\u0001\u0015:fI\u00164\u0017B\u0001)]\u0015\tQ\u0016'\u0001\noK^$v\u000e]5dI\u0011,g-Y;mi\u0012\nT#A0+\u0005M\u00037&A1\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017!C;oG\",7m[3e\u0015\t1\u0017'\u0001\u0006b]:|G/\u0019;j_:L!\u0001[2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006tKR\u001c\u0006/\u0019:l\u000b:4HCA\u0018l\u0011\u0015a\u0007\u00021\u0001n\u0003!\u0019X\r\u001e;j]\u001e\u001c\bc\u00018tm:\u0011q.\u001d\b\u0003-BL\u0011AM\u0005\u0003eF\nq\u0001]1dW\u0006<W-\u0003\u0002uk\nA\u0011\n^3sC\ndWM\u0003\u0002scA!\u0001g^*T\u0013\tA\u0018G\u0001\u0004UkBdWMM\u0001\u000bC\u0012l\u0017N\u001c)s_B\u001cX#A>\u0011\u000bqt8+!\u0001\u000e\u0003uT!!I'\n\u0005}l(aA'baB\u0019!*a\u0001\n\u0007\u0005\u00151J\u0001\u0004PE*,7\r^\u0001\u0006C\u0012l\u0017N\u001c\u000b\u0005\u0003\u0017\ti\u0002\u0005\u0003\u0002\u000e\u0005eQBAA\b\u0015\u0011\t9!!\u0005\u000b\t\u0005M\u0011QC\u0001\bG2LWM\u001c;t\u0015\r\t9\u0002F\u0001\u0006W\u000647.Y\u0005\u0005\u00037\tyAA\u0003BI6Lg\u000eC\u0004\u0002 )\u0001\r!!\t\u0002\u0011M$(/\u0019;fOf\u00042aJA\u0012\u0013\r\t)C\u0004\u0002\u0011\u0007>t7/^7feN#(/\u0019;fOf\f\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003=\n\u0001\"\u00194uKJ\fE\u000e\u001c")
public class ConsumerStrategySuite
extends SparkFunSuite
implements ResetSystemProperties {
    private KafkaTestUtils testUtils;
    private Properties oldProperties;

    public /* synthetic */ void org$apache$spark$util$ResetSystemProperties$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$util$ResetSystemProperties$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void beforeEach() {
        ResetSystemProperties.beforeEach$((ResetSystemProperties)this);
    }

    public void afterEach() {
        ResetSystemProperties.afterEach$((ResetSystemProperties)this);
    }

    public Properties oldProperties() {
        return this.oldProperties;
    }

    public void oldProperties_$eq(Properties x$1) {
        this.oldProperties = x$1;
    }

    private KafkaTestUtils testUtils() {
        return this.testUtils;
    }

    private void testUtils_$eq(KafkaTestUtils x$1) {
        this.testUtils = x$1;
    }

    private Stubber doReturn(Object value) {
        return Mockito.doReturn((Object)value, (Object[])ScalaRunTime$.MODULE$.toObjectArray(package$.MODULE$.Seq().empty().toArray(ClassTag$.MODULE$.Any())));
    }

    public String newTopic(String prefix) {
        return prefix + "-" + UUID.randomUUID().toString();
    }

    public String newTopic$default$1() {
        return "topic";
    }

    private void setSparkEnv(Iterable<Tuple2<String, String>> settings) {
        SparkConf conf = new SparkConf().setAll(settings);
        SparkEnv env = (SparkEnv)Mockito.mock(SparkEnv.class);
        ((SparkEnv)this.doReturn(conf).when((Object)env)).conf();
        SparkEnv$.MODULE$.set(env);
    }

    private java.util.Map<String, Object> adminProps() {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.testUtils().brokerAddress())}))).asJava();
    }

    private Admin admin(ConsumerStrategy strategy) {
        return strategy.createAdmin(this.adminProps());
    }

    public void beforeAll() {
        super.beforeAll();
        this.testUtils_$eq(new KafkaTestUtils((scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty(), KafkaTestUtils$.MODULE$.$lessinit$greater$default$2()));
        this.testUtils().setup();
        this.setSparkEnv((Iterable<Tuple2<String, String>>)Predef$.MODULE$.Map().empty());
    }

    public void afterAll() {
        if (this.testUtils() != null) {
            this.testUtils().teardown();
            this.testUtils_$eq(null);
        }
        super.afterAll();
    }

    public ConsumerStrategySuite() {
        ResetSystemProperties.$init$((ResetSystemProperties)this);
        this.test("createAdmin must create admin properly", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            AssignStrategy strategy = new AssignStrategy((TopicPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(TopicPartition.class)));
            Admin $org_scalatest_assert_macro_left = strategy.createAdmin(this.adminProps());
            Object $org_scalatest_assert_macro_right = null;
            Admin admin = $org_scalatest_assert_macro_left;
            Object var5_4 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, admin == null ? var5_4 != null : !admin.equals(var5_4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("AssignStrategy.assignedTopicPartitions must give back all assigned", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String assignedTopic = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$1 = this.testUtils();
            String x$1 = assignedTopic;
            int x$2 = 3;
            boolean x$3 = qual$1.createTopic$default$3();
            qual$1.createTopic(x$1, 3, x$3);
            String otherExistingTopic = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$2 = this.testUtils();
            String x$4 = otherExistingTopic;
            int x$5 = 2;
            boolean x$6 = qual$2.createTopic$default$3();
            qual$2.createTopic(x$4, 2, x$6);
            TopicPartition[] partitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition(assignedTopic, 0), new TopicPartition(assignedTopic, 2)});
            AssignStrategy strategy = new AssignStrategy(partitions);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(strategy.assignedTopicPartitions(this.admin((ConsumerStrategy)strategy)));
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.wrapRefArray((Object[])partitions).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            this.testUtils().deleteTopic(assignedTopic);
            this.testUtils().deleteTopic(otherExistingTopic);
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("AssignStrategy.assignedTopicPartitions must skip invalid partitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String assignedTopic = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$3 = this.testUtils();
            String x$7 = assignedTopic;
            boolean x$8 = true;
            boolean x$9 = qual$3.createTopic$default$3();
            qual$3.createTopic(x$7, 1, x$9);
            TopicPartition[] partitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition(assignedTopic, 1)});
            AssignStrategy strategy = new AssignStrategy(partitions);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(strategy.assignedTopicPartitions(this.admin((ConsumerStrategy)strategy)));
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            this.testUtils().deleteTopic(assignedTopic);
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("SubscribeStrategy.assignedTopicPartitions must give back all assigned", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String subscribedTopic1 = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$4 = this.testUtils();
            String x$10 = subscribedTopic1;
            int x$11 = 2;
            boolean x$12 = qual$4.createTopic$default$3();
            qual$4.createTopic(x$10, 2, x$12);
            String subscribedTopic2 = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$5 = this.testUtils();
            String x$13 = subscribedTopic2;
            int x$14 = 2;
            boolean x$15 = qual$5.createTopic$default$3();
            qual$5.createTopic(x$13, 2, x$15);
            String otherExistingTopic = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$6 = this.testUtils();
            String x$16 = otherExistingTopic;
            int x$17 = 2;
            boolean x$18 = qual$6.createTopic$default$3();
            qual$6.createTopic(x$16, 2, x$18);
            Set partitions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(subscribedTopic1, 0), new TopicPartition(subscribedTopic1, 1), new TopicPartition(subscribedTopic2, 0), new TopicPartition(subscribedTopic2, 1)}));
            SubscribeStrategy strategy = new SubscribeStrategy((Seq)new .colon.colon((Object)subscribedTopic1, (List)new .colon.colon((Object)subscribedTopic2, (List)Nil$.MODULE$)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(strategy.assignedTopicPartitions(this.admin((ConsumerStrategy)strategy)));
            Set $org_scalatest_assert_macro_right = partitions;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            this.testUtils().deleteTopic(subscribedTopic1);
            this.testUtils().deleteTopic(subscribedTopic2);
            this.testUtils().deleteTopic(otherExistingTopic);
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("SubscribePatternStrategy.assignedTopicPartitions must give back all assigned", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String subscribePattern = "subscribePattern";
            String subscribedTopic1 = this.newTopic(subscribePattern);
            KafkaTestUtils qual$7 = this.testUtils();
            String x$19 = subscribedTopic1;
            int x$20 = 2;
            boolean x$21 = qual$7.createTopic$default$3();
            qual$7.createTopic(x$19, 2, x$21);
            String subscribedTopic2 = this.newTopic(subscribePattern);
            KafkaTestUtils qual$8 = this.testUtils();
            String x$22 = subscribedTopic2;
            int x$23 = 2;
            boolean x$24 = qual$8.createTopic$default$3();
            qual$8.createTopic(x$22, 2, x$24);
            String otherExistingTopic = this.newTopic("other");
            KafkaTestUtils qual$9 = this.testUtils();
            String x$25 = otherExistingTopic;
            int x$26 = 2;
            boolean x$27 = qual$9.createTopic$default$3();
            qual$9.createTopic(x$25, 2, x$27);
            Set partitions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(subscribedTopic1, 0), new TopicPartition(subscribedTopic1, 1), new TopicPartition(subscribedTopic2, 0), new TopicPartition(subscribedTopic2, 1)}));
            SubscribePatternStrategy strategy = new SubscribePatternStrategy(subscribePattern + ".*");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(strategy.assignedTopicPartitions(this.admin((ConsumerStrategy)strategy)));
            Set $org_scalatest_assert_macro_right = partitions;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            this.testUtils().deleteTopic(subscribedTopic1);
            this.testUtils().deleteTopic(subscribedTopic2);
            this.testUtils().deleteTopic(otherExistingTopic);
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
    }
}

