/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRange$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005A3A!\u0003\u0006\u0001+!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB&\u0001A\u0003%1\tC\u0004M\u0001\t\u0007I\u0011\u0002\"\t\r5\u0003\u0001\u0015!\u0003D\u0011\u001dq\u0005A1A\u0005\n\tCaa\u0014\u0001!\u0002\u0013\u0019%aH&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0007\u0006d7-\u001e7bi>\u00148+^5uK*\u00111\u0002D\u0001\tW\u000647.\u0019\u00192a)\u0011QBD\u0001\u0004gFd'BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011AD\u0005\u000339\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u000b\u0003U!Xm\u001d;XSRDW*\u001b8QCJ$\u0018\u000e^5p]N$2\u0001I\u0018=)\t\ts\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0003V]&$\b\"\u0002\u0015\u0003\u0001\u0004I\u0013!\u00014\u0011\t\tRC&I\u0005\u0003W\r\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005ui\u0013B\u0001\u0018\u000b\u0005iY\u0015MZ6b\u001f\u001a47/\u001a;SC:<WmQ1mGVd\u0017\r^8s\u0011\u0015\u0001$\u00011\u00012\u0003\u0011q\u0017-\\3\u0011\u0005IJdBA\u001a8!\t!4%D\u00016\u0015\t1D#\u0001\u0004=e>|GOP\u0005\u0003q\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001h\t\u0005\u0006{\t\u0001\rAP\u0001\r[&t\u0007+\u0019:uSRLwN\u001c\t\u0003E}J!\u0001Q\u0012\u0003\u0007%sG/A\u0002uaF*\u0012a\u0011\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000baaY8n[>t'B\u0001%\u0011\u0003\u0015Y\u0017MZ6b\u0013\tQUI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\u0018\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\n1\u0001\u001e94\u0003\u0011!\bo\r\u0011")
public class KafkaOffsetRangeCalculatorSuite
extends SparkFunSuite {
    private final TopicPartition tp1;
    private final TopicPartition tp2;
    private final TopicPartition tp3;

    public void testWithMinPartitions(String name, int minPartition, Function1<KafkaOffsetRangeCalculator, BoxedUnit> f) {
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minPartitions"), (Object)Integer.toString(minPartition))}))).asJava());
        this.test(new StringBuilder(22).append("with minPartition = ").append(minPartition).append(": ").append(name).toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)KafkaOffsetRangeCalculator$.MODULE$.apply(options)), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
    }

    private TopicPartition tp1() {
        return this.tp1;
    }

    private TopicPartition tp2() {
        return this.tp2;
    }

    private TopicPartition tp3() {
        return this.tp3;
    }

    public static final /* synthetic */ void $anonfun$new$3(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp3(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 2L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 1L, 2L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 1L, 2L, (Option)None$.MODULE$)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
    }

    public static final /* synthetic */ void $anonfun$new$4(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp3(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4())})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exec1", "exec2", "exec3"}))));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 2L, (Option)new Some((Object)"exec3")), new KafkaOffsetRange($this.tp2(), 1L, 2L, (Option)new Some((Object)"exec1")), new KafkaOffsetRange($this.tp3(), 1L, 2L, (Option)new Some((Object)"exec2"))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
    }

    public static final /* synthetic */ void $anonfun$new$5(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        Seq $org_scalatest_assert_macro_left = calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 5L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2());
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 2L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 2L, 3L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 3L, 4L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 4L, 5L, (Option)None$.MODULE$)}));
        Seq seq = $org_scalatest_assert_macro_left;
        Seq seq2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        Seq $org_scalatest_assert_macro_left2 = calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 5L, KafkaOffsetRange$.MODULE$.apply$default$4())})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"location"})));
        Seq $org_scalatest_assert_macro_right2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 2L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 2L, 3L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 3L, 4L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 4L, 5L, (Option)None$.MODULE$)}));
        Seq seq3 = $org_scalatest_assert_macro_left2;
        Seq seq4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
    }

    public static final /* synthetic */ void $anonfun$new$6(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 5L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 1L, 21L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 5L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 1L, 7L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 7L, 14L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 14L, 21L, (Option)None$.MODULE$)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }

    public static final /* synthetic */ void $anonfun$new$7(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 1L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 1L, 21L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp2(), 1L, 6L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 6L, 11L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 11L, 16L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 16L, 21L, (Option)None$.MODULE$)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }

    public static final /* synthetic */ void $anonfun$new$8(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 1L, 1001L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 2L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 1L, 334L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 334L, 667L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 667L, 1001L, (Option)None$.MODULE$)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
    }

    public static final /* synthetic */ void $anonfun$new$9(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 5L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 1L, 21L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 5L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 1L, 21L, (Option)None$.MODULE$)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }

    public static final /* synthetic */ void $anonfun$new$10(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        Seq $org_scalatest_assert_macro_left = calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 11L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2());
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 4L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 4L, 7L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 7L, 11L, (Option)None$.MODULE$)}));
        Seq seq = $org_scalatest_assert_macro_left;
        Seq seq2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
    }

    public static final /* synthetic */ void $anonfun$new$11(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        Seq $org_scalatest_assert_macro_left = calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 5L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 1L, 21L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp3(), 1L, 1L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2());
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 1L, 5L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 1L, 7L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 7L, 14L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 14L, 21L, (Option)None$.MODULE$)}));
        Seq seq = $org_scalatest_assert_macro_left;
        Seq seq2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
    }

    public static final /* synthetic */ void $anonfun$new$12(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        Seq $org_scalatest_assert_macro_left = calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 0L, 10L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 0L, 10L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp3(), 0L, 1L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2());
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 0L, 3L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 3L, 6L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 6L, 10L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 0L, 3L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 3L, 6L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 6L, 10L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 0L, 1L, (Option)None$.MODULE$)}));
        Seq seq = $org_scalatest_assert_macro_left;
        Seq seq2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
    }

    public static final /* synthetic */ void $anonfun$new$13(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 0L, 10000L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 0L, 15000L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp3(), 0L, 20000L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 0L, 5000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp1(), 5000L, 10000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 0L, 5000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 5000L, 10000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 10000L, 15000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 0L, 5000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 5000L, 10000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 10000L, 15000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 15000L, 20000L, (Option)None$.MODULE$)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }

    public static final /* synthetic */ void $anonfun$new$14(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 0L, 500L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 0L, 12000L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp3(), 0L, 15001L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 0L, 500L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 0L, 6000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 6000L, 12000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 0L, 5000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 5000L, 10000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 10000L, 15001L, (Option)None$.MODULE$)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
    }

    public static final /* synthetic */ void $anonfun$new$15(KafkaOffsetRangeCalculatorSuite $this, KafkaOffsetRangeCalculator calc) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 0L, 1L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp2(), 0L, 1L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange($this.tp3(), 0L, 10000L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
        Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange($this.tp1(), 0L, 1L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp2(), 0L, 1L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 0L, 2500L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 2500L, 5000L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 5000L, 7500L, (Option)None$.MODULE$), new KafkaOffsetRange($this.tp3(), 7500L, 10000L, (Option)None$.MODULE$)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
    }

    public KafkaOffsetRangeCalculatorSuite() {
        this.test("with no minPartition: N TopicPartitions to N offset ranges", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KafkaOffsetRangeCalculator calc = KafkaOffsetRangeCalculator$.MODULE$.apply(CaseInsensitiveStringMap.empty());
            Seq $org_scalatest_assert_macro_left = calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange(this.tp1(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2());
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange(this.tp1(), 1L, 2L, (Option)None$.MODULE$)}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            Seq $org_scalatest_assert_macro_left2 = calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange(this.tp1(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4())})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"location"})));
            Seq $org_scalatest_assert_macro_right2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange(this.tp1(), 1L, 2L, (Option)new Some((Object)"location"))}));
            Seq seq3 = $org_scalatest_assert_macro_left2;
            Seq seq4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        }, new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("with no minPartition: empty ranges ignored", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KafkaOffsetRangeCalculator calc = KafkaOffsetRangeCalculator$.MODULE$.apply(CaseInsensitiveStringMap.empty());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(calc.getRanges((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange(this.tp1(), 1L, 2L, KafkaOffsetRange$.MODULE$.apply$default$4()), new KafkaOffsetRange(this.tp2(), 1L, 1L, KafkaOffsetRange$.MODULE$.apply$default$4())})), calc.getRanges$default$2()));
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange(this.tp1(), 1L, 2L, (Option)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("KafkaOffsetRangeCalculatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.testWithMinPartitions("N TopicPartitions to N offset ranges", 3, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$3(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("N TopicPartitions to N offset ranges with executors", 3, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$4(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("1 TopicPartition to N offset ranges", 4, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$5(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("N skewed TopicPartitions to M offset ranges", 4, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$6(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("SPARK-30656: ignore empty ranges and split the rest", 4, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$7(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("SPARK-30656: N very skewed TopicPartitions to M offset ranges", 4, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$8(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("SPARK-30656: minPartitions less than the length of topic partitions", 1, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$9(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("range inexact multiple of minPartitions", 3, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$10(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("empty ranges ignored", 4, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$11(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("SPARK-28489: never drop offsets", 6, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$12(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("SPARK-36576: 0 small unsplit ranges and 3 large split ranges", 9, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$13(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("SPARK-36576: 1 small unsplit range and 2 large split ranges", 6, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$14(this, calc);
            return BoxedUnit.UNIT;
        });
        this.testWithMinPartitions("SPARK-36576: 2 small unsplit ranges and 1 large split range", 6, (Function1<KafkaOffsetRangeCalculator, BoxedUnit>)(Function1 & Serializable)calc -> {
            KafkaOffsetRangeCalculatorSuite.$anonfun$new$15(this, calc);
            return BoxedUnit.UNIT;
        });
        this.tp1 = new TopicPartition("t1", 1);
        this.tp2 = new TopicPartition("t2", 1);
        this.tp3 = new TopicPartition("t3", 1);
    }
}

