/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.UUID;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.kafka010.AssignStrategy;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.KafkaTestUtils;
import org.apache.spark.sql.kafka010.KafkaTestUtils$;
import org.apache.spark.sql.kafka010.SubscribePatternStrategy;
import org.apache.spark.sql.kafka010.SubscribeStrategy;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\u0007\u000f\u0001eAQA\b\u0001\u0005\u0002}A\u0011B\t\u0001A\u0002\u0003\u0007I\u0011B\u0012\t\u0013\u001d\u0002\u0001\u0019!a\u0001\n\u0013A\u0003\"C\u0019\u0001\u0001\u0004\u0005\t\u0015)\u0003%\u0011\u0015\u0011\u0004\u0001\"\u00034\u0011\u0015\t\u0005\u0001\"\u0005C\u0011\u001d\u0001\u0006!%A\u0005\u0012ECQ\u0001\u0018\u0001\u0005\nuCQ\u0001\u001c\u0001\u0005\n5DQ\u0001 \u0001\u0005\nuDq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002\u001e\u0001!\t%a\u0007\u0003+\r{gn];nKJ\u001cFO]1uK\u001eL8+^5uK*\u0011q\u0002E\u0001\tW\u000647.\u0019\u00192a)\u0011\u0011CE\u0001\u0004gFd'BA\n\u0015\u0003\u0015\u0019\b/\u0019:l\u0015\t)b#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0007\t\u00037qi\u0011AE\u0005\u0003;I\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u000f\u0003%!Xm\u001d;Vi&d7/F\u0001%!\t\tS%\u0003\u0002'\u001d\tq1*\u00194lCR+7\u000f^+uS2\u001c\u0018!\u0004;fgR,F/\u001b7t?\u0012*\u0017\u000f\u0006\u0002*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5u\u0011\u001d\u00014!!AA\u0002\u0011\n1\u0001\u001f\u00132\u0003)!Xm\u001d;Vi&d7\u000fI\u0001\tI>\u0014V\r^;s]R\u0011A\u0007\u0010\t\u0003kij\u0011A\u000e\u0006\u0003oa\n\u0001b\u001d;vE\nLgn\u001a\u0006\u0003sY\tq!\\8dW&$x.\u0003\u0002<m\t91\u000b^;cE\u0016\u0014\b\"B\u001f\u0006\u0001\u0004q\u0014!\u0002<bYV,\u0007C\u0001\u0016@\u0013\t\u00015FA\u0002B]f\f\u0001B\\3x)>\u0004\u0018n\u0019\u000b\u0003\u0007:\u0003\"\u0001R&\u000f\u0005\u0015K\u0005C\u0001$,\u001b\u00059%B\u0001%\u0019\u0003\u0019a$o\\8u}%\u0011!jK\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002KW!9qJ\u0002I\u0001\u0002\u0004\u0019\u0015A\u00029sK\u001aL\u00070\u0001\noK^$v\u000e]5dI\u0011,g-Y;mi\u0012\nT#\u0001*+\u0005\r\u001b6&\u0001+\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016!C;oG\",7m[3e\u0015\tI6&\u0001\u0006b]:|G/\u0019;j_:L!a\u0017,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006tKR\u001c\u0006/\u0019:l\u000b:4HCA\u0015_\u0011\u0015y\u0006\u00021\u0001a\u0003!\u0019X\r\u001e;j]\u001e\u001c\bcA1gS:\u0011!\r\u001a\b\u0003\r\u000eL\u0011\u0001L\u0005\u0003K.\nq\u0001]1dW\u0006<W-\u0003\u0002hQ\nA\u0011\n^3sC\ndWM\u0003\u0002fWA!!F[\"D\u0013\tY7F\u0001\u0004UkBdWMM\u0001\u000bC\u0012l\u0017N\u001c)s_B\u001cX#\u00018\u0011\t=$8I^\u0007\u0002a*\u0011\u0011O]\u0001\u0005kRLGNC\u0001t\u0003\u0011Q\u0017M^1\n\u0005U\u0004(aA'baB\u0011qO_\u0007\u0002q*\u0011\u0011P]\u0001\u0005Y\u0006tw-\u0003\u0002|q\n1qJ\u00196fGR\fQ!\u00193nS:$2A`A\b!\ry\u00181B\u0007\u0003\u0003\u0003Q1\u0001`A\u0002\u0015\u0011\t)!a\u0002\u0002\u000f\rd\u0017.\u001a8ug*\u0019\u0011\u0011\u0002\u000b\u0002\u000b-\fgm[1\n\t\u00055\u0011\u0011\u0001\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\b\u0003#Q\u0001\u0019AA\n\u0003!\u0019HO]1uK\u001eL\bcA\u0011\u0002\u0016%\u0019\u0011q\u0003\b\u0003!\r{gn];nKJ\u001cFO]1uK\u001eL\u0018!\u00032fM>\u0014X-\u00117m)\u0005I\u0013\u0001C1gi\u0016\u0014\u0018\t\u001c7")
public class ConsumerStrategySuite
extends SparkFunSuite {
    private KafkaTestUtils testUtils;

    private KafkaTestUtils testUtils() {
        return this.testUtils;
    }

    private void testUtils_$eq(KafkaTestUtils x$1) {
        this.testUtils = x$1;
    }

    private Stubber doReturn(Object value) {
        return Mockito.doReturn((Object)value, (Object[])ScalaRunTime$.MODULE$.toObjectArray(package$.MODULE$.Seq().empty().toArray(ClassTag$.MODULE$.Any())));
    }

    public String newTopic(String prefix) {
        return new StringBuilder(1).append(prefix).append("-").append(UUID.randomUUID().toString()).toString();
    }

    public String newTopic$default$1() {
        return "topic";
    }

    private void setSparkEnv(Iterable<Tuple2<String, String>> settings) {
        SparkConf conf = new SparkConf().setAll(settings);
        SparkEnv env = (SparkEnv)Mockito.mock(SparkEnv.class);
        ((SparkEnv)this.doReturn(conf).when((Object)env)).conf();
        SparkEnv$.MODULE$.set(env);
    }

    private java.util.Map<String, Object> adminProps() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.testUtils().brokerAddress())}))).asJava();
    }

    private Admin admin(ConsumerStrategy strategy) {
        return strategy.createAdmin(this.adminProps());
    }

    public void beforeAll() {
        super.beforeAll();
        this.testUtils_$eq(new KafkaTestUtils((scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty(), KafkaTestUtils$.MODULE$.$lessinit$greater$default$2()));
        this.testUtils().setup();
        this.setSparkEnv((Iterable<Tuple2<String, String>>)Predef$.MODULE$.Map().empty());
    }

    public void afterAll() {
        if (this.testUtils() != null) {
            this.testUtils().teardown();
            this.testUtils_$eq(null);
        }
        super.afterAll();
    }

    public ConsumerStrategySuite() {
        this.test("createAdmin must create admin properly", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            AssignStrategy strategy = new AssignStrategy((TopicPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(TopicPartition.class)));
            Admin $org_scalatest_assert_macro_left = strategy.createAdmin(this.adminProps());
            Object $org_scalatest_assert_macro_right = null;
            Admin admin = $org_scalatest_assert_macro_left;
            Object var5_4 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, admin == null ? var5_4 != null : !admin.equals(var5_4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("AssignStrategy.assignedTopicPartitions must give back all assigned", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String assignedTopic = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$1 = this.testUtils();
            String x$1 = assignedTopic;
            int x$2 = 3;
            boolean x$3 = qual$1.createTopic$default$3();
            qual$1.createTopic(x$1, 3, x$3);
            String otherExistingTopic = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$2 = this.testUtils();
            String x$4 = otherExistingTopic;
            int x$5 = 2;
            boolean x$6 = qual$2.createTopic$default$3();
            qual$2.createTopic(x$4, 2, x$6);
            TopicPartition[] partitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition(assignedTopic, 0), new TopicPartition(assignedTopic, 2)});
            AssignStrategy strategy = new AssignStrategy(partitions);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(strategy.assignedTopicPartitions(this.admin((ConsumerStrategy)strategy)));
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.wrapRefArray((Object[])partitions).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            this.testUtils().deleteTopic(assignedTopic);
            this.testUtils().deleteTopic(otherExistingTopic);
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("AssignStrategy.assignedTopicPartitions must skip invalid partitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String assignedTopic = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$3 = this.testUtils();
            String x$7 = assignedTopic;
            boolean x$8 = true;
            boolean x$9 = qual$3.createTopic$default$3();
            qual$3.createTopic(x$7, 1, x$9);
            TopicPartition[] partitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition(assignedTopic, 1)});
            AssignStrategy strategy = new AssignStrategy(partitions);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(strategy.assignedTopicPartitions(this.admin((ConsumerStrategy)strategy)));
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            this.testUtils().deleteTopic(assignedTopic);
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("SubscribeStrategy.assignedTopicPartitions must give back all assigned", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String subscribedTopic1 = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$4 = this.testUtils();
            String x$10 = subscribedTopic1;
            int x$11 = 2;
            boolean x$12 = qual$4.createTopic$default$3();
            qual$4.createTopic(x$10, 2, x$12);
            String subscribedTopic2 = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$5 = this.testUtils();
            String x$13 = subscribedTopic2;
            int x$14 = 2;
            boolean x$15 = qual$5.createTopic$default$3();
            qual$5.createTopic(x$13, 2, x$15);
            String otherExistingTopic = this.newTopic(this.newTopic$default$1());
            KafkaTestUtils qual$6 = this.testUtils();
            String x$16 = otherExistingTopic;
            int x$17 = 2;
            boolean x$18 = qual$6.createTopic$default$3();
            qual$6.createTopic(x$16, 2, x$18);
            Set partitions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(subscribedTopic1, 0), new TopicPartition(subscribedTopic1, 1), new TopicPartition(subscribedTopic2, 0), new TopicPartition(subscribedTopic2, 1)}));
            SubscribeStrategy strategy = new SubscribeStrategy((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{subscribedTopic1, subscribedTopic2})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(strategy.assignedTopicPartitions(this.admin((ConsumerStrategy)strategy)));
            Set $org_scalatest_assert_macro_right = partitions;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            this.testUtils().deleteTopic(subscribedTopic1);
            this.testUtils().deleteTopic(subscribedTopic2);
            this.testUtils().deleteTopic(otherExistingTopic);
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("SubscribePatternStrategy.assignedTopicPartitions must give back all assigned", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String subscribePattern = "subscribePattern";
            String subscribedTopic1 = this.newTopic(subscribePattern);
            KafkaTestUtils qual$7 = this.testUtils();
            String x$19 = subscribedTopic1;
            int x$20 = 2;
            boolean x$21 = qual$7.createTopic$default$3();
            qual$7.createTopic(x$19, 2, x$21);
            String subscribedTopic2 = this.newTopic(subscribePattern);
            KafkaTestUtils qual$8 = this.testUtils();
            String x$22 = subscribedTopic2;
            int x$23 = 2;
            boolean x$24 = qual$8.createTopic$default$3();
            qual$8.createTopic(x$22, 2, x$24);
            String otherExistingTopic = this.newTopic("other");
            KafkaTestUtils qual$9 = this.testUtils();
            String x$25 = otherExistingTopic;
            int x$26 = 2;
            boolean x$27 = qual$9.createTopic$default$3();
            qual$9.createTopic(x$25, 2, x$27);
            Set partitions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(subscribedTopic1, 0), new TopicPartition(subscribedTopic1, 1), new TopicPartition(subscribedTopic2, 0), new TopicPartition(subscribedTopic2, 1)}));
            SubscribePatternStrategy strategy = new SubscribePatternStrategy(new StringBuilder(2).append(subscribePattern).append(".*").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(strategy.assignedTopicPartitions(this.admin((ConsumerStrategy)strategy)));
            Set $org_scalatest_assert_macro_right = partitions;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            this.testUtils().deleteTopic(subscribedTopic1);
            this.testUtils().deleteTopic(subscribedTopic2);
            this.testUtils().deleteTopic(otherExistingTopic);
        }, new Position("ConsumerStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }
}

