/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager$;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.consumer.FetchedData;
import org.apache.spark.sql.kafka010.consumer.FetchedDataPool;
import org.apache.spark.sql.kafka010.consumer.FetchedRecord;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumerPool;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011-a!\u00027n\u0001=L\bBCA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0012!Q\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005U\u0003A!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u0003CBq!a\u001a\u0001\t\u0003\tI\u0007C\u0005\u0002v\u0001\u0001\r\u0011\"\u0003\u0002x!I\u0011q\u0010\u0001A\u0002\u0013%\u0011\u0011\u0011\u0005\t\u0003\u001b\u0003\u0001\u0015)\u0003\u0002z!I\u0011q\u0012\u0001A\u0002\u0013%\u0011q\u000f\u0005\n\u0003#\u0003\u0001\u0019!C\u0005\u0003'C\u0001\"a&\u0001A\u0003&\u0011\u0011\u0010\u0005\n\u00033\u0003!\u0019!C\u0005\u00037C\u0001\"a)\u0001A\u0003%\u0011Q\u0014\u0005\u000b\u0003K\u0003\u0001\u0019!C\u0001[\u0006\u001d\u0006BCA[\u0001\u0001\u0007I\u0011A7\u00028\"A\u00111\u0018\u0001!B\u0013\tI\u000bC\u0005\u0002F\u0002\u0001\r\u0011\"\u0003\u0002H\"I\u0011\u0011\u001b\u0001A\u0002\u0013%\u00111\u001b\u0005\t\u0003/\u0004\u0001\u0015)\u0003\u0002J\"I\u00111\u001c\u0001C\u0002\u0013%\u0011Q\u001c\u0005\t\u0003?\u0004\u0001\u0015!\u0003\u00024!I\u0011\u0011\u001d\u0001C\u0002\u0013%\u00111\u001d\u0005\t\u0007\u001b\u0002\u0001\u0015!\u0003\u0002f\"I1q\n\u0001C\u0002\u0013%1\u0011\u000b\u0005\t\u00073\u0002\u0001\u0015!\u0003\u0004T!911\f\u0001\u0005\u0002\ru\u0003bBBD\u0001\u0011\u00051\u0011\u0012\u0005\b\u0007\u001b\u0003A\u0011ABH\u0011\u001d\u0019\t\n\u0001C\u0001\u0007\u001fCqaa%\u0001\t\u0003\u0019)\nC\u0004\u0004\u0018\u0002!Ia!&\t\u000f\re\u0005\u0001\"\u0003\u0004\u0016\"911\u0014\u0001\u0005\n\ru\u0005bBBS\u0001\u0011%1q\u0015\u0005\b\u0007o\u0003A\u0011BB]\u0011!\u0019\u0019\r\u0001C\u0001_\u000e\u0015\u0007bBBd\u0001\u0011%1Q\u0013\u0005\b\u0007\u0013\u0004A\u0011BBf\u0011\u001d\u0019y\r\u0001C\u0005\u0007#Dqa!7\u0001\t\u0013\u0019Y\u000eC\u0005\u0004j\u0002\t\n\u0011\"\u0003\u0004J!911\u001e\u0001\u0005\n\r5x\u0001CAu[\"\u0005q.a;\u0007\u000f1l\u0007\u0012A8\u0002n\"9\u0011q\r\u0017\u0005\u0002\u0005=\b\"CAyY\t\u0007I\u0011AA<\u0011!\t\u0019\u0010\fQ\u0001\n\u0005edABA{Y\u0001\u000b9\u0010\u0003\u0006\u0003\u0012A\u0012)\u001a!C\u0001\u0003oB!Ba\u00051\u0005#\u0005\u000b\u0011BA=\u0011)\u0011)\u0002\rBK\u0002\u0013\u0005\u0011q\u000f\u0005\u000b\u0005/\u0001$\u0011#Q\u0001\n\u0005e\u0004bBA4a\u0011\u0005!\u0011\u0004\u0005\n\u0005G\u0001\u0014\u0011!C\u0001\u0005KA\u0011Ba\u000b1#\u0003%\tA!\f\t\u0013\t\r\u0003'%A\u0005\u0002\t5\u0002\"\u0003B#a\u0005\u0005I\u0011\tB$\u0011%\u0011i\u0005MA\u0001\n\u0003\u0011y\u0005C\u0005\u0003XA\n\t\u0011\"\u0001\u0003Z!I!1\r\u0019\u0002\u0002\u0013\u0005#Q\r\u0005\n\u0005g\u0002\u0014\u0011!C\u0001\u0005kB\u0011B!\u001f1\u0003\u0003%\tEa\u001f\t\u0013\t}\u0004'!A\u0005B\t\u0005\u0005\"\u0003BBa\u0005\u0005I\u0011\tBC\u0011%\u00119\tMA\u0001\n\u0003\u0012IiB\u0005\u0003\u000e2\n\t\u0011#\u0001\u0003\u0010\u001aI\u0011Q\u001f\u0017\u0002\u0002#\u0005!\u0011\u0013\u0005\b\u0003O\u001aE\u0011\u0001BU\u0011%\u0011\u0019iQA\u0001\n\u000b\u0012)\tC\u0005\u0003,\u000e\u000b\t\u0011\"!\u0003.\"I!1W\"\u0002\u0002\u0013\u0005%Q\u0017\u0005\n\u0005\u0007\u001c\u0015\u0011!C\u0005\u0005\u000b4aAa2-\u0001\n%\u0007BCAn\u0013\nU\r\u0011\"\u0001\u0002^\"Q\u0011q\\%\u0003\u0012\u0003\u0006I!a\r\t\u0015\u00055\u0011J!f\u0001\n\u0003\u0011Y\r\u0003\u0006\u0003N&\u0013\t\u0012)A\u0005\u0003#Aq!a\u001aJ\t\u0003\u0011y\rC\u0004\u0002h%#\tAa6\t\u0013\t\r\u0012*!A\u0005\u0002\tu\u0007\"\u0003B\u0016\u0013F\u0005I\u0011\u0001Br\u0011%\u0011\u0019%SI\u0001\n\u0003\u00119\u000fC\u0005\u0003F%\u000b\t\u0011\"\u0011\u0003H!I!QJ%\u0002\u0002\u0013\u0005!q\n\u0005\n\u0005/J\u0015\u0011!C\u0001\u0005WD\u0011Ba\u0019J\u0003\u0003%\tE!\u001a\t\u0013\tM\u0014*!A\u0005\u0002\t=\b\"\u0003B=\u0013\u0006\u0005I\u0011\tBz\u0011%\u0011y(SA\u0001\n\u0003\u0012\t\tC\u0005\u0003\u0004&\u000b\t\u0011\"\u0011\u0003\u0006\"I!qQ%\u0002\u0002\u0013\u0005#q_\u0004\n\u0005wd\u0013\u0011!E\u0001\u0005{4\u0011Ba2-\u0003\u0003E\tAa@\t\u000f\u0005\u001dT\f\"\u0001\u0004\u0004!I!1Q/\u0002\u0002\u0013\u0015#Q\u0011\u0005\n\u0005Wk\u0016\u0011!CA\u0007\u000bA\u0011Ba-^\u0003\u0003%\tia\u0003\t\u0013\t\rW,!A\u0005\n\t\u0015\u0007\"CB\nY\t\u0007I\u0011BB\u000b\u0011!\u0019y\u0002\fQ\u0001\n\r]\u0001\"CA+Y\t\u0007I\u0011BB\u0011\u0011!\u0019\u0019\u0003\fQ\u0001\n\u0005]\u0003\"CA0Y\t\u0007I\u0011BB\u0013\u0011!\u00199\u0003\fQ\u0001\n\u0005\u0005\u0004bBB\u0015Y\u0011\u000511\u0006\u0005\b\u0007caC\u0011BB\u001a\u0011%\u00199\u0005LI\u0001\n\u0013\u0019IEA\tLC\u001a\\\u0017\rR1uC\u000e{gn];nKJT!A\\8\u0002\u0011\r|gn];nKJT!\u0001]9\u0002\u0011-\fgm[11cAR!A]:\u0002\u0007M\fHN\u0003\u0002uk\u0006)1\u000f]1sW*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h'\u0011\u0001!0!\u0001\u0011\u0005mtX\"\u0001?\u000b\u0003u\fQa]2bY\u0006L!a ?\u0003\r\u0005s\u0017PU3g!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004g\u0006A\u0011N\u001c;fe:\fG.\u0003\u0003\u0002\f\u0005\u0015!a\u0002'pO\u001eLgnZ\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0007\u0001\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0004d_6lwN\u001c\u0006\u0004\u00037)\u0018!B6bM.\f\u0017\u0002BA\u0010\u0003+\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0006lC\u001a\\\u0017\rU1sC6\u001c\b\u0003CA\u0013\u0003_\t\u0019$!\u0013\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tA!\u001e;jY*\u0011\u0011QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0005\u001d\"aA'baB!\u0011QGA\"\u001d\u0011\t9$a\u0010\u0011\u0007\u0005eB0\u0004\u0002\u0002<)!\u0011QHA\b\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\t?\u0002\rA\u0013X\rZ3g\u0013\u0011\t)%a\u0012\u0003\rM#(/\u001b8h\u0015\r\t\t\u0005 \t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)!\u0011qJA\u0016\u0003\u0011a\u0017M\\4\n\t\u0005M\u0013Q\n\u0002\u0007\u001f\nTWm\u0019;\u0002\u0019\r|gn];nKJ\u0004vn\u001c7\u0011\t\u0005e\u00131L\u0007\u0002[&\u0019\u0011QL7\u00033%sG/\u001a:oC2\\\u0015MZ6b\u0007>t7/^7feB{w\u000e\\\u0001\u0010M\u0016$8\r[3e\t\u0006$\u0018\rU8pYB!\u0011\u0011LA2\u0013\r\t)'\u001c\u0002\u0010\r\u0016$8\r[3e\t\u0006$\u0018\rU8pY\u00061A(\u001b8jiz\"\"\"a\u001b\u0002n\u0005=\u0014\u0011OA:!\r\tI\u0006\u0001\u0005\b\u0003\u001b)\u0001\u0019AA\t\u0011\u001d\t\t#\u0002a\u0001\u0003GAq!!\u0016\u0006\u0001\u0004\t9\u0006C\u0004\u0002`\u0015\u0001\r!!\u0019\u0002!=4gm]3u\u001fV$xJ\u001a*b]\u001e,WCAA=!\rY\u00181P\u0005\u0004\u0003{b(\u0001\u0002'p]\u001e\fAc\u001c4gg\u0016$x*\u001e;PMJ\u000bgnZ3`I\u0015\fH\u0003BAB\u0003\u0013\u00032a_AC\u0013\r\t9\t \u0002\u0005+:LG\u000fC\u0005\u0002\f\u001e\t\t\u00111\u0001\u0002z\u0005\u0019\u0001\u0010J\u0019\u0002#=4gm]3u\u001fV$xJ\u001a*b]\u001e,\u0007%\u0001\u0005eCR\fGj\\:t\u00031!\u0017\r^1M_N\u001cx\fJ3r)\u0011\t\u0019)!&\t\u0013\u0005-%\"!AA\u0002\u0005e\u0014!\u00033bi\u0006dun]:!\u0003YI7\u000fV8lK:\u0004&o\u001c<jI\u0016\u0014XI\\1cY\u0016$WCAAO!\rY\u0018qT\u0005\u0004\u0003Cc(a\u0002\"p_2,\u0017M\\\u0001\u0018SN$vn[3o!J|g/\u001b3fe\u0016s\u0017M\u00197fI\u0002\n\u0011bX2p]N,X.\u001a:\u0016\u0005\u0005%\u0006#B>\u0002,\u0006=\u0016bAAWy\n1q\n\u001d;j_:\u0004B!!\u0017\u00022&\u0019\u00111W7\u0003+%sG/\u001a:oC2\\\u0015MZ6b\u0007>t7/^7fe\u0006iqlY8ogVlWM]0%KF$B!a!\u0002:\"I\u00111R\b\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u000b?\u000e|gn];nKJ\u0004\u0003f\u0001\t\u0002@B\u001910!1\n\u0007\u0005\rGP\u0001\u0005w_2\fG/\u001b7f\u00031yf-\u001a;dQ\u0016$G)\u0019;b+\t\tI\rE\u0003|\u0003W\u000bY\r\u0005\u0003\u0002Z\u00055\u0017bAAh[\nYa)\u001a;dQ\u0016$G)\u0019;b\u0003Ayf-\u001a;dQ\u0016$G)\u0019;b?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0006U\u0007\"CAF%\u0005\u0005\t\u0019AAe\u00035yf-\u001a;dQ\u0016$G)\u0019;bA!\u001a1#a0\u0002\u000f\u001d\u0014x.\u001e9JIV\u0011\u00111G\u0001\tOJ|W\u000f]%eA\u0005A1-Y2iK.+\u00170\u0006\u0002\u0002fB\u0019\u0011q]%\u000f\u0007\u0005e3&A\tLC\u001a\\\u0017\rR1uC\u000e{gn];nKJ\u00042!!\u0017-'\u0011a#0!\u0001\u0015\u0005\u0005-\u0018AD+O\u0017:{uKT0P\r\u001a\u001bV\tV\u0001\u0010+:[ejT,O?>3eiU#UA\t!\u0012I^1jY\u0006\u0014G.Z(gMN,GOU1oO\u0016\u001cb\u0001\r>\u0002z\u0006}\bcA>\u0002|&\u0019\u0011Q ?\u0003\u000fA\u0013x\u000eZ;diB!!\u0011\u0001B\u0006\u001d\u0011\u0011\u0019Aa\u0002\u000f\t\u0005e\"QA\u0005\u0002{&\u0019!\u0011\u0002?\u0002\u000fA\f7m[1hK&!!Q\u0002B\b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\u0011I\u0001`\u0001\tK\u0006\u0014H.[3ti\u0006IQ-\u0019:mS\u0016\u001cH\u000fI\u0001\u0007Y\u0006$Xm\u001d;\u0002\u000f1\fG/Z:uAQ1!1\u0004B\u0010\u0005C\u00012A!\b1\u001b\u0005a\u0003b\u0002B\tk\u0001\u0007\u0011\u0011\u0010\u0005\b\u0005+)\u0004\u0019AA=\u0003\u0011\u0019w\u000e]=\u0015\r\tm!q\u0005B\u0015\u0011%\u0011\tB\u000eI\u0001\u0002\u0004\tI\bC\u0005\u0003\u0016Y\u0002\n\u00111\u0001\u0002z\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0018U\u0011\tIH!\r,\u0005\tM\u0002\u0003\u0002B\u001b\u0005\u007fi!Aa\u000e\u000b\t\te\"1H\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0010}\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\u00129DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0013\u0002B!a\u0013\u0003L%!\u0011QIA'\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011\t\u0006E\u0002|\u0005'J1A!\u0016}\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011YF!\u0019\u0011\u0007m\u0014i&C\u0002\u0003`q\u00141!\u00118z\u0011%\tYiOA\u0001\u0002\u0004\u0011\t&A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0007\u0005\u0004\u0003j\t=$1L\u0007\u0003\u0005WR1A!\u001c}\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005c\u0012YG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAO\u0005oB\u0011\"a#>\u0003\u0003\u0005\rAa\u0017\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u0013\u0012i\bC\u0005\u0002\fz\n\t\u00111\u0001\u0003R\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003R\u0005AAo\\*ue&tw\r\u0006\u0002\u0003J\u00051Q-];bYN$B!!(\u0003\f\"I\u00111R!\u0002\u0002\u0003\u0007!1L\u0001\u0015\u0003Z\f\u0017\u000e\\1cY\u0016|eMZ:fiJ\u000bgnZ3\u0011\u0007\tu1iE\u0003D\u0005'\u0013y\n\u0005\u0006\u0003\u0016\nm\u0015\u0011PA=\u00057i!Aa&\u000b\u0007\teE0A\u0004sk:$\u0018.\\3\n\t\tu%q\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003\u0002BQ\u0005Ok!Aa)\u000b\t\t\u0015\u00161F\u0001\u0003S>LAA!\u0004\u0003$R\u0011!qR\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u00057\u0011yK!-\t\u000f\tEa\t1\u0001\u0002z!9!Q\u0003$A\u0002\u0005e\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005o\u0013y\fE\u0003|\u0003W\u0013I\fE\u0004|\u0005w\u000bI(!\u001f\n\u0007\tuFP\u0001\u0004UkBdWM\r\u0005\n\u0005\u0003<\u0015\u0011!a\u0001\u00057\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tIE\u0001\u0005DC\u000eDWmS3z'\u0019I%0!?\u0002\u0000V\u0011\u0011\u0011C\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oAQ1!\u0011\u001bBj\u0005+\u00042A!\bJ\u0011\u001d\tYN\u0014a\u0001\u0003gAq!!\u0004O\u0001\u0004\t\t\u0002\u0006\u0004\u0003R\ne'1\u001c\u0005\b\u0003\u001by\u0005\u0019AA\t\u0011\u001d\t\tc\u0014a\u0001\u0003G!bA!5\u0003`\n\u0005\b\"CAn!B\u0005\t\u0019AA\u001a\u0011%\ti\u0001\u0015I\u0001\u0002\u0004\t\t\"\u0006\u0002\u0003f*\"\u00111\u0007B\u0019+\t\u0011IO\u000b\u0003\u0002\u0012\tEB\u0003\u0002B.\u0005[D\u0011\"a#V\u0003\u0003\u0005\rA!\u0015\u0015\t\u0005u%\u0011\u001f\u0005\n\u0003\u0017;\u0016\u0011!a\u0001\u00057\"BA!\u0013\u0003v\"I\u00111\u0012-\u0002\u0002\u0003\u0007!\u0011\u000b\u000b\u0005\u0003;\u0013I\u0010C\u0005\u0002\fn\u000b\t\u00111\u0001\u0003\\\u0005A1)Y2iK.+\u0017\u0010E\u0002\u0003\u001eu\u001bR!XB\u0001\u0005?\u0003\"B!&\u0003\u001c\u0006M\u0012\u0011\u0003Bi)\t\u0011i\u0010\u0006\u0004\u0003R\u000e\u001d1\u0011\u0002\u0005\b\u00037\u0004\u0007\u0019AA\u001a\u0011\u001d\ti\u0001\u0019a\u0001\u0003#!Ba!\u0004\u0004\u0012A)10a+\u0004\u0010A91Pa/\u00024\u0005E\u0001\"\u0003BaC\u0006\u0005\t\u0019\u0001Bi\u0003%\u0019\b/\u0019:l\u0007>tg-\u0006\u0002\u0004\u0018A!1\u0011DB\u000e\u001b\u0005\u0019\u0018bAB\u000fg\nI1\u000b]1sW\u000e{gNZ\u0001\u000bgB\f'o[\"p]\u001a\u0004SCAA,\u00035\u0019wN\\:v[\u0016\u0014\bk\\8mAU\u0011\u0011\u0011M\u0001\u0011M\u0016$8\r[3e\t\u0006$\u0018\rU8pY\u0002\nq!Y2rk&\u0014X\r\u0006\u0004\u0002l\r52q\u0006\u0005\b\u0003\u001bI\u0007\u0019AA\t\u0011\u001d\t\t#\u001ba\u0001\u0003G\tqB]3q_J$H)\u0019;b\u0019>\u001c8\u000f\r\u000b\t\u0003\u0007\u001b)d!\u000f\u0004>!91q\u00076A\u0002\u0005u\u0015A\u00044bS2|e\u000eR1uC2{7o\u001d\u0005\b\u0007wQ\u0007\u0019AA\u001a\u000311\u0017N\\1m\u001b\u0016\u001c8/Y4f\u0011%\u0019yD\u001bI\u0001\u0002\u0004\u0019\t%A\u0003dCV\u001cX\r\u0005\u0003\u0003\u0002\r\r\u0013\u0002BB#\u0005\u001f\u0011\u0011\u0002\u00165s_^\f'\r\\3\u00023I,\u0007o\u001c:u\t\u0006$\u0018\rT8tgB\"C-\u001a4bk2$HeM\u000b\u0003\u0007\u0017RCa!\u0011\u00032\u0005I1-Y2iK.+\u0017\u0010I\u0001\u000eM\u0016$8\r[3e%\u0016\u001cwN\u001d3\u0016\u0005\rM\u0003\u0003BA-\u0007+J1aa\u0016n\u000551U\r^2iK\u0012\u0014VmY8sI\u0006qa-\u001a;dQ\u0016$'+Z2pe\u0012\u0004\u0013aA4fiRQ1qLB=\u0007{\u001a\ti!\"\u0011\u0011\r\u00054\u0011NB7\u0007[j!aa\u0019\u000b\u00079\u001c)G\u0003\u0003\u0004h\u0005e\u0011aB2mS\u0016tGo]\u0005\u0005\u0007W\u001a\u0019G\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u000bm\u001cyga\u001d\n\u0007\rEDPA\u0003BeJ\f\u0017\u0010E\u0002|\u0007kJ1aa\u001e}\u0005\u0011\u0011\u0015\u0010^3\t\u000f\rm$\u00041\u0001\u0002z\u00051qN\u001a4tKRDqaa \u001b\u0001\u0004\tI(A\u0006v]RLGn\u00144gg\u0016$\bbBBB5\u0001\u0007\u0011\u0011P\u0001\u000ea>dG\u000eV5nK>,H/T:\t\u000f\r]\"\u00041\u0001\u0002\u001e\u00069r-\u001a;Bm\u0006LG.\u00192mK>3gm]3u%\u0006tw-\u001a\u000b\u0003\u0007\u0017\u00032!a:1\u0003Y9W\r\u001e(v[>3gm]3u\u001fV$xJ\u001a*b]\u001e,GCAA=\u000399W\r\u001e(v[\u0012\u000bG/\u0019'pgN\fqA]3mK\u0006\u001cX\r\u0006\u0002\u0002\u0004\u0006y!/\u001a7fCN,7i\u001c8tk6,'/\u0001\nsK2,\u0017m]3GKR\u001c\u0007.\u001a3ECR\f\u0017!I4fi\u0016\u000b'\u000f\\5fgR\fe/Y5mC\ndWm\u00144gg\u0016$()\u001a;xK\u0016tG\u0003CA=\u0007?\u001b\tka)\t\r9\f\u0003\u0019AAX\u0011\u001d\u0019Y(\ta\u0001\u0003sBqaa \"\u0001\u0004\tI(A\u0006gKR\u001c\u0007NU3d_J$GCDB*\u0007S\u001bYka,\u00042\u000eM6Q\u0017\u0005\u0007]\n\u0002\r!a,\t\u000f\r5&\u00051\u0001\u0002L\u0006Ya-\u001a;dQ\u0016$G)\u0019;b\u0011\u001d\u0019YH\ta\u0001\u0003sBqaa #\u0001\u0004\tI\bC\u0004\u0004\u0004\n\u0002\r!!\u001f\t\u000f\r]\"\u00051\u0001\u0002\u001e\u0006Ia-\u001a;dQ\u0012\u000bG/\u0019\u000b\u000b\u0003\u0007\u001bYl!0\u0004@\u000e\u0005\u0007B\u00028$\u0001\u0004\ty\u000bC\u0004\u0004.\u000e\u0002\r!a3\t\u000f\rm4\u00051\u0001\u0002z!911Q\u0012A\u0002\u0005e\u0014!F4fi>\u0013(+\u001a;sS\u00164XmQ8ogVlWM\u001d\u000b\u0003\u0003_\u000b\u0001C]3ue&,g/Z\"p]N,X.\u001a:\u00021\u001d,Go\u0014:SKR\u0014\u0018.\u001a<f\r\u0016$8\r[3e\t\u0006$\u0018\r\u0006\u0003\u0002L\u000e5\u0007bBB>M\u0001\u0007\u0011\u0011P\u0001\u0012C\u0012$\u0017\u000e^5p]\u0006dW*Z:tC\u001e,G\u0003CA\u001a\u0007'\u001c)na6\t\u000f\u00055q\u00051\u0001\u0002\u0012!9\u00111\\\u0014A\u0002\u0005M\u0002bBB\u001cO\u0001\u0007\u0011QT\u0001\u000fe\u0016\u0004xN\u001d;ECR\fGj\\:t)1\t\u0019i!8\u0004`\u000e\u000581]Bt\u0011\u001d\ti\u0001\u000ba\u0001\u0003#Aq!a7)\u0001\u0004\t\u0019\u0004C\u0004\u00048!\u0002\r!!(\t\u000f\r\u0015\b\u00061\u0001\u00024\u00059Q.Z:tC\u001e,\u0007\"CB QA\u0005\t\u0019AB!\u0003a\u0011X\r]8si\u0012\u000bG/\u0019'pgN$C-\u001a4bk2$H%N\u0001\u001deVtWK\\5oi\u0016\u0014(/\u001e9uS\nd\u00170\u00134Q_N\u001c\u0018N\u00197f+\u0011\u0019yo!>\u0015\t\rEH\u0011\u0001\t\u0005\u0007g\u001c)\u0010\u0004\u0001\u0005\u000f\r](F1\u0001\u0004z\n\tA+\u0005\u0003\u0004|\nm\u0003cA>\u0004~&\u00191q ?\u0003\u000f9{G\u000f[5oO\"AA1\u0001\u0016\u0005\u0002\u0004!)!\u0001\u0003c_\u0012L\b#B>\u0005\b\rE\u0018b\u0001C\u0005y\nAAHY=oC6,g\b")
public class KafkaDataConsumer
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final InternalKafkaConsumerPool consumerPool;
    private final FetchedDataPool fetchedDataPool;
    private long offsetOutOfRange;
    private long dataLoss;
    private final boolean isTokenProviderEnabled;
    private volatile Option<InternalKafkaConsumer> _consumer;
    private volatile Option<FetchedData> _fetchedData;
    private final String groupId;
    private final CacheKey cacheKey;
    private final FetchedRecord fetchedRecord;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> map) {
        return KafkaDataConsumer$.MODULE$.acquire(topicPartition, map);
    }

    public static long UNKNOWN_OFFSET() {
        return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long offsetOutOfRange() {
        return this.offsetOutOfRange;
    }

    private void offsetOutOfRange_$eq(long x$1) {
        this.offsetOutOfRange = x$1;
    }

    private long dataLoss() {
        return this.dataLoss;
    }

    private void dataLoss_$eq(long x$1) {
        this.dataLoss = x$1;
    }

    private boolean isTokenProviderEnabled() {
        return this.isTokenProviderEnabled;
    }

    public Option<InternalKafkaConsumer> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Option<InternalKafkaConsumer> x$1) {
        this._consumer = x$1;
    }

    private Option<FetchedData> _fetchedData() {
        return this._fetchedData;
    }

    private void _fetchedData_$eq(Option<FetchedData> x$1) {
        this._fetchedData = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private CacheKey cacheKey() {
        return this.cacheKey;
    }

    private FetchedRecord fetchedRecord() {
        return this.fetchedRecord;
    }

    public ConsumerRecord<byte[], byte[]> get(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        return (ConsumerRecord)this.runUninterruptiblyIfPossible((Function0 & Serializable)() -> {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            Predef$.MODULE$.require(offset < untilOffset, (Function0 & Serializable)() -> new StringBuilder(69).append("offset must always be less than untilOffset [offset: ").append(offset).append(", untilOffset: ").append(untilOffset).append("]").toString());
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            FetchedData fetchedData = this.getOrRetrieveFetchedData(offset);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(18).append("Get ").append(this.groupId()).append(" ").append($this.topicPartition).append(" nextOffset ").append(fetchedData.nextOffsetInFetchedData()).append(" ").toString()).append(new StringBuilder(10).append("requested ").append(offset).toString()).toString());
            LongRef toFetchOffset = LongRef.create((long)offset);
            FetchedRecord fetchedRecord = null;
            boolean isFetchComplete = false;
            while (toFetchOffset.elem != KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET() && !isFetchComplete) {
                try {
                    fetchedRecord = this.fetchRecord(consumer, fetchedData, toFetchOffset.elem, untilOffset, pollTimeoutMs, failOnDataLoss);
                    if (fetchedRecord.record() != null) {
                        isFetchComplete = true;
                        continue;
                    }
                    toFetchOffset.elem = fetchedRecord.nextOffsetToFetch();
                    if (toFetchOffset.elem >= untilOffset) {
                        fetchedData.reset();
                        toFetchOffset.elem = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
                        continue;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Skipped offsets [").append(offset).append(", ").append(toFetchOffset$1.elem).append("]").toString());
                }
                catch (OffsetOutOfRangeException e) {
                    this.releaseConsumer();
                    fetchedData.reset();
                    this.reportDataLoss($this.topicPartition, this.groupId(), failOnDataLoss, new StringBuilder(20).append("Cannot fetch offset ").append(toFetchOffset.elem).toString(), e);
                    long oldToFetchOffsetd = toFetchOffset.elem;
                    toFetchOffset.elem = this.getEarliestAvailableOffsetBetween(consumer, toFetchOffset.elem, untilOffset);
                    if (toFetchOffset.elem == KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET()) {
                        this.offsetOutOfRange_$eq(this.offsetOutOfRange() + (untilOffset - oldToFetchOffsetd));
                        continue;
                    }
                    this.offsetOutOfRange_$eq(this.offsetOutOfRange() + (toFetchOffset.elem - oldToFetchOffsetd));
                }
            }
            if (isFetchComplete) {
                consumerRecord = fetchedRecord.record();
            } else {
                fetchedData.reset();
                consumerRecord = null;
            }
            return consumerRecord;
        });
    }

    public AvailableOffsetRange getAvailableOffsetRange() {
        return (AvailableOffsetRange)this.runUninterruptiblyIfPossible((Function0 & Serializable)() -> {
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            return consumer.getAvailableOffsetRange();
        });
    }

    public long getNumOffsetOutOfRange() {
        return this.offsetOutOfRange();
    }

    public long getNumDataLoss() {
        return this.dataLoss();
    }

    public void release() {
        this.releaseConsumer();
        this.releaseFetchedData();
    }

    private void releaseConsumer() {
        block0: {
            if (!this._consumer().isDefined()) break block0;
            this.consumerPool.returnObject((InternalKafkaConsumer)this._consumer().get());
            this._consumer_$eq((Option<InternalKafkaConsumer>)None$.MODULE$);
        }
    }

    private void releaseFetchedData() {
        block0: {
            if (!this._fetchedData().isDefined()) break block0;
            this.fetchedDataPool.release(this.cacheKey(), (FetchedData)this._fetchedData().get());
            this._fetchedData_$eq((Option<FetchedData>)None$.MODULE$);
        }
    }

    private long getEarliestAvailableOffsetBetween(InternalKafkaConsumer consumer, long offset, long untilOffset) {
        long l;
        AvailableOffsetRange range = consumer.getAvailableOffsetRange();
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Some data may be lost. Recovering from the earliest offset: ").append(range.earliest()).toString());
        TopicPartition topicPartition = consumer.topicPartition();
        String groupId = consumer.groupId();
        if (offset >= range.latest() || range.earliest() >= untilOffset) {
            String warningMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(untilOffset).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString()));
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> warningMessage);
            l = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
        } else if (offset >= range.earliest()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(51).append("Found a disappeared offset ").append(offset).append(". Some data may be lost ").toString()).append(String.valueOf(this.additionalMessage(topicPartition, groupId, false))).toString());
            l = offset;
        } else {
            String warningMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(range.earliest()).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString()));
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> warningMessage);
            l = range.earliest();
        }
        return l;
    }

    private FetchedRecord fetchRecord(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        FetchedRecord fetchedRecord;
        if (offset != fetchedData.nextOffsetInFetchedData()) {
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        } else if (!fetchedData.hasNext()) {
            if (offset < fetchedData.offsetAfterPoll()) {
                long nextOffsetToFetch = fetchedData.offsetAfterPoll();
                fetchedData.reset();
                return this.fetchedRecord().withRecord(null, nextOffsetToFetch);
            }
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        }
        if (!fetchedData.hasNext()) {
            Predef$.MODULE$.assert(offset <= fetchedData.offsetAfterPoll(), (Function0 & Serializable)() -> new StringBuilder(46).append("seek to ").append(offset).append(" and poll but the offset was reset to ").append(fetchedData.offsetAfterPoll()).toString());
            fetchedRecord = this.fetchedRecord().withRecord(null, fetchedData.offsetAfterPoll());
        } else {
            ConsumerRecord<byte[], byte[]> record = fetchedData.next();
            if (record.offset() > offset) {
                long earliestOffset;
                Tuple2<Object, Object> tuple2 = fetchedData.availableOffsetRange();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long l = earliestOffset = tuple2._1$mcJ$sp();
                long earliestOffset2 = l;
                if (earliestOffset2 <= offset) {
                    fetchedData.previous();
                    return this.fetchedRecord().withRecord(null, record.offset());
                }
                if (failOnDataLoss) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), true, new StringBuilder(28).append("Cannot fetch records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    throw new IllegalStateException("reportDataLoss didn't throw an exception when 'failOnDataLoss' is true");
                }
                if (record.offset() >= untilOffset) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(untilOffset).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(null, untilOffset);
                } else {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
                }
            } else {
                if (record.offset() < offset) {
                    throw new IllegalStateException(new StringBuilder(51).append("Tried to fetch ").append(offset).append(" but the returned record offset was ").append(record.offset()).toString());
                }
                fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
            }
        }
        return fetchedRecord;
    }

    private void fetchData(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long pollTimeoutMs) {
        Tuple3<List<ConsumerRecord<byte[], byte[]>>, Object, AvailableOffsetRange> tuple3 = consumer.fetch(offset, pollTimeoutMs);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        List records = (List)tuple3._1();
        long offsetAfterPoll = BoxesRunTime.unboxToLong((Object)tuple3._2());
        AvailableOffsetRange range = (AvailableOffsetRange)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)records, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll), (Object)range);
        Tuple3 tuple33 = tuple32;
        List records2 = (List)tuple33._1();
        long offsetAfterPoll2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        AvailableOffsetRange range2 = (AvailableOffsetRange)tuple33._3();
        fetchedData.withNewPoll(records2.listIterator(), offsetAfterPoll2, range2);
    }

    public InternalKafkaConsumer getOrRetrieveConsumer() {
        block1: {
            if (!this._consumer().isDefined()) {
                this.retrieveConsumer();
            }
            Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable)() -> "Consumer must be defined");
            if (!this.isTokenProviderEnabled() || !KafkaTokenUtil$.MODULE$.needTokenUpdate(((InternalKafkaConsumer)this._consumer().get()).kafkaParamsWithSecurity(), ((InternalKafkaConsumer)this._consumer().get()).clusterConfig())) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Cached consumer uses an old delegation token, invalidating.");
            this.releaseConsumer();
            this.consumerPool.invalidateKey(this.cacheKey());
            this.fetchedDataPool.invalidate(this.cacheKey());
            this.retrieveConsumer();
        }
        return (InternalKafkaConsumer)this._consumer().get();
    }

    private void retrieveConsumer() {
        this._consumer_$eq((Option<InternalKafkaConsumer>)Option$.MODULE$.apply((Object)this.consumerPool.borrowObject(this.cacheKey(), this.kafkaParams)));
        Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable)() -> "borrowing consumer from pool must always succeed.");
    }

    private FetchedData getOrRetrieveFetchedData(long offset) {
        FetchedData fetchedData;
        Option<FetchedData> option = this._fetchedData();
        if (None$.MODULE$.equals(option)) {
            this._fetchedData_$eq((Option<FetchedData>)Option$.MODULE$.apply((Object)this.fetchedDataPool.acquire(this.cacheKey(), offset)));
            Predef$.MODULE$.require(this._fetchedData().isDefined(), (Function0 & Serializable)() -> "acquiring fetched data from cache must always succeed.");
            fetchedData = (FetchedData)this._fetchedData().get();
        } else if (option instanceof Some) {
            FetchedData fetchedData2;
            Some some = (Some)option;
            fetchedData = fetchedData2 = (FetchedData)some.value();
        } else {
            throw new MatchError(option);
        }
        return fetchedData;
    }

    private String additionalMessage(TopicPartition topicPartition, String groupId, boolean failOnDataLoss) {
        return failOnDataLoss ? new StringBuilder(0).append(new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").toString()).append(String.valueOf(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE())).toString() : new StringBuilder(0).append(new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").toString()).append(String.valueOf(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE())).toString();
    }

    private void reportDataLoss(TopicPartition topicPartition, String groupId, boolean failOnDataLoss, String message, Throwable cause) {
        String finalMessage = new StringBuilder(1).append(message).append(" ").append(this.additionalMessage(topicPartition, groupId, failOnDataLoss)).toString();
        this.dataLoss_$eq(this.dataLoss() + 1L);
        KafkaDataConsumer$.MODULE$.org$apache$spark$sql$kafka010$consumer$KafkaDataConsumer$$reportDataLoss0(failOnDataLoss, finalMessage, cause);
    }

    private Throwable reportDataLoss$default$5() {
        return null;
    }

    private <T> T runUninterruptiblyIfPossible(Function0<T> body) {
        Object object;
        Thread thread = Thread.currentThread();
        if (thread instanceof UninterruptibleThread) {
            UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
            object = uninterruptibleThread.runUninterruptibly(body);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "KafkaDataConsumer is not running in UninterruptibleThread. It may hang when KafkaDataConsumer's methods are interrupted because of KAFKA-1894");
            object = body.apply();
        }
        return (T)object;
    }

    public KafkaDataConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams, InternalKafkaConsumerPool consumerPool, FetchedDataPool fetchedDataPool) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        this.consumerPool = consumerPool;
        this.fetchedDataPool = fetchedDataPool;
        Logging.$init$((Logging)this);
        this.offsetOutOfRange = 0L;
        this.dataLoss = 0L;
        this.isTokenProviderEnabled = HadoopDelegationTokenManager$.MODULE$.isServiceEnabled(SparkEnv$.MODULE$.get().conf(), "kafka");
        this._consumer = None$.MODULE$;
        this._fetchedData = None$.MODULE$;
        this.groupId = (String)kafkaParams.get("group.id");
        this.cacheKey = new CacheKey(this.groupId(), topicPartition);
        this.fetchedRecord = new FetchedRecord(null, KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET());
    }

    public static class AvailableOffsetRange
    implements Product,
    Serializable {
        private final long earliest;
        private final long latest;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long earliest() {
            return this.earliest;
        }

        public long latest() {
            return this.latest;
        }

        public AvailableOffsetRange copy(long earliest, long latest) {
            return new AvailableOffsetRange(earliest, latest);
        }

        public long copy$default$1() {
            return this.earliest();
        }

        public long copy$default$2() {
            return this.latest();
        }

        public String productPrefix() {
            return "AvailableOffsetRange";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.earliest());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.latest());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AvailableOffsetRange;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "earliest";
                    break;
                }
                case 1: {
                    string = "latest";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.earliest()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latest()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AvailableOffsetRange)) return false;
            boolean bl = true;
            if (!bl) return false;
            AvailableOffsetRange availableOffsetRange = (AvailableOffsetRange)x$1;
            if (this.earliest() != availableOffsetRange.earliest()) return false;
            if (this.latest() != availableOffsetRange.latest()) return false;
            if (!availableOffsetRange.canEqual(this)) return false;
            return true;
        }

        public AvailableOffsetRange(long earliest, long latest) {
            this.earliest = earliest;
            this.latest = latest;
            Product.$init$((Product)this);
        }
    }

    public static class CacheKey
    implements Product,
    Serializable {
        private final String groupId;
        private final TopicPartition topicPartition;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String groupId() {
            return this.groupId;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public CacheKey copy(String groupId, TopicPartition topicPartition) {
            return new CacheKey(groupId, topicPartition);
        }

        public String copy$default$1() {
            return this.groupId();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.groupId();
                    break;
                }
                case 1: {
                    object = this.topicPartition();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "groupId";
                    break;
                }
                case 1: {
                    string = "topicPartition";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.groupId();
            String string2 = cacheKey.groupId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = cacheKey.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String groupId, TopicPartition topicPartition) {
            this.groupId = groupId;
            this.topicPartition = topicPartition;
            Product.$init$((Product)this);
        }

        public CacheKey(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
            this((String)kafkaParams.get("group.id"), topicPartition);
        }
    }
}

