/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter$;
import org.apache.spark.sql.kafka010.KafkaSource$;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceOffset$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEe!\u0002\u001b6\u0001Uz\u0004\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"I\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005E\u0001BCA\f\u0001\t\u0005\t\u0015!\u0003\u0002\u001a!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002\"CA\u001b\u0001\t\u0007I\u0011BA\u001c\u0011!\t\t\u0005\u0001Q\u0001\n\u0005e\u0002\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\ti\u0005\u0001Q\u0001\n\u0005\u001d\u0003\"CA(\u0001\t\u0007I\u0011BA)\u0011!\tI\u0006\u0001Q\u0001\n\u0005M\u0003BCA.\u0001\t\u0007I\u0011A\u001b\u0002R!A\u0011Q\f\u0001!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0002`\u0001\u0011\r\u0011\"\u00016\u0003\u000bB\u0001\"!\u0019\u0001A\u0003%\u0011q\t\u0005\u000b\u0003G\u0002!\u0019!C\u0001k\u0005\u0015\u0004\u0002CA9\u0001\u0001\u0006I!a\u001a\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004\u0002CA<\u0001\u0001\u0006I!!\u0007\t\u0013\u0005e\u0004\u00011A\u0005\n\u0005\u0015\u0003\"CA>\u0001\u0001\u0007I\u0011BA?\u0011!\tI\t\u0001Q!\n\u0005\u001d\u0003BCAF\u0001!\u0015\r\u0011\"\u0003\u0002\u000e\"9\u00111\u0015\u0001\u0005B\u0005\u0015\u0006\"CAW\u0001\u0001\u0007I\u0011BAX\u0011%\t\u0019\f\u0001a\u0001\n\u0013\t)\f\u0003\u0005\u0002:\u0002\u0001\u000b\u0015BAY\u0011%\tY\f\u0001a\u0001\n\u0013\ty\u000bC\u0005\u0002>\u0002\u0001\r\u0011\"\u0003\u0002@\"A\u00111\u0019\u0001!B\u0013\t\t\fC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u0011q\u001a\u0001!\u0002\u0013\tI\rC\u0004\u0002R\u0002!\t%a5\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002d\"9\u0011Q\u001e\u0001\u0005B\u0005=\bbBA{\u0001\u0011\u0005\u0013q\u001f\u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqA!\t\u0001\t\u0003\u0012\u0019\u0003C\u0004\u0003L\u0001!\tE!\u0014\t\u000f\t=\u0003\u0001\"\u0011\u0003R!9!1\u000b\u0001\u0005\n\tU\u0003B\u0004B.\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\u0015&QL\u0004\t\u0005?*\u0004\u0012A\u001b\u0003b\u00199A'\u000eE\u0001k\t\r\u0004bBA\u0011a\u0011\u0005!1\u000e\u0005\b\u0005[\u0002D\u0011\u0001B8\u0011\u001d\u0011I\b\rC\u0005\u0005w\u00121bS1gW\u0006\u001cv.\u001e:dK*\u0011agN\u0001\tW\u000647.\u0019\u00192a)\u0011\u0001(O\u0001\u0004gFd'B\u0001\u001e<\u0003\u0015\u0019\b/\u0019:l\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\u0014\u000b\u0001\u0001\u0005JU-\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015\u0001\u00027b]\u001eT\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H\u0005\n1qJ\u00196fGR\u0004\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0013M$(/Z1nS:<'BA'O\u0003\u0011\u0011X-\u00193\u000b\u0005=;\u0014!C2p]:,7\r^8s\u0013\t\t&J\u0001\rTkB\u0004xN\u001d;t\u0003\u0012l\u0017n]:j_:\u001cuN\u001c;s_2\u0004\"aU,\u000e\u0003QS!aS+\u000b\u0005Y;\u0014!C3yK\u000e,H/[8o\u0013\tAFK\u0001\u0004T_V\u00148-\u001a\t\u00035vk\u0011a\u0017\u0006\u00039f\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=n\u0013q\u0001T8hO&tw-\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001\u0001\u0005\u0002cG6\tq'\u0003\u0002eo\tQ1+\u0015'D_:$X\r\u001f;\u0002\u0017-\fgm[1SK\u0006$WM\u001d\t\u0003O\"l\u0011!N\u0005\u0003SV\u0012\u0011cS1gW\u0006|eMZ:fiJ+\u0017\rZ3s\u0003M)\u00070Z2vi>\u00148*\u00194lCB\u000b'/Y7t!\u0011aw.\u001d!\u000e\u00035T!A\u001c#\u0002\tU$\u0018\u000e\\\u0005\u0003a6\u00141!T1q!\t\u00118P\u0004\u0002tsB\u0011Ao^\u0007\u0002k*\u0011a\u000fY\u0001\u0007yI|w\u000e\u001e \u000b\u0003a\fQa]2bY\u0006L!A_<\u0002\rA\u0013X\rZ3g\u0013\taXP\u0001\u0004TiJLgn\u001a\u0006\u0003u^\fQb]8ve\u000e,w\n\u001d;j_:\u001c\b#BA\u0001\u0003\u0013\tXBAA\u0002\u0015\rq\u0017Q\u0001\u0006\u0004\u0003\u000f9\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005-\u00111\u0001\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007/\u0001\u0007nKR\fG-\u0019;b!\u0006$\b.A\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;t!\r9\u00171C\u0005\u0004\u0003+)$!F&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0019&l\u0017\u000e^\u0001\u000fM\u0006LGn\u00148ECR\fGj\\:t!\u0011\tY\"!\b\u000e\u0003]L1!a\bx\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003EA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a!\t9\u0007\u0001C\u0003`\u0011\u0001\u0007\u0011\rC\u0003f\u0011\u0001\u0007a\rC\u0003k\u0011\u0001\u00071\u000eC\u0003\u007f\u0011\u0001\u0007q\u0010\u0003\u0004\u0002\u000e!\u0001\r!\u001d\u0005\b\u0003\u001fA\u0001\u0019AA\t\u0011\u001d\t9\u0002\u0003a\u0001\u00033\t!a]2\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003{i\u0011!O\u0005\u0004\u0003\u007fI$\u0001D*qCJ\\7i\u001c8uKb$\u0018aA:dA\u0005i\u0001o\u001c7m)&lWm\\;u\u001bN,\"!a\u0012\u0011\t\u0005m\u0011\u0011J\u0005\u0004\u0003\u0017:(\u0001\u0002'p]\u001e\fa\u0002]8mYRKW.Z8vi6\u001b\b%\u0001\u000bnCb|eMZ:fiN\u0004VM\u001d+sS\u001e<WM]\u000b\u0003\u0003'\u0002b!a\u0007\u0002V\u0005\u001d\u0013bAA,o\n1q\n\u001d;j_:\fQ#\\1y\u001f\u001a47/\u001a;t!\u0016\u0014HK]5hO\u0016\u0014\b%A\nnS:|eMZ:fiB+'\u000f\u0016:jO\u001e,'/\u0001\u000bnS:|eMZ:fiB+'\u000f\u0016:jO\u001e,'\u000fI\u0001\u0012[\u0006DHK]5hO\u0016\u0014H)\u001a7bs6\u001b\u0018AE7bqR\u0013\u0018nZ4fe\u0012+G.Y=Ng\u0002\nQa\u00197pG.,\"!a\u001a\u0011\t\u0005%\u0014QN\u0007\u0003\u0003WR!A\\\u001d\n\t\u0005=\u00141\u000e\u0002\u0006\u00072|7m[\u0001\u0007G2|7m\u001b\u0011\u0002\u001d%t7\r\\;eK\"+\u0017\rZ3sgV\u0011\u0011\u0011D\u0001\u0010S:\u001cG.\u001e3f\u0011\u0016\fG-\u001a:tA\u0005\tB.Y:u)JLwmZ3s\u001b&dG.[:\u0002+1\f7\u000f\u001e+sS\u001e<WM]'jY2L7o\u0018\u0013fcR!\u0011qPAC!\u0011\tY\"!!\n\u0007\u0005\ruO\u0001\u0003V]&$\b\"CAD1\u0005\u0005\t\u0019AA$\u0003\rAH%M\u0001\u0013Y\u0006\u001cH\u000f\u0016:jO\u001e,'/T5mY&\u001c\b%A\fj]&$\u0018.\u00197QCJ$\u0018\u000e^5p]>3gm]3ugV\u0011\u0011q\u0012\t\be\u0006E\u00151SA$\u0013\t\u0001X\u0010\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\r\r|W.\\8o\u0015\r\tijO\u0001\u0006W\u000647.Y\u0005\u0005\u0003C\u000b9J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002'\u001d,G\u000fR3gCVdGOU3bI2KW.\u001b;\u0015\u0005\u0005\u001d\u0006cA%\u0002*&\u0019\u00111\u0016&\u0003\u0013I+\u0017\r\u001a'j[&$\u0018aF2veJ,g\u000e\u001e)beRLG/[8o\u001f\u001a47/\u001a;t+\t\t\t\f\u0005\u0004\u0002\u001c\u0005U\u0013qR\u0001\u001cGV\u0014(/\u001a8u!\u0006\u0014H/\u001b;j_:|eMZ:fiN|F%Z9\u0015\t\u0005}\u0014q\u0017\u0005\n\u0003\u000fk\u0012\u0011!a\u0001\u0003c\u000b\u0001dY;se\u0016tG\u000fU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:!\u0003Ya\u0017\r^3tiB\u000b'\u000f^5uS>twJ\u001a4tKR\u001c\u0018A\u00077bi\u0016\u001cH\u000fU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:`I\u0015\fH\u0003BA@\u0003\u0003D\u0011\"a\"!\u0003\u0003\u0005\r!!-\u0002/1\fG/Z:u!\u0006\u0014H/\u001b;j_:|eMZ:fiN\u0004\u0013!C2p]Z,'\u000f^3s+\t\tI\rE\u0002h\u0003\u0017L1!!46\u0005eY\u0015MZ6b%\u0016\u001cwN\u001d3U_J{woQ8om\u0016\u0014H/\u001a:\u0002\u0015\r|gN^3si\u0016\u0014\b%\u0001\u0004tG\",W.Y\u000b\u0003\u0003+\u0004B!a6\u0002^6\u0011\u0011\u0011\u001c\u0006\u0004\u00037<\u0014!\u0002;za\u0016\u001c\u0018\u0002BAp\u00033\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003%9W\r^(gMN,G/\u0006\u0002\u0002fB1\u00111DA+\u0003O\u00042aUAu\u0013\r\tY\u000f\u0016\u0002\u0007\u001f\u001a47/\u001a;\u0002%I,\u0007o\u001c:u\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e\u000b\u0003\u0003c\u00042!SAz\u0013\r\tYOS\u0001\rY\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e\u000b\u0007\u0003c\fI0!@\t\u000f\u0005mx\u00051\u0001\u0002r\u0006Y1\u000f^1si>3gm]3u\u0011\u001d\typ\na\u0001\u0003O\u000bQ\u0001\\5nSR\f!\u0002Z3mCf\u0014\u0015\r^2i))\tIB!\u0002\u0003\n\t5!\u0011\u0003\u0005\b\u0005\u000fA\u0003\u0019AA$\u0003!i\u0017N\u001c'j[&$\bb\u0002B\u0006Q\u0001\u0007\u0011qR\u0001\u000eY\u0006$Xm\u001d;PM\u001a\u001cX\r^:\t\u000f\t=\u0001\u00061\u0001\u0002\u0010\u0006q1-\u001e:sK:$xJ\u001a4tKR\u001c\bbBA0Q\u0001\u0007\u0011qI\u0001\ne\u0006$X\rT5nSR$\u0002\"a$\u0003\u0018\te!Q\u0004\u0005\b\u0003\u007fL\u0003\u0019AA$\u0011\u001d\u0011Y\"\u000ba\u0001\u0003\u001f\u000bAA\u001a:p[\"9!qD\u0015A\u0002\u0005=\u0015!B;oi&d\u0017\u0001C4fi\n\u000bGo\u00195\u0015\r\t\u0015\"1\tB$!\u0011\u00119C!\u0010\u000f\t\t%\"\u0011\b\b\u0005\u0005W\u00119D\u0004\u0003\u0003.\tUb\u0002\u0002B\u0018\u0005gq1\u0001\u001eB\u0019\u0013\u0005q\u0014B\u0001\u001f>\u0013\tQ4(\u0003\u00029s%\u0019!1H\u001c\u0002\u000fA\f7m[1hK&!!q\bB!\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0003<]BqA!\u0012+\u0001\u0004\t)/A\u0003ti\u0006\u0014H\u000fC\u0004\u0003J)\u0002\r!a:\u0002\u0007\u0015tG-\u0001\u0003ti>\u0004HCAA@\u0003!!xn\u0015;sS:<G#A9\u0002\u001dI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgR!\u0011q\u0010B,\u0011\u0019\u0011I&\fa\u0001c\u00069Q.Z:tC\u001e,\u0017!G:va\u0016\u0014HeZ3u\t\u00164\u0017-\u001e7u%\u0016\fG\rT5nSRL1!a)Q\u0003-Y\u0015MZ6b'>,(oY3\u0011\u0005\u001d\u00044c\u0001\u0019\u0003fA!\u00111\u0004B4\u0013\r\u0011Ig\u001e\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0005\u0014!F4fiN{'\u000f^3e\u000bb,7-\u001e;pe2K7\u000f\u001e\u000b\u0005\u0005c\u00129\bE\u0003\u0002\u001c\tM\u0014/C\u0002\u0003v]\u0014Q!\u0011:sCfDq!!\u000e3\u0001\u0004\tI$A\u0004d_6\u0004\u0018M]3\u0015\r\u0005e!Q\u0010BG\u0011\u001d\u0011yh\ra\u0001\u0005\u0003\u000b\u0011!\u0019\t\u0005\u0005\u0007\u0013I)\u0004\u0002\u0003\u0006*\u0019!qQ\u001d\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0002\u0002BF\u0005\u000b\u0013\u0011$\u0012=fGV$xN]\"bG\",G+Y:l\u0019>\u001c\u0017\r^5p]\"9!qR\u001aA\u0002\t\u0005\u0015!\u00012")
public class KafkaSource
implements SupportsAdmissionControl,
Source,
Logging {
    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets;
    private final SQLContext sqlContext;
    private final KafkaOffsetReader kafkaReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final SparkContext sc;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private final boolean includeHeaders;
    private long lastTriggerMillis;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets;
    private final KafkaRecordToRowConverter converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String[] getSortedExecutorList(SparkContext sparkContext) {
        return KafkaSource$.MODULE$.getSortedExecutorList(sparkContext);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ ReadLimit super$getDefaultReadLimit() {
        return super.getDefaultReadLimit();
    }

    private SparkContext sc() {
        return this.sc;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    private Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets$lzycompute() {
        KafkaSource kafkaSource = this;
        synchronized (kafkaSource) {
            if (!this.bitmap$0) {
                KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialPartitionOffsets = ((KafkaSourceOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable)() -> {
                    void var3_12;
                    KafkaSourceOffset kafkaSourceOffset;
                    KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
                    if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchEarliestOffsets());
                    } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
                    } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                        SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
                            this.reportDataLoss(message);
                            return BoxedUnit.UNIT;
                        });
                    } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                        SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                        Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificTimestampBasedOffsets(p, true, strategy);
                    } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                        GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                        long ts = globalTimestampRangeLimit.timestamp();
                        Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchGlobalTimestampBasedOffsets(ts, true, strategy);
                    } else {
                        throw new MatchError((Object)kafkaOffsetRangeLimit);
                    }
                    KafkaSourceOffset offsets = kafkaSourceOffset;
                    metadataLog.add(0L, offsets);
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append(offsets).toString());
                    return var3_12;
                })).partitionToOffsets();
                this.bitmap$0 = true;
            }
        }
        return this.initialPartitionOffsets;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets() {
        return !this.bitmap$0 ? this.initialPartitionOffsets$lzycompute() : this.initialPartitionOffsets;
    }

    public ReadLimit getDefaultReadLimit() {
        return this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined() ? ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))}))) : (this.minOffsetPerTrigger().isDefined() ? ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()) : (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable)x$1 -> KafkaSource.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable)() -> this.super$getDefaultReadLimit()));
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets() {
        return this.currentPartitionOffsets;
    }

    private void currentPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.currentPartitionOffsets = x$1;
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private KafkaRecordToRowConverter converter() {
        return this.converter;
    }

    public StructType schema() {
        return KafkaRecordToRowConverter$.MODULE$.kafkaSchema(this.includeHeaders());
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset reportLatestOffset() {
        return (Offset)this.latestPartitionOffsets().map((Function1 & Serializable)x$3 -> new KafkaSourceOffset((scala.collection.immutable.Map<TopicPartition, Object>)x$3)).getOrElse((Function0 & Serializable)() -> null);
    }

    public Offset latestOffset(Offset startOffset, ReadLimit limit2) {
        scala.collection.immutable.Map map;
        IndexedSeq indexedSeq;
        this.initialPartitionOffsets();
        Option currentOffsets = this.currentPartitionOffsets().orElse((Function0 & Serializable)() -> new Some(this.initialPartitionOffsets()));
        scala.collection.immutable.Map latest = this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)currentOffsets);
        this.latestPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(latest));
        ReadLimit readLimit = limit2;
        if (readLimit instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit;
            indexedSeq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)compositeReadLimit.getReadLimits());
        } else {
            indexedSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReadLimit[]{readLimit}));
        }
        IndexedSeq limits = indexedSeq;
        if (limits.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$2(x$4)))) {
            map = latest;
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$3(x$5))).map((Function1 & Serializable)x$6 -> (ReadMinRows)x$6);
            Option upperLimit = limits.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$5(x$7))).map((Function1 & Serializable)x$8 -> (ReadMaxRows)x$8);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable)limit -> {
                None$ none$;
                boolean skipBatch = this.delayBatch(limit.minRows(), (scala.collection.immutable.Map<TopicPartition, Object>)latest, (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)currentOffsets.get()), limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    none$ = new Some(currentOffsets.get());
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable)() -> upperLimit.map((Function1 & Serializable)limit -> this.rateLimit(limit.maxRows(), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)this.currentPartitionOffsets().getOrElse((Function0 & Serializable)() -> this.initialPartitionOffsets())), (scala.collection.immutable.Map<TopicPartition, Object>)latest))).getOrElse((Function0 & Serializable)() -> latest);
        }
        scala.collection.immutable.Map offsets = map;
        this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(offsets));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("GetOffset: ").append(((SeqOps)offsets.toSeq().map((Function1 & Serializable)x$9 -> x$9.toString())).sorted((Ordering)Ordering.String$.MODULE$)).toString());
        return new KafkaSourceOffset(offsets);
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        boolean bl;
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            bl = false;
        } else {
            double newRecords = BoxesRunTime.unboxToLong((Object)((MapOps)latestOffsets.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Some some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))))));
                return some;
            })).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (newRecords < (double)minLimit) {
                bl = true;
            } else {
                this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
                bl = false;
            }
        }
        return bl;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Option option = from.get((Object)tp).orElse((Function0 & Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable)begin -> KafkaSource.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin)));
            return option;
        });
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("rateLimit ").append(tp).append(" prorated amount is ").append(prorate).toString());
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("rateLimit ").append(tp).append(" new offset is ").append(off).toString());
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> end));
            return tuple22;
        });
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start, org.apache.spark.sql.execution.streaming.Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        Option<org.apache.spark.sql.execution.streaming.Offset> option;
        this.initialPartitionOffsets();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("GetBatch called with start = ").append(start).append(", end = ").append(end).toString());
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = KafkaSourceOffset$.MODULE$.getPartitionOffsets(end);
        if (this.currentPartitionOffsets().isEmpty()) {
            this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(untilPartitionOffsets));
        }
        if (start.isDefined()) {
            Object object = start.get();
            org.apache.spark.sql.execution.streaming.Offset offset = end;
            if (!(object != null ? !object.equals(offset) : offset != null)) {
                return this.sqlContext.internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
            }
        }
        if ((option = start) instanceof Some) {
            Some some = (Some)option;
            org.apache.spark.sql.execution.streaming.Offset prevBatchEndOffset = (org.apache.spark.sql.execution.streaming.Offset)some.value();
            map = KafkaSourceOffset$.MODULE$.getPartitionOffsets(prevBatchEndOffset);
        } else if (None$.MODULE$.equals(option)) {
            map = this.initialPartitionOffsets();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = map;
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaReader.getOffsetRangesFromResolvedOffsets(fromPartitionOffsets, untilPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        RDD rdd = this.includeHeaders() ? new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithHeaders(), ClassTag$.MODULE$.apply(InternalRow.class)) : new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithoutHeaders(), ClassTag$.MODULE$.apply(InternalRow.class));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(((IterableOnceOps)offsetRanges.sortBy((Function1 & Serializable)x$10 -> x$10.topicPartition().toString(), (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString());
        return this.sqlContext.internalCreateDataFrame(rdd.setName("kafka"), this.schema(), true);
    }

    public synchronized void stop() {
        this.kafkaReader.close();
    }

    public String toString() {
        return new StringBuilder(15).append("KafkaSourceV1[").append(this.kafkaReader).append("]").toString();
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString()).toString());
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$4) {
        return x$4 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$3(ReadLimit x$5) {
        return x$5 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$5(ReadLimit x$7) {
        return x$7 instanceof ReadMaxRows;
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaReader.fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((Set)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        return fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaSource $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public KafkaSource(SQLContext sqlContext, KafkaOffsetReader kafkaReader, Map<String, Object> executorKafkaParams, CaseInsensitiveMap<String> sourceOptions, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.sqlContext = sqlContext;
        this.kafkaReader = kafkaReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        this.sc = sqlContext.sparkContext();
        this.pollTimeoutMs = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), (Function0 & Serializable)() -> Long.toString(BoxesRunTime.unboxToLong((Object)this.sc().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L))));
        this.maxOffsetsPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$1))));
        this.minOffsetPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$2))));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY()).getOrElse((Function0 & Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = sourceOptions.contains(KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.includeHeaders = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), (Function0 & Serializable)() -> "false")));
        this.lastTriggerMillis = 0L;
        this.currentPartitionOffsets = None$.MODULE$;
        this.latestPartitionOffsets = None$.MODULE$;
        this.converter = new KafkaRecordToRowConverter();
    }
}

