/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaWriter$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005eaA\u0002\b\u0010\u0003\u0003y\u0011\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003#\u0011!1\u0004A!A!\u0002\u00139\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005\"\u0003%\u0001\u0001\u0004\u0005\r\u0011\"\u0005J\u0011%i\u0005\u00011AA\u0002\u0013Ea\nC\u0005U\u0001\u0001\u0007\t\u0011)Q\u0005\u0015\"9\u0011\f\u0001b\u0001\n#Q\u0006B\u00020\u0001A\u0003%1\fC\u0004`\u0001\t\u0007I\u0011\u00021\t\r\u0011\u0004\u0001\u0015!\u0003b\u0011\u00159\b\u0001\"\u0005y\u0011\u001d\t\u0019\u0002\u0001C\t\u0003+Aa!a\u0006\u0001\t\u0013Q&AD&bM.\f'k\\<Xe&$XM\u001d\u0006\u0003!E\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003%M\t1a]9m\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u0006Y\u0011N\u001c9viN\u001b\u0007.Z7b\u0007\u0001\u00012aI\u0016/\u001d\t!\u0013F\u0004\u0002&Q5\taE\u0003\u0002(C\u00051AH]8pizJ\u0011!H\u0005\u0003Uq\tq\u0001]1dW\u0006<W-\u0003\u0002-[\t\u00191+Z9\u000b\u0005)b\u0002CA\u00185\u001b\u0005\u0001$BA\u00193\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005M\n\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005U\u0002$!C!uiJL'-\u001e;f\u0003\u0015!x\u000e]5d!\rY\u0002HO\u0005\u0003sq\u0011aa\u00149uS>t\u0007CA\u001e@\u001d\taT\b\u0005\u0002&9%\u0011a\bH\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?9\u00051A(\u001b8jiz\"2\u0001\u0012$H!\t)\u0005!D\u0001\u0010\u0011\u0015\u00013\u00011\u0001#\u0011\u001514\u00011\u00018\u0003-1\u0017-\u001b7fI^\u0013\u0018\u000e^3\u0016\u0003)\u0003\"aI&\n\u00051k#!C#yG\u0016\u0004H/[8o\u0003=1\u0017-\u001b7fI^\u0013\u0018\u000e^3`I\u0015\fHCA(S!\tY\u0002+\u0003\u0002R9\t!QK\\5u\u0011\u001d\u0019V!!AA\u0002)\u000b1\u0001\u001f\u00132\u000311\u0017-\u001b7fI^\u0013\u0018\u000e^3!Q\t1a\u000b\u0005\u0002\u001c/&\u0011\u0001\f\b\u0002\tm>d\u0017\r^5mK\u0006Q\u0001O]8kK\u000e$\u0018n\u001c8\u0016\u0003m\u0003\"a\f/\n\u0005u\u0003$\u0001E+og\u00064W\r\u0015:pU\u0016\u001cG/[8o\u0003-\u0001(o\u001c6fGRLwN\u001c\u0011\u0002\u0011\r\fG\u000e\u001c2bG.,\u0012!\u0019\n\u0004E\u0016lg\u0001B2\u000b\u0001\u0005\u0014A\u0002\u0010:fM&tW-\\3oiz\n\u0011bY1mY\n\f7m\u001b\u0011\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017\u0001\u00027b]\u001eT\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\n1qJ\u00196fGR\u0004\"A\\;\u000e\u0003=T!\u0001]9\u0002\u0011A\u0014x\u000eZ;dKJT!A]:\u0002\u000f\rd\u0017.\u001a8ug*\u0011A/F\u0001\u0006W\u000647.Y\u0005\u0003m>\u0014\u0001bQ1mY\n\f7m[\u0001\bg\u0016tGMU8x)\ry\u0015p \u0005\u0006u.\u0001\ra_\u0001\u0004e><\bC\u0001?~\u001b\u0005\u0011\u0014B\u0001@3\u0005-Ie\u000e^3s]\u0006d'k\\<\t\rA\\\u0001\u0019AA\u0001!\u001dq\u00171AA\u0004\u0003\u000fI1!!\u0002p\u00055Y\u0015MZ6b!J|G-^2feB)1$!\u0003\u0002\u000e%\u0019\u00111\u0002\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0007m\ty!C\u0002\u0002\u0012q\u0011AAQ=uK\u0006q1\r[3dW\u001a{'/\u0012:s_J\u001cH#A(\u0002!\r\u0014X-\u0019;f!J|'.Z2uS>t\u0007")
public abstract class KafkaRowWriter {
    private final Seq<Attribute> inputSchema;
    private final Option<String> topic;
    private volatile Exception failedWrite;
    private final UnsafeProjection projection;
    private final Callback callback;

    public Exception failedWrite() {
        return this.failedWrite;
    }

    public void failedWrite_$eq(Exception x$1) {
        this.failedWrite = x$1;
    }

    public UnsafeProjection projection() {
        return this.projection;
    }

    private Callback callback() {
        return this.callback;
    }

    public void sendRow(InternalRow row, KafkaProducer<byte[], byte[]> producer) {
        ProducerRecord producerRecord;
        Integer partition;
        UnsafeRow projectedRow = this.projection().apply(row);
        UTF8String topic = projectedRow.getUTF8String(0);
        byte[] key = projectedRow.getBinary(1);
        byte[] value = projectedRow.getBinary(2);
        if (topic == null) {
            throw new NullPointerException(new StringBuilder(76).append("null topic present in the data. Use the ").append(KafkaSourceProvider$.MODULE$.TOPIC_OPTION_KEY()).append(" option for setting a default topic.").toString());
        }
        Integer n = partition = projectedRow.isNullAt(4) ? null : Predef$.MODULE$.int2Integer(projectedRow.getInt(4));
        if (projectedRow.isNullAt(3)) {
            producerRecord = new ProducerRecord(topic.toString(), partition, (Object)key, (Object)value);
        } else {
            UnsafeArrayData headerArray = projectedRow.getArray(3);
            IndexedSeq headers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), headerArray.numElements()).map((Function1 & Serializable & scala.Serializable)i -> KafkaRowWriter.$anonfun$sendRow$1(headerArray, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producerRecord = new ProducerRecord(topic.toString(), partition, (Object)key, (Object)value, (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)headers).asJava());
        }
        ProducerRecord record = producerRecord;
        producer.send(record, this.callback());
    }

    public void checkForErrors() {
        if (this.failedWrite() != null) {
            throw this.failedWrite();
        }
    }

    private UnsafeProjection createProjection() {
        return UnsafeProjection$.MODULE$.create((Seq)new .colon.colon((Object)KafkaWriter$.MODULE$.topicExpression(this.inputSchema, this.topic), (List)new .colon.colon((Object)new Cast(KafkaWriter$.MODULE$.keyExpression(this.inputSchema), (DataType)BinaryType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new Cast(KafkaWriter$.MODULE$.valueExpression(this.inputSchema), (DataType)BinaryType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)KafkaWriter$.MODULE$.headersExpression(this.inputSchema), (List)new .colon.colon((Object)KafkaWriter$.MODULE$.partitionExpression(this.inputSchema), (List)Nil$.MODULE$))))), this.inputSchema);
    }

    public static final /* synthetic */ Header $anonfun$sendRow$1(UnsafeArrayData headerArray$1, int i) {
        UnsafeRow struct = headerArray$1.getStruct(i, 2);
        return new RecordHeader(struct.getUTF8String(0).toString(), struct.getBinary(1));
    }

    public KafkaRowWriter(Seq<Attribute> inputSchema, Option<String> topic) {
        this.inputSchema = inputSchema;
        this.topic = topic;
        this.projection = this.createProjection();
        this.callback = new Callback(this){
            private final /* synthetic */ KafkaRowWriter $outer;

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
                if (this.$outer.failedWrite() == null && e != null) {
                    this.$outer.failedWrite_$eq(e);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

