/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.logging;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.pipelines.common.FlowStatus;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.QueryOrigin$;
import org.apache.spark.sql.pipelines.logging.ConstructPipelineEvent$;
import org.apache.spark.sql.pipelines.logging.EventDetails;
import org.apache.spark.sql.pipelines.logging.EventLevel;
import org.apache.spark.sql.pipelines.logging.FlowProgress;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.logging.PipelineEventOrigin;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}1AAA\u0002\u0001!!)1\u0004\u0001C\u00019\tY2i\u001c8tiJ,8\r\u001e)ja\u0016d\u0017N\\3Fm\u0016tGoU;ji\u0016T!\u0001B\u0003\u0002\u000f1|wmZ5oO*\u0011aaB\u0001\na&\u0004X\r\\5oKNT!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u00192\u0001A\t\u0016!\t\u00112#D\u0001\n\u0013\t!\u0012BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003-ei\u0011a\u0006\u0006\u000315\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005i9\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0002")
public class ConstructPipelineEventSuite
extends SparkFunSuite {
    public ConstructPipelineEventSuite() {
        this.test("Basic event construction", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Timestamp ts = new Timestamp(1747338049615L);
            Some x$1 = new Some((Object)"path");
            None$ x$2 = None$.MODULE$;
            None$ x$3 = None$.MODULE$;
            Option x$4 = QueryOrigin$.MODULE$.apply$default$1();
            Option x$5 = QueryOrigin$.MODULE$.apply$default$3();
            Option x$6 = QueryOrigin$.MODULE$.apply$default$6();
            Option x$7 = QueryOrigin$.MODULE$.apply$default$7();
            PipelineEventOrigin x$8 = new PipelineEventOrigin((Option)new Some((Object)"dataset"), (Option)new Some((Object)"flow"), (Option)new Some((Object)new QueryOrigin(x$4, (Option)x$1, x$5, (Option)x$2, (Option)x$3, x$6, x$7)));
            EventLevel.INFO$ x$9 = EventLevel.INFO$.MODULE$;
            String x$10 = "Flow 'b' has failed";
            FlowProgress x$11 = new FlowProgress((FlowStatus)FlowStatus.FAILED$.MODULE$);
            Some x$12 = new Some((Object)ts);
            Option x$13 = ConstructPipelineEvent$.MODULE$.apply$default$5();
            PipelineEvent event = ConstructPipelineEvent$.MODULE$.apply(x$8, (EventLevel)x$9, "Flow 'b' has failed", (EventDetails)x$11, x$13, (Option)x$12);
            Option $org_scalatest_assert_macro_left = event.origin().datasetName();
            String $org_scalatest_assert_macro_right = "dataset";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            Option $org_scalatest_assert_macro_left2 = event.origin().flowName();
            String $org_scalatest_assert_macro_right2 = "flow";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            Option $org_scalatest_assert_macro_left3 = ((QueryOrigin)event.origin().sourceCodeLocation().get()).filePath();
            String $org_scalatest_assert_macro_right3 = "path";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            EventLevel $org_scalatest_assert_macro_left4 = event.level();
            EventLevel.INFO$ $org_scalatest_assert_macro_right4 = EventLevel.INFO$.MODULE$;
            EventLevel eventLevel = $org_scalatest_assert_macro_left4;
            EventLevel.INFO$ iNFO$ = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(eventLevel != null ? !eventLevel.equals(iNFO$) : iNFO$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            String $org_scalatest_assert_macro_left5 = event.message();
            String $org_scalatest_assert_macro_right5 = "Flow 'b' has failed";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            FlowStatus $org_scalatest_assert_macro_left6 = ((FlowProgress)event.details()).status();
            FlowStatus.FAILED$ $org_scalatest_assert_macro_right6 = FlowStatus.FAILED$.MODULE$;
            FlowStatus flowStatus = $org_scalatest_assert_macro_left6;
            FlowStatus.FAILED$ fAILED$ = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(flowStatus != null ? !flowStatus.equals(fAILED$) : fAILED$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Timestamp $org_scalatest_assert_macro_left7 = event.timestamp();
            Timestamp $org_scalatest_assert_macro_right7 = ts;
            Timestamp timestamp = $org_scalatest_assert_macro_left7;
            Timestamp timestamp2 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(timestamp != null ? !((Object)timestamp).equals(timestamp2) : timestamp2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        }, new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("basic flow progress event has expected fields set", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option x$14 = Option$.MODULE$.apply((Object)"a");
            None$ x$15 = None$.MODULE$;
            None$ x$16 = None$.MODULE$;
            PipelineEventOrigin x$17 = new PipelineEventOrigin((Option)x$15, x$14, (Option)x$16);
            String x$18 = "Flow 'a' has completed";
            FlowProgress x$19 = new FlowProgress((FlowStatus)FlowStatus.COMPLETED$.MODULE$);
            EventLevel.INFO$ x$20 = EventLevel.INFO$.MODULE$;
            Option x$21 = ConstructPipelineEvent$.MODULE$.apply$default$5();
            Option x$22 = ConstructPipelineEvent$.MODULE$.apply$default$6();
            PipelineEvent event = ConstructPipelineEvent$.MODULE$.apply(x$17, (EventLevel)x$20, "Flow 'a' has completed", (EventDetails)x$19, x$21, x$22);
            String $org_scalatest_assert_macro_left = event.message();
            String $org_scalatest_assert_macro_right = "Flow 'a' has completed";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            EventDetails $org_scalatest_assert_macro_left2 = event.details();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.pipelines.logging.FlowProgress", $org_scalatest_assert_macro_left2 instanceof FlowProgress, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            Option $org_scalatest_assert_macro_left3 = event.origin().flowName();
            Option $org_scalatest_assert_macro_right2 = Option$.MODULE$.apply((Object)"a");
            Option option = $org_scalatest_assert_macro_left3;
            Option option2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            EventLevel $org_scalatest_assert_macro_left4 = event.level();
            EventLevel.INFO$ $org_scalatest_assert_macro_right3 = EventLevel.INFO$.MODULE$;
            EventLevel eventLevel = $org_scalatest_assert_macro_left4;
            EventLevel.INFO$ iNFO$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(eventLevel != null ? !eventLevel.equals(iNFO$) : iNFO$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("ConstructPipelineEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }
}

