/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.pipelines.common.FlowStatus;
import org.apache.spark.sql.pipelines.common.RunState;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.GraphExecution;
import org.apache.spark.sql.pipelines.graph.PersistedView;
import org.apache.spark.sql.pipelines.graph.UnresolvedPipelineException;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.sql.pipelines.logging.EventLevel;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.utils.EventVerificationTestHelpers;
import org.apache.spark.sql.pipelines.utils.ExecutionTest;
import org.apache.spark.sql.pipelines.utils.PipelineRunEventBuffer;
import org.apache.spark.sql.pipelines.utils.PipelineTest;
import org.apache.spark.sql.pipelines.utils.TestPipelineUpdateContextMixin;
import org.apache.spark.sql.pipelines.utils.TestPipelineUpdateContextMixin$TestPipelineUpdateContext$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Y3A\u0001C\u0005\u0001-!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0013Y\u0003B\u0002\u001a\u0001A\u0003%A\u0006C\u00034\u0001\u0011\u0005C\u0007C\u0003<\u0001\u0011\u0005C\u0007C\u0003=\u0001\u0011%Q\bC\u0003S\u0001\u0011%1KA\u0005WS\u0016<8+^5uK*\u0011!bC\u0001\u0006OJ\f\u0007\u000f\u001b\u0006\u0003\u00195\t\u0011\u0002]5qK2Lg.Z:\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\u0006gB\f'o\u001b\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00019R\u0004\t\t\u00031mi\u0011!\u0007\u0006\u00035-\tQ!\u001e;jYNL!\u0001H\r\u0003\u0019AK\u0007/\u001a7j]\u0016$Vm\u001d;\u0011\u0005aq\u0012BA\u0010\u001a\u00055)\u00050Z2vi&|g\u000eV3tiB\u0011\u0011\u0005J\u0007\u0002E)\u00111%D\u0001\u0005i\u0016\u001cH/\u0003\u0002&E\t\u00112\u000b[1sK\u0012\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\t\u0011\"A\nfqR,'O\\1m)\u0006\u0014G.Z\u0019JI\u0016tG/F\u0001-!\ti\u0003'D\u0001/\u0015\tyS\"\u0001\u0005dCR\fG._:u\u0013\t\tdFA\bUC\ndW-\u00133f]RLg-[3s\u0003Q)\u0007\u0010^3s]\u0006dG+\u00192mKFJE-\u001a8uA\u0005Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012A!\u00168ji\u0006I\u0011M\u001a;fe\u0016\u000b7\r[\u0001\u001cm\u0016\u0014\u0018NZ=QKJ\u001c\u0018n\u001d;fIZKWm^'fi\u0006$\u0017\r^1\u0015\u0007Ur$\tC\u0003\u000b\r\u0001\u0007q\b\u0005\u0002*\u0001&\u0011\u0011)\u0003\u0002\u000e\t\u0006$\u0018M\u001a7po\u001e\u0013\u0018\r\u001d5\t\u000b\r3\u0001\u0019\u0001#\u0002\u0019YLWm^'fi\u0006$\u0017\r^1\u0011\t\u0015cEf\u0014\b\u0003\r*\u0003\"aR\u001c\u000e\u0003!S!!S\u000b\u0002\rq\u0012xn\u001c;?\u0013\tYu'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u00131!T1q\u0015\tYu\u0007\u0005\u0002F!&\u0011\u0011K\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002!\t,\u0018\u000e\u001c3TK2,7\r^)vKJLHCA(U\u0011\u0015)v\u00011\u0001-\u0003)IG-\u001a8uS\u001aLWM\u001d")
public class ViewSuite
extends PipelineTest
implements ExecutionTest,
SharedSparkSession {
    private final TableIdentifier externalTable1Ident;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private volatile TestPipelineUpdateContextMixin$TestPipelineUpdateContext$ TestPipelineUpdateContext$module;

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$((SharedSparkSessionBase)this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$((SharedSparkSession)this);
    }

    public void afterAll() {
        SharedSparkSession.afterAll$((SharedSparkSession)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        super.beforeEach();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        super.afterEach();
    }

    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$((SharedSparkSessionBase)this);
    }

    public SparkSession spark() {
        return SharedSparkSessionBase.spark$((SharedSparkSessionBase)this);
    }

    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$((SharedSparkSessionBase)this);
    }

    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$((SharedSparkSessionBase)this);
    }

    public SQLConf sqlConf() {
        return SharedSparkSessionBase.sqlConf$((SharedSparkSessionBase)this);
    }

    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$((SharedSparkSessionBase)this);
    }

    @Override
    public void assertFlowProgressEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, FlowStatus expectedFlowStatus, EventLevel expectedEventLevel, Function1<Throwable, Object> errorChecker, Function1<String, Object> msgChecker, Function1<PipelineEvent, Object> cond, Option<Object> expectedNumOfEvents) {
        EventVerificationTestHelpers.assertFlowProgressEvent$(this, eventBuffer, identifier, expectedFlowStatus, expectedEventLevel, errorChecker, msgChecker, cond, expectedNumOfEvents);
    }

    @Override
    public Function1<Throwable, Object> assertFlowProgressEvent$default$5() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$5$(this);
    }

    @Override
    public Function1<String, Object> assertFlowProgressEvent$default$6() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$6$(this);
    }

    @Override
    public Function1<PipelineEvent, Object> assertFlowProgressEvent$default$7() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$7$(this);
    }

    @Override
    public Option<Object> assertFlowProgressEvent$default$8() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$8$(this);
    }

    @Override
    public void assertFlowProgressStatusInOrder(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, Seq<Tuple2<EventLevel, FlowStatus>> expectedFlowProgressStatus) {
        EventVerificationTestHelpers.assertFlowProgressStatusInOrder$(this, eventBuffer, identifier, expectedFlowProgressStatus);
    }

    @Override
    public void assertNoFlowProgressEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, FlowStatus flowStatus) {
        EventVerificationTestHelpers.assertNoFlowProgressEvent$(this, eventBuffer, identifier, flowStatus);
    }

    @Override
    public Map<String, FlowStatus> latestFlowStatuses(PipelineRunEventBuffer eventBuffer) {
        return EventVerificationTestHelpers.latestFlowStatuses$(this, eventBuffer);
    }

    @Override
    public void assertPlanningEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier) {
        EventVerificationTestHelpers.assertPlanningEvent$(this, eventBuffer, identifier);
    }

    @Override
    public void assertRunProgressEvent(PipelineRunEventBuffer eventBuffer, RunState state, EventLevel expectedEventLevel, Function1<Option<Throwable>, Object> errorChecker, Function1<String, Object> msgChecker) {
        EventVerificationTestHelpers.assertRunProgressEvent$(this, eventBuffer, state, expectedEventLevel, errorChecker, msgChecker);
    }

    @Override
    public Function1<Option<Throwable>, Object> assertRunProgressEvent$default$4() {
        return EventVerificationTestHelpers.assertRunProgressEvent$default$4$(this);
    }

    @Override
    public Function1<String, Object> assertRunProgressEvent$default$5() {
        return EventVerificationTestHelpers.assertRunProgressEvent$default$5$(this);
    }

    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public TestPipelineUpdateContextMixin$TestPipelineUpdateContext$ TestPipelineUpdateContext() {
        if (this.TestPipelineUpdateContext$module == null) {
            this.TestPipelineUpdateContext$lzycompute$1();
        }
        return this.TestPipelineUpdateContext$module;
    }

    private TableIdentifier externalTable1Ident() {
        return this.externalTable1Ident;
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$((SharedSparkSessionBase)this);
        this.spark().sql("CREATE TABLE " + this.externalTable1Ident() + " AS SELECT * FROM RANGE(3)");
    }

    @Override
    public void afterEach() {
        this.spark().sql("DROP TABLE IF EXISTS " + this.externalTable1Ident());
        SharedSparkSessionBase.afterEach$((SharedSparkSessionBase)this);
    }

    private void verifyPersistedViewMetadata(DataflowGraph graph, Map<TableIdentifier, String> viewMetadata) {
        viewMetadata.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Bool bool;
                View view;
                TableIdentifier key = (TableIdentifier)tuple2._1();
                String value = (String)tuple2._2();
                Option viewOpt = graph.view().get((Object)key);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(viewOpt.isDefined(), "viewOpt.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
                View $org_scalatest_assert_macro_left = view = (View)viewOpt.get();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.pipelines.graph.PersistedView", $org_scalatest_assert_macro_left instanceof PersistedView, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.simpleMacroBool(view.sqlText().isDefined(), "view.sqlText.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    String $org_scalatest_assert_macro_left3 = (String)view.sqlText().get();
                    String $org_scalatest_assert_macro_right = value;
                    String string = $org_scalatest_assert_macro_left3;
                    String string2 = $org_scalatest_assert_macro_right;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String buildSelectQuery(TableIdentifier identifier) {
        return "SELECT * FROM " + identifier;
    }

    private final void TestPipelineUpdateContext$lzycompute$1() {
        ViewSuite viewSuite = this;
        synchronized (viewSuite) {
            if (this.TestPipelineUpdateContext$module == null) {
                this.TestPipelineUpdateContext$module = new TestPipelineUpdateContextMixin$TestPipelineUpdateContext$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$16(Throwable x$1) {
        return x$1.getMessage().contains("CREATE_PERMANENT_VIEW_WITHOUT_ALIAS");
    }

    public ViewSuite() {
        TestPipelineUpdateContextMixin.$init$(this);
        EventVerificationTestHelpers.$init$(this);
        SharedSparkSessionBase.$init$((SharedSparkSessionBase)this);
        SharedSparkSession.$init$((SharedSparkSession)this);
        this.externalTable1Ident = this.fullyQualifiedIdentifier("external_t1", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
        this.test("create persisted views", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            String viewName = "mypersistedview";
            TableIdentifier viewIdentifier = this.fullyQualifiedIdentifier(viewName, this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql("CREATE VIEW " + viewName + " AS SELECT * FROM range(1, 4);", this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().startPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            DataflowGraph executedGraph = ((GraphExecution)updateContext.pipelineExecution().graphExecution().get()).graphForExecution();
            this.verifyPersistedViewMetadata(executedGraph, (Map<TableIdentifier, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)viewIdentifier), (Object)"SELECT * FROM range(1, 4)")}))));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + viewIdentifier), (Dataset)session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})), session.implicits().newLongEncoder()).toDF());
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("persisted view reads from external table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            String viewName = "mypersistedview";
            TableIdentifier viewIdentifier = this.fullyQualifiedIdentifier(viewName, this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier tableIdentifier = this.fullyQualifiedIdentifier("mytable", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            this.spark().sql("CREATE TABLE " + tableIdentifier + " AS SELECT * FROM range(1, 4)");
            String source = tableIdentifier.toString();
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql("CREATE VIEW " + viewName + " AS SELECT * FROM " + source + ";", this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().startPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            DataflowGraph graph = ((GraphExecution)updateContext.pipelineExecution().graphExecution().get()).graphForExecution();
            this.verifyPersistedViewMetadata(graph, (Map<TableIdentifier, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)viewIdentifier), (Object)("SELECT * FROM " + source))}))));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + viewIdentifier), (Dataset)session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})), session.implicits().newLongEncoder()).toDF());
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("persisted view reads from a temporary view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String viewName = "pv";
            TableIdentifier pv = this.fullyQualifiedIdentifier(viewName, this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TEMPORARY VIEW temp_view AS SELECT * FROM range(1, 4);\n                   |CREATE VIEW " + viewName + " AS SELECT * FROM temp_view;")), this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            AnalysisException ex = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                updateContext.pipelineExecution().startPipeline();
                updateContext.pipelineExecution().awaitCompletion();
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            this.assertAnalysisException((Throwable)ex, "INVALID_TEMP_OBJ_REFERENCE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objName"), (Object)pv.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"obj"), (Object)"view"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObjName"), (Object)"`temp_view`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObj"), (Object)"temporary view")}))));
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("persisted view reads from a non-existent dataset", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql("CREATE VIEW myview AS SELECT * FROM nonexistent_view;", this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            Exception ex = (Exception)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                updateContext.pipelineExecution().startPipeline();
                updateContext.pipelineExecution().awaitCompletion();
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            Exception exception = ex;
            if (exception instanceof UnresolvedPipelineException) {
                UnresolvedPipelineException unresolvedPipelineException = (UnresolvedPipelineException)exception;
                Set $org_scalatest_assert_macro_left = unresolvedPipelineException.directFailures().keySet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("myview", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            }
            throw this.fail("Unexpected error", ex, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("persisted view reads from a streaming source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String viewName = "mypersistedview";
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE STREAMING TABLE source AS SELECT * FROM STREAM(" + this.externalTable1Ident() + ");\n                   |CREATE VIEW " + viewName + " AS SELECT * FROM STREAM(source);")), this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            AnalysisException ex = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                updateContext.pipelineExecution().startPipeline();
                updateContext.pipelineExecution().awaitCompletion();
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            this.assertAnalysisException((Throwable)ex, "INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_PERSISTED_VIEW");
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("persisted view reads from an external streaming source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String viewName = "mypersistedview";
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql("CREATE VIEW " + viewName + " AS SELECT * FROM STREAM(" + this.externalTable1Ident() + ");", this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            AnalysisException ex = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                updateContext.pipelineExecution().startPipeline();
                updateContext.pipelineExecution().awaitCompletion();
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            this.assertAnalysisException((Throwable)ex, "INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_PERSISTED_VIEW");
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("persisted view reads from another persisted view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE VIEW pv3 AS SELECT * FROM pv2;\n                   |CREATE VIEW pv2 AS SELECT * FROM pv1;\n                   |CREATE VIEW pv1 AS SELECT * FROM range(1, 4);")), this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().startPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            DataflowGraph graph = ((GraphExecution)updateContext.pipelineExecution().graphExecution().get()).graphForExecution();
            this.verifyPersistedViewMetadata(graph, (Map<TableIdentifier, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fullyQualifiedIdentifier("pv1", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())), (Object)"SELECT * FROM range(1, 4)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fullyQualifiedIdentifier("pv2", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())), (Object)"SELECT * FROM pv1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fullyQualifiedIdentifier("pv3", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())), (Object)"SELECT * FROM pv2")}))));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql(this.buildSelectQuery(this.fullyQualifiedIdentifier("pv3", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))), (Dataset)session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})), session.implicits().newLongEncoder()).toDF());
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("persisted view reads from a failed persisted view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE VIEW pv2 AS SELECT * FROM pv1;\n        |CREATE VIEW pv1 AS SELECT 1 + 1;")), this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().startPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            this.assertFlowProgressEvent(updateContext.eventBuffer(), this.fullyQualifiedIdentifier("pv1", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), (FlowStatus)FlowStatus.FAILED$.MODULE$, (EventLevel)EventLevel.ERROR$.MODULE$, (Function1<Throwable, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ViewSuite.$anonfun$new$16(x$1)), this.assertFlowProgressEvent$default$6(), this.assertFlowProgressEvent$default$7(), this.assertFlowProgressEvent$default$8());
            this.assertFlowProgressEvent(updateContext.eventBuffer(), this.fullyQualifiedIdentifier("pv2", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), (FlowStatus)FlowStatus.SKIPPED$.MODULE$, (EventLevel)EventLevel.INFO$.MODULE$, this.assertFlowProgressEvent$default$5(), this.assertFlowProgressEvent$default$6(), this.assertFlowProgressEvent$default$7(), this.assertFlowProgressEvent$default$8());
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        this.test("persisted view reads from MV", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            String viewName = "mypersistedview";
            TableIdentifier viewIdentifier = this.fullyQualifiedIdentifier(viewName, this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier mvIdentifier = this.fullyQualifiedIdentifier("mymv", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            String source = mvIdentifier.toString();
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE MATERIALIZED VIEW mymv AS SELECT * FROM RANGE(1, 4);\n                   |CREATE VIEW " + viewName + " AS SELECT * FROM " + source + ";")), this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().startPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            DataflowGraph graph = ((GraphExecution)updateContext.pipelineExecution().graphExecution().get()).graphForExecution();
            this.verifyPersistedViewMetadata(graph, (Map<TableIdentifier, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)viewIdentifier), (Object)("SELECT * FROM " + source))}))));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + viewIdentifier), (Dataset)session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})), session.implicits().newLongEncoder()).toDF());
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("persisted view reads from ST", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            String viewName = "mypersistedview";
            TableIdentifier viewIdentifier = this.fullyQualifiedIdentifier(viewName, this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier stIdentifier = this.fullyQualifiedIdentifier("myst", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            String source = stIdentifier.toString();
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE STREAMING TABLE myst AS SELECT * FROM STREAM(" + this.externalTable1Ident() + ");\n                   |CREATE VIEW " + viewName + " AS SELECT * FROM " + source + ";")), this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().startPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            DataflowGraph graph = ((GraphExecution)updateContext.pipelineExecution().graphExecution().get()).graphForExecution();
            this.verifyPersistedViewMetadata(graph, (Map<TableIdentifier, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)viewIdentifier), (Object)("SELECT * FROM " + source))}))));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + viewIdentifier), (Dataset)session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L})), session.implicits().newLongEncoder()).toDF());
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("mv reading from a persisted view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            String viewName = "pv";
            TableIdentifier viewIdentifier = this.fullyQualifiedIdentifier(viewName, this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE VIEW " + viewName + " AS SELECT * FROM range(1, 4);\n        |CREATE MATERIALIZED VIEW myviewreader AS SELECT * FROM " + viewName + ";")), this.unresolvedDataflowGraphFromSql$default$2());
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext(this, this.spark(), unresolvedDataflowGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().startPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            DataflowGraph graph = ((GraphExecution)updateContext.pipelineExecution().graphExecution().get()).graphForExecution();
            this.verifyPersistedViewMetadata(graph, (Map<TableIdentifier, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)viewIdentifier), (Object)"SELECT * FROM range(1, 4)")}))));
            String q = this.buildSelectQuery(this.fullyQualifiedIdentifier("myviewreader", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql(q), (Dataset)session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})), session.implicits().newLongEncoder()).toDF());
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + viewIdentifier), (Dataset)session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})), session.implicits().newLongEncoder()).toDF());
        }, new Position("ViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        Statics.releaseFence();
    }
}

