/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.execution.streaming.runtime.MemoryStream;
import org.apache.spark.sql.execution.streaming.runtime.MemoryStream$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.pipelines.graph.CircularDependencyException;
import org.apache.spark.sql.pipelines.graph.ConnectInvalidPipelineSuite;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.FlowFunction;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.UnresolvedDatasetException;
import org.apache.spark.sql.pipelines.graph.UnresolvedPipelineException;
import org.apache.spark.sql.pipelines.utils.PipelineTest;
import org.apache.spark.sql.pipelines.utils.TestGraphRegistrationContext;
import org.apache.spark.sql.pipelines.utils.TestGraphRegistrationContext$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00052AAA\u0002\u0001!!)Q\u0004\u0001C\u0001=\tY2i\u001c8oK\u000e$\u0018J\u001c<bY&$\u0007+\u001b9fY&tWmU;ji\u0016T!\u0001B\u0003\u0002\u000b\u001d\u0014\u0018\r\u001d5\u000b\u0005\u00199\u0011!\u00039ja\u0016d\u0017N\\3t\u0015\tA\u0011\"A\u0002tc2T!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011c\u0006\t\u0003%Ui\u0011a\u0005\u0006\u0003)\u0015\tQ!\u001e;jYNL!AF\n\u0003\u0019AK\u0007/\u001a7j]\u0016$Vm\u001d;\u0011\u0005aYR\"A\r\u000b\u0005i9\u0011\u0001\u0002;fgRL!\u0001H\r\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\r\u0001")
public class ConnectInvalidPipelineSuite
extends PipelineTest
implements SharedSparkSession {
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$((SharedSparkSessionBase)this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$((SharedSparkSession)this);
    }

    public void afterAll() {
        SharedSparkSession.afterAll$((SharedSparkSession)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        super.beforeEach();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        super.afterEach();
    }

    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$((SharedSparkSessionBase)this);
    }

    public org.apache.spark.sql.classic.SparkSession spark() {
        return SharedSparkSessionBase.spark$((SharedSparkSessionBase)this);
    }

    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$((SharedSparkSessionBase)this);
    }

    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$((SharedSparkSessionBase)this);
    }

    public SQLConf sqlConf() {
        return SharedSparkSessionBase.sqlConf$((SharedSparkSessionBase)this);
    }

    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$((SharedSparkSessionBase)this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$((SharedSparkSessionBase)this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$((SharedSparkSessionBase)this);
    }

    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public ConnectInvalidPipelineSuite() {
        SharedSparkSessionBase.$init$((SharedSparkSessionBase)this);
        SharedSparkSession.$init$((SharedSparkSession)this);
        this.test("Missing source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$1
            extends TestGraphRegistrationContext {
                public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$1(ConnectInvalidPipelineSuite $outer) {
                    super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                    this.registerPersistedView("b", this.readFlowFunc("a"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                }
            }
            DataflowGraph dfg = new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$1(this).resolveToDataflowGraph();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(dfg.resolved(), "dfg.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Pipeline should not have resolved properly", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            UnresolvedPipelineException ex = (UnresolvedPipelineException)this.intercept((Function0 & Serializable)() -> dfg.validate(), ClassTag$.MODULE$.apply(UnresolvedPipelineException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "Failed to resolve flows in the pipeline";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            this.assertAnalysisException((Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())), "TABLE_OR_VIEW_NOT_FOUND");
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("Correctly differentiate between upstream and downstream errors", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$2
            extends TestGraphRegistrationContext {
                public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$2(ConnectInvalidPipelineSuite $outer) {
                    super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                    this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)this.spark().range(5L).toDF()), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("b", this.readFlowFunc("nonExistentFlow"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("c", this.readFlowFunc("b"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("d", this.dfFlowFunc((Dataset<Row>)this.spark().range(5L).toDF()), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("e", this.sqlFlowFunc(this.spark(), "SELECT nonExistentColumn FROM RANGE(5)"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("f", this.readFlowFunc("e"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                }
            }
            DataflowGraph dfg = new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$2(this).resolveToDataflowGraph();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(dfg.resolved(), "dfg.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Pipeline should not have resolved properly", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            UnresolvedPipelineException ex = (UnresolvedPipelineException)this.intercept((Function0 & Serializable)() -> dfg.validate(), ClassTag$.MODULE$.apply(UnresolvedPipelineException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "Failed to resolve flows in the pipeline";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            String $org_scalatest_assert_macro_left2 = ex.getMessage();
            String $org_scalatest_assert_macro_right2 = "Flows with errors: " + this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + ", " + this.fullyQualifiedIdentifier("e", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            String $org_scalatest_assert_macro_left3 = ex.getMessage();
            String $org_scalatest_assert_macro_right3 = "Flows that failed due to upstream errors: " + this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + ", " + this.fullyQualifiedIdentifier("f", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            Set $org_scalatest_assert_macro_left4 = ex.directFailures().keySet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("e", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            Set set = $org_scalatest_assert_macro_left4;
            Set set2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            Set $org_scalatest_assert_macro_left5 = ex.downstreamFailures().keySet();
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("f", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            Set set3 = $org_scalatest_assert_macro_left5;
            Set set4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            this.assertAnalysisException((Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())), "TABLE_OR_VIEW_NOT_FOUND");
            Throwable $org_scalatest_assert_macro_left6 = (Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("e", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.AnalysisException", $org_scalatest_assert_macro_left6 instanceof AnalysisException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            String $org_scalatest_assert_macro_left7 = ((Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("e", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
            String $org_scalatest_assert_macro_right6 = "nonExistentColumn";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Throwable $org_scalatest_assert_macro_left8 = (Throwable)ex.downstreamFailures().apply((Object)this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.pipelines.graph.UnresolvedDatasetException", $org_scalatest_assert_macro_left8 instanceof UnresolvedDatasetException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            String $org_scalatest_assert_macro_left9 = ((Throwable)ex.downstreamFailures().apply((Object)this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
            String $org_scalatest_assert_macro_right7 = "Failed to read dataset '" + this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "'. Dataset is defined in the pipeline but could not be resolved";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            Throwable $org_scalatest_assert_macro_left10 = (Throwable)ex.downstreamFailures().apply((Object)this.fullyQualifiedIdentifier("f", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.pipelines.graph.UnresolvedDatasetException", $org_scalatest_assert_macro_left10 instanceof UnresolvedDatasetException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            String $org_scalatest_assert_macro_left11 = ((Throwable)ex.downstreamFailures().apply((Object)this.fullyQualifiedIdentifier("f", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
            String $org_scalatest_assert_macro_right8 = "Failed to read dataset '" + this.fullyQualifiedIdentifier("e", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "'. Dataset is defined in the pipeline but could not be resolved";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left11.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("correctly identify direct and downstream errors for multi-flow pipelines", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            UnresolvedPipelineException ex = (UnresolvedPipelineException)this.intercept((Function0 & Serializable)() -> {
                public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$3
                extends TestGraphRegistrationContext {
                    public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$3(ConnectInvalidPipelineSuite $outer) {
                        super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                        this.registerTable("a", this.registerTable$default$2(), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerFlow("a", "a", this.dfFlowFunc((Dataset<Row>)this.spark().range(5L).toDF()), this.registerFlow$default$4(), this.registerFlow$default$5(), this.registerFlow$default$6());
                        this.registerFlow("a", "a_2", this.sqlFlowFunc(this.spark(), "SELECT non_existent_col FROM RANGE(5)"), this.registerFlow$default$4(), this.registerFlow$default$5(), this.registerFlow$default$6());
                        this.registerTable("b", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.readFlowFunc("a")), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                    }
                }
                return new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$3(this).resolveToDataflowGraph().validate();
            }, ClassTag$.MODULE$.apply(UnresolvedPipelineException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            Set $org_scalatest_assert_macro_left = ex.directFailures().keySet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("a_2", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Set $org_scalatest_assert_macro_left2 = ex.downstreamFailures().keySet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("Missing attribute in the schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$4
            extends TestGraphRegistrationContext {
                public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$4(ConnectInvalidPipelineSuite $outer, org.apache.spark.sql.classic.SparkSession session$1) {
                    super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                    this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)session$1.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), session$1.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"z"}))), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("b", this.sqlFlowFunc(this.spark(), "SELECT x FROM a"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                }
            }
            DataflowGraph dfg = new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$4(this, session).resolveToDataflowGraph();
            String ex = ((Throwable)((UnresolvedPipelineException)this.intercept((Function0 & Serializable)() -> dfg.validate(), ClassTag$.MODULE$.apply(UnresolvedPipelineException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159))).directFailures().apply((Object)this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
            this.verifyUnresolveColumnError(ex, "x", (Seq<String>)new .colon.colon((Object)"z", (List)Nil$.MODULE$));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("Joining on a column with different names", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$5
            extends TestGraphRegistrationContext {
                public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$5(ConnectInvalidPipelineSuite $outer, org.apache.spark.sql.classic.SparkSession session$2) {
                    super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                    this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)session$2.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), session$2.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("b", this.dfFlowFunc((Dataset<Row>)session$2.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), session$2.implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("c", this.sqlFlowFunc(this.spark(), "SELECT * FROM a JOIN b USING (x)"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                }
            }
            DataflowGraph dfg = new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$5(this, session).resolveToDataflowGraph();
            UnresolvedPipelineException ex = (UnresolvedPipelineException)this.intercept((Function0 & Serializable)() -> dfg.validate(), ClassTag$.MODULE$.apply(UnresolvedPipelineException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            String $org_scalatest_assert_macro_left = ((Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
            String $org_scalatest_assert_macro_right = "USING column `x` cannot be resolved on the right side";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("Writing to one table by unioning flows with different schemas", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool bool;
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$6
            extends TestGraphRegistrationContext {
                public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$6(ConnectInvalidPipelineSuite $outer, org.apache.spark.sql.classic.SparkSession session$3) {
                    super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                    this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)session$3.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), session$3.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("b", this.dfFlowFunc((Dataset<Row>)session$3.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})), session$3.implicits().newBooleanEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("c", this.sqlFlowFunc(this.spark(), "SELECT x FROM a UNION SELECT x FROM b"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                }
            }
            DataflowGraph dfg = new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$6(this, session).resolveToDataflowGraph();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(dfg.resolved(), "dfg.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            UnresolvedPipelineException ex = (UnresolvedPipelineException)this.intercept((Function0 & Serializable)() -> dfg.validate(), ClassTag$.MODULE$.apply(UnresolvedPipelineException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            String $org_scalatest_assert_macro_left = ((Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
            String $org_scalatest_assert_macro_right = "compatible column types";
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            } else {
                String $org_scalatest_assert_macro_left3 = ((Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
                String $org_scalatest_assert_macro_right2 = "Failed to merge incompatible data types";
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("Self reference", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CircularDependencyException e = (CircularDependencyException)this.intercept((Function0 & Serializable)() -> {
                public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$7
                extends TestGraphRegistrationContext {
                    public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$7(ConnectInvalidPipelineSuite $outer) {
                        super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                        this.registerPersistedView("a", this.readFlowFunc("a"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    }
                }
                return new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$7(this).resolveToDataflowGraph().validate();
            }, ClassTag$.MODULE$.apply(CircularDependencyException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            TableIdentifier $org_scalatest_assert_macro_left = e.upstreamDataset();
            TableIdentifier $org_scalatest_assert_macro_right = this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            TableIdentifier $org_scalatest_assert_macro_left2 = e.downstreamTable();
            TableIdentifier $org_scalatest_assert_macro_right2 = this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier tableIdentifier3 = $org_scalatest_assert_macro_left2;
            TableIdentifier tableIdentifier4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(tableIdentifier3 != null ? !tableIdentifier3.equals(tableIdentifier4) : tableIdentifier4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("Cyclic graph - simple", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CircularDependencyException e = (CircularDependencyException)this.intercept((Function0 & Serializable)() -> {
                public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$8
                extends TestGraphRegistrationContext {
                    public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$8(ConnectInvalidPipelineSuite $outer) {
                        super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                        this.registerPersistedView("a", this.readFlowFunc("b"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                        this.registerPersistedView("b", this.readFlowFunc("a"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    }
                }
                return new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$8(this).resolveToDataflowGraph().validate();
            }, ClassTag$.MODULE$.apply(CircularDependencyException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            Set cycle = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            TableIdentifier $org_scalatest_assert_macro_left = e.upstreamDataset();
            TableIdentifier $org_scalatest_assert_macro_right = e.downstreamTable();
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, tableIdentifier == null ? tableIdentifier2 != null : !tableIdentifier.equals(tableIdentifier2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            Set $org_scalatest_assert_macro_left2 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right2 = e.upstreamDataset();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            Set $org_scalatest_assert_macro_left3 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right3 = e.downstreamTable();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("Cyclic graph", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            Set cycle = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("d", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            CircularDependencyException e = (CircularDependencyException)this.intercept((Function0 & Serializable)() -> {
                public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$9
                extends TestGraphRegistrationContext {
                    public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$9(ConnectInvalidPipelineSuite $outer, org.apache.spark.sql.classic.SparkSession session$4) {
                        super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                        this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)session$4.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), session$4.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                        this.registerPersistedView("b", this.sqlFlowFunc(this.spark(), "SELECT * FROM a UNION SELECT * FROM d"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                        this.registerPersistedView("c", this.readFlowFunc("b"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                        this.registerPersistedView("d", this.readFlowFunc("c"), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    }
                }
                return new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$9(this, session).resolveToDataflowGraph().validate();
            }, ClassTag$.MODULE$.apply(CircularDependencyException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            TableIdentifier $org_scalatest_assert_macro_left = e.upstreamDataset();
            TableIdentifier $org_scalatest_assert_macro_right = e.downstreamTable();
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, tableIdentifier == null ? tableIdentifier2 != null : !tableIdentifier.equals(tableIdentifier2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            Set $org_scalatest_assert_macro_left2 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right2 = e.upstreamDataset();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            Set $org_scalatest_assert_macro_left3 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right3 = e.downstreamTable();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("Cyclic graph with materialized nodes", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            Set cycle = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("d", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            CircularDependencyException e = (CircularDependencyException)this.intercept((Function0 & Serializable)() -> {
                public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$10
                extends TestGraphRegistrationContext {
                    public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$10(ConnectInvalidPipelineSuite $outer, org.apache.spark.sql.classic.SparkSession session$5) {
                        super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                        this.registerTable("a", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.dfFlowFunc((Dataset<Row>)session$5.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), session$5.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"})))), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerTable("b", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.sqlFlowFunc(this.spark(), "SELECT * FROM a UNION SELECT * FROM d")), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerTable("c", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.readFlowFunc("b")), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerTable("d", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.readFlowFunc("c")), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                    }
                }
                return new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$10(this, session).resolveToDataflowGraph().validate();
            }, ClassTag$.MODULE$.apply(CircularDependencyException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
            TableIdentifier $org_scalatest_assert_macro_left = e.upstreamDataset();
            TableIdentifier $org_scalatest_assert_macro_right = e.downstreamTable();
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, tableIdentifier == null ? tableIdentifier2 != null : !tableIdentifier.equals(tableIdentifier2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            Set $org_scalatest_assert_macro_left2 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right2 = e.upstreamDataset();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            Set $org_scalatest_assert_macro_left3 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right3 = e.downstreamTable();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("Cyclic graph - second query makes it cyclic", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            Set cycle = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("d", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            CircularDependencyException e = (CircularDependencyException)this.intercept((Function0 & Serializable)() -> {
                public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$11
                extends TestGraphRegistrationContext {
                    public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$11(ConnectInvalidPipelineSuite $outer, org.apache.spark.sql.classic.SparkSession session$6) {
                        super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                        this.registerTable("a", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.dfFlowFunc((Dataset<Row>)session$6.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), session$6.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"})))), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerTable("b", this.registerTable$default$2(), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerFlow("b", "b", this.readFlowFunc("a"), this.registerFlow$default$4(), this.registerFlow$default$5(), this.registerFlow$default$6());
                        this.registerFlow("b", "b2", this.readFlowFunc("d"), this.registerFlow$default$4(), this.registerFlow$default$5(), this.registerFlow$default$6());
                        this.registerTable("c", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.readFlowFunc("b")), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerTable("d", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.readFlowFunc("c")), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                    }
                }
                return new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$11(this, session).resolveToDataflowGraph().validate();
            }, ClassTag$.MODULE$.apply(CircularDependencyException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            TableIdentifier $org_scalatest_assert_macro_left = e.upstreamDataset();
            TableIdentifier $org_scalatest_assert_macro_right = e.downstreamTable();
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, tableIdentifier == null ? tableIdentifier2 != null : !tableIdentifier.equals(tableIdentifier2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
            Set $org_scalatest_assert_macro_left2 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right2 = e.upstreamDataset();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            Set $org_scalatest_assert_macro_left3 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right3 = e.downstreamTable();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("Cyclic graph - all named queries", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            Set cycle = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()), this.fullyQualifiedIdentifier("d", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            CircularDependencyException e = (CircularDependencyException)this.intercept((Function0 & Serializable)() -> {
                public class Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$12
                extends TestGraphRegistrationContext {
                    public Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$12(ConnectInvalidPipelineSuite $outer, org.apache.spark.sql.classic.SparkSession session$7) {
                        super($outer.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
                        this.registerTable("a", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.dfFlowFunc((Dataset<Row>)session$7.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), session$7.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"})))), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerTable("b", this.registerTable$default$2(), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerFlow("b", "`b-name`", this.sqlFlowFunc(this.spark(), "SELECT * FROM a UNION SELECT * FROM d"), this.registerFlow$default$4(), this.registerFlow$default$5(), this.registerFlow$default$6());
                        this.registerTable("c", this.registerTable$default$2(), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerFlow("c", "`c-name`", this.readFlowFunc("b"), this.registerFlow$default$4(), this.registerFlow$default$5(), this.registerFlow$default$6());
                        this.registerTable("d", this.registerTable$default$2(), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                        this.registerFlow("d", "`d-name`", this.readFlowFunc("c"), this.registerFlow$default$4(), this.registerFlow$default$5(), this.registerFlow$default$6());
                    }
                }
                return new Org_apache_spark_sql_pipelines_graph_ConnectInvalidPipelineSuite$P$12(this, session).resolveToDataflowGraph().validate();
            }, ClassTag$.MODULE$.apply(CircularDependencyException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            TableIdentifier $org_scalatest_assert_macro_left = e.upstreamDataset();
            TableIdentifier $org_scalatest_assert_macro_right = e.downstreamTable();
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, tableIdentifier == null ? tableIdentifier2 != null : !tableIdentifier.equals(tableIdentifier2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            Set $org_scalatest_assert_macro_left2 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right2 = e.upstreamDataset();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            Set $org_scalatest_assert_macro_left3 = cycle;
            TableIdentifier $org_scalatest_assert_macro_right3 = e.downstreamTable();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("view-table conf conflict", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            TestGraphRegistrationContext p = new TestGraphRegistrationContext(this, session){
                {
                    this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)session$8.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), session$8.implicits().newIntEncoder()).toDF()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)"a-val")}))), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerTable("b", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.readFlowFunc("a")), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)"b-val")}))), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                }
            };
            AnalysisException ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> p.resolveToDataflowGraph(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "Found duplicate sql conf for dataset '" + this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "':";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            String $org_scalatest_assert_macro_left2 = ex.getMessage();
            String $org_scalatest_assert_macro_right2 = "'x' is defined by both '" + this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "' and '" + this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "'";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        this.test("view-view conf conflict", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            TestGraphRegistrationContext p = new TestGraphRegistrationContext(this, session){
                {
                    this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)session$9.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), session$9.implicits().newIntEncoder()).toDF()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)"a-val")}))), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerPersistedView("b", this.dfFlowFunc((Dataset<Row>)session$9.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), session$9.implicits().newIntEncoder()).toDF()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)"b-val")}))), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerTable("c", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.sqlFlowFunc(this.spark(), "SELECT * FROM a UNION SELECT * FROM b")), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"y"), (Object)"c-val")}))), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                }
            };
            AnalysisException ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> p.resolveToDataflowGraph(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "Found duplicate sql conf for dataset '" + this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "':";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            String $org_scalatest_assert_macro_left2 = ex.getMessage();
            String $org_scalatest_assert_macro_right2 = "'x' is defined by both '" + this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "' and '" + this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "'";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        this.test("reading a complete view incrementally", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            TestGraphRegistrationContext p = new TestGraphRegistrationContext(this, session){
                {
                    this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)session$10.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), session$10.implicits().newIntEncoder()).toDF()), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerTable("b", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.readStreamFlowFunc("a")), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                }
            };
            UnresolvedPipelineException ex = (UnresolvedPipelineException)this.intercept((Function0 & Serializable)() -> p.resolveToDataflowGraph().validate(), ClassTag$.MODULE$.apply(UnresolvedPipelineException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            String $org_scalatest_assert_macro_left = ((Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
            String $org_scalatest_assert_macro_right = "View " + this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString() + " is a batch view and must be referenced using SparkSession#read.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        this.test("reading an incremental view completely", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            TestGraphRegistrationContext p = new TestGraphRegistrationContext(this, session){
                private final SparkSession sparkSession;
                private final MemoryStream<Object> mem;

                public SparkSession sparkSession() {
                    return this.sparkSession;
                }

                public MemoryStream<Object> mem() {
                    return this.mem;
                }
                {
                    this.sparkSession = this.spark();
                    this.mem = MemoryStream$.MODULE$.apply(session$11.implicits().newIntEncoder(), this.sparkSession());
                    this.mem().addData((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
                    this.registerPersistedView("a", this.dfFlowFunc((Dataset<Row>)this.mem().toDF()), this.registerPersistedView$default$3(), this.registerPersistedView$default$4(), this.registerPersistedView$default$5(), this.registerPersistedView$default$6(), this.registerPersistedView$default$7());
                    this.registerTable("b", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.readFlowFunc("a")), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                }
            };
            UnresolvedPipelineException ex = (UnresolvedPipelineException)this.intercept((Function0 & Serializable)() -> p.resolveToDataflowGraph().validate(), ClassTag$.MODULE$.apply(UnresolvedPipelineException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
            String $org_scalatest_assert_macro_left = ((Throwable)ex.directFailures().apply((Object)this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()))).getMessage();
            String $org_scalatest_assert_macro_right = "View " + this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString() + " is a streaming view and must be referenced using SparkSession#readStream";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        this.test("Streaming table backed by batch relation fails validation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException ex;
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            DataflowGraph graph = new TestGraphRegistrationContext(this, session){
                {
                    this.registerTable("a", (Option<FlowFunction>)Option$.MODULE$.apply((Object)this.dfFlowFunc((Dataset<Row>)session$12.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), session$12.implicits().newIntEncoder()).toDF())), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                }
            }.resolveToDataflowGraph();
            AnalysisException x$1 = ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> graph.validate(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            String x$2 = "INVALID_FLOW_QUERY_TYPE.BATCH_RELATION_FOR_STREAMING_TABLE";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowIdentifier"), (Object)this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentifier"), (Object)this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString())}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "INVALID_FLOW_QUERY_TYPE.BATCH_RELATION_FOR_STREAMING_TABLE", x$4, x$3, x$5, x$6);
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        this.test("Materialized view backed by streaming relation fails validation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException ex;
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            DataflowGraph graph = new TestGraphRegistrationContext(this, session){
                private final SparkSession sparkSession;

                public SparkSession sparkSession() {
                    return this.sparkSession;
                }
                {
                    this.sparkSession = this.spark();
                    this.registerMaterializedView("a", this.dfFlowFunc((Dataset<Row>)MemoryStream$.MODULE$.apply(session$13.implicits().newIntEncoder(), this.sparkSession()).toDF()), this.registerMaterializedView$default$3(), this.registerMaterializedView$default$4(), this.registerMaterializedView$default$5(), this.registerMaterializedView$default$6(), this.registerMaterializedView$default$7(), this.registerMaterializedView$default$8(), this.registerMaterializedView$default$9(), this.registerMaterializedView$default$10(), this.registerMaterializedView$default$11());
                }
            }.resolveToDataflowGraph();
            AnalysisException x$7 = ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> graph.validate(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            String x$8 = "INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_MATERIALIZED_VIEW";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowIdentifier"), (Object)this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentifier"), (Object)this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString())}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_MATERIALIZED_VIEW", x$10, x$9, x$11, x$12);
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        this.test("Once flow backed by streaming relation fails validation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException ex;
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            DataflowGraph graph = new TestGraphRegistrationContext(this, session){
                private final SparkSession sparkSession;

                public SparkSession sparkSession() {
                    return this.sparkSession;
                }
                {
                    this.registerTable("a", this.registerTable$default$2(), this.registerTable$default$3(), this.registerTable$default$4(), this.registerTable$default$5(), this.registerTable$default$6(), this.registerTable$default$7(), this.registerTable$default$8(), this.registerTable$default$9(), this.registerTable$default$10(), this.registerTable$default$11());
                    this.sparkSession = this.spark();
                    this.registerFlow("a", "once_flow", this.dfFlowFunc((Dataset<Row>)MemoryStream$.MODULE$.apply(session$14.implicits().newIntEncoder(), this.sparkSession()).toDF()), true, this.registerFlow$default$5(), this.registerFlow$default$6());
                }
            }.resolveToDataflowGraph();
            AnalysisException x$13 = ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> graph.validate(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            String x$14 = "INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_ONCE_FLOW";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowIdentifier"), (Object)this.fullyQualifiedIdentifier("once_flow", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString())}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_ONCE_FLOW", x$16, x$15, x$17, x$18);
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        this.test("Inferred schema that isn't a subset of user-specified schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool bool;
            org.apache.spark.sql.classic.SparkSession session = this.spark();
            DataflowGraph graph1 = new TestGraphRegistrationContext(this, session){
                {
                    String x$1 = "a";
                    Option x$2 = Option$.MODULE$.apply((Object)this.dfFlowFunc((Dataset<Row>)session$15.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), session$15.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"incorrect-col-name"}))));
                    Option x$3 = Option$.MODULE$.apply((Object)new StructType().add("x", (DataType)IntegerType$.MODULE$));
                    Map<String, String> x$4 = this.registerTable$default$3();
                    Option<String> x$5 = this.registerTable$default$4();
                    Option<Seq<String>> x$6 = this.registerTable$default$6();
                    Map<String, String> x$7 = this.registerTable$default$7();
                    QueryOrigin x$8 = this.registerTable$default$8();
                    Option<String> x$9 = this.registerTable$default$9();
                    Option<String> x$10 = this.registerTable$default$10();
                    Option<String> x$11 = this.registerTable$default$11();
                    this.registerTable("a", (Option<FlowFunction>)x$2, x$4, x$5, (Option<StructType>)x$3, x$6, x$7, x$8, x$9, x$10, x$11);
                }
            }.resolveToDataflowGraph();
            AnalysisException ex1 = (AnalysisException)this.intercept((Function0 & Serializable)() -> graph1.validate(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
            String $org_scalatest_assert_macro_left = ex1.getMessage();
            String $org_scalatest_assert_macro_right = "'" + this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "' has a user-specified schema that is incompatible";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
            String $org_scalatest_assert_macro_left2 = ex1.getMessage();
            String $org_scalatest_assert_macro_right2 = "incorrect-col-name";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
            DataflowGraph graph2 = new TestGraphRegistrationContext(this, session){
                {
                    String x$1 = "a";
                    Option x$2 = Option$.MODULE$.apply((Object)new StructType().add("x", (DataType)IntegerType$.MODULE$));
                    Option<FlowFunction> x$3 = this.registerTable$default$2();
                    Map<String, String> x$4 = this.registerTable$default$3();
                    Option<String> x$5 = this.registerTable$default$4();
                    Option<Seq<String>> x$6 = this.registerTable$default$6();
                    Map<String, String> x$7 = this.registerTable$default$7();
                    QueryOrigin x$8 = this.registerTable$default$8();
                    Option<String> x$9 = this.registerTable$default$9();
                    Option<String> x$10 = this.registerTable$default$10();
                    Option<String> x$11 = this.registerTable$default$11();
                    this.registerTable("a", x$3, x$4, x$5, (Option<StructType>)x$2, x$6, x$7, x$8, x$9, x$10, x$11);
                    this.registerFlow("a", "a", this.dfFlowFunc((Dataset<Row>)session$15.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})), session$15.implicits().newBooleanEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))), true, this.registerFlow$default$5(), this.registerFlow$default$6());
                }
            }.resolveToDataflowGraph();
            AnalysisException ex2 = (AnalysisException)this.intercept((Function0 & Serializable)() -> graph2.validate(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
            String $org_scalatest_assert_macro_left3 = ex2.getMessage();
            String $org_scalatest_assert_macro_right3 = "'" + this.fullyQualifiedIdentifier("a", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString() + "' has a user-specified schema that is incompatible";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
            String $org_scalatest_assert_macro_left4 = ex2.getMessage();
            String $org_scalatest_assert_macro_right4 = "boolean";
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                String $org_scalatest_assert_macro_left6 = ex2.getMessage();
                String $org_scalatest_assert_macro_right5 = "integer";
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
            String streamingTableHint = "please full refresh";
            String $org_scalatest_assert_macro_left7 = ex1.getMessage();
            String $org_scalatest_assert_macro_right7 = streamingTableHint;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
            String $org_scalatest_assert_macro_left8 = ex2.getMessage();
            String $org_scalatest_assert_macro_right8 = streamingTableHint;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        }, new Position("ConnectInvalidPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        Statics.releaseFence();
    }
}

