/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.NettyMemoryMetrics;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class NettyMemoryMetricsSuite {
    private TransportConf conf;
    private TransportContext context;
    private TransportServer server;
    private TransportClientFactory clientFactory;

    private void setUp(boolean enableVerboseMetrics) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("spark.shuffle.io.enableVerboseMetrics", String.valueOf(enableVerboseMetrics));
        this.conf = new TransportConf("shuffle", (ConfigProvider)new MapConfigProvider(configMap));
        NoOpRpcHandler rpcHandler = new NoOpRpcHandler();
        this.context = new TransportContext(this.conf, (RpcHandler)rpcHandler);
        this.server = this.context.createServer();
        this.clientFactory = this.context.createClientFactory();
    }

    @After
    public void tearDown() {
        if (this.clientFactory != null) {
            JavaUtils.closeQuietly((Closeable)this.clientFactory);
            this.clientFactory = null;
        }
        if (this.server != null) {
            JavaUtils.closeQuietly((Closeable)this.server);
            this.server = null;
        }
        if (this.context != null) {
            JavaUtils.closeQuietly((Closeable)this.context);
            this.context = null;
        }
    }

    @Test
    public void testGeneralNettyMemoryMetrics() throws IOException, InterruptedException {
        this.setUp(false);
        MetricSet serverMetrics = this.server.getAllMetrics();
        Assert.assertNotNull((Object)serverMetrics);
        Assert.assertNotNull((Object)serverMetrics.getMetrics());
        Assert.assertNotEquals((long)serverMetrics.getMetrics().size(), (long)0L);
        Map serverMetricMap = serverMetrics.getMetrics();
        serverMetricMap.forEach((name, metric) -> Assert.assertTrue((boolean)name.startsWith("shuffle-server")));
        MetricSet clientMetrics = this.clientFactory.getAllMetrics();
        Assert.assertNotNull((Object)clientMetrics);
        Assert.assertNotNull((Object)clientMetrics.getMetrics());
        Assert.assertNotEquals((long)clientMetrics.getMetrics().size(), (long)0L);
        Map clientMetricMap = clientMetrics.getMetrics();
        clientMetricMap.forEach((name, metrics) -> Assert.assertTrue((boolean)name.startsWith("shuffle-client")));
        String heapMemoryMetric = "usedHeapMemory";
        String directMemoryMetric = "usedDirectMemory";
        Assert.assertNotNull(serverMetricMap.get(MetricRegistry.name((String)"shuffle-server", (String[])new String[]{heapMemoryMetric})));
        Assert.assertNotNull(serverMetricMap.get(MetricRegistry.name((String)"shuffle-server", (String[])new String[]{directMemoryMetric})));
        Assert.assertNotNull(clientMetricMap.get(MetricRegistry.name((String)"shuffle-client", (String[])new String[]{heapMemoryMetric})));
        Assert.assertNotNull(clientMetricMap.get(MetricRegistry.name((String)"shuffle-client", (String[])new String[]{directMemoryMetric})));
        try (TransportClient client = this.clientFactory.createClient(TestUtils.getLocalHost(), this.server.getPort());){
            Assert.assertTrue((boolean)client.isActive());
            Assert.assertTrue(((Long)((Gauge)serverMetricMap.get(MetricRegistry.name((String)"shuffle-server", (String[])new String[]{heapMemoryMetric}))).getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue(((Long)((Gauge)serverMetricMap.get(MetricRegistry.name((String)"shuffle-server", (String[])new String[]{directMemoryMetric}))).getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue(((Long)((Gauge)clientMetricMap.get(MetricRegistry.name((String)"shuffle-client", (String[])new String[]{heapMemoryMetric}))).getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue(((Long)((Gauge)clientMetricMap.get(MetricRegistry.name((String)"shuffle-client", (String[])new String[]{directMemoryMetric}))).getValue() >= 0L ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdditionalMetrics() throws IOException, InterruptedException {
        this.setUp(true);
        Map serverMetricMap = this.server.getAllMetrics().getMetrics();
        serverMetricMap.forEach((name, metric) -> {
            Assert.assertTrue((boolean)name.startsWith("shuffle-server"));
            String metricName = name.substring(name.lastIndexOf(".") + 1);
            Assert.assertTrue((metricName.equals("usedDirectMemory") || metricName.equals("usedHeapMemory") || NettyMemoryMetrics.VERBOSE_METRICS.contains(metricName) ? 1 : 0) != 0);
        });
        Map clientMetricMap = this.clientFactory.getAllMetrics().getMetrics();
        clientMetricMap.forEach((name, metric) -> {
            Assert.assertTrue((boolean)name.startsWith("shuffle-client"));
            String metricName = name.substring(name.lastIndexOf(".") + 1);
            Assert.assertTrue((metricName.equals("usedDirectMemory") || metricName.equals("usedHeapMemory") || NettyMemoryMetrics.VERBOSE_METRICS.contains(metricName) ? 1 : 0) != 0);
        });
        try (TransportClient client = null;){
            client = this.clientFactory.createClient(TestUtils.getLocalHost(), this.server.getPort());
            Assert.assertTrue((boolean)client.isActive());
            String activeBytesMetric = "numActiveBytes";
            Assert.assertTrue(((Long)((Gauge)serverMetricMap.get(MetricRegistry.name((String)"shuffle-server", (String[])new String[]{"directArena0", activeBytesMetric}))).getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue(((Long)((Gauge)clientMetricMap.get(MetricRegistry.name((String)"shuffle-client", (String[])new String[]{"directArena0", activeBytesMetric}))).getValue() >= 0L ? 1 : 0) != 0);
        }
    }
}

