/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.google.common.collect.ImmutableMap;
import java.util.Properties;
import org.apache.spark.network.util.CryptoUtils;
import org.junit.Assert;
import org.junit.Test;

public class CryptoUtilsSuite {
    @Test
    public void testConfConversion() {
        String prefix = "my.prefix.commons.config.";
        String confKey1 = prefix + "a.b.c";
        String confVal1 = "val1";
        String cryptoKey1 = "commons.crypto.a.b.c";
        String confKey2 = prefix.substring(0, prefix.length() - 1) + "A.b.c";
        String confVal2 = "val2";
        String cryptoKey2 = "commons.crypto.A.b.c";
        ImmutableMap conf = ImmutableMap.of((Object)confKey1, (Object)confVal1, (Object)confKey2, (Object)confVal2);
        Properties cryptoConf = CryptoUtils.toCryptoConf((String)prefix, conf.entrySet());
        Assert.assertEquals((Object)confVal1, (Object)cryptoConf.getProperty(cryptoKey1));
        Assert.assertFalse((boolean)cryptoConf.containsKey(cryptoKey2));
    }
}

