/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.network.TestManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class OneForOneStreamManagerSuite {
    List<ManagedBuffer> managedBuffersToRelease = new ArrayList<ManagedBuffer>();

    @After
    public void tearDown() {
        this.managedBuffersToRelease.forEach(managedBuffer -> managedBuffer.release());
        this.managedBuffersToRelease.clear();
    }

    private ManagedBuffer getChunk(OneForOneStreamManager manager, long streamId, int chunkIndex) {
        ManagedBuffer chunk = manager.getChunk(streamId, chunkIndex);
        if (chunk != null) {
            this.managedBuffersToRelease.add(chunk);
        }
        return chunk;
    }

    @Test
    public void testMissingChunk() {
        OneForOneStreamManager manager = new OneForOneStreamManager();
        ArrayList<TestManagedBuffer> buffers = new ArrayList<TestManagedBuffer>();
        TestManagedBuffer buffer1 = (TestManagedBuffer)((Object)Mockito.spy((Object)((Object)new TestManagedBuffer(10))));
        TestManagedBuffer buffer2 = (TestManagedBuffer)((Object)Mockito.spy((Object)((Object)new TestManagedBuffer(20))));
        TestManagedBuffer buffer3 = (TestManagedBuffer)((Object)Mockito.spy((Object)((Object)new TestManagedBuffer(20))));
        buffers.add(buffer1);
        buffers.add(null);
        buffers.add(buffer2);
        buffers.add(null);
        buffers.add(buffer3);
        Channel dummyChannel = (Channel)Mockito.mock(Channel.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        long streamId = manager.registerStream("appId", buffers.iterator(), dummyChannel);
        Assert.assertEquals((long)1L, (long)manager.numStreamStates());
        Assert.assertNotNull((Object)this.getChunk(manager, streamId, 0));
        Assert.assertNull((Object)this.getChunk(manager, streamId, 1));
        Assert.assertNotNull((Object)this.getChunk(manager, streamId, 2));
        manager.connectionTerminated(dummyChannel);
        ((TestManagedBuffer)((Object)Mockito.verify((Object)((Object)buffer1), (VerificationMode)Mockito.never()))).release();
        ((TestManagedBuffer)((Object)Mockito.verify((Object)((Object)buffer2), (VerificationMode)Mockito.never()))).release();
        ((TestManagedBuffer)((Object)Mockito.verify((Object)((Object)buffer3), (VerificationMode)Mockito.times((int)1)))).release();
    }

    @Test
    public void managedBuffersAreFreedWhenConnectionIsClosed() {
        OneForOneStreamManager manager = new OneForOneStreamManager();
        ArrayList<TestManagedBuffer> buffers = new ArrayList<TestManagedBuffer>();
        TestManagedBuffer buffer1 = (TestManagedBuffer)((Object)Mockito.spy((Object)((Object)new TestManagedBuffer(10))));
        TestManagedBuffer buffer2 = (TestManagedBuffer)((Object)Mockito.spy((Object)((Object)new TestManagedBuffer(20))));
        buffers.add(buffer1);
        buffers.add(buffer2);
        Channel dummyChannel = (Channel)Mockito.mock(Channel.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        manager.registerStream("appId", buffers.iterator(), dummyChannel);
        Assert.assertEquals((long)1L, (long)manager.numStreamStates());
        manager.connectionTerminated(dummyChannel);
        ((TestManagedBuffer)((Object)Mockito.verify((Object)((Object)buffer1), (VerificationMode)Mockito.times((int)1)))).release();
        ((TestManagedBuffer)((Object)Mockito.verify((Object)((Object)buffer2), (VerificationMode)Mockito.times((int)1)))).release();
        Assert.assertEquals((long)0L, (long)manager.numStreamStates());
    }

    @Test
    public void streamStatesAreFreedWhenConnectionIsClosedEvenIfBufferIteratorThrowsException() {
        OneForOneStreamManager manager = new OneForOneStreamManager();
        Iterator buffers = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)buffers.hasNext()).thenReturn((Object)true);
        Mockito.when(buffers.next()).thenThrow(RuntimeException.class);
        ManagedBuffer mockManagedBuffer = (ManagedBuffer)Mockito.mock(ManagedBuffer.class);
        Iterator buffers2 = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)buffers2.hasNext()).thenReturn((Object)true).thenReturn((Object)true);
        Mockito.when(buffers2.next()).thenReturn((Object)mockManagedBuffer).thenThrow(RuntimeException.class);
        Channel dummyChannel = (Channel)Mockito.mock(Channel.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        manager.registerStream("appId", buffers, dummyChannel);
        manager.registerStream("appId", buffers2, dummyChannel);
        Assert.assertEquals((long)2L, (long)manager.numStreamStates());
        try {
            manager.connectionTerminated(dummyChannel);
            Assert.fail((String)"connectionTerminated should throw exception when fails to release all buffers");
        }
        catch (RuntimeException e) {
            ((Iterator)Mockito.verify((Object)buffers, (VerificationMode)Mockito.times((int)1))).hasNext();
            ((Iterator)Mockito.verify((Object)buffers, (VerificationMode)Mockito.times((int)1))).next();
            ((Iterator)Mockito.verify((Object)buffers2, (VerificationMode)Mockito.times((int)2))).hasNext();
            ((Iterator)Mockito.verify((Object)buffers2, (VerificationMode)Mockito.times((int)2))).next();
            ((ManagedBuffer)Mockito.verify((Object)mockManagedBuffer, (VerificationMode)Mockito.times((int)1))).release();
            Assert.assertEquals((long)0L, (long)manager.numStreamStates());
        }
    }
}

