/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.spark.network.TestManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;
import org.apache.spark.network.protocol.MessageWithHeader;
import org.apache.spark.network.util.AbstractFileRegion;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MessageWithHeaderSuite {
    @Test
    public void testSingleWrite() throws Exception {
        this.testFileRegionBody(8, 8);
    }

    @Test
    public void testShortWrite() throws Exception {
        this.testFileRegionBody(8, 1);
    }

    @Test
    public void testByteBufBody() throws Exception {
        this.testByteBufBody(Unpooled.copyLong((long)42L));
    }

    @Test
    public void testCompositeByteBufBodySingleBuffer() throws Exception {
        ByteBuf header = Unpooled.copyLong((long)42L);
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer();
        compositeByteBuf.addComponent(true, header);
        Assert.assertEquals((long)1L, (long)compositeByteBuf.nioBufferCount());
        this.testByteBufBody((ByteBuf)compositeByteBuf);
    }

    @Test
    public void testCompositeByteBufBodyMultipleBuffers() throws Exception {
        ByteBuf header = Unpooled.copyLong((long)42L);
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer();
        compositeByteBuf.addComponent(true, header.retainedSlice(0, 4));
        compositeByteBuf.addComponent(true, header.slice(4, 4));
        Assert.assertEquals((long)2L, (long)compositeByteBuf.nioBufferCount());
        this.testByteBufBody((ByteBuf)compositeByteBuf);
    }

    private void testByteBufBody(ByteBuf header) throws Exception {
        long expectedHeaderValue = header.getLong(header.readerIndex());
        ByteBuf bodyPassedToNettyManagedBuffer = Unpooled.copyLong((long)84L);
        Assert.assertEquals((long)1L, (long)header.refCnt());
        Assert.assertEquals((long)1L, (long)bodyPassedToNettyManagedBuffer.refCnt());
        NettyManagedBuffer managedBuf = new NettyManagedBuffer(bodyPassedToNettyManagedBuffer);
        Object body = managedBuf.convertToNetty();
        Assert.assertEquals((long)2L, (long)bodyPassedToNettyManagedBuffer.refCnt());
        Assert.assertEquals((long)1L, (long)header.refCnt());
        MessageWithHeader msg = new MessageWithHeader((ManagedBuffer)managedBuf, header, body, managedBuf.size());
        ByteBuf result = this.doWrite(msg, 1);
        Assert.assertEquals((long)msg.count(), (long)result.readableBytes());
        Assert.assertEquals((long)expectedHeaderValue, (long)result.readLong());
        Assert.assertEquals((long)84L, (long)result.readLong());
        Assert.assertTrue((boolean)msg.release());
        Assert.assertEquals((long)0L, (long)bodyPassedToNettyManagedBuffer.refCnt());
        Assert.assertEquals((long)0L, (long)header.refCnt());
    }

    @Test
    public void testDeallocateReleasesManagedBuffer() throws Exception {
        ByteBuf header = Unpooled.copyLong((long)42L);
        ManagedBuffer managedBuf = (ManagedBuffer)Mockito.spy((Object)((Object)new TestManagedBuffer(84)));
        ByteBuf body = (ByteBuf)managedBuf.convertToNetty();
        Assert.assertEquals((long)2L, (long)body.refCnt());
        MessageWithHeader msg = new MessageWithHeader(managedBuf, header, (Object)body, (long)body.readableBytes());
        Assert.assertTrue((boolean)msg.release());
        ((ManagedBuffer)Mockito.verify((Object)managedBuf, (VerificationMode)Mockito.times((int)1))).release();
        Assert.assertEquals((long)0L, (long)body.refCnt());
    }

    private void testFileRegionBody(int totalWrites, int writesPerCall) throws Exception {
        ByteBuf header = Unpooled.copyLong((long)42L);
        int headerLength = header.readableBytes();
        TestFileRegion region = new TestFileRegion(totalWrites, writesPerCall);
        MessageWithHeader msg = new MessageWithHeader(null, header, (Object)region, region.count());
        ByteBuf result = this.doWrite(msg, totalWrites / writesPerCall);
        Assert.assertEquals((long)((long)headerLength + region.count()), (long)result.readableBytes());
        Assert.assertEquals((long)42L, (long)result.readLong());
        for (long i = 0L; i < 8L; ++i) {
            Assert.assertEquals((long)i, (long)result.readLong());
        }
        Assert.assertTrue((boolean)msg.release());
    }

    private ByteBuf doWrite(MessageWithHeader msg, int minExpectedWrites) throws Exception {
        int writes = 0;
        ByteArrayWritableChannel channel = new ByteArrayWritableChannel((int)msg.count());
        while (msg.transferred() < msg.count()) {
            msg.transferTo((WritableByteChannel)channel, msg.transferred());
            ++writes;
        }
        Assert.assertTrue((String)"Not enough writes!", (minExpectedWrites <= writes ? 1 : 0) != 0);
        return Unpooled.wrappedBuffer((byte[])channel.getData());
    }

    private static class TestFileRegion
    extends AbstractFileRegion {
        private final int writeCount;
        private final int writesPerCall;
        private int written;

        TestFileRegion(int totalWrites, int writesPerCall) {
            this.writeCount = totalWrites;
            this.writesPerCall = writesPerCall;
        }

        public long count() {
            return 8L * (long)this.writeCount;
        }

        public long position() {
            return 0L;
        }

        public long transferred() {
            return 8L * (long)this.written;
        }

        public long transferTo(WritableByteChannel target, long position) throws IOException {
            for (int i = 0; i < this.writesPerCall; ++i) {
                ByteBuf buf = Unpooled.copyLong((long)(position / 8L + (long)i));
                ByteBuffer nio = buf.nioBuffer();
                while (nio.remaining() > 0) {
                    target.write(nio);
                }
                buf.release();
                ++this.written;
            }
            return 8L * (long)this.writesPerCall;
        }

        protected void deallocate() {
        }
    }
}

