/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.BufferOverflowException;
import org.apache.spark.network.protocol.Encoders;
import org.junit.Assert;
import org.junit.Test;
import org.roaringbitmap.RoaringBitmap;

public class EncodersSuite {
    @Test
    public void testRoaringBitmapEncodeDecode() {
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.add(new int[]{1, 2, 3});
        ByteBuf buf = Unpooled.buffer((int)Encoders.Bitmaps.encodedLength((RoaringBitmap)bitmap));
        Encoders.Bitmaps.encode((ByteBuf)buf, (RoaringBitmap)bitmap);
        RoaringBitmap decodedBitmap = Encoders.Bitmaps.decode((ByteBuf)buf);
        Assert.assertEquals((Object)bitmap, (Object)decodedBitmap);
    }

    @Test(expected=BufferOverflowException.class)
    public void testRoaringBitmapEncodeShouldFailWhenBufferIsSmall() {
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.add(new int[]{1, 2, 3});
        ByteBuf buf = Unpooled.buffer((int)4);
        Encoders.Bitmaps.encode((ByteBuf)buf, (RoaringBitmap)bitmap);
    }

    @Test
    public void testBitmapArraysEncodeDecode() {
        Object[] bitmaps = new RoaringBitmap[]{new RoaringBitmap(), new RoaringBitmap(), new RoaringBitmap(), new RoaringBitmap(), new RoaringBitmap()};
        bitmaps[0].add(new int[]{1, 2, 3});
        bitmaps[1].add(new int[]{1, 2, 4});
        bitmaps[3].add(7L, 9L);
        bitmaps[4].add(1L, 100L);
        ByteBuf buf = Unpooled.buffer((int)Encoders.BitmapArrays.encodedLength((RoaringBitmap[])bitmaps));
        Encoders.BitmapArrays.encode((ByteBuf)buf, (RoaringBitmap[])bitmaps);
        Object[] decodedBitmaps = Encoders.BitmapArrays.decode((ByteBuf)buf);
        Assert.assertArrayEquals((Object[])bitmaps, (Object[])decodedBitmaps);
    }
}

