/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;

class StreamTestHelper {
    static final String[] STREAMS = new String[]{"largeBuffer", "smallBuffer", "emptyBuffer", "file"};
    final File testFile;
    final File tempDir = Files.createTempDir();
    final ByteBuffer emptyBuffer = StreamTestHelper.createBuffer(0);
    final ByteBuffer smallBuffer = StreamTestHelper.createBuffer(100);
    final ByteBuffer largeBuffer = StreamTestHelper.createBuffer(100000);

    private static ByteBuffer createBuffer(int bufSize) {
        ByteBuffer buf = ByteBuffer.allocate(bufSize);
        for (int i = 0; i < bufSize; ++i) {
            buf.put((byte)i);
        }
        buf.flip();
        return buf;
    }

    StreamTestHelper() throws Exception {
        this.testFile = File.createTempFile("stream-test-file", "txt", this.tempDir);
        try (FileOutputStream fp = new FileOutputStream(this.testFile);){
            Random rnd = new Random();
            for (int i = 0; i < 512; ++i) {
                byte[] fileContent = new byte[1024];
                rnd.nextBytes(fileContent);
                fp.write(fileContent);
            }
        }
    }

    public ByteBuffer srcBuffer(String name) {
        switch (name) {
            case "largeBuffer": {
                return this.largeBuffer;
            }
            case "smallBuffer": {
                return this.smallBuffer;
            }
            case "emptyBuffer": {
                return this.emptyBuffer;
            }
        }
        throw new IllegalArgumentException("Invalid stream: " + name);
    }

    public ManagedBuffer openStream(TransportConf conf, String streamId) {
        switch (streamId) {
            case "file": {
                return new FileSegmentManagedBuffer(conf, this.testFile, 0L, this.testFile.length());
            }
        }
        return new NioManagedBuffer(this.srcBuffer(streamId));
    }

    void cleanup() {
        if (this.tempDir != null) {
            try {
                JavaUtils.deleteRecursively((File)this.tempDir);
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
    }
}

