/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;

class ExtendedChannelPromise
extends DefaultChannelPromise {
    private List<GenericFutureListener<Future<Void>>> listeners = new ArrayList<GenericFutureListener<Future<Void>>>();
    private boolean success = false;

    ExtendedChannelPromise(Channel channel) {
        super(channel);
    }

    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        GenericFutureListener<? extends Future<? super Void>> gfListener = listener;
        this.listeners.add(gfListener);
        return super.addListener(listener);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ChannelPromise await() throws InterruptedException {
        return this;
    }

    public void finish(boolean success) {
        this.success = success;
        this.listeners.forEach(listener -> {
            try {
                listener.operationComplete((Future)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

