/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.spark.network.util.TimerWithCustomTimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class TimerWithCustomUnitSuite {
    private static final double EPSILON = 1.0E-9;

    @Test
    public void testTimerWithMillisecondTimeUnit() {
        this.testTimerWithCustomTimeUnit(TimeUnit.MILLISECONDS);
    }

    @Test
    public void testTimerWithNanosecondTimeUnit() {
        this.testTimerWithCustomTimeUnit(TimeUnit.NANOSECONDS);
    }

    private void testTimerWithCustomTimeUnit(TimeUnit timeUnit) {
        TimerWithCustomTimeUnit timer = new TimerWithCustomTimeUnit(timeUnit);
        Duration[] durations = new Duration[]{Duration.ofNanos(1L), Duration.ofMillis(1L), Duration.ofMillis(5L), Duration.ofMillis(100L), Duration.ofSeconds(10L)};
        Arrays.stream(durations).forEach(arg_0 -> ((Timer)timer).update(arg_0));
        Snapshot snapshot = timer.getSnapshot();
        Assert.assertEquals((long)TimerWithCustomUnitSuite.toTimeUnit(durations[0], timeUnit), (long)snapshot.getMin());
        Assert.assertEquals((double)TimerWithCustomUnitSuite.toTimeUnitFloating(durations[0], timeUnit), (double)snapshot.getValue(0.0), (double)1.0E-9);
        Assert.assertEquals((double)TimerWithCustomUnitSuite.toTimeUnitFloating(durations[2], timeUnit), (double)snapshot.getMedian(), (double)1.0E-9);
        Assert.assertEquals((double)TimerWithCustomUnitSuite.toTimeUnitFloating(durations[3], timeUnit), (double)snapshot.get75thPercentile(), (double)1.0E-9);
        Assert.assertEquals((long)TimerWithCustomUnitSuite.toTimeUnit(durations[4], timeUnit), (long)snapshot.getMax());
        Assert.assertArrayEquals((long[])Arrays.stream(durations).mapToLong(d -> TimerWithCustomUnitSuite.toTimeUnit(d, timeUnit)).toArray(), (long[])snapshot.getValues());
        double total = Arrays.stream(durations).mapToDouble(d -> TimerWithCustomUnitSuite.toTimeUnitFloating(d, timeUnit)).sum();
        Assert.assertEquals((double)(total / (double)durations.length), (double)snapshot.getMean(), (double)1.0E-9);
    }

    @Test
    public void testTimingViaContext() {
        Duration[] durations;
        ManualClock clock = new ManualClock();
        TimerWithCustomTimeUnit timer = new TimerWithCustomTimeUnit(TimeUnit.MILLISECONDS, (Clock)clock);
        for (Duration d : durations = new Duration[]{Duration.ofNanos(1L), Duration.ofMillis(100L), Duration.ofMillis(1000L)}) {
            Timer.Context context = timer.time();
            clock.advance(TimerWithCustomUnitSuite.toTimeUnit(d, TimeUnit.NANOSECONDS));
            context.stop();
        }
        Snapshot snapshot = timer.getSnapshot();
        Assert.assertEquals((long)0L, (long)snapshot.getMin());
        Assert.assertEquals((double)100.0, (double)snapshot.getMedian(), (double)1.0E-9);
        Assert.assertEquals((double)1000.0, (double)snapshot.getMax(), (double)1.0E-9);
    }

    private static long toTimeUnit(Duration duration, TimeUnit timeUnit) {
        return timeUnit.convert(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    private static double toTimeUnitFloating(Duration duration, TimeUnit timeUnit) {
        return (double)duration.toNanos() / (double)timeUnit.toNanos(1L);
    }

    private static class ManualClock
    extends Clock {
        private long currTick = 1L;

        private ManualClock() {
        }

        void advance(long nanos) {
            this.currTick += nanos;
        }

        public long getTick() {
            return this.currTick;
        }
    }
}

