/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.MergedBlockMetaSuccess;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.MessageDecoder;
import org.apache.spark.network.protocol.MessageEncoder;
import org.apache.spark.network.protocol.MessageWithHeader;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.apache.spark.network.util.TransportConf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.roaringbitmap.RoaringBitmap;

public class MergedBlockMetaSuccessSuite {
    @Test
    public void testMergedBlocksMetaEncodeDecode() throws Exception {
        int i;
        File chunkMetaFile = new File("target/mergedBlockMetaTest");
        Files.deleteIfExists(chunkMetaFile.toPath());
        RoaringBitmap chunk1 = new RoaringBitmap();
        chunk1.add(1);
        chunk1.add(3);
        RoaringBitmap chunk2 = new RoaringBitmap();
        chunk2.add(2);
        chunk2.add(4);
        RoaringBitmap[] expectedChunks = new RoaringBitmap[]{chunk1, chunk2};
        try (DataOutputStream metaOutput = new DataOutputStream(new FileOutputStream(chunkMetaFile));){
            for (int i2 = 0; i2 < expectedChunks.length; ++i2) {
                expectedChunks[i2].serialize((DataOutput)metaOutput);
            }
        }
        TransportConf conf = (TransportConf)Mockito.mock(TransportConf.class);
        Mockito.when((Object)conf.lazyFileDescriptor()).thenReturn((Object)false);
        long requestId = 1L;
        MergedBlockMetaSuccess expectedMeta = new MergedBlockMetaSuccess(requestId, 2, (ManagedBuffer)new FileSegmentManagedBuffer(conf, chunkMetaFile, 0L, chunkMetaFile.length()));
        ArrayList out = Lists.newArrayList();
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)context.alloc()).thenReturn((Object)ByteBufAllocator.DEFAULT);
        MessageEncoder.INSTANCE.encode(context, (Message)expectedMeta, (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
        MessageWithHeader msgWithHeader = (MessageWithHeader)out.remove(0);
        ByteArrayWritableChannel writableChannel = new ByteArrayWritableChannel((int)msgWithHeader.count());
        while (msgWithHeader.transfered() < msgWithHeader.count()) {
            msgWithHeader.transferTo((WritableByteChannel)writableChannel, msgWithHeader.transfered());
        }
        ByteBuf messageBuf = Unpooled.wrappedBuffer((byte[])writableChannel.getData());
        messageBuf.readLong();
        MessageDecoder.INSTANCE.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), messageBuf, (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
        MergedBlockMetaSuccess decoded = (MergedBlockMetaSuccess)out.get(0);
        Assert.assertEquals((String)"merged block", (long)expectedMeta.requestId, (long)decoded.requestId);
        Assert.assertEquals((String)"num chunks", (long)expectedMeta.getNumChunks(), (long)decoded.getNumChunks());
        ByteBuf responseBuf = Unpooled.wrappedBuffer((ByteBuffer)decoded.body().nioByteBuffer());
        RoaringBitmap[] responseBitmaps = new RoaringBitmap[expectedMeta.getNumChunks()];
        for (i = 0; i < expectedMeta.getNumChunks(); ++i) {
            responseBitmaps[i] = Encoders.Bitmaps.decode((ByteBuf)responseBuf);
        }
        Assert.assertEquals((String)"num of roaring bitmaps", (long)expectedMeta.getNumChunks(), (long)responseBitmaps.length);
        for (i = 0; i < expectedMeta.getNumChunks(); ++i) {
            Assert.assertEquals((String)("chunk bitmap " + i), (Object)expectedChunks[i], (Object)responseBitmaps[i]);
        }
        Files.delete(chunkMetaFile.toPath());
    }
}

