/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import com.google.common.collect.ImmutableMap;
import com.google.crypto.tink.subtle.Hex;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.spark.network.crypto.AuthEngine;
import org.apache.spark.network.crypto.AuthMessage;
import org.apache.spark.network.crypto.TransportCipher;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class AuthEngineSuite {
    private static final String clientPrivate = "efe6b68b3fce92158e3637f6ef9d937e75558928dd4b401de04b43d300a73186";
    private static final String clientChallengeHex = "fb00000005617070496400000010890b6e960f48e998777267a7e4e623220000003c48ad7dc7ec9466da93bda9f11488dc9404050e02c661d87d67c782444944c6e369b27e0a416c30845a2d9e64271511ca98b41d65f8c426e18ff380f6";
    private static final String serverResponseHex = "fb00000005617070496400000010708451c9dd2792c97c1ca66e6df449ef0000003c64fe899ecdaf458d4e25e9d5c5a380b8e6d1a184692fac065ed84f8592c18e9629f9c636809dca2ffc041f20346eb53db7873808ecad08b46b5ee3ff";
    private static final String sharedKey = "31963f15a320d5c90333f7ecf5cf3a31c7eaf151de07fef8494663a9f47cfd31";
    private static final String inputIv = "fc6a5dc8b90a9dad8f54f08b51a59ed2";
    private static final String outputIv = "a72709baf00785cad6329ce09f631f71";
    private static TransportConf conf;

    @BeforeClass
    public static void setUp() {
        conf = new TransportConf("rpc", (ConfigProvider)MapConfigProvider.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthEngine() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "secret", conf);
        try {
            AuthMessage clientChallenge = client.challenge();
            AuthMessage serverResponse = server.response(clientChallenge);
            client.deriveSessionCipher(clientChallenge, serverResponse);
            TransportCipher serverCipher = server.sessionCipher();
            TransportCipher clientCipher = client.sessionCipher();
            Assert.assertTrue((boolean)Arrays.equals(serverCipher.getInputIv(), clientCipher.getOutputIv()));
            Assert.assertTrue((boolean)Arrays.equals(serverCipher.getOutputIv(), clientCipher.getInputIv()));
            Assert.assertEquals((Object)serverCipher.getKey(), (Object)clientCipher.getKey());
        }
        finally {
            client.close();
            server.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCorruptChallengeAppId() throws Exception {
        try (AuthEngine client = new AuthEngine("appId", "secret", conf);
             AuthEngine server = new AuthEngine("appId", "secret", conf);){
            AuthMessage clientChallenge = client.challenge();
            AuthMessage corruptChallenge = new AuthMessage("junk", clientChallenge.salt, clientChallenge.ciphertext);
            AuthMessage authMessage = server.response(corruptChallenge);
        }
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCorruptChallengeSalt() throws Exception {
        try (AuthEngine client = new AuthEngine("appId", "secret", conf);
             AuthEngine server = new AuthEngine("appId", "secret", conf);){
            AuthMessage clientChallenge = client.challenge();
            clientChallenge.salt[0] = (byte)(clientChallenge.salt[0] ^ 1);
            AuthMessage authMessage = server.response(clientChallenge);
        }
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCorruptChallengeCiphertext() throws Exception {
        try (AuthEngine client = new AuthEngine("appId", "secret", conf);
             AuthEngine server = new AuthEngine("appId", "secret", conf);){
            AuthMessage clientChallenge = client.challenge();
            clientChallenge.ciphertext[0] = (byte)(clientChallenge.ciphertext[0] ^ 1);
            AuthMessage authMessage = server.response(clientChallenge);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCorruptResponseAppId() throws Exception {
        try (AuthEngine client = new AuthEngine("appId", "secret", conf);
             AuthEngine server = new AuthEngine("appId", "secret", conf);){
            AuthMessage clientChallenge = client.challenge();
            AuthMessage serverResponse = server.response(clientChallenge);
            AuthMessage corruptResponse = new AuthMessage("junk", serverResponse.salt, serverResponse.ciphertext);
            client.deriveSessionCipher(clientChallenge, corruptResponse);
        }
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCorruptResponseSalt() throws Exception {
        try (AuthEngine client = new AuthEngine("appId", "secret", conf);
             AuthEngine server = new AuthEngine("appId", "secret", conf);){
            AuthMessage clientChallenge = client.challenge();
            AuthMessage serverResponse = server.response(clientChallenge);
            serverResponse.salt[0] = (byte)(serverResponse.salt[0] ^ 1);
            client.deriveSessionCipher(clientChallenge, serverResponse);
        }
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCorruptServerCiphertext() throws Exception {
        try (AuthEngine client = new AuthEngine("appId", "secret", conf);
             AuthEngine server = new AuthEngine("appId", "secret", conf);){
            AuthMessage clientChallenge = client.challenge();
            AuthMessage serverResponse = server.response(clientChallenge);
            serverResponse.ciphertext[0] = (byte)(serverResponse.ciphertext[0] ^ 1);
            client.deriveSessionCipher(clientChallenge, serverResponse);
        }
    }

    @Test
    public void testFixedChallenge() throws Exception {
        try (AuthEngine server = new AuthEngine("appId", "secret", conf);){
            AuthMessage clientChallenge = AuthMessage.decodeMessage((ByteBuffer)ByteBuffer.wrap(Hex.decode((String)clientChallengeHex)));
            AuthMessage authMessage = server.response(clientChallenge);
        }
    }

    @Test
    public void testFixedChallengeResponse() throws Exception {
        try (AuthEngine client = new AuthEngine("appId", "secret", conf);){
            byte[] clientPrivateKey = Hex.decode((String)clientPrivate);
            client.setClientPrivateKey(clientPrivateKey);
            AuthMessage clientChallenge = AuthMessage.decodeMessage((ByteBuffer)ByteBuffer.wrap(Hex.decode((String)clientChallengeHex)));
            AuthMessage serverResponse = AuthMessage.decodeMessage((ByteBuffer)ByteBuffer.wrap(Hex.decode((String)serverResponseHex)));
            client.deriveSessionCipher(clientChallenge, serverResponse);
            TransportCipher clientCipher = client.sessionCipher();
            Assert.assertEquals((Object)Hex.encode((byte[])clientCipher.getKey().getEncoded()), (Object)sharedKey);
            Assert.assertEquals((Object)Hex.encode((byte[])clientCipher.getInputIv()), (Object)inputIv);
            Assert.assertEquals((Object)Hex.encode((byte[])clientCipher.getOutputIv()), (Object)outputIv);
        }
    }

    @Test(expected=GeneralSecurityException.class)
    public void testMismatchedSecret() throws Exception {
        try (AuthEngine client = new AuthEngine("appId", "secret", conf);
             AuthEngine server = new AuthEngine("appId", "different_secret", conf);){
            AuthMessage clientChallenge = client.challenge();
            server.response(clientChallenge);
        }
    }

    @Test(expected=AssertionError.class)
    public void testBadKeySize() throws Exception {
        ImmutableMap mconf = ImmutableMap.of((Object)"spark.network.crypto.keyLength", (Object)"42");
        TransportConf conf = new TransportConf("rpc", (ConfigProvider)new MapConfigProvider((Map)mconf));
        try (AuthEngine engine = new AuthEngine("appId", "secret", conf);){
            engine.challenge();
            Assert.fail((String)"Should have failed to create challenge message.");
            engine.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedMessage() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "secret", conf);
        try {
            AuthMessage clientChallenge = client.challenge();
            AuthMessage serverResponse = server.response(clientChallenge);
            client.deriveSessionCipher(clientChallenge, serverResponse);
            TransportCipher cipher = server.sessionCipher();
            TransportCipher.EncryptionHandler handler = new TransportCipher.EncryptionHandler(cipher);
            byte[] data = new byte[32769];
            new Random().nextBytes(data);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
            ByteArrayWritableChannel channel = new ByteArrayWritableChannel(data.length);
            TransportCipher.EncryptedMessage emsg = handler.createEncryptedMessage((Object)buf);
            while (emsg.transferred() < emsg.count()) {
                emsg.transferTo((WritableByteChannel)channel, emsg.transferred());
            }
            Assert.assertEquals((long)data.length, (long)channel.length());
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedMessageWhenTransferringZeroBytes() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "secret", conf);
        try {
            AuthMessage clientChallenge = client.challenge();
            AuthMessage serverResponse = server.response(clientChallenge);
            client.deriveSessionCipher(clientChallenge, serverResponse);
            TransportCipher cipher = server.sessionCipher();
            TransportCipher.EncryptionHandler handler = new TransportCipher.EncryptionHandler(cipher);
            final int testDataLength = 4;
            FileRegion region = (FileRegion)Mockito.mock(FileRegion.class);
            Mockito.when((Object)region.count()).thenReturn((Object)testDataLength);
            Mockito.when((Object)region.transferTo((WritableByteChannel)Mockito.any(), Mockito.anyLong())).thenAnswer((Answer)new Answer<Long>(){
                private boolean firstTime = true;

                public Long answer(InvocationOnMock invocationOnMock) throws Throwable {
                    if (this.firstTime) {
                        this.firstTime = false;
                        return 0L;
                    }
                    WritableByteChannel channel = (WritableByteChannel)invocationOnMock.getArgument(0);
                    channel.write(ByteBuffer.wrap(new byte[testDataLength]));
                    return testDataLength;
                }
            });
            TransportCipher.EncryptedMessage emsg = handler.createEncryptedMessage((Object)region);
            ByteArrayWritableChannel channel = new ByteArrayWritableChannel(testDataLength);
            Assert.assertEquals((long)0L, (long)emsg.transferTo((WritableByteChannel)channel, emsg.transferred()));
            Assert.assertEquals((long)testDataLength, (long)emsg.transferTo((WritableByteChannel)channel, emsg.transferred()));
            Assert.assertEquals((long)emsg.transferred(), (long)emsg.count());
            Assert.assertEquals((long)4L, (long)channel.length());
        }
        finally {
            client.close();
            server.close();
        }
    }
}

